/*
 * Decompiled with CFR 0.152.
 */
package cfdoc.parser;

import cfdoc.parser.CfParserException;
import cfdoc.parser.ScannerPosition;
import cfdoc.util.Logger;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;

public class CharReader {
    private static Logger logger;
    static final int EOF = -1;
    File file;
    String source;
    int pos;
    int line;
    int col;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static String readFile(File file, String charsetName) throws IOException {
        if (!$assertionsDisabled && file == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && charsetName == null) {
            throw new AssertionError();
        }
        String source = "";
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), charsetName));
        while (reader.ready()) {
            String line = reader.readLine();
            source = source + line + "\n";
        }
        reader.close();
        return source;
    }

    public static String readFile(File file) throws IOException {
        if (!$assertionsDisabled && file == null) {
            throw new AssertionError();
        }
        return CharReader.readFile(file, Charset.defaultCharset().name());
    }

    void setSource(String source, File file) {
        if (!$assertionsDisabled && source == null) {
            throw new AssertionError();
        }
        this.file = file;
        this.source = source;
        this.pos = 0;
        this.col = 1;
        this.line = 1;
    }

    private int getChar0() {
        int ch;
        if (this.pos < this.source.length()) {
            ch = this.source.charAt(this.pos);
            ++this.pos;
            if (ch == 10) {
                ++this.line;
                this.col = 1;
            } else {
                ++this.col;
            }
        } else {
            ch = -1;
        }
        return ch;
    }

    int getChar() throws CfParserException {
        return this.getChar0();
    }

    void throwException(String message) throws CfParserException {
        throw new CfParserException(message, new ScannerPosition(this.file, this.pos, this.line, this.col));
    }

    void throwException(String message, Exception cause) throws CfParserException {
        throw new CfParserException(message, new ScannerPosition(this.file, this.pos, this.line, this.col), cause);
    }

    ScannerPosition getScannerPosition() {
        return new ScannerPosition(this.file, this.pos, this.line, this.col);
    }

    public static void main(String[] args) {
        try {
            File file = new File(args[0]);
            String source = CharReader.readFile(file);
            CharReader scanner = new CharReader();
            scanner.setSource(source, file);
            int ch = -1;
            do {
                System.out.print(file + " " + scanner.pos + "(" + scanner.line + ";" + scanner.col + ")");
                ch = scanner.getChar();
                System.out.println("'" + (char)ch + "'");
            } while (ch != -1);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    static {
        $assertionsDisabled = !CharReader.class.desiredAssertionStatus();
        logger = Logger.getLogger(CharReader.class);
    }
}

