/*
 * Decompiled with CFR 0.152.
 */
package cfdoc.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;

public class FileUtil {
    static final /* synthetic */ boolean $assertionsDisabled;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFile(File file, String charsetName) throws IOException {
        if (!$assertionsDisabled && file == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && charsetName == null) {
            throw new AssertionError();
        }
        String source = "";
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), charsetName));
            while (reader.ready()) {
                String line = reader.readLine();
                source = source + line + "\n";
            }
            String string = source;
            return string;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException ex) {}
            }
        }
    }

    public static String readFile(File file) throws IOException {
        if (!$assertionsDisabled && file == null) {
            throw new AssertionError();
        }
        return FileUtil.readFile(file, Charset.defaultCharset().name());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeFile(File file, String content, String charsetName) throws IOException {
        if (!$assertionsDisabled && file == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && content == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && charsetName == null) {
            throw new AssertionError();
        }
        PrintWriter reader = null;
        try {
            reader = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), charsetName));
            reader.print(content);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    public static ArrayList collectFiles(File dir) {
        ArrayList<File> result = new ArrayList<File>();
        File[] files = dir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            result.add(files[i]);
            if (!files[i].isDirectory()) continue;
            result.addAll(FileUtil.collectFiles(files[i]));
        }
        return result;
    }

    public static void deleteDirs(File dir) throws IOException {
        if (dir.isDirectory()) {
            File[] files = dir.listFiles();
            for (int i = 0; i < files.length; ++i) {
                FileUtil.deleteDirs(files[i]);
            }
        }
        dir.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File src, File dst) throws IOException {
        if (!$assertionsDisabled && src == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && dst == null) {
            throw new AssertionError();
        }
        BufferedInputStream in = null;
        FilterOutputStream out = null;
        try {
            in = new BufferedInputStream(new FileInputStream(src));
            out = new BufferedOutputStream(new FileOutputStream(dst));
            byte[] buf = new byte[4096];
            while (in.available() > 0) {
                int len = in.read(buf, 0, 4096);
                ((BufferedOutputStream)out).write(buf, 0, len);
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ex) {}
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException ex) {}
            }
        }
    }

    public static void copyDir(File srcdir, File dstdir) throws IOException {
        if (!$assertionsDisabled && srcdir == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && dstdir == null) {
            throw new AssertionError();
        }
        dstdir.mkdirs();
        File[] files = srcdir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            File dst = new File(dstdir.getPath() + File.separator + files[i].getName());
            if (files[i].isDirectory()) {
                FileUtil.copyDir(files[i], dst);
                continue;
            }
            FileUtil.copyFile(files[i], dst);
        }
    }

    static {
        $assertionsDisabled = !FileUtil.class.desiredAssertionStatus();
    }
}

