/*
 * Decompiled with CFR 0.152.
 */
package cfdoc.util;

import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Calendar;

public class Logger {
    public static final int OFF = Integer.MAX_VALUE;
    public static final int FATAL = 50000;
    public static final int ERROR = 40000;
    public static final int WARN = 30000;
    public static final int INFO = 20000;
    public static final int DEBUG = 10000;
    public static final int ALL = Integer.MIN_VALUE;
    String filename = "cfdoc" + new SimpleDateFormat("yyyyMMdd").format(Calendar.getInstance().getTime()) + ".log";
    private Class cls;
    SimpleDateFormat formatter = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.SSS");
    public static int threshold = Integer.MAX_VALUE;

    private Logger(Class cls) {
        this.cls = cls;
    }

    public static Logger getLogger(Class cls) {
        return new Logger(cls);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void log(int level, Object msg, Throwable th) {
        StringBuffer sb = new StringBuffer();
        StackTraceElement ste = this.getCallSideStackTraceElement();
        sb.append(this.formatter.format(Calendar.getInstance().getTime()));
        switch (level) {
            case 50000: {
                sb.append("[FATAL]");
                break;
            }
            case 40000: {
                sb.append("[ERROR]");
                break;
            }
            case 30000: {
                sb.append("[WARN]");
                break;
            }
            case 20000: {
                sb.append("[INFO]");
                break;
            }
            case 10000: {
                sb.append("[DEBUG]");
                break;
            }
            default: {
                sb.append("[" + level + "]");
            }
        }
        sb.append(this.cls.getName());
        sb.append(".");
        sb.append(ste.getMethodName());
        sb.append("(");
        sb.append(ste.getFileName());
        sb.append(":");
        sb.append(ste.getLineNumber());
        sb.append(")- ");
        sb.append(msg);
        PrintWriter writer = null;
        try {
            writer = new PrintWriter(new FileWriter(this.filename, true));
            writer.println(sb.toString());
            if (th != null) {
                th.printStackTrace(writer);
            }
        }
        catch (IOException ex) {
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
        if (level > threshold) {
            System.out.println(msg);
        }
        if (th != null) {
            th.printStackTrace();
        }
    }

    public void debug(Object msg) {
        this.log(10000, msg, null);
    }

    public void debug(Object msg, Throwable th) {
        this.log(10000, msg, th);
    }

    public void info(Object msg) {
        this.log(20000, msg, null);
    }

    public void info(Object msg, Throwable th) {
        this.log(20000, msg, th);
    }

    StackTraceElement getCallSideStackTraceElement() {
        StackTraceElement[] traces = new Throwable().getStackTrace();
        return traces[3];
    }
}

