/*
 * 쐬: 2008/05/21
 */
package cfdoc.parser;

import java.util.ArrayList;
import java.util.HashMap;

public class CfElement implements CfNode {
	public static final String OPEN_TAG = "OPEN";
	public static final String CLOSE_TAG = "CLOSE";
	public static final String SINGLE_TAG = "SINGLE";
	String type;
	final String tagname;
	ScannerPosition pos;
	HashMap attrMap = new HashMap();
	ArrayList attrList = new ArrayList();
	
	CfElement(String type, String tagname, ScannerPosition pos) {
		this.type = type;
		this.tagname = tagname;
		this.pos = pos;
	}
	boolean addAttribute(String name, String value) {
		if (attrMap == null) {
			attrMap = new HashMap();
			attrList = new ArrayList();
		}
		if (attrMap.containsKey(name)) return false; 
		attrMap.put(name.toLowerCase(), value);
		attrList.add(new Object[] { name, value});
		return true;
	}
	String getAttributeValue(String name) {
		return (String) attrMap.get(name.toLowerCase());
	}
	String getAttributeValue(String name, String defaultValue) {
		String result = (String) attrMap.get(name.toLowerCase());
		if (result == null) return defaultValue;
		return result;
	}
	void addExpression(String exp) {
		attrList.add(exp);
	}
	public String toString() {
		return "CfElement[" + tagname+"]"+type;
	}
}
