/*
 * 쐬: 2008/07/19
 */
package cfdoc.util;

import java.io.*;
import java.nio.charset.Charset;
import java.util.ArrayList;

public class FileUtil {
    /**
     * t@CeLXgCɓǂݍށB 
     * @param	file	\[Xt@C. nulls
     * @param	charsetName	LN^Zbg("windows-31j"Ȃ) nulls
     * @return	\[Xt@C̓e
     */
	public static String readFile(File file, String charsetName) throws IOException {
		assert file != null;
		assert charsetName != null;
        String source = "";
        BufferedReader reader = null;
        try {
        	reader = new BufferedReader(new InputStreamReader(new FileInputStream(file), charsetName));
			while (reader.ready()) {
				String line = reader.readLine();
				source += line + "\n";
			}
			return source;
        } finally {
        	if (reader != null) try { reader.close(); } catch (IOException ex) {}
        }		
	}

	/**
     * t@CeLXgCɓǂݍށB R[h̓ftHĝ̂gpB
     * @param	file	\[Xt@C. nulls
     * @return	\[Xt@C̓e
     */
	public static String readFile(File file) throws IOException {
		assert file != null;
		return readFile(file, Charset.defaultCharset().name());
	}
	public static void writeFile(File file, String content, String charsetName) throws IOException {
		assert file != null;
		assert content != null;
		assert charsetName != null;
        PrintWriter reader = null;
        try {
        	reader = new PrintWriter(new OutputStreamWriter(new FileOutputStream(file), charsetName));
			reader.print(content);
        } finally {
        	if (reader != null) reader.close(); 
        }		
	}	
	
	/**
	 * w肳ꂽpX̃t@CǂݍށB
	 * subdir  true ̂Ƃɂ́ATufBNgTB
	 * fBNgԂ̂Œ.
	 * t@CȂꍇ́A̔zԂB(nullł͂Ȃ)
	 * @param dir
	 * @return
	 */
	public static ArrayList collectFiles(File dir) {
		ArrayList result = new ArrayList();
		File[] files = dir.listFiles();
		for (int i=0; i<files.length; i++) {
			result.add(files[i]);
			if (files[i].isDirectory()) {
				result.addAll(collectFiles(files[i]));
			}
		}
		return result;
	}
	/**
	 * w肵fBNgȉ̃t@Cׂč폜B
	 * gpۂ͏\pSĎgƁB 
	 */
	public static void deleteDirs(File dir) throws IOException {
		if (dir.isDirectory()) {
			File[] files = dir.listFiles();
			for (int i=0; i<files.length; i++) {
				deleteDirs(files[i]);
			}
		}
		dir.delete();
	}
	/**
	 * 
	 */
	public static void copyFile(File src, File dst) throws IOException {
		assert src != null;
		assert dst != null;
		BufferedInputStream in = null;
		BufferedOutputStream out = null;
		try {
			in = new BufferedInputStream(new FileInputStream(src));
			out = new BufferedOutputStream(new FileOutputStream(dst));
			byte[] buf = new byte[4096];
			while (in.available() > 0) {
				int len = in.read(buf, 0, 4096);
				out.write(buf, 0, len);
			}
		} finally {
			if (in != null) try { in.close(); } catch (IOException ex) {}
			if (out != null) try { out.close(); } catch (IOException ex) {}
		}
	}
	public static void copyDir(File srcdir, File dstdir) throws IOException {
		assert srcdir != null;
		assert dstdir != null;
		dstdir.mkdirs();
		File[] files = srcdir.listFiles();
		for (int i=0; i<files.length; i++) {
			File dst = new File(dstdir.getPath()+File.separator+files[i].getName());
			if (files[i].isDirectory()) {
				copyDir(files[i], dst);
			} else {
				copyFile(files[i], dst);
			}
		}
	}
}
