/*
 * 쐬: 2008/05/22
 */
package cfdoc.util;

import java.util.ArrayList;

public class TextUtil {
	/**
	 * u.
	 * ꕶɕ̕ϊΏۂĂ悢B
	 * @param	str		ΏۂƂȂ镶
	 * @param	src		ϊO(ex."<")
	 * @param	dst		ϊ(ex."&lt;")
	 * @return			uꂽ
	 */
	public static String replace(String str, String src, String dst) {
		String newStr = "";
		int lastpos = 0;
		for(;;) {
			int pos = str.indexOf(src, lastpos);
			if(pos==-1) break;
			newStr += str.substring(lastpos, pos);
			newStr += dst;
			lastpos = pos + src.length();
		}
		return newStr + str.substring(lastpos);
	}
	public static String decodeXml(String str) {
		if (str.compareTo("<null/>") == 0) return null;
		str = replace(str, "&lt;", "<");
		str = replace(str, "&gt;", ">");
		str = replace(str, "&quot;", "\"");
		str = replace(str, "&amp;", "&");
		return str;
	}
	/**
	 * &,<,>," &amp; &lt; &gt; &quot;ɕϊ.
	 */
	public static String encodeXml(String str) {
		if (str == null) return "<null/>";
		str = replace(str, "&", "&amp;");
		str = replace(str, "<", "&lt;");
		str = replace(str, ">", "&gt;");
		str = replace(str, "\"", "&quot;");
		return str;
	}	
	/** strcountJԂԂBtimes("../", 3) => "../../../" */
	public static String times(String str, int count) {
		assert str != null;
		assert count >= 0: count;
		String result = "";
		for (int i=0; i<count; i++) {
			result += str;
		}
		return result;
	}
	/**
	 * sƂɕ𕪊B
	 * @param text
	 * @return
	 */
	public static String[] splitLine(String text) {
		ArrayList list = new ArrayList();
		int pos = text.indexOf("\n");
		while (pos != -1) {
			list.add(text.substring(0, pos+1));
			text = text.substring(pos+1);
			pos = text.indexOf("\n");
		}
		if (text.length() > 0) list.add(text);
		String[] result = new String[list.size()];
		for (int i=0; i<list.size(); i++) {
			result[i] = (String) list.get(i);
		}
		return result;
	}
}
