<cfprocessingdirective pageencoding="UTF-8"/>
<cfcontent type="text/html; charset=UTF-8"/>
<cfoutput>
<html>
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
<!--- Form変数の中から、システム情報を取得。 --->
<cfobject type="Java" class="cfdoc.util.TextUtil" name="class_TextUtil" />
<cfobject type="Java" class="cfdoc.parser.CfSystem" name="class_CfSystem" />
<cfset cfsystem=class_CfSystem.load("#Form.binfile#") />
	<title>#cfsystem.getProperty("SystemName", "")#</title>
	<link rel ="stylesheet" type="text/css" href="stylesheet.css" title="Style">
</head>

<body>
<cfscript>
	t = now();
	nowstr = DateFormat(t, "YYYY/MM/DD") & " " & TimeFormat(t, "hh:mm:ss");
</cfscript>
<center><b>ColdFusion API仕様</b></center>
<div align="right">cfdoc生成日: #cfsystem.getProperty("GenerateDate", "???")#</div>
<HR><!-- ===================================================================== -->
<h1><font size="-1">システム名:</font>#cfsystem.getProperty("SystemName", "")#</h1>

<ul>
ファイルの数: #cfsystem.getFileCount()#<br>
コンポーネントの数: #cfsystem.getComponentCount()#<br>
ユーザ定義関数の数: #cfsystem.getFunctionCount()#<br>
</ul>
<hr><!-- ===================================================================== -->
<h2>ファイル一覧</h2>

<table>
	<tr>
		<th width="50%">ファイル名</th>
		<th width="25%">コンポーネント数</th>
		<th width="25%">ユーザ定義関数数</th>
	</tr>
	<cfloop index="index" from=0 to="#cfsystem.getFileCount()-1#">
		<cfset cffile=cfsystem.getFile(index) />
		<tr>
			<td>
				<img src="./resources/cffile.png">
				<font class="FrameItemFont">
					<a href="file_#cffile.file.getName()#.html" target="contentFrame">#cffile.getRelativePath()#</a>
				</font>
			</td>
			<td align="right">#cffile.getComponentCount()#</td>
			<td align="right">#cffile.getFunctionCount()#</td>
		</tr>
	</cfloop>
</table>

<h2>コンポーネント一覧</h2>
<table>
	<tr>
		<th width="75%">ファイル名</th>
		<th width="25%">ユーザ定義関数数</th>
	</tr>
	<cfloop index="index" from=0 to="#cfsystem.getComponentCount()-1#">
		<cfset comp=cfsystem.getComponent(index) />
		<tr>
			<td>
				<img src="./resources/component.png">
				<font class="FrameItemFont">
					<a href="file_#comp.file.file.getName()#.html" target="contentFrame">#comp.file.getRelativePath()#</a>
				</font>
			</td>
<!---
			<td>
				#comp.getAttribute("name", "")#
			</td>
--->
			<td align="right">#comp.getFunctionCount()#</td>
		</tr>
	</cfloop>
</table>

<h2>ユーザ定義関数一覧</h2>
<table>
	<tr>
		<th>ユーザ定義関数名</th>
		<th>ファイル名</th>
	</tr>
	<cfloop index="index" from=0 to="#cfsystem.getFunctionCount()-1#">
		<cfset cffunc=cfsystem.getFunction(index) />
		<tr>
			<td>
				<cfinvoke component="cfdocUtils" method="writeFunctionSignature">
					<cfinvokeargument name="cffunc" value=#cffunc# />
				</cfinvoke>
			</td>
			<td>#cffunc.file.getRelativePath()#</td>
		</tr>
	</cfloop>
</table>
<hr><!-- ===================================================================== -->
<h2>リンク集</h2>
<a href="http://www.adobe.com/" target="_blank">adobe.com</a><br>
<a href="http://www.adobe.com/jp/" target="_blank">アドビ</a><br>
<a href="http://www.adobe.com/jp/products/coldfusion/?promoid=BQSVM" target="_blank">ColdFusion</a><br>
<a href="http://www.adobe.com/jp/devnet/coldfusion/" target="_blank">ColdFusion デベロッパーセンター</a><br>
<a href="http://www.adobe.com/support/documentation/jp/coldfusion/" target="_blank">ColdFusion 8リソース</a><br>
<!--- ココに便利なリンクを追加しましょう。 --->
<hr><!-- ===================================================================== -->
<div align="right">
<a href="https://sourceforge.jp/projects/cfdoc" target="sourceforge">cfdoc@SOURCEFORGE.JP</a>
<a href="http://sourceforge.jp/" target="sourceforge"><img src="http://sourceforge.jp/sflogo.php?group_id=673" width="96" height="31" border="0" alt="SourceForge.jp"></a>
</div>

</body>
</html>
</cfoutput>