// =====================================================================
//  $Id: Rs00ViewCommand.cc,v 1.1.1.1 2003/06/27 02:56:41 goiwai Exp $
//  $Name: CLDAQ-1-06-00 $
// =====================================================================
#include "TRunManager.hh"
#include "TUserInterface.hh"
#include "TOutputObjectFile.hh"
#include "TEnvironmentVariableTable.hh"

#include "Rs00ViewCommand.hh"
#include "Rs00RunAction.hh"

static const Tstring _name = "/local/rs00view";
static const Tstring _desc = "view multimeter";

Rs00ViewCommand::Rs00ViewCommand()
  : TCommand( _name, _desc )
{;}

Rs00ViewCommand::~Rs00ViewCommand()
{;}

Tvoid Rs00ViewCommand::Execute( const TstringList& arguments )
{
  const TEnvironmentVariableTable& envtable = 
    theRunManager -> GetEnvironmentVariableTable();
  Tstring bindir = envtable.GetEnvironmentValue( "RS00_BIN_DIR" );
  Tstring comname = bindir + Tslash + "rs00view";

  TUserInterface* ui = theRunManager -> GetUserInterface();
  Rs00RunAction* action = (Rs00RunAction*)( theRunManager -> GetRunAction() );
  Tstring filename = action -> GetOutputFile() -> GetFileName();
  Tstring com = "/system/shell";
  TstringList args;
  args.push_back( comname );
  args.push_back( filename );
  args.push_back( "&" );
  ui -> ExecuteCommand( com, args );
  return;
}
