// =====================================================================
//  $Id: Rs01ReadoutBookDefinition.cc,v 1.1 2003/07/06 03:21:34 goiwai Exp $
//  $Name: CLDAQ-1-06-00 $
// =====================================================================
#include "TReadoutList.hh"
#include "TReadoutSection.hh"
#include "TReadoutSegment.hh"
#include "TReadoutElement.hh"
#include "TCrate.hh"
#include "TRunManager.hh"
#include "TReadoutBook.hh"
#include "TEnvironmentVariableTable.hh"
#include "Rs01ReadoutBookDefinition.hh"

Rs01ReadoutBookDefinition::Rs01ReadoutBookDefinition()
  : TReadoutBookDefinition()
{;}

Rs01ReadoutBookDefinition::~Rs01ReadoutBookDefinition()
{;}

TReadoutBook* Rs01ReadoutBookDefinition::Define()
{
  // module IDs:
  //   RUN INFO
  //   MODEL 7702
  //   CLOCK
  //   TIMERxx ( 00-31 )
  //   EVENT ID

  const TEnvironmentVariableTable& envtable = 
    theRunManager -> GetEnvironmentVariableTable();
  Tint npin = envtable.GetIntegerValue( "RS01_KEITHLEY_CHANNEL" );


  TReadoutBook* book = new TReadoutBook();

  // define run begin record readout
  TReadoutList* runbegin = new TReadoutList( "RUN BEGIN" );
  TReadoutSection sec0( "RUN INFO" );
  TReadoutSegment runinfo( theCrate -> GetModule( "RUN INFO" ), "RUN INFO" );
  TReadoutSegment clock( theCrate -> GetModule( "CLOCK" ), "CLOCK" );
  sec0.push_back( runinfo );
  sec0.push_back( clock );
  runbegin -> push_back( sec0 );



  // define run end record readout
  TReadoutList* runend = new TReadoutList( "RUN END" );
  TReadoutSection sec1( "RUN INFO" );
  sec1.push_back( runinfo );
  sec1.push_back( clock );
  for ( Tint i = 0; i < npin; i ++ ) {
    Tstring modid = "TIMER" + itostr( i, 2 );
    Tstring segid = modid;
    TReadoutSegment seg( theCrate -> GetModule( modid ), segid );
    sec1.push_back( seg );
  }
  runend -> push_back( sec1 );



  // define event record readout
  TReadoutList* event = new TReadoutList( "EVENT" );
  TReadoutSection sec2( "EVENT INFO" );
  TReadoutSection sec3( "KEITHLEY" );
  TReadoutSegment evtid( theCrate -> GetModule( "EVENT ID" ), "EVENT ID" );
  sec2.push_back( evtid );

  TModule* m7702 = theCrate -> GetModule( "MODEL 7702" );
  TModule* clk = theCrate -> GetModule( "CLOCK" );
  for ( Tint i = 0; i < npin; i ++ ) {
    Tstring segid = "CHANNEL" + itostr( i, 2 );
    TReadoutSegment seg( segid );

    TReadoutElement ch( m7702, "VDC", i );
    TReadoutElement strtime( clk, "DATE", 0 );
    TReadoutElement inttime( clk, "SEC", 1 );
    TReadoutElement elapsed( clk, "ELAPSED", 2 );

    //ΥͥѤΥޡ
    Tstring modid = "TIMER" + itostr( i, 2 );    
    TModule* timer = theCrate -> GetModule( modid );
    TReadoutElement realelapsed( timer, "REAL ELAPSED", 0 );
    TReadoutElement realelapsedtotal( timer, "REAL ELAPSED TOTAL", 1 );

    seg.push_back( ch );
    seg.push_back( strtime );
    seg.push_back( inttime );
    seg.push_back( elapsed );
    seg.push_back( realelapsed );
    seg.push_back( realelapsedtotal );

    sec3.push_back( seg );
  }
  event -> push_back( sec2 );
  event -> push_back( sec3 );


  book -> AddReadoutList( runbegin );
  book -> AddReadoutList( runend );
  book -> AddReadoutList( event );

  return( book );
}
