// =====================================================================
//  $Id: St01DarkViewCommand.cc,v 1.3 2003/07/03 08:12:49 goiwai Exp $
//  $Name: CLDAQ-1-06-00 $
// =====================================================================
#include "TRunManager.hh"
#include "TUserInterface.hh"
#include "TOutputObjectFile.hh"
#include "TEnvironmentVariableTable.hh"

#include "St01DarkViewCommand.hh"
#include "St01RunAction.hh"

static const Tstring _name = "/local/st01darkview";
static const Tstring _desc = "view histograms in DARK run.";

St01DarkViewCommand::St01DarkViewCommand()
  : TCommand( _name, _desc )
{;}

St01DarkViewCommand::~St01DarkViewCommand()
{;}

Tvoid St01DarkViewCommand::Execute( const TstringList& arguments )
{
  const TEnvironmentVariableTable& envtable = 
    theRunManager -> GetEnvironmentVariableTable();
  Tstring bindir = envtable.GetEnvironmentValue( "ST01_BIN_DIR" );

  TstringList args;
  Tstring comname = bindir + Tslash + "st01darkview";
  Tstring runid = theRunManager -> GetRun().GetStringRunID();

  args.push_back( comname );
  args.push_back( runid );
  args.push_back( "&" );

  TUserInterface* ui = theRunManager -> GetUserInterface();
  Tstring com = "/system/shell";
  ui -> ExecuteCommand( com, args );

  return;
}
