// =====================================================================
//  $Id: St01SignalViewCommand.cc,v 1.2 2003/06/30 03:43:37 goiwai Exp $
//  $Name: CLDAQ-1-06-00 $
// =====================================================================
#include "TRunManager.hh"
#include "TEnvironmentVariableTable.hh"
#include "TUserInterface.hh"
#include "TOutputObjectFile.hh"

#include "St01SignalViewCommand.hh"
#include "St01RunAction.hh"

static const Tstring _name = "/local/st01signalview";
static const Tstring _desc = "view histograms, subtracted H.O.C and dark.";

St01SignalViewCommand::St01SignalViewCommand()
  : TCommand( _name, _desc )
{;}

St01SignalViewCommand::~St01SignalViewCommand()
{;}

Tvoid St01SignalViewCommand::Execute( const TstringList& arguments )
{
  const TEnvironmentVariableTable& envtable = 
    theRunManager -> GetEnvironmentVariableTable();
  Tstring bindir = envtable.GetEnvironmentValue( "ST01_BIN_DIR" );

  TstringList args;
  Tstring comname = bindir + Tslash + "st01signalview";
  Tstring runid = theRunManager -> GetRun().GetStringRunID();
  args.push_back( comname );
  args.push_back( runid );
  args.push_back( "&" );
  

  TUserInterface* ui = theRunManager -> GetUserInterface();
  Tstring com = "/system/shell";
  ui -> ExecuteCommand( com, args );

  return;
}
