// =====================================================================
//  $Id: St02DarkDataSet.hh,v 1.1 2003/07/11 05:34:13 goiwai Exp $
//  $Name: CLDAQ-1-06-00 $
// =====================================================================
#ifndef __ST02DARKDATASET_HH
#define __ST02DARKDATASET_HH

#include "Tglobals.h"

class St02DarkDataSet
{

  private:
    Tdouble theTemperature;
    Tdouble theCycle;
    Tdouble theVoltage;
    Tdouble theAverage;
    Tdouble theRms;
    // ====
    //  RMSη׻˻Ȥäԥ
    //  theRms/sqrt( theNumberOfData ) Υ顼Ȥʤ
    Tdouble theNumberOfData;
    // ====
    Tint theNumberOfBadChannels;
    Tstring theFileName;

  public:
    St02DarkDataSet( Tdouble temp = 0.0, Tdouble cycle = 0.0, Tdouble v = 0.0, Tdouble ave = 0.0, Tdouble rms = 0.0, Tdouble ndata = 0.0, Tint nbad = 0, const Tstring& file = "" );
    St02DarkDataSet( const St02DarkDataSet& right );
    ~St02DarkDataSet();

  public:
    const St02DarkDataSet& operator=( const St02DarkDataSet& right );
    friend Tostream& operator<<( Tostream& tos, const St02DarkDataSet& right );
    friend Tistream& operator>>( Tistream& tis, St02DarkDataSet& right );

  public:
    Tdouble GetTemperature() const;
    Tdouble GetCycle() const;
    Tdouble GetVoltage() const;
    Tdouble GetAverage() const;
    Tdouble GetRms() const;
    Tdouble GetNumberOfData() const;
    Tint GetNumberOfBadChannels() const;
    const Tstring& GetFileName() const;
    Tvoid SetTemperature( Tdouble temp );
    Tvoid SetCycle( Tdouble cycle );
    Tvoid SetVoltage( Tdouble v );
    Tvoid SetAverage( Tdouble ave );
    Tvoid SetRms( Tdouble rms );
    Tvoid SetNumberOfData( Tdouble ndata );
    Tvoid SetNumberOfBadChannels( Tint nbad );
    Tvoid SetFileName( const Tstring& file );

};

inline Tdouble St02DarkDataSet::GetTemperature() const
{
  return( theTemperature );
}

inline Tdouble St02DarkDataSet::GetCycle() const
{
  return( theCycle );
}

inline Tdouble St02DarkDataSet::GetVoltage() const
{
  return( theVoltage );
}

inline Tdouble St02DarkDataSet::GetAverage() const
{
  return( theAverage );
}

inline Tdouble St02DarkDataSet::GetRms() const
{
  return( theRms );
}

inline Tdouble St02DarkDataSet::GetNumberOfData() const
{
  return( theNumberOfData );
}

inline Tint St02DarkDataSet::GetNumberOfBadChannels() const
{
  return( theNumberOfBadChannels );
}

inline const Tstring& St02DarkDataSet::GetFileName() const
{
  return( theFileName );
}

inline Tvoid St02DarkDataSet::SetTemperature( Tdouble temp )
{
  theTemperature = temp;
  return;
}

inline Tvoid St02DarkDataSet::SetCycle( Tdouble cycle )
{
  theCycle = cycle;
  return;
}

inline Tvoid St02DarkDataSet::SetVoltage( Tdouble v )
{
  theVoltage = v;
  return;
}

inline Tvoid St02DarkDataSet::SetAverage( Tdouble ave )
{
  theAverage = ave;
  return;
}

inline Tvoid St02DarkDataSet::SetRms( Tdouble rms )
{
  theRms = rms;
  return;
}

inline Tvoid St02DarkDataSet::SetNumberOfData( Tdouble ndata )
{
  theNumberOfData = ndata;
  return;
}

inline Tvoid St02DarkDataSet::SetNumberOfBadChannels( Tint nbad )
{
  theNumberOfBadChannels = nbad;
  return;
}

inline Tvoid St02DarkDataSet::SetFileName( const Tstring& file )
{
  theFileName = file;
  return;
}

#endif
