// =====================================================================
//  $Id: St02DarkViewCommand.cc,v 1.1 2003/07/11 05:34:14 goiwai Exp $
//  $Name: CLDAQ-1-06-00 $
// =====================================================================
#include "TRunManager.hh"
#include "TUserInterface.hh"
#include "TOutputObjectFile.hh"
#include "TEnvironmentVariableTable.hh"

#include "St02DarkViewCommand.hh"
#include "St02RunAction.hh"

static const Tstring _name = "/local/st02darkview";
static const Tstring _desc = "view histograms in DARK run.";

St02DarkViewCommand::St02DarkViewCommand()
  : TCommand( _name, _desc )
{;}

St02DarkViewCommand::~St02DarkViewCommand()
{;}

Tvoid St02DarkViewCommand::Execute( const TstringList& arguments )
{
  const TEnvironmentVariableTable& envtable = 
    theRunManager -> GetEnvironmentVariableTable();
  Tstring bindir = envtable.GetEnvironmentValue( "ST02_BIN_DIR" );

  TstringList args;
  Tstring comname = bindir + Tslash + "st02darkview";
  Tstring runid = theRunManager -> GetRun().GetStringRunID();

  args.push_back( comname );
  args.push_back( runid );
  args.push_back( "&" );

  TUserInterface* ui = theRunManager -> GetUserInterface();
  Tstring com = "/system/shell";
  ui -> ExecuteCommand( com, args );

  return;
}
