// =====================================================================
//  $Id: TAddRunInformationModuleCommand.cc,v 1.1.1.1 2003/06/27 02:56:41 goiwai Exp $
//  $Name: CLDAQ-1-06-00 $
// =====================================================================
#include "TAddRunInformationModuleCommand.hh"
#include "TRunManager.hh"
#include "TSoftwareRunInformationModule.hh"
#include "TRunInformationTable.hh"

static const Tstring _name = "/run/addinfo";
static const Tstring _desc = "add run information into the table.";

TAddRunInformationModuleCommand::TAddRunInformationModuleCommand( TRunManager* manager, TSoftwareRunInformationModule* module )
  : TCommand( manager, _name, _desc ), TRunInformationModuleCommand( module )
{;}

TAddRunInformationModuleCommand::~TAddRunInformationModuleCommand()
{;}

Tvoid TAddRunInformationModuleCommand::Execute( const TstringList& arguments )
{
  if ( theRunInformationModule == 0 ) {
    return;
  }

  TRunInformationTable& table =
    theRunInformationModule -> GetRunInformationTable();
  table.AddRunInformation();

  return;
}
