// =====================================================================
//  $Id: TClearRunInformationModuleCommand.cc,v 1.1.1.1 2003/06/27 02:56:41 goiwai Exp $
//  $Name: CLDAQ-1-06-00 $
// =====================================================================
#include "TClearRunInformationModuleCommand.hh"
#include "TRunManager.hh"
#include "TSoftwareRunInformationModule.hh"
#include "TRunInformationTable.hh"

static const Tstring _name = "/run/clearinfo";
static const Tstring _desc = "clear run information in the table.";

TClearRunInformationModuleCommand::TClearRunInformationModuleCommand( TRunManager* manager, TSoftwareRunInformationModule* module )
  : TCommand( manager, _name, _desc ), TRunInformationModuleCommand( module )
{;}

TClearRunInformationModuleCommand::~TClearRunInformationModuleCommand()
{;}

Tvoid TClearRunInformationModuleCommand::Execute( const TstringList& arguments )
{
  if ( theRunInformationModule == 0 ) {
    return;
  }
  theRunInformationModule -> Clear();

  return;
}
