// =====================================================================
//  $Id: TPrintAllEnvironmentVariablesCommand.cc,v 1.1.1.1 2003/06/27 02:56:41 goiwai Exp $
//  $Name: CLDAQ-1-06-00 $
// =====================================================================
#include "TPrintAllEnvironmentVariablesCommand.hh"
#include "TUserInterface.hh"
#include "TRunManager.hh"

static const Tstring _name = "env";
static const Tstring _desc = "print all of environment.";

TPrintAllEnvironmentVariablesCommand::TPrintAllEnvironmentVariablesCommand( TRunManager* manager )
  : TCommand( manager, _name, _desc )
{;}

TPrintAllEnvironmentVariablesCommand::~TPrintAllEnvironmentVariablesCommand()
{;}

Tvoid TPrintAllEnvironmentVariablesCommand::Execute( const TstringList& arguments )
{
  if ( arguments.empty() ) {
    TUserInterface* ui = theRunManager -> GetUserInterface();
    ui -> ExecuteCommand( "printenv" );
  } else {
    ShowCommandDetail();
  }
  return;
}
