// =====================================================================
//  $Id: TSoftwareFlashAdcModule.hh,v 1.1.1.1 2003/06/27 02:56:41 goiwai Exp $
//  $Name: CLDAQ-1-06-00 $
// =====================================================================
#ifndef __TSOFTWAREFLASHADCMODULE_HH
#define __TSOFTWAREFLASHADCMODULE_HH

#include "Tglobals.h"
#include "TSoftwareModule.hh"

class TDataSegment;
class TDataElement;

class TSoftwareFlashAdcModule
  : public TSoftwareModule
{

  private:
    enum { tDefaultSampling = 62500 };
    enum { tDefaultChannel = 1 };

  private:
    Tint theNumberOfSampling;

  public:
    TSoftwareFlashAdcModule( Tint nchannel = tDefaultChannel, Tint nsampling = tDefaultSampling );
    TSoftwareFlashAdcModule( const TSoftwareFlashAdcModule& right ); 
   ~TSoftwareFlashAdcModule();

  public:
    Tint Clear();
    Tint Update();
    Tint Initialize();
    Tvoid FillData( TDataElement& element, Tint channel );

  public:
    const TSoftwareFlashAdcModule& operator=( const TSoftwareFlashAdcModule& right );
    Tbool operator==( const TSoftwareFlashAdcModule& right ) const;
    Tbool operator!=( const TSoftwareFlashAdcModule& right ) const;

  public:
    Tint GetNumberOfSampling() const;
    Tvoid SetNumberOfSampling( Tint nsampling );

  protected:
    Tvoid setParameters();
    Tvoid fillValue();

};

inline Tint TSoftwareFlashAdcModule::GetNumberOfSampling() const
{
  return( theNumberOfSampling );
}

inline Tvoid TSoftwareFlashAdcModule::SetNumberOfSampling( Tint nsampling )
{
  theNumberOfSampling = nsampling;
  return;
}

#endif
