// =====================================================================
//  $Id: TOutputObjectFile.cc,v 1.1.1.1 2003/06/27 02:56:41 goiwai Exp $
//  $Name: CLDAQ-1-06-00 $
// =====================================================================
#include "TOutputObjectFile.hh"
#include "TObjectFilter.hh"

TOutputObjectFile::TOutputObjectFile( const Tstring& filename, const Tstring& mode )
  : TObjectFile( filename, mode ), TOutputObjectStream( tFileStream )
{;}

TOutputObjectFile::TOutputObjectFile( TObjectFilter* filter, const Tstring& filename, const Tstring& mode )
  : TObjectFile( filename, mode ), TOutputObjectStream( filter, tFileStream )
{;}

TOutputObjectFile::~TOutputObjectFile()
{;}

Tint TOutputObjectFile::Write( TStreamableObject& object )
{
  theLastDataSize = theDataSize;
  theDataSize = 0;
  if ( HasFilter() ) {
    theDataSize = theObjectFilter -> Filtering( object, this );
  } else {
    theDataSize = object.Record( this );
  }
  theTotalDataSize += theDataSize;
  return( theDataSize );
}
