// =====================================================================
//  $Id: syswrite.cc,v 1.1 2003/12/08 04:26:23 goiwai Exp $
//  $Name: CLDAQ-1-11-00 $
//  $Log: syswrite.cc,v $
//  Revision 1.1  2003/12/08 04:26:23  goiwai
//  4kB read/write ץ
//  褱ʤȤϤäʤǤ.
//  ɾѤˤɤ.
//
// =====================================================================
#include "TBenchmark.hh"
#include "TSystemTimer.hh"
#include "TFileProperty.hh"
#include "constants.h"

int main()
{
  const Tint buflen = 0x1000;
  Tbyte buf[buflen];
  const Tsize_t recordsize = Tsizeof(buf) * Tsizeof(Tbyte);

  for ( Tint i = 0; i < len; i ++ ) {
    Tint max = nevent[i];
    Tstring filename = "syswrite" + itostr(max,0) + ".dat";
    TBenchmark bench;
    bench.Start();
    Tint flags = O_RDWR|O_CREAT|O_TRUNC;
    Tint mode = S_IRUSR|S_IWUSR|S_IRGRP|S_IROTH;
    Tint fd = open(filename.c_str(),flags,mode);
    for ( Tint event = 0; event < max; event ++ ) {
      write(fd,buf,recordsize);
    }
    close(fd);
    bench.Stop();

    TFileProperty p(filename);
    Tcout << recordsize << " "
          << max << " "
          << p.GetTotalSize() << " "
          << bench.GetSystemTimer().GetRealElapsedTime() << Tendl;
  }

  return 0;
}
