// =====================================================================
/*!
//
//  \file TVmeMpx201aModule.hh
//  \brief This file contains the TVmeMpx201aModule class.
//  \author Go IWAI <goiwai@users.sourceforge.jp>
//
//  $Id: TVmeMpx201aModule.hh,v 1.4 2003/11/03 08:35:13 goiwai Exp $
//  $Name: CLDAQ-1-11-00 $
//  $Log: TVmeMpx201aModule.hh,v $
//  Revision 1.4  2003/11/03 08:35:13  goiwai
//  DoxygenѤΥȥȤ򤦤Ǥߤ򳫻Ϥޤ.
//
//  Revision 1.3  2003/10/06 17:02:40  goiwai
//  *** empty log message ***
//
//  Revision 1.2  2003/07/30 16:19:12  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
*/
// =====================================================================
#ifndef __TVMEMPX201AMODULE_HH
#define __TVMEMPX201AMODULE_HH

#include "Tglobals.h"
#include "TVmeModule.hh"

class TDataElement;


/*!
// \example
//
// If example code exists.
//
*/

/*!
// \class TVmeMpx201aModule
// \brief This is the TVmeMpx201aModule class.
// \author Go IWAI <goiwai@users.sourceforge.jp>
//
// The TVmeMpx201aModule class detail description.
// Write it down ASAP!
//
// \todo None?
// \bug None?
// \ingroup ModulesCategory
*/
class TVmeMpx201aModule
  : public TVmeModule
{

  private:
    enum {
      ID = 0x00,
      DEVICE_TYPE = 0x02,
      CONTROL_STATUS = 0x04,
      VME_OFFSET_ADDRESS = 0x06,
      PAGE_SET = 0x08,
      RESERVED = 0x0a,
      TEST_MODE = 0x0c,
      TEST_DATA = 0x0e,
      INTERRUPT = 0x10,
      BLOCK_COUNT = 0x12,
      DAQ_POINTER = 0x14,
      SAMPLE_RATE = 0x16,
      FRONT_PORCH = 0x18,
      FRAME_LENGTH = 0x1a,
      ROW_LENGTH = 0x1c
    };

  public:
    enum {
      tIdRegister,
      tDeviceTypeRegister,
      tControlStatusRegister,
      tVmeOffsetAddressRegister,
      tPageSetAddressRegister,
      tReserved,
      tTestModeRegister,
      tTestDataRegister,
      tInterruptConfigurationRegister,
      tBlockCounterRegister,
      tAcquisitionPointerRegister,
      tSampleRateRegister,
      tFrontPorchRegister,
      tFrameLengthRegister,
      tRowLengthRegister,
      tNumberOfChannels
    };

  public:
    enum Tsync_t {
      tScannerMode,
      tInternalSynchronisationMode,
      tExternalSynchronisationMode,
      tModeUnknown = -1
    };

    enum TdataCapture_t {
      tTransientMode,
      tContinuousMode
    };

    enum { tBlock = 2048 };

  public:
    TVmeMpx201aModule( Toff_t offset, Tint mapsize = 0x1000, Tint nch = tNumberOfChannels );
    TVmeMpx201aModule( const TVmeMpx201aModule& right );
    ~TVmeMpx201aModule();

  public:
    const TVmeMpx201aModule& operator=( const TVmeMpx201aModule& right );
    Tbool operator==( const TVmeMpx201aModule& right ) const;
    Tbool operator!=( const TVmeMpx201aModule& right ) const;

  public:
    Tint Clear();
    Tint Update();
    Tint Initialize();
    Tvoid FillData( TDataElement& element, Tint channel );

  public:
    Tshort GetProductID() const;
    Tshort GetDeviceType() const;
    Tbool IsMemoryBlockFull() const;
    Tbool IsDataOverFlow() const;
    Tsync_t GetEventSynchronisationMode() const;
    Toff_t GetOffsetAddressForDaughterBoard() const;
    Tint GetPage() const;
    Tint GetNumberOfBlock() const;
    Tvoid EnableAccessToDaughterBoard();
    Tvoid DisableAccessToDaughterBoard();
    Tvoid SetBufferOrientation( Tbit bit );
    Tvoid SetScanCompleteFlag( Tbit bit );
    Tvoid SetMemoryBlockFullFlag( Tbit bit );
    Tvoid SetDataOverFlowFlag( Tbit bit );
    Tvoid SetEventSynchronisationMode( Tsync_t mode );
    Tvoid SetDataCaptureMode( TdataCapture_t mode );
    Tvoid EnableAcquisition();
    Tvoid DisableAcquisition();
    Tvoid EnableSystemFailure();
    Tvoid DisableSystemFailure();
    Tvoid Reset();
    Tvoid SetOffsetAddressForDaughterBoard( Toff_t offset );
    Tvoid SetPage( Tint id );
    Tvoid SetSamplingRate( Tint nsample );
    Tvoid SetNumberOfBlock( Tint nblock );
    Tvoid SetupCCDmeasurement( Tint rate, Tint nblock, Toff_t offset );
    Tint GetMappingSizeOfDaughterBoard() const;
    Tvoid NextEventProcedure();
    TUshort Read( Tint ch );

};

inline Tint TVmeMpx201aModule::GetNumberOfBlock() const
{
  // 1block = 2048 sampling
  Tshort retval = *( (Tshort*)( theBaseAddress + BLOCK_COUNT ) );
  retval &= 0x7fff;
  return (Tint)retval;
}

inline Tshort TVmeMpx201aModule::GetProductID() const
{
  return *( (Tshort*)( theBaseAddress + ID ) );
}

inline Tshort TVmeMpx201aModule::GetDeviceType() const
{
  return *( (Tshort*)( theBaseAddress + DEVICE_TYPE ) );
}

inline Tbool TVmeMpx201aModule::IsMemoryBlockFull() const
{
  return getBit( (TUshort*)( theBaseAddress + CONTROL_STATUS ), 9 );
}

inline Tbool TVmeMpx201aModule::IsDataOverFlow() const
{
  return getBit( (TUshort*)( theBaseAddress + CONTROL_STATUS ), 8 );
}

inline Tint TVmeMpx201aModule::GetPage() const
{
  Tshort regval = *( (Tshort*)( theBaseAddress + PAGE_SET ) );
  regval &= 0x0007;
  return (Tint)regval;
}

inline Tvoid TVmeMpx201aModule::EnableAccessToDaughterBoard()
{
  setBit( (TUshort*)( theBaseAddress + CONTROL_STATUS ), 15, 1 );
  return;
}

inline Tvoid TVmeMpx201aModule::DisableAccessToDaughterBoard()
{
  setBit( (TUshort*)( theBaseAddress + CONTROL_STATUS ), 15, 0 );
  return;
}

inline Tvoid TVmeMpx201aModule::SetBufferOrientation( Tbit bit )
{
  setBit( (TUshort*)( theBaseAddress + CONTROL_STATUS ), 11, bit );
  return;
}

inline Tvoid TVmeMpx201aModule::SetScanCompleteFlag( Tbit bit )
{
  setBit( (TUshort*)( theBaseAddress + CONTROL_STATUS ), 10, bit );
  return;
}

inline Tvoid TVmeMpx201aModule::SetMemoryBlockFullFlag( Tbit bit )
{
  setBit( (TUshort*)( theBaseAddress + CONTROL_STATUS ), 9, bit );
  return;
}

inline Tvoid TVmeMpx201aModule::SetDataOverFlowFlag( Tbit bit )
{
  setBit( (TUshort*)( theBaseAddress + CONTROL_STATUS ), 8, bit );
  return;
}

inline Tvoid TVmeMpx201aModule::EnableAcquisition()
{
  setBit( (TUshort*)( theBaseAddress + CONTROL_STATUS ), 4, 0 );
  return;
}

inline Tvoid TVmeMpx201aModule::DisableAcquisition()
{
  setBit( (TUshort*)( theBaseAddress + CONTROL_STATUS ), 4, 1 );
  return;
}

inline Tvoid TVmeMpx201aModule::EnableSystemFailure()
{
  setBit( (TUshort*)( theBaseAddress + CONTROL_STATUS ), 1, 0 );
  return;
}

inline Tvoid TVmeMpx201aModule::DisableSystemFailure()
{
  setBit( (TUshort*)( theBaseAddress + CONTROL_STATUS ), 1, 1 );
  return;
}

inline Tvoid TVmeMpx201aModule::Reset()
{
  setBit( (TUshort*)( theBaseAddress + CONTROL_STATUS ), 0, 1 );
  return;
}

#endif
