// =====================================================================
/*!
//
//  \file TReadoutIndex.hh
//  \brief This file contains the TReadoutIndex class.
//  \author Go IWAI <goiwai@users.sourceforge.jp>
//
//  $Id: TReadoutIndex.hh,v 1.4 2003/11/03 08:35:14 goiwai Exp $
//  $Name: CLDAQ-1-11-00 $
//  $Log: TReadoutIndex.hh,v $
//  Revision 1.4  2003/11/03 08:35:14  goiwai
//  DoxygenѤΥȥȤ򤦤Ǥߤ򳫻Ϥޤ.
//
//  Revision 1.3  2003/10/06 16:39:00  goiwai
//  *** empty log message ***
//
//  Revision 1.2  2003/07/30 16:20:11  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
*/
// =====================================================================
#ifndef __TREADOUTINDEX_HH
#define __TREADOUTINDEX_HH

#include "Tglobals.h"
#include "TReadoutSpecified.hh"

class TReadoutList;


/*!
// \example
//
// If example code exists.
//
*/

/*!
// \class TReadoutIndex
// \brief This is the TReadoutIndex class.
// \author Go IWAI <goiwai@users.sourceforge.jp>
//
// The TReadoutIndex class detail description.
// Write it down ASAP!
//
// \todo None?
// \bug None?
// \ingroup ReadoutCategory
*/
class TReadoutIndex
  : public Tvector<TReadoutSpecified>
{

  public:
    TReadoutIndex();
    ~TReadoutIndex();

  public:
    TReadoutList* FindReadoutList( const Tstring& id ) const;
    Tvoid AddReadoutList( const Tstring& id, TReadoutList* readoutlist );
    Tvoid RemoveReadoutList( Tint index );
    Tint GetSize() const;
    Tvoid Clear();

};

#endif
