<?php

/*
 * ꥹȥǡե쥯饹
 * $Id: alist.php,v 1.5 2003/01/25 07:08:04 yuryu Exp $
 *
 */

class AList
{
	var $fname;
	var $id;
	
	function AList($afname, $aid)
	{
		$this -> fname = $afname;
		$this -> id = $aid;
	}

	function get($avalue)
	{
		$fp = fopen($this -> fname, "r");
		flock($fp, LOCK_SH);
		while($result = $this -> read_data($fp)){
			if($result[$this -> id] == $avalue)
			{
				fclose($fp);
				return $result;
			}
		}
		fclose($fp);
		return false;
	}
	
	function set($adata)
	{
		$temp_fname = tempnam(DATA_DIRECTORY, 'aset_');
		copy($this -> fname, $temp_fname);
		$rfp = fopen($temp_fname, "r");
		flock($rfp, LOCK_SH);
		$wfp = fopen($this -> fname, "a");
		flock($wfp, LOCK_EX);
		ftruncate($wfp, 0);

		$found = false;
		
		while($stored_data = $this -> read_data($rfp)){

			if($this -> compare($stored_data, $adata)){
				$found = true;
				$this -> write_data($wfp, $adata);
			}else{
				$this -> write_data($wfp, $stored_data);
			}
		}
		if($found == false){
			$this -> write_data($wfp, $adata);
		}
		fclose($rfp);
		fclose($wfp);
		unlink($temp_fname);
		
	}
	
	function remove($avalue)
	{
		$temp_fname = tempnam(DATA_DIRECTORY, 'aset_');
		copy($this -> fname, $temp_fname);
		$rfp = fopen($temp_fname, "r");
		flock($rfp, LOCK_SH);
		$wfp = fopen($this -> fname, "a");
		flock($wfp, LOCK_EX);
		ftruncate($wfp, 0);
		
		$found = false;
		
		while($data = $this -> read_data($rfp)){
			if($data[$this -> id] == $avalue)
			{
				$found = true;
				continue;
			}
			$this -> write_data($wfp, $data);
		}
		fclose($rfp);
		fclose($wfp);
		unlink($temp_fname);
		
		return $found;
	}
	
	function skip_data($fp)
	{
		while($line = fgets($fp)){
			if(trim($line) == ''){
				return true;
			}
		}
		return false;
	}
	
	function write_data($fp, $data)
	{
		foreach($data as $key => $value){
			fputs($fp, sprintf("%s\t%s\n", $key, $value));
		}
		fputs($fp, "\n");
		return true;
	}
	
	function read_data($fp)
	{
		while($line = fgets($fp)){
			$line = trim($line);
			if($line == ''){
				return $result;
			}
			list($key, $value) = explode("\t", $line);
			$result[$key] = $value;
		}
		return false;
	}

	function get_list($sorted_by = false, $reverse = false, $filter = false)
	{
		$fp = fopen($this -> fname, "r");
		flock($fp, LOCK_SH);
		$temp = array();
		$result = array();
		while($data = $this -> read_data($fp)){
			if($filter){
				if($data[$filter['key']] != $filter['value']){
					continue;
				}
			}
			if($sorted_by){
				array_push($temp, $data);
				$sortinfo[] = $data[$sorted_by];
			}else{
				array_push($result, $data);
			}
		}
		fclose($fp);

		if($sorted_by){
			if($reverse){
				arsort($sortinfo);
			}else{
				asort($sortinfo);
			}
			foreach($sortinfo as $key => $value){
				array_push($result, $temp[$key]);
			}
		}
		
		return $result;
		
	}
	
	function compare($lhs, $rhs)
	{
		if($lhs[$this -> id] == $rhs[$this -> id]){
			return true;
		}
		return false;
	}

}

?>
