<?php

/*
 * Herald  XML ǡϢȥץ쥤
 * $Id: readxmls.php,v 1.3 2003/01/11 16:19:59 yuryu Exp $
 *
 */

require_once("./settings.php");
require_once("./clist.php");


function startElement($parser, $tagName, $attrs)
{
	global $character_list, $current_char, $current_tag;
	
	$current_tag = $tagName;
	// 饯
	if ($tagName == "CHARACTER")
	{
		foreach($attrs as $key => $value){
			switch ($key){
				case "NAME":
					list($first_name, $last_name) = explode(" ", $value);
					$current_char = $character_list -> get($first_name);
					break;
			}
		}
	}
}
	
function characterData($parser, $data)
{
	global $element;

	$element = $data;
	
}

function endElement($parser, $tagName)
{
	global $character_list, $current_char, $element;

	if ($tagName == "CHARACTER")
	{
		if($current_char){
			if($current_char['ldeath']){
				$current_char['irs'] = (double)$current_char['lrp'] / (double)$current_char['ldeath'];
			}else{
				$current_char['irs'] = $current_char['lrp'] . '.0';
			}
			$character_list -> set($current_char);
			$current_char = false;
		}
	}
	if($current_char){
		switch($tagName){
			case "RACE": $current_char['race'] = $element; break;
			case "CLASS": $current_char['class'] = $element; break;
			case "LEVEL": $current_char['level'] = $element; break;
			case "GUILDRANK": $current_char['rank'] = $element; break;
			case "TOTALRP": $current_char['rp'] = $element; break;
			case "LASTWEEKRP": $current_char['lrp'] = $element; break;
			case "TOTALDEATHS": $current_char['death'] = $element; break;
			case "LASTWEEKDEATHS": $current_char['ldeath'] = $element; break;
			case "WEAPONCRAFT": $current_char['Weaponcraft'] = $element; break;
			case "ARMORCRAFT": $current_char['Armorcraft'] = $element; break;
			case "TAILORING": $current_char['Tailoring'] = $element; break;
			case "FLETCHING": $current_char['Fletching'] = $element; break;
			case "SPELLCRAFT": $current_char['Spellcraft'] = $element; break;
			case "ALCHEMY": $current_char['Alchemy'] = $element; break;
		}
	}
}

function parse_xml($xml_path)
{
	global $character_list;
	
	$character_list = new CharacterList(CHARDATA_FNAME);
	// Open the XML file for reading
	$xfp = fopen($xml_path, "r")  or die("Error reading xml data.");

	// Read the XML file 4KB at a time

	// Create an XML parser
	$xml_parser = xml_parser_create();

	// Set the functions to handle opening and closing tags
	xml_set_element_handler($xml_parser, "startElement", "endElement");

	// Set the function to handle blocks of character data
	xml_set_character_data_handler($xml_parser, "characterData");

	while ($data = fread($xfp, 4096))
		// Parse each 4KB chunk with the XML parser created above
		xml_parse($xml_parser, $data, feof($xfp)) 
			or die(sprintf("XML error: %s at line %d while parsing %s",
				xml_error_string(xml_get_error_code($xml_parser)),
					xml_get_current_line_number($xml_parser), $xml_path));
	// Close the XML filef
	fclose($xfp);
	
	xml_parser_free($xml_parser);
	
}

?>
