/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.types;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import org.hsqldb.HsqlDateTime;
import org.hsqldb.Session;
import org.hsqldb.SessionInterface;
import org.hsqldb.error.Error;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.StringConverter;
import org.hsqldb.lib.StringUtil;
import org.hsqldb.lib.java.JavaSystem;
import org.hsqldb.types.BlobData;
import org.hsqldb.types.Charset;
import org.hsqldb.types.ClobData;
import org.hsqldb.types.ClobDataID;
import org.hsqldb.types.ClobType;
import org.hsqldb.types.Collation;
import org.hsqldb.types.Type;

public class CharacterType
extends Type {
    static final int defaultCharPrecision = 256;
    static final int defaultVarcharPrecision = 32768;
    static final long maxCharPrecision = Integer.MAX_VALUE;
    Collation collation;
    Charset charset;
    boolean isEqualIdentical;
    String nameString;
    private static final int fixedTypesLength = 32;
    static CharacterType[] charArray = new CharacterType[32];

    public CharacterType(Collation collation, int n, long l) {
        super(12, n, l, 0);
        if (collation == null) {
            collation = Collation.defaultCollation;
        }
        this.collation = collation;
        this.charset = Charset.getDefaultInstance();
        this.isEqualIdentical = this.collation.isEqualAlwaysIdentical() && n != 100;
        this.nameString = this.getNameStringPrivate();
    }

    public CharacterType(int n, long l) {
        super(12, n, l, 0);
        this.collation = Collation.getDefaultInstance();
        this.charset = Charset.getDefaultInstance();
        this.isEqualIdentical = n != 100;
        this.nameString = this.getNameStringPrivate();
    }

    @Override
    public int displaySize() {
        return this.precision > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)this.precision;
    }

    @Override
    public int getJDBCTypeCode() {
        switch (this.typeCode) {
            case 1: {
                return 1;
            }
            case 12: 
            case 100: {
                return 12;
            }
            case 40: {
                return 2005;
            }
        }
        throw Error.runtimeError(201, "CharacterType");
    }

    @Override
    public Class getJDBCClass() {
        return String.class;
    }

    @Override
    public String getJDBCClassName() {
        return "java.lang.String";
    }

    @Override
    public int getSQLGenericTypeCode() {
        return this.typeCode == 1 ? this.typeCode : 12;
    }

    @Override
    public String getNameString() {
        return this.nameString;
    }

    private String getNameStringPrivate() {
        switch (this.typeCode) {
            case 1: {
                return "CHARACTER";
            }
            case 12: {
                return "VARCHAR";
            }
            case 100: {
                return "VARCHAR_IGNORECASE";
            }
            case 40: {
                return "CLOB";
            }
        }
        throw Error.runtimeError(201, "CharacterType");
    }

    @Override
    public String getFullNameString() {
        switch (this.typeCode) {
            case 1: {
                return "CHARACTER";
            }
            case 12: {
                return "CHARACTER VARYING";
            }
            case 100: {
                return "VARCHAR_IGNORECASE";
            }
            case 40: {
                return "CHARACTER LARGE OBJECT";
            }
        }
        throw Error.runtimeError(201, "CharacterType");
    }

    @Override
    public String getDefinition() {
        if (this.precision == 0L) {
            return this.getNameString();
        }
        StringBuffer stringBuffer = new StringBuffer(16);
        stringBuffer.append(this.getNameString());
        stringBuffer.append('(');
        stringBuffer.append(this.precision);
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    @Override
    public boolean hasCollation() {
        return this.collation != Collation.defaultCollation;
    }

    @Override
    public String getCollationDefinition() {
        if (this.hasCollation()) {
            return this.collation.getName().getSchemaQualifiedStatementName();
        }
        return "";
    }

    @Override
    public boolean isCharacterType() {
        return true;
    }

    @Override
    public long getMaxPrecision() {
        return Integer.MAX_VALUE;
    }

    @Override
    public boolean acceptsPrecision() {
        return true;
    }

    @Override
    public boolean requiresPrecision() {
        return this.typeCode == 12 || this.typeCode == 100;
    }

    @Override
    public int precedenceDegree(Type type) {
        if (type.typeCode == this.typeCode) {
            return 0;
        }
        if (!type.isCharacterType()) {
            return Integer.MIN_VALUE;
        }
        switch (this.typeCode) {
            case 1: {
                return type.typeCode == 40 ? 4 : 2;
            }
            case 12: 
            case 100: {
                if (type.typeCode == 12 || type.typeCode == 100) {
                    return 0;
                }
                return type.typeCode == 40 ? 4 : 2;
            }
            case 40: {
                return type.typeCode == 1 ? -4 : -2;
            }
        }
        throw Error.runtimeError(201, "CharacterType");
    }

    @Override
    public Type getAggregateType(Type type) {
        if (type == null) {
            return this;
        }
        if (type == SQL_ALL_TYPES) {
            return this;
        }
        if (this.typeCode == type.typeCode) {
            return this.precision >= type.precision ? this : type;
        }
        switch (type.typeCode) {
            case 1: {
                return this.precision >= type.precision ? this : CharacterType.getCharacterType(this.typeCode, type.precision, type.getCollation());
            }
            case 12: {
                if (this.typeCode == 40 || this.typeCode == 100) {
                    return this.precision >= type.precision ? this : CharacterType.getCharacterType(this.typeCode, type.precision, type.getCollation());
                }
                return type.precision >= this.precision ? type : CharacterType.getCharacterType(type.typeCode, this.precision, type.getCollation());
            }
            case 100: {
                if (this.typeCode == 40) {
                    return this.precision >= type.precision ? this : CharacterType.getCharacterType(this.typeCode, type.precision, this.getCollation());
                }
                return type.precision >= this.precision ? type : CharacterType.getCharacterType(type.typeCode, this.precision, type.getCollation());
            }
            case 40: {
                return type.precision >= this.precision ? type : CharacterType.getCharacterType(type.typeCode, this.precision, type.getCollation());
            }
            case 14: 
            case 15: 
            case 30: 
            case 60: 
            case 61: 
            case 1111: {
                throw Error.error(5562);
            }
        }
        throw Error.error(5562);
    }

    @Override
    public Type getCombinedType(Session session, Type type, int n) {
        Type type2;
        if (n != 36) {
            return this.getAggregateType(type);
        }
        long l = this.precision + type.precision;
        switch (type.typeCode) {
            case 0: {
                return this;
            }
            case 1: {
                type2 = this;
                break;
            }
            case 12: {
                type2 = this.typeCode == 40 || this.typeCode == 100 ? this : type;
                break;
            }
            case 100: {
                type2 = this.typeCode == 40 ? this : type;
                break;
            }
            case 40: {
                type2 = type;
                break;
            }
            default: {
                throw Error.error(5562);
            }
        }
        if (l > Integer.MAX_VALUE) {
            if (this.typeCode == 60) {
                l = Integer.MAX_VALUE;
            } else if (this.typeCode == 1) {
                l = Integer.MAX_VALUE;
            }
        }
        return CharacterType.getCharacterType(type2.typeCode, l);
    }

    @Override
    public int compare(Session session, Object object, Object object2) {
        int n;
        if (object == object2) {
            return 0;
        }
        if (object == null) {
            return -1;
        }
        if (object2 == null) {
            return 1;
        }
        if (object2 instanceof ClobData) {
            return -session.database.lobManager.compare(this.collation, (ClobData)object2, (String)object);
        }
        String string = (String)object;
        String string2 = (String)object2;
        int n2 = string.length();
        if (n2 != (n = string2.length())) {
            if (n2 > n) {
                if (this.collation.isPadSpace()) {
                    char[] cArray = new char[n2];
                    string2.getChars(0, n, cArray, 0);
                    ArrayUtil.fillArray(cArray, n, ' ');
                    string2 = String.valueOf(cArray);
                }
            } else if (this.collation.isPadSpace()) {
                char[] cArray = new char[n];
                string.getChars(0, n2, cArray, 0);
                ArrayUtil.fillArray(cArray, n2, ' ');
                string = String.valueOf(cArray);
            }
        }
        if (this.typeCode == 100) {
            return this.collation.compareIgnoreCase(string, string2);
        }
        return this.collation.compare(string, string2);
    }

    @Override
    public Object convertToTypeLimits(SessionInterface sessionInterface, Object object) {
        if (object == null) {
            return object;
        }
        if (this.precision == 0L) {
            return object;
        }
        switch (this.typeCode) {
            case 1: {
                int n = ((String)object).length();
                if ((long)n == this.precision) {
                    return object;
                }
                if ((long)n > this.precision) {
                    if ((long)CharacterType.getRightTrimSise((String)object, ' ') <= this.precision) {
                        return ((String)object).substring(0, (int)this.precision);
                    }
                    throw Error.error(3401);
                }
                char[] cArray = new char[(int)this.precision];
                ((String)object).getChars(0, n, cArray, 0);
                int n2 = n;
                while ((long)n2 < this.precision) {
                    cArray[n2] = 32;
                    ++n2;
                }
                return new String(cArray);
            }
            case 12: 
            case 100: {
                int n = ((String)object).length();
                if ((long)n > this.precision) {
                    if ((long)CharacterType.getRightTrimSise((String)object, ' ') <= this.precision) {
                        return ((String)object).substring(0, (int)this.precision);
                    }
                    throw Error.error(3401);
                }
                return object;
            }
            case 40: {
                return object;
            }
        }
        throw Error.runtimeError(201, "CharacterType");
    }

    @Override
    public Object castToType(SessionInterface sessionInterface, Object object, Type type) {
        if (object == null) {
            return object;
        }
        return this.castOrConvertToType(sessionInterface, object, type, true);
    }

    public Object castOrConvertToType(SessionInterface sessionInterface, Object object, Type type, boolean bl) {
        switch (type.typeCode) {
            case 1: 
            case 12: 
            case 100: {
                int n = ((String)object).length();
                if (this.precision != 0L && (long)n > this.precision) {
                    if ((long)StringUtil.rightTrimSize((String)object) > this.precision) {
                        if (!bl) {
                            throw Error.error(3401);
                        }
                        sessionInterface.addWarning(Error.error(1004));
                    }
                    object = ((String)object).substring(0, (int)this.precision);
                }
                switch (this.typeCode) {
                    case 1: {
                        return this.convertToTypeLimits(sessionInterface, object);
                    }
                    case 12: 
                    case 100: {
                        return object;
                    }
                    case 40: {
                        ClobDataID clobDataID = sessionInterface.createClob(((String)object).length());
                        clobDataID.setString(sessionInterface, 0L, (String)object);
                        return clobDataID;
                    }
                }
                throw Error.runtimeError(201, "CharacterType");
            }
            case 40: {
                long l = ((ClobData)object).length(sessionInterface);
                if (this.precision != 0L && l > this.precision && ((ClobData)object).nonSpaceLength(sessionInterface) > this.precision) {
                    if (!bl) {
                        throw Error.error(3401);
                    }
                    sessionInterface.addWarning(Error.error(1004));
                }
                switch (this.typeCode) {
                    case 1: 
                    case 12: 
                    case 100: {
                        if (l > Integer.MAX_VALUE) {
                            if (!bl) {
                                throw Error.error(3401);
                            }
                            l = Integer.MAX_VALUE;
                        }
                        object = ((ClobData)object).getSubString(sessionInterface, 0L, (int)l);
                        return this.convertToTypeLimits(sessionInterface, object);
                    }
                    case 40: {
                        if (this.precision != 0L && l > this.precision) {
                            return ((ClobData)object).getClob(sessionInterface, 0L, this.precision);
                        }
                        return object;
                    }
                }
                throw Error.runtimeError(201, "CharacterType");
            }
            case 1111: {
                throw Error.error(5561);
            }
            case 30: {
                long l = ((BlobData)object).length(sessionInterface);
                if (this.precision != 0L && l * 2L > this.precision) {
                    throw Error.error(3401);
                }
                byte[] byArray = ((BlobData)object).getBytes(sessionInterface, 0L, (int)l);
                object = StringConverter.byteArrayToHexString(byArray);
                return this.convertToTypeLimits(sessionInterface, object);
            }
        }
        String string = type.convertToString(object);
        if (this.precision != 0L && (long)string.length() > this.precision) {
            throw Error.error(3401);
        }
        object = string;
        return this.convertToTypeLimits(sessionInterface, object);
    }

    @Override
    public Object convertToType(SessionInterface sessionInterface, Object object, Type type) {
        if (object == null) {
            return object;
        }
        return this.castOrConvertToType(sessionInterface, object, type, false);
    }

    @Override
    public Object convertToTypeJDBC(SessionInterface sessionInterface, Object object, Type type) {
        if (object == null) {
            return object;
        }
        if (type.typeCode == 30) {
            throw Error.error(5561);
        }
        return this.convertToType(sessionInterface, object, type);
    }

    @Override
    public Object convertToDefaultType(SessionInterface sessionInterface, Object object) {
        String string;
        if (object == null) {
            return object;
        }
        if (object instanceof Boolean) {
            string = object.toString();
        } else if (object instanceof BigDecimal) {
            string = JavaSystem.toString((BigDecimal)object);
        } else if (object instanceof Number) {
            string = object.toString();
        } else if (object instanceof String) {
            string = (String)object;
        } else if (object instanceof Date) {
            string = ((Date)object).toString();
        } else if (object instanceof Time) {
            string = ((Time)object).toString();
        } else if (object instanceof Timestamp) {
            string = ((Timestamp)object).toString();
        } else if (object instanceof java.util.Date) {
            string = HsqlDateTime.getTimestampString(((Date)object).getTime());
        } else {
            throw Error.error(5561);
        }
        return string;
    }

    @Override
    public Object convertJavaToSQL(SessionInterface sessionInterface, Object object) {
        return this.convertToDefaultType(sessionInterface, object);
    }

    @Override
    public String convertToString(Object object) {
        if (object == null) {
            return null;
        }
        switch (this.typeCode) {
            case 1: {
                int n = ((String)object).length();
                if (this.precision == 0L || (long)n == this.precision) {
                    return (String)object;
                }
                char[] cArray = new char[(int)this.precision];
                ((String)object).getChars(0, n, cArray, 0);
                int n2 = n;
                while ((long)n2 < this.precision) {
                    cArray[n2] = 32;
                    ++n2;
                }
                return new String(cArray);
            }
            case 12: 
            case 100: {
                return (String)object;
            }
        }
        throw Error.runtimeError(201, "CharacterType");
    }

    @Override
    public String convertToSQLString(Object object) {
        if (object == null) {
            return "NULL";
        }
        String string = this.convertToString(object);
        return StringConverter.toQuotedString(string, '\'', true);
    }

    @Override
    public boolean canConvertFrom(Type type) {
        return !type.isObjectType() && !type.isArrayType();
    }

    @Override
    public int canMoveFrom(Type type) {
        if (type == this) {
            return 0;
        }
        if (!type.isCharacterType()) {
            return -1;
        }
        switch (this.typeCode) {
            case 12: {
                if (type.typeCode == this.typeCode) {
                    return this.precision >= type.precision ? 0 : 1;
                }
                if (type.typeCode == 1) {
                    return this.precision >= type.precision ? 0 : -1;
                }
                return -1;
            }
            case 40: {
                if (type.typeCode == 40) {
                    return this.precision >= type.precision ? 0 : 1;
                }
                return -1;
            }
            case 1: {
                return type.typeCode == 1 && this.precision == type.precision ? 0 : -1;
            }
        }
        return -1;
    }

    @Override
    public Collation getCollation() {
        return this.collation;
    }

    @Override
    public Charset getCharacterSet() {
        return this.charset;
    }

    public boolean isEqualIdentical() {
        return this.isEqualIdentical;
    }

    public boolean isCaseInsensitive() {
        return this.typeCode == 100;
    }

    public long position(SessionInterface sessionInterface, Object object, Object object2, Type type, long l) {
        if (object == null || object2 == null) {
            return -1L;
        }
        if (type.typeCode == 40) {
            long l2 = ((ClobData)object2).length(sessionInterface);
            if (l + l2 > (long)((String)object).length()) {
                return -1L;
            }
            if (l2 > Integer.MAX_VALUE) {
                throw Error.error(3459);
            }
            String string = ((ClobData)object2).getSubString(sessionInterface, 0L, (int)l2);
            return ((String)object).indexOf(string, (int)l);
        }
        if (type.isCharacterType()) {
            long l3 = ((String)object2).length();
            if (l + l3 > (long)((String)object).length()) {
                return -1L;
            }
            return ((String)object).indexOf((String)object2, (int)l);
        }
        throw Error.runtimeError(201, "CharacterType");
    }

    public Object substring(SessionInterface sessionInterface, Object object, long l, long l2, boolean bl, boolean bl2) {
        long l3;
        long l4;
        long l5 = l4 = this.typeCode == 40 ? ((ClobData)object).length(sessionInterface) : (long)((String)object).length();
        if (bl2) {
            l3 = l4;
            if (l2 > l4) {
                l = 0L;
                l2 = l4;
            } else {
                l = l4 - l2;
            }
        } else if (bl) {
            l3 = l + l2;
        } else {
            long l6 = l3 = l4 > l ? l4 : l;
        }
        if (l3 < l) {
            throw Error.error(3431);
        }
        if (l > l3 || l3 < 0L) {
            l = 0L;
            l3 = 0L;
        }
        if (l < 0L) {
            l = 0L;
        }
        if (l3 > l4) {
            l3 = l4;
        }
        l2 = l3 - l;
        if (object instanceof String) {
            return ((String)object).substring((int)l, (int)(l + l2));
        }
        if (object instanceof ClobData) {
            ClobDataID clobDataID = sessionInterface.createClob(l2);
            if (l2 > Integer.MAX_VALUE) {
                throw Error.error(3401);
            }
            String string = ((ClobData)object).getSubString(sessionInterface, l, (int)l2);
            clobDataID.setString(sessionInterface, 0L, string);
            return clobDataID;
        }
        throw Error.runtimeError(201, "CharacterType");
    }

    public Object upper(Session session, Object object) {
        if (object == null) {
            return null;
        }
        if (this.typeCode == 40) {
            String string = ((ClobData)object).getSubString(session, 0L, (int)((ClobData)object).length(session));
            string = this.collation.toUpperCase(string);
            ClobDataID clobDataID = session.createClob(string.length());
            clobDataID.setString(session, 0L, string);
            return clobDataID;
        }
        return this.collation.toUpperCase((String)object);
    }

    public Object lower(Session session, Object object) {
        if (object == null) {
            return null;
        }
        if (this.typeCode == 40) {
            String string = ((ClobData)object).getSubString(session, 0L, (int)((ClobData)object).length(session));
            string = this.collation.toLowerCase(string);
            ClobDataID clobDataID = session.createClob(string.length());
            clobDataID.setString(session, 0L, string);
            return clobDataID;
        }
        return this.collation.toLowerCase((String)object);
    }

    public Object trim(SessionInterface sessionInterface, Object object, int n, boolean bl, boolean bl2) {
        int n2;
        String string;
        if (object == null) {
            return null;
        }
        if (this.typeCode == 40) {
            long l = ((ClobData)object).length(sessionInterface);
            if (l > Integer.MAX_VALUE) {
                throw Error.error(3459);
            }
            string = ((ClobData)object).getSubString(sessionInterface, 0L, (int)l);
        } else {
            string = (String)object;
        }
        int n3 = string.length();
        if (bl2) {
            --n3;
            while (n3 >= 0 && string.charAt(n3) == n) {
                --n3;
            }
            ++n3;
        }
        if (bl) {
            for (n2 = 0; n2 < n3 && string.charAt(n2) == n; ++n2) {
            }
        }
        if (n2 != 0 || n3 != string.length()) {
            string = string.substring(n2, n3);
        }
        if (this.typeCode == 40) {
            ClobDataID clobDataID = sessionInterface.createClob(string.length());
            clobDataID.setString(sessionInterface, 0L, string);
            return clobDataID;
        }
        return string;
    }

    public Object overlay(SessionInterface sessionInterface, Object object, Object object2, long l, long l2, boolean bl) {
        if (object == null || object2 == null) {
            return null;
        }
        if (!bl) {
            l2 = this.typeCode == 40 ? ((ClobData)object2).length(sessionInterface) : (long)((String)object2).length();
        }
        Object object3 = this.concat(null, this.substring(sessionInterface, object, 0L, l, true, false), object2);
        return this.concat(null, object3, this.substring(sessionInterface, object, l + l2, 0L, false, false));
    }

    @Override
    public Object concat(Session session, Object object, Object object2) {
        if (object == null || object2 == null) {
            return null;
        }
        String string = object instanceof ClobData ? ((ClobData)object).getSubString(session, 0L, (int)((ClobData)object).length(session)) : (String)object;
        String string2 = object2 instanceof ClobData ? ((ClobData)object2).getSubString(session, 0L, (int)((ClobData)object2).length(session)) : (String)object2;
        if (this.typeCode == 40) {
            ClobDataID clobDataID = session.createClob(string.length() + string2.length());
            clobDataID.setString(session, 0L, string);
            clobDataID.setString(session, string.length(), string2);
            return clobDataID;
        }
        return string + string2;
    }

    public long size(SessionInterface sessionInterface, Object object) {
        if (this.typeCode == 40) {
            return ((ClobData)object).length(sessionInterface);
        }
        return ((String)object).length();
    }

    public Boolean match(Session session, String string, String[] stringArray) {
        if (string == null || stringArray == null) {
            return null;
        }
        String string2 = null;
        int n = 0;
        boolean bl = true;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null) {
                ++n;
                bl = true;
            } else if (stringArray[i].length() == 0) {
                bl = false;
            }
            if (bl) {
                if (n + stringArray[i].length() > string.length()) {
                    return Boolean.FALSE;
                }
                string2 = string.substring(n, n + stringArray[i].length());
                if (this.collation.compare(string2, stringArray[i]) != 0) {
                    return Boolean.FALSE;
                }
                n += stringArray[i].length();
                continue;
            }
            int n2 = string.indexOf(stringArray[i], n);
            if (n2 < 0) {
                return Boolean.FALSE;
            }
            n = n2 + stringArray[i].length();
            bl = true;
        }
        return Boolean.TRUE;
    }

    public Type getCharacterType(long l) {
        if (l == this.precision) {
            return this;
        }
        return new CharacterType(this.collation, this.typeCode, l);
    }

    public static int getRightTrimSise(String string, char c) {
        int n = string.length();
        --n;
        while (n >= 0 && string.charAt(n) == c) {
            --n;
        }
        return ++n;
    }

    public static CharacterType getCharacterType(int n, long l) {
        switch (n) {
            case 1: {
                if (l < 32L) {
                    return charArray[(int)l];
                }
            }
            case 12: 
            case 100: {
                return new CharacterType(n, (int)l);
            }
            case 40: {
                return new ClobType(l);
            }
        }
        throw Error.runtimeError(201, "CharacterType");
    }

    public static CharacterType getCharacterType(int n, long l, Collation collation) {
        if (collation == null) {
            collation = Collation.defaultCollation;
        }
        switch (n) {
            case 1: 
            case 12: 
            case 100: {
                return new CharacterType(collation, n, (int)l);
            }
            case 40: {
                ClobType clobType = new ClobType(l);
                clobType.collation = collation;
                return clobType;
            }
        }
        throw Error.runtimeError(201, "CharacterType");
    }

    static {
        for (int i = 0; i < charArray.length; ++i) {
            CharacterType.charArray[i] = new CharacterType(1, i);
        }
    }
}

