<?php
require_once ('../code/cssj_driver.php');
header("Content-Type: application/pdf");

/**
 * 与えられたデータをPDFに変換して返します。
 * 
 * @param $session セッション
 * @param $input 元のデータ
 * @return 変換結果PDF
 */
function &toPDF(&$session, $input) {
  //出力先
  $output = '';//nullの場合標準出力となるので、必ず文字列を代入しておく必要がある
  cssj_set_output($session, $output);

  //変換
  cssj_ob_start_main($session, 'file:/test.html');
  echo $input;
  cssj_ob_end_flush_main();

  //セッションの終了
  cssj_close($session);
  
  return $output;
}


//ドライバの作成
$driver = cssj_create_driver_for('localhost', 8099);

//セッションの開始
$session = cssj_create_session($driver, 'user', 'kappa') or die('サーバーに接続できません');

//入力
$input = '
<html>
  <head>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
    <title>Hello CSSJ</title>
  </head>
  <body>
    <h2>ただいまの時刻</h2>
    <p>'.date("l dS of F Y h:i:s A").'</p>
  </body>
</html>
';

//変換
$output = toPDF($session, $input);
echo $output;

?>