#!/bin/sh

if test $# -lt 1 ; then
	echo "usage : " `basename $0` "URI1 URI2 ... " 1>&2
	exit 1
fi


JAVA_HOME=/usr
HADOOP_HOME=${HOME}/work/hadoop.d/hadoop-1.0.3
HADOOP_STREAMING=${HADOOP_HOME}/contrib/streaming/hadoop-streaming-*.jar

rm -f  inputs.str
rm -f  outputs.str
rm -rf outputs

while [ "$1" != "" ]
do
	descartes get_httpstring.dec $1 >> inputs.str
	shift
done

${HADOOP_HOME}/bin/hadoop jar ${HADOOP_STREAMING} \
	-input inputs.str -output outputs \
	-mapper teniwoha.dec  -reducer wsort-reduce.dec \
	-combiner wsort-reduce.dec \
	-file teniwoha.dec -file wsort-reduce.dec 

sort -g -r -k 2 outputs/part-00000 > outputs.str

