package com.aibonware.viewnaver.browser.win32;

public class URLAction {
	public static final int URLACTION_MIN = 0x00001000;
	public static final int URLACTION_DOWNLOAD_MIN = 0x00001000;
	public static final int URLACTION_DOWNLOAD_SIGNED_ACTIVEX = 0x00001001;
	public static final int URLACTION_DOWNLOAD_UNSIGNED_ACTIVEX = 0x00001004;
	public static final int URLACTION_DOWNLOAD_CURR_MAX = 0x00001004;
	public static final int URLACTION_DOWNLOAD_MAX = 0x000011FF;
	public static final int URLACTION_ACTIVEX_MIN = 0x00001200;
	public static final int URLACTION_ACTIVEX_RUN = 0x00001200;
	public static final int URLPOLICY_ACTIVEX_CHECK_LIST = 0x00010000;
	public static final int URLACTION_ACTIVEX_OVERRIDE_OBJECT_SAFETY = 0x00001201;
	public static final int URLACTION_ACTIVEX_OVERRIDE_DATA_SAFETY = 0x00001202;
	public static final int URLACTION_ACTIVEX_OVERRIDE_SCRIPT_SAFETY = 0x00001203;
	public static final int URLACTION_SCRIPT_OVERRIDE_SAFETY = 0x00001401;
	public static final int URLACTION_ACTIVEX_CONFIRM_NOOBJECTSAFETY = 0x00001204;
	public static final int URLACTION_ACTIVEX_TREATASUNTRUSTED = 0x00001205;
	public static final int URLACTION_ACTIVEX_NO_WEBOC_SCRIPT = 0x00001206;
	public static final int URLACTION_ACTIVEX_CURR_MAX = 0x00001206;
	public static final int URLACTION_ACTIVEX_MAX = 0x000013ff;
	public static final int URLACTION_SCRIPT_MIN = 0x00001400;
	public static final int URLACTION_SCRIPT_RUN = 0x00001400;
	public static final int URLACTION_SCRIPT_JAVA_USE = 0x00001402;
	public static final int URLACTION_SCRIPT_SAFE_ACTIVEX = 0x00001405;
	public static final int URLACTION_CROSS_DOMAIN_DATA = 0x00001406;
	public static final int URLACTION_SCRIPT_PASTE = 0x00001407;
	public static final int URLACTION_SCRIPT_CURR_MAX = 0x00001407;
	public static final int URLACTION_SCRIPT_MAX = 0x000015ff;
	public static final int URLACTION_HTML_MIN = 0x00001600;
	public static final int URLACTION_HTML_SUBMIT_FORMS = 0x00001601;
	public static final int URLACTION_HTML_SUBMIT_FORMS_FROM = 0x00001602;
	public static final int URLACTION_HTML_SUBMIT_FORMS_TO = 0x00001603;
	public static final int URLACTION_HTML_FONT_DOWNLOAD = 0x00001604;
	public static final int URLACTION_HTML_JAVA_RUN = 0x00001605;
	public static final int URLACTION_HTML_USERDATA_SAVE = 0x00001606;
	public static final int URLACTION_HTML_SUBFRAME_NAVIGATE = 0x00001607;
	public static final int URLACTION_HTML_META_REFRESH = 0x00001608;
	public static final int URLACTION_HTML_MIXED_CONTENT = 0x00001609;
	public static final int URLACTION_HTML_MAX = 0x000017ff;
	public static final int URLACTION_SHELL_MIN = 0x00001800;
	public static final int URLACTION_SHELL_INSTALL_DTITEMS = 0x00001800;
	public static final int URLACTION_SHELL_MOVE_OR_COPY = 0x00001802;
	public static final int URLACTION_SHELL_FILE_DOWNLOAD = 0x00001803;
	public static final int URLACTION_SHELL_VERB = 0x00001804;
	public static final int URLACTION_SHELL_WEBVIEW_VERB = 0x00001805;
	public static final int URLACTION_SHELL_SHELLEXECUTE = 0x00001806;
	public static final int URLACTION_SHELL_CURR_MAX = 0x00001806;
	public static final int URLACTION_SHELL_MAX = 0x000019ff;
	public static final int URLACTION_NETWORK_MIN = 0x00001A00;
	public static final int URLACTION_CREDENTIALS_USE = 0x00001A00;
	public static final int URLPOLICY_CREDENTIALS_SILENT_LOGON_OK = 0x00000000;
	public static final int URLPOLICY_CREDENTIALS_MUST_PROMPT_USER = 0x00010000;
	public static final int URLPOLICY_CREDENTIALS_CONDITIONAL_PROMPT = 0x00020000;
	public static final int URLPOLICY_CREDENTIALS_ANONYMOUS_ONLY = 0x00030000;
	public static final int URLACTION_AUTHENTICATE_CLIENT = 0x00001A01;
	public static final int URLPOLICY_AUTHENTICATE_CLEARTEXT_OK = 0x00000000;
	public static final int URLPOLICY_AUTHENTICATE_CHALLENGE_RESPONSE = 0x00010000;
	public static final int URLPOLICY_AUTHENTICATE_MUTUAL_ONLY = 0x00030000;
	public static final int URLACTION_COOKIES = 0x00001A02;
	public static final int URLACTION_COOKIES_SESSION = 0x00001A03;
	public static final int URLACTION_CLIENT_CERT_PROMPT = 0x00001A04;
	public static final int URLACTION_COOKIES_THIRD_PARTY = 0x00001A05;
	public static final int URLACTION_COOKIES_SESSION_THIRD_PARTY = 0x00001A06;
	public static final int URLACTION_COOKIES_ENABLED = 0x00001A10;
	public static final int URLACTION_NETWORK_CURR_MAX = 0x00001A10;
	public static final int URLACTION_NETWORK_MAX = 0x00001Bff;
	public static final int URLACTION_JAVA_MIN = 0x00001C00;
	public static final int URLACTION_JAVA_PERMISSIONS = 0x00001C00;
	public static final int URLPOLICY_JAVA_PROHIBIT = 0x00000000;
	public static final int URLPOLICY_JAVA_HIGH = 0x00010000;
	public static final int URLPOLICY_JAVA_MEDIUM = 0x00020000;
	public static final int URLPOLICY_JAVA_LOW = 0x00030000;
	public static final int URLPOLICY_JAVA_CUSTOM = 0x00800000;
	public static final int URLACTION_JAVA_CURR_MAX = 0x00001C00;
	public static final int URLACTION_JAVA_MAX = 0x00001Cff;
	public static final int URLACTION_INFODELIVERY_MIN = 0x00001D00;
	public static final int URLACTION_INFODELIVERY_NO_ADDING_CHANNELS = 0x00001D00;
	public static final int URLACTION_INFODELIVERY_NO_EDITING_CHANNELS = 0x00001D01;
	public static final int URLACTION_INFODELIVERY_NO_REMOVING_CHANNELS = 0x00001D02;
	public static final int URLACTION_INFODELIVERY_NO_ADDING_SUBSCRIPTIONS = 0x00001D03;
	public static final int URLACTION_INFODELIVERY_NO_EDITING_SUBSCRIPTIONS = 0x00001D04;
	public static final int URLACTION_INFODELIVERY_NO_REMOVING_SUBSCRIPTIONS = 0x00001D05;
	public static final int URLACTION_INFODELIVERY_NO_CHANNEL_LOGGING = 0x00001D06;
	public static final int URLACTION_INFODELIVERY_CURR_MAX = 0x00001D06;
	public static final int URLACTION_INFODELIVERY_MAX = 0x00001Dff;
	public static final int URLACTION_CHANNEL_SOFTDIST_MIN = 0x00001E00;
	public static final int URLACTION_CHANNEL_SOFTDIST_PERMISSIONS = 0x00001E05;
	public static final int URLPOLICY_CHANNEL_SOFTDIST_PROHIBIT = 0x00010000;
	public static final int URLPOLICY_CHANNEL_SOFTDIST_PRECACHE = 0x00020000;
	public static final int URLPOLICY_CHANNEL_SOFTDIST_AUTOINSTALL = 0x00030000;
	public static final int URLACTION_CHANNEL_SOFTDIST_MAX = 0x00001Eff;

	public final int minAction;
	public final int maxAction;
	public final String name;
	public final URLPolicy[] policies;
	public int currentPolicy;

	public URLAction(int action, String name, URLPolicy... policies) {
		this.minAction = action;
		this.maxAction = action;
		this.name = name;
		this.policies = policies;
		currentPolicy = policies[0].policy;
	}

	public URLAction(int minAction, int maxAction, String name, URLPolicy... policies) {
		this.minAction = minAction;
		this.maxAction = maxAction;
		this.name = name;
		this.policies = policies;
		currentPolicy = policies[0].policy;
	}

	public int getPolicyIndex(int policy) {
		for(int i=0; i<policies.length; i++) {
			if(policies[i].policy == policy) return i;
		}

		return -1;
	}

	public boolean containPolicy(int policy) {
		for(int i=0; i<policies.length; i++) {
			if(policies[i].policy == policy) return true;
		}

		return false;
	}
}
