/*
 * Copyright (c) 2006, team-naver.com
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.aibonware.viewnaver.command;

import java.util.*;
import java.awt.*;
import javax.swing.*;

import org.apache.commons.httpclient.*;

import com.aibonware.viewnaver.*;
import com.aibonware.viewnaver.content.*;
import com.aibonware.viewnaver.content.board.*;
import com.aibonware.viewnaver.model.*;
import com.aibonware.viewnaver.task.*;

@SuppressWarnings("serial")
public class OpenURLCommand {
	private final String urlText;
	private final boolean onlyNaverUrl;
	private final Component parentComponent;
	private Vector<String> naverHosts = new Vector<String>();
	
	public OpenURLCommand(Component parentComponent, String urlText, boolean onlyNaverUrl) {
		this.urlText = urlText;
		this.onlyNaverUrl = onlyNaverUrl;
		this.parentComponent = parentComponent;
		
		naverHosts.addElement("bbs.enjoykorea.jp");
		naverHosts.addElement("enjoykorea.jp");
		naverHosts.addElement("www.enjoykorea.jp");
		naverHosts.addElement("enjoyjapan.naver.com");
		naverHosts.addElement("bbs.enjoyjapan.naver.com");
	}

	private static Map<String, String> parseUrlParam(HttpURL url) throws URIException {
		String query = url.getQuery();
		
		HashMap<String, String> map = new HashMap<String, String>();
		
		StringTokenizer params = new StringTokenizer(query, "&");
		
		while(params.hasMoreTokens()) {
			String token = params.nextToken();

			int index = token.indexOf("=");
			
			String name = token.substring(0, index);
			String value = token.substring(index + 1);

			map.put(name, value);
		}
		
		return map;
	}

	private class NotNaverUrlException extends Exception {
		public NotNaverUrlException(String message) {
			super(message);
		}
	}
	
	public void run() {
		try {
			openNaverUrl(urlText);
			return;
		} catch(NotNaverUrlException e) {
			if(onlyNaverUrl) {
				ViewNaver.println(e.getMessage());
				return;
			}
		}

/*
		int confirm = JOptionPane.showConfirmDialog(
				parentComponent, 
				urlText + "\n\nURL͑TCgURLłBI[vĂ낵łH"
				+ "\nR}hCWFNV₱̃bZ[W_CAŐU܂߁A\n"
				+ "@ZLeB̊댯\ɊmFĂB", 
				"mF", 
				JOptionPane.YES_NO_OPTION);
		if(confirm != JOptionPane.YES_OPTION) return;

		try {
			Runtime.getRuntime().exec(new String[] {ViewNaver.instance.config.browserPath, urlText});
		} catch(IOException e) {
			ViewNaver.err(e);ne
		}
*/
		
		JOptionPane.showMessageDialog(parentComponent, urlText 
			+ "\n\nURLviewNVRł͊J܂B\nENbNuVEBhEŊJvIA"
			+ "IEgpĊJĂB");
	}

	private void openNaverUrl(String urlText) throws NotNaverUrlException {
		try {
			
			HttpURL url = new HttpURL(urlText);

			if("http:".equals(url.getScheme())) {
				throw new NotNaverUrlException("'" + url.getScheme() + "' T|[g̃vgRłB");
			}

			if(!naverHosts.contains(url.getHost())) {
				throw new NotNaverUrlException("'" + url.getHost() + "' T|[g̃zXgłB");
			}

			if(url.getPort() != 80) {
				throw new NotNaverUrlException("'" + url.getPort() + "' T|[g̃|[gԍłB");
			}

			if("read.php".equals(url.getName())) {
				Map<String, String> params = parseUrlParam(url);

				String boardName = params.get("board_id");
				int nid = Integer.parseInt(params.get("nid"));
				String showPollText = params.get("chk_poll");
				boolean showPoll = "YES".equalsIgnoreCase(showPollText);

				TaskFlow taskFlow = ViewNaver.instance.taskFlowList.getThreadFlow(boardName, nid);
				taskFlow.execute(new ShowThreadCommand(boardName, nid));

			} else if("list.php".equals(url.getName())) {
				Map<String, String> params = parseUrlParam(url);

				final String boardName = params.get("board_id");
				String pageText = params.get("page");

				if(pageText == null) pageText = "1";

				final int pageNo = Integer.parseInt(pageText);
/*
				BoardTitle boardTitle = ViewNaver.instance.mainWindow.textBoardTitlesGroup.getBoardTitle(boardName);
				if(boardTitle == null) boardTitle = ViewNaver.instance.mainWindow.imageBoardTitlesGroup.getBoardTitle(boardName);

				if(boardTitle == null) {
					throw new NotNaverUrlException("'" + boardName + "' T|[g̔łB");
				}
*/

				final TabContainerView containerView = ViewNaver.instance.mainWindow.containerView;
				BoardView view = (BoardView)containerView.registerEmptyView(BoardContent.getCategory(boardName));

				TaskFlow taskFlow = ViewNaver.instance.taskFlowList.getBoardFlow(boardName, pageNo);

				taskFlow.addStatusReceiver(view.createTaskStatusReceiver(taskFlow));
				
				taskFlow.execute(new WorkerTask() {
					public void exec() {
						final Board newBoard = ViewNaver.instance.cache.getBoard(boardName, pageNo, false);

						taskFlow.execute(new GUITask() {
							public void exec() {
								if(newBoard == null) {
									containerView.revertEmptyView(BoardContent.getCategory(boardName));
									return;
								}

								containerView.update(new BoardContent(newBoard));
							}
						});
					}
				});

			} else {
				throw new NotNaverUrlException("'" + url.getName() + "' T|[gCGIłB");
			}

		} catch(URIException e)  {
			throw new NotNaverUrlException("T|[gURLłB");
		}
	}
}
