/*
 * Copyright (c) 2006, team-naver.com
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.aibonware.viewnaver.format;

import java.io.*;
import java.text.*;

import com.aibonware.viewnaver.*;
import com.aibonware.viewnaver.model.*;

public class PublishableThreadFormatter {
	public PublishableThreadFormatter() {}

	private static SimpleDateFormat df = new SimpleDateFormat("MM/dd HH:mm");
	private String HR = ViewNaver.instance.getBrowserFactory().HR;

	public String formatThreadHeader(CompositeThread compositeThread) {
		NThread thread = compositeThread.thread;

		String urlString = 
			"http://bbs.enjoykorea.jp/tbbs/read.php?board_id=" + compositeThread.boardName +  "&nid=" + thread.nid;

		return thread.country.toHtml() + " "
			+ "<b>" + thread.poster + "</b> "
			+ thread.title + " "
			+ df.format(thread.createDate) +" "
			+ "<a href=\"" + urlString + "\">URL</a><br>";
	}
	
	public String formatThreadContent(CompositeThread compositeThread) {
		return  "<html><head>"
				+ "<meta http-equiv=\"Content-Type\" content=\"text/html\">"
				+ "</head><body>"
				+  formatThreadHeader(compositeThread)
				+ HR
				+ "<table><tr><td>"
				+ compositeThread.contents;
	}

	public String formatThreadContentFooter(CompositeThread compositeThread) {
		return "</td></tr></table>"
			+ "<font size=-1>";
	}
	
	public String formatArticleFooter(CompositeThread compositeThread) {
		return "</font>"
			+ "</body></html>";
	}

	public String formatArticleList(CompositeThread compositeThread) {
		StringWriter writer = new StringWriter();
		PrintWriter out = new PrintWriter(writer);

		ArticleList articles = compositeThread.articleList;

		int lastVisibleSno = -1;

		for(int i=0; i<articles.getArticleCount(); i++) {
			Article art = articles.getArticle(i);

			String articleContent = formatArticle(lastVisibleSno,art);
			
			lastVisibleSno = art.sno;
			
			out.println(articleContent);
		}

		out.close();
		
		return writer.toString();
	}
	
	public String formatInnerArticle(int lastVisibleSno, Article art) {
		StringWriter writer = new StringWriter();
		PrintWriter out = new PrintWriter(writer);

		if(lastVisibleSno != art.sno) {
			out.print(HR);
		} else {
			out.print("<br>");
		}

		if(art.isReply) {
			out.print("&nbsp;&nbsp;");
		}

		out.print(df.format(art.postDate) + " ");

		out.print(art.country.toHtml() + " ");

		String start = "";
		String end = "";

		if(art.isDeleted) {
			start = "<s>";
			end = "</s>";
		}

		start = start + "<b>";
		end = "</b>" + end;


		out.print(start + art.author + end + "</a> ");

		out.print(ViewNaver.instance.articleDecorator.decorate(art.content));

		out.print("<br>");
		out.close();

		return writer.toString();
	}

	public String formatArticle(int lastVisibleSno, Article art) {
		String artText;
		artText = formatInnerArticle(lastVisibleSno, art);
		return artText;
	}
}
