/*
 * Copyright (c) 2006, team-naver.com
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.aibonware.viewnaver.net;

import java.io.*;
import org.apache.commons.httpclient.*;
import org.apache.commons.httpclient.methods.*;
import org.apache.commons.httpclient.methods.multipart.*;
import com.aibonware.viewnaver.*;
import com.aibonware.viewnaver.model.*;
import com.aibonware.viewnaver.task.*;

public class LoginSession implements NaverSession {
	public final String userName;

	private HttpClient client;
	private boolean nowLogin = false;

	private TaskCanceller createCanceller(final HttpMethod method) {
		TaskCanceller canceller =  new TaskCanceller() {
			public void cancel() {
				method.abort();
			}
		};

		TaskFlow taskFlow = Task.getCurrentThreadTaskFlow();

		if(taskFlow != null) {
			taskFlow.addTaskCanceller(canceller);
		}
		
		return canceller;
	}

	private void disposeCanceller(TaskCanceller canceller) {
		TaskFlow taskFlow = Task.getCurrentThreadTaskFlow();

		if(taskFlow != null && canceller != null) {
			taskFlow.removeTaskCanceller(canceller);
		}
	}

	public LoginSession(String userName) {
		this.userName = userName;

		// ڑݒ
		MultiThreadedHttpConnectionManager connectionManager = new MultiThreadedHttpConnectionManager();
		client = new HttpClient(connectionManager);

		connectionManager.getParams().setConnectionTimeout(180*1000);
		connectionManager.getParams().setSoTimeout(120*1000);
		connectionManager.getParams().setDefaultMaxConnectionsPerHost(5);
		connectionManager.getParams().setMaxTotalConnections(5);

//		client.setStrictMode(true);

		HttpState state = new HttpState();
//		state.setCookiePolicy(CookiePolicy.COMPATIBILITY);
		client.setState(state);

		if(ViewNaver.instance.config.network.useProxy) {
			client.getHostConfiguration().setProxy(
					ViewNaver.instance.config.network.proxyHost,
					ViewNaver.instance.config.network.proxyPort);
		}
	}

	
	public BufferedReader open(String url) throws NetException {
		return open(url, false);
	}

	public BufferedReader open(String url, boolean followRedirects) throws NetException {
		TaskCanceller canceller = null;
		
		try {
/*			try {
				Thread.sleep(3000);
			} catch(InterruptedException e) {
				System.out.println("interrupted");
				throw new NetException(e);
			}
*/
			GetMethod method = new GetMethod(url);
			canceller = createCanceller(method);

			method.setFollowRedirects(followRedirects);

			// s
			/*int httpStatus =*/ client.executeMethod(method);

			final TaskCanceller fcanceller = canceller;

			return 	new BufferedReader(new InputStreamReader(method.getResponseBodyAsStream(), "UTF8")) {
				@Override public void close() throws IOException {
					disposeCanceller(fcanceller);
				}
			};
		} catch(HttpException e) {
			disposeCanceller(canceller);
			throw new NetException(e);
		} catch(IOException e) {
			disposeCanceller(canceller);
			throw new NetException(e);
		}
	}

	public static class ImageBinary {
		public final String contentType;
		public final byte[] bin;
		
		public ImageBinary(String contentType, byte[] bin) {
			this.contentType = contentType;
			this.bin = bin;
		}
	}
	
	public ImageBinary getImageBinary(String url) throws NetException {

		try {
			GetMethod method = new GetMethod(url);
			method.setFollowRedirects(false);

			// s
			/*int httpStatus =*/ client.executeMethod(method);

			return new ImageBinary(
					method.getResponseHeader("Content-Type").getValue(), 
					method.getResponseBody());
			
		} catch(HttpException e) {
			throw new NetException(e);
		} catch(IOException e) {
			throw new NetException(e);
		}

	}
	
	public InputStream openStream(String url) throws NetException {
		return openStream(url, false);
	}

	public InputStream openStream(String url, boolean followRedirects) throws NetException {
		TaskCanceller canceller = null;
		
		try {
			GetMethod method = new GetMethod(url);
			canceller = createCanceller(method);
			method.setFollowRedirects(followRedirects);

			// s
			/*int httpStatus =*/ client.executeMethod(method);

			final TaskCanceller fcanceller = canceller;

			
			
			return new FilterInputStream(method.getResponseBodyAsStream()) {
				@Override public void close() throws IOException {
					disposeCanceller(fcanceller);
				}
			};
		} catch(HttpException e) {
			disposeCanceller(canceller);
			throw new NetException(e);
		} catch(IOException e) {
			disposeCanceller(canceller);
			throw new NetException(e);
		}
	}

	public BufferedReader open(String url, String encoding) throws NetException {
		TaskCanceller canceller = null;

		try {
			GetMethod method = new GetMethod(url);
			canceller = createCanceller(method);
			method.setFollowRedirects(false);

			// s
			/*int httpStatus =*/ client.executeMethod(method);
			final TaskCanceller fcanceller = canceller;

			return new BufferedReader(new InputStreamReader(method.getResponseBodyAsStream(), encoding)) {
				@Override public void close() throws IOException {
					disposeCanceller(fcanceller);
				}
			};
		} catch(HttpException e) {
			disposeCanceller(canceller);
			throw new NetException(e);
		} catch(IOException e) {
			disposeCanceller(canceller);
			throw new NetException(e);
		}
	}

	public void login(String loginPassword) throws NetException {
		TaskCanceller canceller = null;

		try {
			// OCp\bh쐬
			PostMethod method = new PostMethod("http://id.enjoykorea.jp/global/join_login_modify_formaction.php");
			canceller = createCanceller(method);
			method.setFollowRedirects(false);

			// sURL쐬sɂȂ
			method.addParameter("action_mode", "login");
			method.addParameter("url", "about:blank");
			method.addParameter("memberid", userName);
			method.addParameter("password", loginPassword);
			method.addParameter("id_chk", "");

			// s
			int httpStatus = client.executeMethod(method);
			
			if(httpStatus != HttpStatus.SC_MOVED_TEMPORARILY && httpStatus != HttpStatus.SC_OK) {
				throw new NetException("login failed (status code=" + httpStatus + ")");
			}

			// ʂ̎擾
			BufferedReader reader = new BufferedReader(new InputStreamReader(method.getResponseBodyAsStream(), "UTF8"));

			String text = "";
			String line;

			while((line = reader.readLine()) != null) text = text + line;

			checkLoginResult(httpStatus, text);
	
			method.releaseConnection();

//			Cookie[] cookies = client.getState().getCookies(); 

/*
			for(int i=0; i<cookies.length; i++) { 
				Cookie c = cookies[i]; 
				String domain = c.getDomain(); 
				if(domain.charAt(0) == '.') continue; 
				c.setDomain("." + domain); 
			} 
*/			
			nowLogin = true;

		} catch(HttpException e) {
			throw new NetException(e);
		} catch(IOException e) {
			throw new NetException(e);
		} finally {
			disposeCanceller(canceller);
		}
	}

	private static String getAlertString(String text, String startString, String endString) {
		int start = -1;
		int end = -1;
		
		start = text.indexOf(startString);
		if(start >= 0) {
			start += startString.length();
			end = text.indexOf(endString, start);
		}

		if(start < 0 || end < 0) return null;
		else return text.substring(start, end);
	}
	
	public static String getAlertString(String text) {
		String alert;
		
		alert = getAlertString(text, "alert('", "');");
		if(alert == null) alert = getAlertString(text, "alert( '", "');");
		if(alert == null) alert = getAlertString(text, "alert(\"", "\");");
		if(alert == null) alert = getAlertString(text, "alert ('", "');");
		if(alert == null) alert = getAlertString(text, "alert ( '", "');");
		if(alert == null) alert = getAlertString(text, "alert (\"", "\");");
		if(alert == null) alert = text;
		
		return alert.replace("\\n", "\n");
	}
	

	private void checkLoginResult(int httpStatus, String text) throws NetException {
		checkLoginResult(httpStatus, text, null);
	}
	
	private void checkLoginResult(int httpStatus, String text, String succeededSign) throws NetException {
		if(httpStatus == HttpStatus.SC_MOVED_TEMPORARILY
		  && text.indexOf("<body><h1>Object Moved</h1>This object may be found <a HREF=\"\">here</a>.</body>") >= 0) {
			return; // no problem
		}

		if(httpStatus == HttpStatus.SC_OK
		  && text.indexOf("alert") < 0) {
			return; // no problem
		}
	
		String alertString = getAlertString(text);

		if(succeededSign == null || !alertString.equals(succeededSign)) throw new NetException(alertString);
	}

	public void logout() throws NetException {
		TaskCanceller canceller = null;

		try {
			nowLogin = false;

			// OAEgp\bh쐬
			GetMethod method = new GetMethod("http://id.enjoykorea.jp/login/logout.html");
			canceller = createCanceller(method);
			method.setFollowRedirects(false);
		
			// s
			client.executeMethod(method);
			
			method.releaseConnection();

		} catch(HttpException e) {
			throw new NetException(e);
		} catch(IOException e) {
			throw new NetException(e);
		} finally {
			disposeCanceller(canceller);
		}
	}

	public boolean nowLogin() {
		return nowLogin;
	}

	public void postArticle(String rawBoardName, int nid, String htmlContent) throws NetException {
		TaskCanceller canceller = null;

		try {
			if(nid == 0 || htmlContent == null) throw new NetException("sȓeeł");

			PostMethod method = new PostMethod("http://bbs.enjoykorea.jp/tbbs/ment_action.php");
			canceller = createCanceller(method);
			method.setFollowRedirects(false);

			method.addParameter("board_id", rawBoardName);
			method.addParameter("nid",  String.valueOf(nid));
			method.addParameter("rtn_url", "about:blank");
			method.addParameter("work", "write");
			method.addParameter("ment_id", "");
			method.addParameter("ment_reply", "");
			method.addParameter("sno", "");
			method.addParameter("ment_passwd", "");

			method.addParameter("ment_writer", userName);
			method.addParameter("ment_passwd_temp", "");
			method.addParameter("ment_ment", htmlContent);

			method.setRequestHeader("Content-Type", "application/x-www-form-urlencoded; charset=utf-8");

			// s
			int httpStatus = client.executeMethod(method);

			// ʂ̎擾
			BufferedReader reader = new BufferedReader(new InputStreamReader(method.getResponseBodyAsStream(), "UTF8"));

			String text = "";
			String line;

			while((line = reader.readLine()) != null) text = text + line;
			method.releaseConnection();

			checkLoginResult(httpStatus, text);
	
		} catch(HttpException e) {
			throw new NetException(e);
		} catch(IOException e) {
			throw new NetException(e);
		} finally {
			disposeCanceller(canceller);
		}
	}

	public void replyArticle(String rawBoardName, int nid, String htmlContent, int sno) throws NetException {
		TaskCanceller canceller = null;

		try {
			if(nid == 0 || htmlContent == null) throw new NetException("sȓeeł");

			PostMethod method = new PostMethod("http://bbs.enjoykorea.jp/tbbs/ment_action.php");
			canceller = createCanceller(method);
			method.setFollowRedirects(false);

			method.addParameter("board_id", rawBoardName);
			method.addParameter("nid",  String.valueOf(nid));
			method.addParameter("rtn_url", "about:blank");
			method.addParameter("work", "write");
			method.addParameter("ment_id", "");
			method.addParameter("ment_reply", htmlContent);
			method.addParameter("sno", String.valueOf(sno));
			method.addParameter("ment_passwd", "");
			method.addParameter("ment_writer", userName);
			method.addParameter("ment_passwd_temp", "");
			method.addParameter("ment_ment", "");

			method.setRequestHeader("Content-Type", "application/x-www-form-urlencoded; charset=utf-8");

			// s
			int httpStatus = client.executeMethod(method);

			// ʂ̎擾
			BufferedReader reader = new BufferedReader(new InputStreamReader(method.getResponseBodyAsStream(), "UTF8"));

			String text = "";
			String line;

			while((line = reader.readLine()) != null) text = text + line;
			method.releaseConnection();

			checkLoginResult(httpStatus, text);
	
		} catch(HttpException e) {
			throw new NetException(e);
		} catch(IOException e) {
			throw new NetException(e);
		} finally {
			disposeCanceller(canceller);
		}
	}

	public void deleteArticle(String rawBoardName, int nid, int articleId) throws NetException {
		TaskCanceller canceller = null;

		try {
			PostMethod method = new PostMethod("http://bbs.enjoykorea.jp/tbbs/ment_action.php?board_id=" + rawBoardName + "&ment_id=");
			canceller = createCanceller(method);
			method.setFollowRedirects(false);

			method.addParameter("board_id", rawBoardName);
			method.addParameter("nid",  String.valueOf(nid));
			method.addParameter("rtn_url", "about:blank");
			method.addParameter("work", "delete");
			method.addParameter("ment_id", String.valueOf(articleId));
			method.addParameter("ment_reply", "");
			method.addParameter("sno", "");
			method.addParameter("ment_passwd", "");
			method.addParameter("ment_writer", userName);
			method.addParameter("ment_passwd_temp", "");
			method.addParameter("ment_ment", "");
			method.setRequestHeader("Content-Type", "application/x-www-form-urlencoded; charset=utf-8");

			// s
			int httpStatus = client.executeMethod(method);

			// ʂ̎擾
			BufferedReader reader = new BufferedReader(new InputStreamReader(method.getResponseBodyAsStream(), "UTF8"));

			String text = "";
			String line;

			while((line = reader.readLine()) != null) text = text + line;
			method.releaseConnection();

			checkLoginResult(httpStatus, text);
	
		} catch(HttpException e) {
			throw new NetException(e);
		} catch(IOException e) {
			throw new NetException(e);
		} finally {
			disposeCanceller(canceller);
		}
	}

	public int postThread(String boardName, String title, String content) throws NetException {
		TaskCanceller canceller = null;

		try {
			PostMethod method = new PostMethod(
				"http://bbs.enjoykorea.jp/tbbs/write_action.php?chkclick=on");
//				"http://bbs.enjoykorea.jp/tbbs/write_action.php");
			canceller = createCanceller(method);
			method.setFollowRedirects(false);

			Part[] parts = new Part[] {
					new StringPart("status", "", "utf8"),
					new StringPart("board_id", boardName, "utf8"),
					new StringPart("board_id_app", boardName, "utf8"),
					new StringPart("work", "write", "utf8"),
					new StringPart("page", "1", "utf8"),
					new StringPart("nid", "", "utf8"),
					new StringPart("st", "", "utf8"),
					new StringPart("sw", "", "utf8"),
					new StringPart("have_file", "", "utf8"),
					new StringPart("sno", "", "utf8"),
					new StringPart("g1", "", "utf8"),
					new StringPart("g2", "", "utf8"),
					new StringPart("list_url", "/tbbs/list.php?board_id=" + boardName + "&work=write", "utf8"),
					new StringPart("use_editor", "Y", "utf8"),
					new StringPart("use_poll", "", "utf8"),
					new StringPart("attachpolls", "", "utf8"),
					new StringPart("fav_list", "", "utf8"),
					new StringPart("html_mode", "M", "utf8"),
					new StringPart("board_st", boardName, "utf8"),
					new StringPart("writer_name", userName, "utf8"),
					new StringPart("national", "J", "utf8"),
					new StringPart("title", title, "utf8"),
					new StringPart("urlimage_layer", "http://", "utf8"),
					new StringPart("hyper_layer", "http://", "utf8"),
					new StringPart("nvSourceEdit", content, "utf8"),
					new StringPart("content", content, "utf8"),
					new StringPart("file_info[]", "", "utf8"),
					new StringPart("file_info[]", "", "utf8"),
					new StringPart("file_info[]", "", "utf8"),
					new StringPart("file_info[]", "", "utf8"),
					new StringPart("file_info[]", "", "utf8"),
					new StringPart("file_info[]", "", "utf8"),
					new StringPart("file_info[]", "", "utf8"),
					new StringPart("file_info[]", "", "utf8"),
					new StringPart("file_info[]", "", "utf8"),
					new StringPart("file_info[]", "", "utf8"),
					new StringPart("total_attached_size", "0", "utf8"),
					new StringPart("pre_total_attached_size", "0", "utf8"),
					new StringPart("user_defined_size", "512000", "utf8"),
					new StringPart("user_defined_num", "10", "utf8"),
					new StringPart("total_attached_size_kb", "0", "utf8"),
			};

			method.setRequestEntity(new MultipartRequestEntity(parts, method.getParams()));		
			
			// s
			int httpStatus = client.executeMethod(method);
	
			// ʂ̎擾
			BufferedReader reader = new BufferedReader(new InputStreamReader(method.getResponseBodyAsStream(), "UTF-8"));
	
			String text = "";
			String line;
	
			while((line = reader.readLine()) != null) text = text + line;

			method.releaseConnection();

			checkLoginResult(httpStatus, text);
	
			int nid = getResultNid(boardName, text, "write_confirm.php?board_id=" + boardName + "&nid=");
			if(nid == -1) ViewNaver.println("eɂ͐܂쐬ʂ̃Xbhr܂B");
			
			return nid;
			
		} catch(HttpException e) {
			throw new NetException(e);
		} catch(IOException e) {
			throw new NetException(e);
		} finally {
			disposeCanceller(canceller);
		}
	}

	private int getResultNid(String boardName, String text, String prefix){ 
		int start = text.indexOf(prefix);
		if(start == -1) return -1;
		
		start += prefix.length();
		
		int end = text.indexOf("&", start);
		
		if(end == -1) return -1;
		
		try {
			return Integer.parseInt(text.substring(start, end));
		} catch(NumberFormatException e) {
			return -1;
		}
	}

	public void replyThread(String boardName, String title, String content, int nid, int sno) throws NetException {
		TaskCanceller canceller = null;

		try {
			PostMethod method = new PostMethod("http://bbs.enjoykorea.jp/tbbs/write_action.php");
			canceller = createCanceller(method);
			method.setFollowRedirects(false);

			Part[] parts = new Part[] {
					new StringPart("status", "", "utf8"),
					new StringPart("board_id", boardName, "utf8"),
					new StringPart("board_id_app", boardName, "utf8"),
					new StringPart("work", "reply", "utf8"),
					new StringPart("page", "1", "utf8"),
					new StringPart("nid", String.valueOf(nid), "utf8"),
					new StringPart("st", "", "utf8"),
					new StringPart("sw", "", "utf8"),
					new StringPart("have_file", "N", "utf8"),
					new StringPart("sno", String.valueOf(sno), "utf8"),
					new StringPart("g1", "", "utf8"),
					new StringPart("g2", "", "utf8"),
					new StringPart("list_url", "/tbbs/list.php?board_id=" + boardName + "&work=reply&nid=" + nid, "utf8"),
					new StringPart("use_editor", "Y", "utf8"),
					new StringPart("use_poll", "", "utf8"),
					new StringPart("attachpolls", "", "utf8"),
					new StringPart("fav_list", "", "utf8"),
					new StringPart("html_mode", "M", "utf8"),
					new StringPart("board_st", boardName, "utf8"),
					new StringPart("writer_name", userName, "utf8"),
					new StringPart("national", "J", "utf8"),
					new StringPart("title", title, "utf8"),
					new StringPart("urlimage_layer", "http://", "utf8"),
					new StringPart("hyper_layer", "http://", "utf8"),
					new StringPart("nvSourceEdit", content, "utf8"),
					new StringPart("content", content, "utf8"),
					new StringPart("file_info[]", "", "utf8"),
					new StringPart("file_info[]", "", "utf8"),
					new StringPart("file_info[]", "", "utf8"),
					new StringPart("file_info[]", "", "utf8"),
					new StringPart("file_info[]", "", "utf8"),
					new StringPart("file_info[]", "", "utf8"),
					new StringPart("file_info[]", "", "utf8"),
					new StringPart("file_info[]", "", "utf8"),
					new StringPart("file_info[]", "", "utf8"),
					new StringPart("file_info[]", "", "utf8"),
					new StringPart("total_attached_size", "0", "utf8"),
					new StringPart("pre_total_attached_size", "0", "utf8"),
					new StringPart("user_defined_size", "512000", "utf8"),
					new StringPart("user_defined_num", "10", "utf8"),
					new StringPart("total_attached_size_kb", "0", "utf8"),
			};

			method.setRequestEntity(new MultipartRequestEntity(parts, method.getParams()));		
			
			// s
			int httpStatus = client.executeMethod(method);
	
			// ʂ̎擾
			BufferedReader reader = new BufferedReader(new InputStreamReader(method.getResponseBodyAsStream(), "UTF-8"));
	
			String text = "";
			String line;
	
			while((line = reader.readLine()) != null) text = text + line;

			method.releaseConnection();

			checkLoginResult(httpStatus, text);

		} catch(HttpException e) {
			throw new NetException(e);
		} catch(IOException e) {
			throw new NetException(e);
		} finally {
			disposeCanceller(canceller);
		}
	}

	public void modifyThread(String boardName, String title, String content, int nid) throws NetException {
		TaskCanceller canceller = null;

		try {
			PostMethod method = new PostMethod("http://bbs.enjoykorea.jp/tbbs/write_action.php");
			canceller = createCanceller(method);
			method.setFollowRedirects(false);

			Part[] parts = new Part[] {
					new StringPart("status", "", "utf8"),
					new StringPart("board_id", boardName, "utf8"),
					new StringPart("board_id_app", boardName, "utf8"),
					new StringPart("work", "modify", "utf8"),
					new StringPart("page", "1", "utf8"),
					new StringPart("nid", String.valueOf(nid), "utf8"),
					new StringPart("st", "", "utf8"),
					new StringPart("sw", "", "utf8"),
					new StringPart("have_file", "", "utf8"),
					new StringPart("sno", "", "utf8"),
					new StringPart("g1", "", "utf8"),
					new StringPart("g2", "", "utf8"),
					new StringPart("list_url", "/tbbs/list.php?board_id=" + boardName + "&work=modify&nid=" + nid, "utf8"),
					new StringPart("use_editor", "Y", "utf8"),
					new StringPart("use_poll", "", "utf8"),
					new StringPart("attachpolls", "", "utf8"),
					new StringPart("fav_list", "", "utf8"),
					new StringPart("html_mode", "M", "utf8"),
					new StringPart("board_st", boardName, "utf8"),
					new StringPart("writer_name", userName, "utf8"),
					new StringPart("national", "J", "utf8"),
					new StringPart("title", title, "utf8"),
					new StringPart("urlimage_layer", "http://", "utf8"),
					new StringPart("hyper_layer", "http://", "utf8"),
					new StringPart("nvSourceEdit", content, "utf8"),
					new StringPart("content", content, "utf8"),
					new StringPart("file_info[]", "", "utf8"),
					new StringPart("file_info[]", "", "utf8"),
					new StringPart("file_info[]", "", "utf8"),
					new StringPart("file_info[]", "", "utf8"),
					new StringPart("file_info[]", "", "utf8"),
					new StringPart("file_info[]", "", "utf8"),
					new StringPart("file_info[]", "", "utf8"),
					new StringPart("file_info[]", "", "utf8"),
					new StringPart("file_info[]", "", "utf8"),
					new StringPart("file_info[]", "", "utf8"),
					new StringPart("total_attached_size", "0", "utf8"),
					new StringPart("pre_total_attached_size", "0", "utf8"),
					new StringPart("user_defined_size", "512000", "utf8"),
					new StringPart("user_defined_num", "10", "utf8"),
					new StringPart("total_attached_size_kb", "0", "utf8"),
			};

			method.setRequestEntity(new MultipartRequestEntity(parts, method.getParams()));		
			
			// s
			int httpStatus = client.executeMethod(method);
	
			// ʂ̎擾
			BufferedReader reader = new BufferedReader(new InputStreamReader(method.getResponseBodyAsStream(), "UTF-8"));

			String text = "";
			String line;
	
			while((line = reader.readLine()) != null) text = text + line;

			method.releaseConnection();

			checkLoginResult(httpStatus, text);

		} catch(HttpException e) {
			throw new NetException(e);
		} catch(IOException e) {
			throw new NetException(e);
		} finally {
			disposeCanceller(canceller);
		}
	}

	public void deleteThread(String boardName, int nid) throws NetException {
		TaskCanceller canceller = null;

		try {
			// 폜p\bh쐬
			GetMethod method = new GetMethod("http://bbs.enjoykorea.jp/tbbs/write_action.php?board_id=" + boardName + "&work=delete&nid=" + nid);
			canceller = createCanceller(method);
			method.setFollowRedirects(false);
		
			// s
			int httpStatus = client.executeMethod(method);

			// ʂ̎擾
			BufferedReader reader = new BufferedReader(new InputStreamReader(method.getResponseBodyAsStream(), "UTF-8"));
	
			String text = "";
			String line;
	
			while((line = reader.readLine()) != null) text = text + line;

			method.releaseConnection();

			checkLoginResult(httpStatus, text);
			
		} catch(HttpException e) {
			throw new NetException(e);
		} catch(IOException e) {
			throw new NetException(e);
		} finally {
			disposeCanceller(canceller);
		}
	}

	public void sendMessage(String receiver, Country  country, String messageText, boolean saveServer) throws NetException {
		TaskCanceller canceller = null;

		try {
			receiver = receiver.trim();
			
			if(receiver.length() == 0) throw new NetException("M悪w肳Ă܂");
			if(country.equals(Country.UNKNOWN)) throw new NetException("sȍʂłB");
			if(messageText.length() == 0) throw new NetException("eełB");
			if(messageText.length() >= MAX_MESSAGE_LENGTH) throw new NetException("eel" + MAX_MESSAGE_LENGTH + "𒴂Ă܂");

			PostMethod method = new PostMethod("http://bbs.enjoykorea.jp/memo/memo_write.php");
			canceller = createCanceller(method);
			method.setFollowRedirects(false);

			method.addParameter("mode", "write");
			method.addParameter("receive_id", receiver);
			
			if(country.equals(Country.JAPAN)) {
				method.addParameter("id_national", "J");
			} else {
				method.addParameter("id_national", "K");
			}

			if(saveServer) {
				method.addParameter("send_chk", "Y");
			} else {
				method.addParameter("send_chk", "");
			}

			method.addParameter("content", messageText);
			method.addParameter("txtLen", String.valueOf(messageText.length() + " /400"));

			method.setRequestHeader("Content-Type", "application/x-www-form-urlencoded; charset=utf-8");

			// s
			int httpStatus = client.executeMethod(method);

			// ʂ̎擾
			BufferedReader reader = new BufferedReader(new InputStreamReader(method.getResponseBodyAsStream(), "UTF8"));

			String text = "";
			String line;

			while((line = reader.readLine()) != null) text = text + line;
			method.releaseConnection();

			checkLoginResult(httpStatus, text, "bZ[W𑗐M܂B");
			
		} catch(HttpException e) {
			throw new NetException(e);
		} catch(IOException e) {
			throw new NetException(e);
		} finally {
			disposeCanceller(canceller);
		}
	}
	
	private void saveMessage(String url, int[] messageIdList) throws NetException {
		TaskCanceller canceller = null;

		try {
			if(messageIdList.length == 0) throw new NetException("bZ[WIĂ܂");

			PostMethod method = new PostMethod(url);
			canceller = createCanceller(method);
			method.setFollowRedirects(false);

			method.addParameter("check_list", "false");
			method.addParameter("page", "1");
			method.addParameter("mode", "save");

			for(int i=0; i<messageIdList.length; i++) {
				method.addParameter("nidA[]", String.valueOf(messageIdList[i]));
			}

			method.setRequestHeader("Content-Type", "application/x-www-form-urlencoded; charset=utf-8");

			// s
			int httpStatus = client.executeMethod(method);

			// ʂ̎擾
			BufferedReader reader = new BufferedReader(new InputStreamReader(method.getResponseBodyAsStream(), "UTF8"));

			String text = "";
			String line;

			while((line = reader.readLine()) != null) text = text + line;
			method.releaseConnection();

			checkLoginResult(httpStatus, text);
	
		} catch(HttpException e) {
			throw new NetException(e);
		} catch(IOException e) {
			throw new NetException(e);
		} finally {
			disposeCanceller(canceller);
		}
	}

	public void saveReceivedMessage(int[] messageIdList) throws NetException {
		saveMessage("http://bbs.enjoykorea.jp/memo/memo_list.php", messageIdList);
	}

	public void saveSentMessage(int[] messageIdList) throws NetException {
		saveMessage("http://bbs.enjoykorea.jp/memo/save_list.php", messageIdList);
	}

	private void deleteMessage(String url, int[] messageIdList) throws NetException {
		TaskCanceller canceller = null;

		try {
			if(messageIdList.length == 0) throw new NetException("bZ[WIĂ܂");
			PostMethod method = new PostMethod(url);
			canceller = createCanceller(method);
			method.setFollowRedirects(false);

			method.addParameter("check_list", "false");
			method.addParameter("page", "1");
			method.addParameter("mode", "delete");

			for(int i=0; i<messageIdList.length; i++) {
				method.addParameter("nidA[]", String.valueOf(messageIdList[i]));
			}

			method.setRequestHeader("Content-Type", "application/x-www-form-urlencoded; charset=utf-8");

			// s
			int httpStatus = client.executeMethod(method);

			// ʂ̎擾
			BufferedReader reader = new BufferedReader(new InputStreamReader(method.getResponseBodyAsStream(), "UTF8"));

			String text = "";
			String line;

			while((line = reader.readLine()) != null) text = text + line;
			method.releaseConnection();

			checkLoginResult(httpStatus, text);
	
		} catch(HttpException e) {
			throw new NetException(e);
		} catch(IOException e) {
			throw new NetException(e);
		} finally {
			disposeCanceller(canceller);
		}
	}

	public void deleteReceivedMessage(int[] messageIdList) throws NetException {
		deleteMessage("http://bbs.enjoykorea.jp/memo/memo_list.php", messageIdList);
	}

	public void deleteSentMessage(int[] messageIdList) throws NetException {
		deleteMessage("http://bbs.enjoykorea.jp/memo/save_list.php", messageIdList);
	}

	public void denyMessage(String sender, Country country) throws NetException {
		TaskCanceller canceller = null;

		try {
			GetMethod method = new GetMethod("http://bbs.enjoykorea.jp/memo/m_reject_ok.php?id=" + sender + "&national=" + country.toChar());
			canceller = createCanceller(method);
			method.setFollowRedirects(false);

			// s
			int httpStatus = client.executeMethod(method);

			// ʂ̎擾
			BufferedReader reader = new BufferedReader(new InputStreamReader(method.getResponseBodyAsStream(), "UTF8"));

			String text = "";
			String line;

			while((line = reader.readLine()) != null) text = text + line;
			method.releaseConnection();

			checkLoginResult(httpStatus, text);
	
		} catch(HttpException e) {
			throw new NetException(e);
		} catch(IOException e) {
			throw new NetException(e);
		} finally {
			disposeCanceller(canceller);
		}
	}

	public void cancelDenyList(int nidA[]) throws NetException {
		TaskCanceller canceller = null;

		try {
			if(nidA.length == 0) throw new NetException("IDIĂ܂");
			PostMethod method = new PostMethod("http://bbs.enjoykorea.jp/memo/m_reject_list.php");
			canceller = createCanceller(method);
			method.setFollowRedirects(false);

			method.addParameter("mode", "delete");

			for(int i=0; i<nidA.length; i++) {
				method.addParameter("nidA[]", String.valueOf(nidA[i]));
			}

			method.setRequestHeader("Content-Type", "application/x-www-form-urlencoded; charset=utf-8");

			// s
			int httpStatus = client.executeMethod(method);

			// ʂ̎擾
			BufferedReader reader = new BufferedReader(new InputStreamReader(method.getResponseBodyAsStream(), "UTF8"));

			String text = "";
			String line;

			while((line = reader.readLine()) != null) text = text + line;
			method.releaseConnection();

			checkLoginResult(httpStatus, text, "Mۂ܂");
	
		} catch(HttpException e) {
			throw new NetException(e);
		} catch(IOException e) {
			throw new NetException(e);
		} finally {
			disposeCanceller(canceller);
		}
	}

	public String getUserName() {
		return userName;
	}
	
	public Country getCountry() {
		return Country.JAPAN;
	}
}


