/*
 * Copyright (c) 2007, team-naver.com
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.aibonware.viewnaver.server.movie;

import com.aibonware.viewnaver.server.*;

public class Movie {
	public final int no;
	public final String srcUrl;
	public MovieWorker worker;
	
	public byte[] contents = null;
	public String msg = "";
	
	public Movie(UserSession user, int no, String url) {
		this.no = no;
		this.srcUrl = url;
		worker = new MovieWorker(user, this);
	}

	public String getCaption() {
		String statusText = getStatusText();
		
		if(statusText == null) {
			return "";
		} else {
			return "(" + statusText + ")";
		}
	}

	private String getStatusText() {
		switch(worker.getStatus()) {
			case MovieWorker.STATUS_INIT: return null; 
			case MovieWorker.STATUS_DOWNLOAD: return "޳۰ޒ:" + toShortBytes(worker.processedBytes);
			case MovieWorker.STATUS_ENCODE: return "ݺޒ";
			case MovieWorker.STATUS_FINISH: return ":" + toShortBytes(contents.length);
			case MovieWorker.STATUS_IMCOMPLETE: return "s";
			default: return "unknown status";
		}
	}

	private String toShortBytes(int len) {
		if(len < 1024) {
			return len + "B";
		} else if(len < 1024*1024) {
			return (len / 1024) + "KB";
		} else {
			return (len / 1024 / 1024) + "MB";
		}
	}
	
	public void start() {
		synchronized(worker) {
			if(worker.getState() == Thread.State.NEW) {
				worker.start();
			}
		}
	}
}
