/*
 * Copyright (c) 2006, team-naver.com
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.aibonware.viewnaver.task;

import javax.swing.SwingUtilities;

import java.util.*;
import com.aibonware.viewnaver.*;

public class TaskFlowImpl extends TaskFlow {
//	protected Task task;
	Vector<Task> oldTasks = new Vector<Task>();
	Vector<Task> tasks = new Vector<Task>();
	Vector<TaskStatusReceiver> statusReceivers = new Vector<TaskStatusReceiver>();
	boolean disposed = false;
	private final Object tag;

	public TaskFlowImpl(Object tag) {
		this.tag = tag;
	}

	public boolean execute(GUITask task) {
		return execute(task, true);
	}

	private boolean addTask(Task task, boolean mustFirst) {
		synchronized(this) {
			if(disposed) {
				ViewNaver.println("G[F^XNj^ėp悤Ƃ܂B");
				return false;
			}

			if(mustFirst && tasks.size() != 0) {
				ViewNaver.println("G[Fs̃^XN݂܂");
				return false;
			}

			tasks.addElement(task);
			task.taskFlow = new ReusableTaskFlow(this);
		}

		return true;
	}
	
	boolean execute(GUITask task, boolean mustFirst) {
		if(!addTask(task, mustFirst)) return false;
		
		if(SwingUtilities.isEventDispatchThread()) {
			task.run();
		} else {
			SwingUtilities.invokeLater(task);
		}

		return true;
	}

	public boolean execute(WorkerTask task) {
		return execute(task, true);
	}

	public boolean execute(WorkerTask task, boolean mustFirst) {
		if(!addTask(task, mustFirst)) return false;

		ViewNaver.instance.threadPool.execute(task);
		return true;
	}

	public void finish(Task task) {
		synchronized(this) {
			oldTasks.removeElement(task);
			tasks.removeElement(task);

			if(isEmpty()) {
				ViewNaver.instance.taskFlowList.removeFlow(this);
				disposed = true;

				for(TaskStatusReceiver statusReceiver: statusReceivers) {
					statusReceiver.statusChanged(TaskStatusReceiver.FINISHED);
				}
			}
		}
	}

	public void clear() {
		synchronized(this) {
			oldTasks.addAll(tasks);
			tasks.clear();
		}
	}
	
	public boolean isEmpty() {
		return (oldTasks.size() == 0 && tasks.size() == 0);
	}
	
	public Object getTag() {
		return tag;
	}

	public void addStatusReceiver(TaskStatusReceiver statusReceiver) {
		statusReceivers.addElement(statusReceiver);
		statusReceiver.statusChanged(TaskStatusReceiver.RUNNING);
	}

	private Vector<TaskCanceller> taskCancellers = new Vector<TaskCanceller>();
	
	public void addTaskCanceller(TaskCanceller taskCanceller) {
		synchronized(taskCancellers) {
			taskCancellers.addElement(taskCanceller);
		}
	}

	public void removeTaskCanceller(TaskCanceller taskCanceller) {
		synchronized(taskCancellers) {
			taskCancellers.removeElement(taskCanceller);
		}
	}

	public void cancel() {
		Vector<TaskCanceller> cancellers = new Vector<TaskCanceller>();

		synchronized(taskCancellers) {
			cancellers.addAll(taskCancellers);
		}

		for(TaskCanceller canceller: cancellers) {
			canceller.cancel();
		}
	}
}
