/*
 * Copyright (c) 2007, team-naver.com
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.aibonware.viewnaver.window;

import java.util.*;
import java.awt.*;
import java.awt.event.*;

import javax.swing.*;
import javax.swing.event.*;
import javax.swing.border.*;

import com.aibonware.viewnaver.*;
import com.aibonware.viewnaver.component.*;
import com.aibonware.viewnaver.config.*;
import com.aibonware.viewnaver.net.*;
import com.aibonware.viewnaver.task.*;
import com.aibonware.viewnaver.server.*;
import com.aibonware.viewnaver.server.image.ImageCache;

@SuppressWarnings("serial")
public class MiniServerDialog extends JFrame {
	private JTextField portText;
	private JPasswordField passwordText;
	private JPasswordField passwordText2;
	private JCheckBox useSmallImageCheck;
	private JTextField maxImageWidthText;
	private JTextField maxImageHeightText;
	private JTextField maxImageSizeText;
	private JCheckBox useHighSpeedRenderingCheck;
	private JTextField shrinkMovieCommandText;
	private JTextField movieContentTypeText;

	JButton okButton = new JButton("OK");
	JButton cancelButton = new JButton("Cancel");

	public MiniServerDialog(JFrame parentFrame) {
		super("u");

		setDefaultCloseOperation(DISPOSE_ON_CLOSE);

		PagePanel settingPage = new PagePanel();
		settingPage.setBorder(new BevelBorder(BevelBorder.RAISED));

		portText = new JTextField("8080");
		passwordText = new JPasswordField();
		passwordText2 = new JPasswordField();

		useSmallImageCheck = new JCheckBox("k摜\̗L");
		maxImageWidthText = new JTextField("200");
		maxImageHeightText = new JTextField("300");
		maxImageSizeText = new JTextField("20");
		useHighSpeedRenderingCheck = new JCheckBox("Eikgp");
		shrinkMovieCommandText = new JTextField("ffmpeg.exe -y -i %s -b 2000 -ar 8000 -ac 1 -s 128x96 -r 5 -f 3gp %s");
		movieContentTypeText = new JTextField("video/3gpp");
		
		useSmallImageCheck.setSelected(true);
		useHighSpeedRenderingCheck.setSelected(true);
		
		settingPage.addLine("|[gF \t", PagePanel.glue(portText));
		settingPage.addLine("pX[hF \t", PagePanel.glue(passwordText));
		settingPage.addLine("pX[hē: \t", PagePanel.glue(passwordText2));
		settingPage.addLine(useSmallImageCheck);
		settingPage.addLine(useHighSpeedRenderingCheck);
		settingPage.addLine("k摜ő啝F \t", PagePanel.glue(maxImageWidthText));
		settingPage.addLine("k摜ő卂: \t", PagePanel.glue(maxImageHeightText));
		settingPage.addLine("kő摜TCY(KByte): \t", PagePanel.glue(maxImageSizeText));
		settingPage.addLine("ϊR}h: \t", PagePanel.glue(shrinkMovieCommandText));
		settingPage.addLine("Reg^Cv: \t", PagePanel.glue(movieContentTypeText));

		ViewNaver.instance.deftex.plus(portText);
		ViewNaver.instance.deftex.plus(passwordText);
		ViewNaver.instance.deftex.plus(passwordText2);
		ViewNaver.instance.deftex.plus(maxImageWidthText);
		ViewNaver.instance.deftex.plus(maxImageHeightText);
		ViewNaver.instance.deftex.plus(maxImageSizeText);
		ViewNaver.instance.deftex.plus(shrinkMovieCommandText);
		ViewNaver.instance.deftex.plus(movieContentTypeText);

		PagePanel buttonBox = new PagePanel(okButton, cancelButton);

		add(settingPage, BorderLayout.CENTER);
		add(buttonBox, BorderLayout.SOUTH);

		setBounds(200, 200, 600, 300);

		this.getRootPane().setDefaultButton(okButton);

		cancelButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				MiniServerDialog.this.dispose();
			}
		});

		okButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				try {
					String sPort = portText.getText().trim();
					String sPassword1 = new String(passwordText.getPassword()).trim();
					String sPassword2 = new String(passwordText2.getPassword()).trim();
					
					if(sPort.length() == 0) {
						JOptionPane.showMessageDialog(MiniServerDialog.this, "|[gԍ͂Ă܂B");
						return;
					}
					
					if(sPassword1.length() == 0 || sPassword2.length() == 0) {
						JOptionPane.showMessageDialog(MiniServerDialog.this, "pX[h͂Ă܂B");
						return;
					}

					if(!sPassword1.equals(sPassword2)) {
						JOptionPane.showMessageDialog(MiniServerDialog.this, "pX[hvĂ܂B");
						return;
					}

					boolean useSmallImage = useSmallImageCheck.isSelected();
					int maxImageWidth = Integer.parseInt(maxImageWidthText.getText());
					int maxImageHeight = Integer.parseInt(maxImageWidthText.getText());
					int maxImageSize = Integer.parseInt(maxImageSizeText.getText());
					boolean useHighSpeedRendering = useHighSpeedRenderingCheck.isSelected();
					int port = Integer.parseInt(portText.getText());

					HashMap<RenderingHints.Key, Object> renderingHints;
					
					if(useHighSpeedRendering) {
						renderingHints = ImageCache.RENDERING_HINTS_HISPEED;
					} else {
						renderingHints = ImageCache.RENDERING_HINTS_STANDARD;
					}
					
					String shrinkMovieCommand = shrinkMovieCommandText.getText();
					String movieContentType = movieContentTypeText.getText();
					
					ViewNaver.instance.server = new MiniServer(port, sPassword1, 10, useSmallImage, maxImageWidth, maxImageHeight, maxImageSize, renderingHints, shrinkMovieCommand, movieContentType);
					ViewNaver.instance.server.start();
					MiniServerDialog.this.dispose();
				} catch(Exception ex) {
					ViewNaver.println(ex.getMessage());
					return;
				}
				
//				userName = userNameText.getText();
//				password = new String(passwordText.getPassword());
			}
		});
	}
}
