//
// +----------------------------------------------------------------------+
// | Dev-PHP - Integrated Development Environment                         |
// +----------------------------------------------------------------------+
// | Copyright (C) 2002-2003, http://devphp.sourceforge.net               |
// +----------------------------------------------------------------------+
// | This program is free software; you can redistribute it and/or modify |
// | it under the terms of the GNU General Public License as published by |
// | the Free Software Foundation; either version 2 of the License, or    |
// | (at your option) any later version.                                  |
// | This program is distributed in the hope that it will be useful       |
// | but WITHOUT ANY WARRANTY; without even the implied warranty of       |
// | MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the         |
// | GNU General Public License for more details.                         |
// +----------------------------------------------------------------------+
// | Author: Leonardo Garca <simbiotik@users.sourceforge.net>            |
// | Author: Urs Mder <ursmaeder@users.sourceforge.net>                  |
// +----------------------------------------------------------------------+
//
unit frmAbout;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, jpeg, ExtCtrls, ComCtrls, Buttons, shellAPI, uLang,
  uEditor, uIniFile,version, cltreeview;

type
  TAboutForm = class(TForm)
    Panel1: TPanel;
    Bevel1: TBevel;
    Label6: TLabel;
    Image1: TImage;
    GroupBox1: TGroupBox;
    lbMail: TLabel;
    lbWeb: TLabel;
    lbProject: TLabel;
    Label8: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    SpeedButton1: TSpeedButton;
    SpeedButton2: TSpeedButton;
    Panel2: TPanel;
    Label10: TLabel;
    Image2: TImage;
    Label11: TLabel;
    Label7: TLabel;
    SpeedButton3: TSpeedButton;
    GroupBox2: TGroupBox;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label9: TLabel;
    Label12: TLabel;
    Label13: TLabel;
    procedure lbMailClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure UrlClick(Sender: TObject);
    procedure SpeedButton2Click(Sender: TObject);
    procedure SpeedButton1Click(Sender: TObject);
    procedure Label1Click(Sender: TObject);
    procedure FormKeyUp(Sender: TObject; var Key: Word;
      Shift: TShiftState);
  private
    { Private declarations }
  public          
    { Public declarations }
  end;

var
  AboutForm: TAboutForm;

implementation

uses frmMain;

{$R *.dfm}

procedure TAboutForm.lbMailClick(Sender: TObject);
begin
  ShellExecute(0, 'open', PChar('mailto:' + lbMail.Caption), nil, nil, 0);
end;


procedure TAboutForm.Label1Click(Sender: TObject);
begin
  ShellExecute(0, 'open', PChar('mailto:' + Label1.Caption), nil, nil, 0);
end;

procedure TAboutForm.FormShow(Sender: TObject);
begin
  Self.Font.Name := settings.DialogFontText;
  Caption := Lang(750);
  Label10.Caption := 'Dev-PHP Version: ' + DevPHPVer;
  Speedbutton3.Caption:='SynEdit-Version: '+SynEditVer;
end;

procedure TAboutForm.UrlClick(Sender: TObject);
begin
  ShellExecute(0, 'open', PChar((Sender as TLabel).Caption), nil, nil, 0);
end;

procedure TAboutForm.SpeedButton2Click(Sender: TObject);
var
  gpl : string;
begin
  gpl := ExtractFilePath(Application.ExeName) + 'docs\copying.txt';
  if FileExists(gpl) then
  with TEditor.Create do begin
    Init(gpl, TRUE);
  end;
  Self.Close;
end;

procedure TAboutForm.SpeedButton1Click(Sender: TObject);
begin
  Close;
end;


procedure TAboutForm.FormKeyUp(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if Key=VK_ESCAPE then begin
    Close; Key:=0;
  end;

end;

end.
