//
// +----------------------------------------------------------------------+
// | Dev-PHP - Integrated Development Environment                         |
// +----------------------------------------------------------------------+
// | Copyright (C) 2002-2003, http://devphp.sourceforge.net               |
// +----------------------------------------------------------------------+
// | This program is free software; you can redistribute it and/or modify |
// | it under the terms of the GNU General Public License as published by |
// | the Free Software Foundation; either version 2 of the License, or    |
// | (at your option) any later version.                                  |
// | This program is distributed in the hope that it will be useful       |
// | but WITHOUT ANY WARRANTY; without even the implied warranty of       |
// | MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the         |
// | GNU General Public License for more details.                         |
// +----------------------------------------------------------------------+
// | Author: Leonardo Garca <simbiotik@users.sourceforge.net>            |
// | Author: Urs Mder <ursmaeder@users.sourceforge.net>                  |
// +----------------------------------------------------------------------+
//

unit frmAutoText;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls,frmMain,IniFiles, IdCoder3To4, IdBaseComponent, IdCoder,
  DB, Provider, DBClient, ExtCtrls, DBCtrls, Grids, DBGrids, Mask, Spin;

type
  TAutoTextFrm = class(TForm)
    ClientDataSet1: TClientDataSet;
    DataSetProvider1: TDataSetProvider;
    ClientDataSet1Name: TStringField;
    ClientDataSet1Text: TMemoField;
    DataSource1: TDataSource;
    DataSource2: TDataSource;
    Import1: TClientDataSet;
    DataSetProvider2: TDataSetProvider;
    OpenDialog1: TOpenDialog;
    SaveDialog1: TSaveDialog;
    Panel12: TPanel;
    Opciones: TPanel;
    Borde: TPanel;
    DBNavigator1: TDBNavigator;
    Button5: TButton;
    Button3: TButton;
    Button4: TButton;
    Button2: TButton;
    Label1: TLabel;
    DBEdit1: TDBEdit;
    Label2: TLabel;
    Button1: TButton;
    DBGrid1: TDBGrid;
    DBMemo1: TDBMemo;
    procedure FormShow(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure Button5Click(Sender: TObject);
    procedure FormKeyUp(Sender: TObject; var Key: Word;
      Shift: TShiftState);
  private
    { Private-Deklarationen }
  public
    { Public-Deklarationen }
  end;

const
  autofilename='autotext.xml';
  cursorstr='<<|>>';

var
  AutoTextFrm: TAutoTextFrm;

implementation

{$R *.dfm}

procedure TAutoTextFrm.FormShow(Sender: TObject);
begin
  if not FileExists(ExtractFilePath(Application.exename)+ '\'+autofilename) then begin
    clientdataset1.SaveToFile(ExtractFilePath(Application.exename)+ '\'+autofilename);
  end;
end;

procedure TAutoTextFrm.FormCreate(Sender: TObject);
var autofile:string;
begin
  autofile:=ExtractFilePath(Application.exename)+ '\'+autofilename;
  if not FileExists(autofile) then begin
    ClientDataSet1.filename:=autofile;
    ClientDataSet1.CreateDataSet;
    ClientDataSet1.saveToFile(ClientDataSet1.filename,dfXML);
  end else begin
    ClientDataSet1.filename:=autofile;
  end;
  clientDataSet1.active:=true;
end;

procedure TAutoTextFrm.Button1Click(Sender: TObject);
begin
  dbmemo1.SelText:=cursorstr;
end;

procedure TAutoTextFrm.Button3Click(Sender: TObject);
begin
  OpenDialog1.InitialDir:=ExtractFilePath(application.exename);
  if OpenDialog1.Execute then begin
    if fileExists(OpenDialog1.FileName) then begin
      try
        Import1.FileName:=OpenDialog1.FileName;
        Import1.Active:=true;
        if (Import1.FieldDefs.Find('Text')<>nil) and
          (Import1.FieldDefs.Find('Name')<>nil) then begin
          Import1.First;
          while not import1.Eof do  begin
            clientDataset1.Append;
            clientDataset1.FieldByName('Name').AsString:=Import1.fieldbyName('Name').AsString;
            clientDataset1.FieldByName('Text').AsString:=Import1.fieldbyName('Text').AsString;
            clientDataset1.Post;
            Import1.Next;
          end;
        end else begin
        end;
      except
        showmessage('Import - Format failed');
      end;
    end;
  end;
end;

procedure TAutoTextFrm.Button4Click(Sender: TObject);
begin
  SaveDialog1.InitialDir:=ExtractFilePath(application.ExeName);
  if SaveDialog1.Execute then begin
    try
      Import1.FileName:=SaveDialog1.FileName;
      with Import1.FieldDefs do begin
        Clear;
        with AddFieldDef do begin
          Name := 'Name';
          DataType := ftString;
          Required := True;
          Size := 20;
        end;
        with AddFieldDef do begin
          Name := 'Text';
          DataType := ftMemo;
        end;
      end;
      import1.ProviderName:='DataSetProvider2';
      import1.CreateDataSet;
      Import1.Active:=true;
      clientDataset1.First;
      while not clientDataset1.Eof do  begin
        Import1.Append;
        Import1.FieldByName('Name').AsString:=clientDataset1.fieldbyName('Name').AsString;
        Import1.FieldByName('Text').AsString:=clientDataset1.fieldbyName('Text').AsString;
        Import1.Post;
        clientDataset1.Next;
      end;
      Import1.Close;
    except
    end;
  end;

end;

procedure TAutoTextFrm.Button5Click(Sender: TObject);
begin
  clientdataset1.EmptyDataSet();
end;

procedure TAutoTextFrm.FormKeyUp(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if Key=VK_ESCAPE then begin
    Close; Key:=0;
  end;
end;

end.
