//
// +----------------------------------------------------------------------+
// | Dev-PHP - Integrated Development Environment                         |
// +----------------------------------------------------------------------+
// | Copyright (C) 2002-2003, http://devphp.sourceforge.net               |
// +----------------------------------------------------------------------+
// | This program is free software; you can redistribute it and/or modify |
// | it under the terms of the GNU General Public License as published by |
// | the Free Software Foundation; either version 2 of the License, or    |
// | (at your option) any later version.                                  |
// | This program is distributed in the hope that it will be useful       |
// | but WITHOUT ANY WARRANTY; without even the implied warranty of       |
// | MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the         |
// | GNU General Public License for more details.                         |
// +----------------------------------------------------------------------+
// | Author: Leonardo Garca <simbiotik@users.sourceforge.net>            |
// | Author: Urs Mder       <ursmaeder@users.sourceforge.net>            |
// +----------------------------------------------------------------------+
//
unit frmCheck;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ExtCtrls, uLang,uIniFile
//  , XPMenu
  ;

type
  TSyntaxCheck = class(TForm)
    Panel1: TPanel;
    procedure FormShow(Sender: TObject);
    procedure Panel2Click(Sender: TObject);
    procedure FormKeyUp(Sender: TObject; var Key: Word;
      Shift: TShiftState);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  SyntaxCheck: TSyntaxCheck;

implementation

uses frmMain;

{$R *.dfm}

procedure TSyntaxCheck.FormShow(Sender: TObject);
var
  Parser,archEntry,command,compile : string;
begin
  Self.Font.Name := settings.DialogFontText;
  Caption := Lang(650);
  Panel1.Hint := Lang(653);
  Parser := MainFrm.Parser;
  archEntry := ExtractFilePath(Application.ExeName) + '~out.php';
  MainFrm.GetEditor.SynEdit.Lines.SaveToFile(archEntry);
  command := '"' + Parser + '" -l "' + archEntry + '"';
  compile := MainFrm.RunAndGetOutput(command, ExtractFilePath(archEntry));
  if Pos('No syntax errors detected in ',compile) <> 0 then
    Panel1.Caption := Lang(651)
  else
    Panel1.Caption := Lang(652);
  DeleteFile(archEntry);
end;

procedure TSyntaxCheck.Panel2Click(Sender: TObject);
begin
  Close;
end;

procedure TSyntaxCheck.FormKeyUp(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if Key=VK_ESCAPE then begin
    Close; Key:=0;
  end;
end;

end.
