//
// +----------------------------------------------------------------------+
// | Dev-PHP - Integrated Development Environment                         |
// +----------------------------------------------------------------------+
// | Copyright (C) 2002, http://devphp.sourceforge.net                    |
// +----------------------------------------------------------------------+
// | This program is free software; you can redistribute it and/or modify |
// | it under the terms of the GNU General Public License as published by |
// | the Free Software Foundation; either version 2 of the License, or    |
// | (at your option) any later version.                                  |
// | This program is distributed in the hope that it will be useful       |
// | but WITHOUT ANY WARRANTY; without even the implied warranty of       |
// | MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the         |
// | GNU General Public License for more details.                         |
// +----------------------------------------------------------------------+
// | Author: Urs Maeder <umaeder@bluewin.ch>                              |
// +----------------------------------------------------------------------+

unit frmFTP;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ImgList, IdBaseComponent, IdAntiFreezeBase, IdAntiFreeze,IniFiles,
  ComCtrls, ExtCtrls, ShellCtrls, StdCtrls, IdComponent, IdTCPConnection,uIniFile,
  IdTCPClient,shlobj, IdFTP, DateUtils,IdException, Menus, Buttons, ToolWin,ulang;

type
  TftpInfo=record
    name:string;
    isdir:boolean;
    date:TDateTime;
    owner:string;
    group:string;
    size:integer;
    permission:string;
    unknown:string;
  end;
  EStringInvalid = class(Exception);

  TWalkProc=Procedure (tp:TftpInfo) of object;
  TWalkFolderProc=Procedure (folder:string) of object;

  TFTPForm = class(TForm)
    IdAntiFreeze1: TIdAntiFreeze;
    FtpItems: TImageList;
    IdFTP1: TIdFTP;
    PopupMenu1: TPopupMenu;
    delete1: TMenuItem;
    newFolder1: TMenuItem;
    ControlBar1: TControlBar;
    Panel1: TPanel;
    Memo1: TMemo;
    Panel2: TPanel;
    Splitter2: TSplitter;
    ShellListView1: TShellListView;
    ListView: TListView;
    ToolBar1: TToolBar;
    SpeedButton1: TSpeedButton;
    Button2: TButton;
    Button4: TButton;
    ShellComboBox1: TShellComboBox;
    ToolButton1: TToolButton;
    ToolButton2: TToolButton;
    CheckBox1: TCheckBox;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormShow(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure ListViewCompare(Sender: TObject; Item1, Item2: TListItem;
      Data: Integer; var Compare: Integer);
    procedure ListViewDblClick(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure delete1Click(Sender: TObject);
    procedure newFolder1Click(Sender: TObject);
    procedure SpeedButton1Click(Sender: TObject);
    procedure ShellListView1KeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure ShellListView1DblClick(Sender: TObject);
    procedure ListViewKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
  private
     ftpList:TStringList;
     procedure showFTP;
    procedure setPath(s: string);
    procedure splitFTPMessage(st: string; var t: TFTPInfo);
    procedure walkTree(OnWalk : TWalkProc;OnDirChange:TWalkFolderProc;OnDirUp:TWalkFolderProc);
    procedure getDir(folder: string);
    procedure getWalk(tp: tftpinfo);
    procedure delWalk(tp: tftpinfo);
    procedure delDir(folder: string);
    procedure delDirUp(folder: string);
    procedure getDirUp(folder: string);
    procedure FileLook(Filespec: string);
    procedure setLang;
    procedure ChangeFTPPath;
    { Private-Deklarationen }
  public
    currPath:string;
    { Public-Deklarationen }
  end;

var
  FTPForm: TFTPForm;

implementation

{$R *.dfm}
const cfname=55;

procedure TFTPForm.showFTP;
var n:string;
    i:integer;
    ListItem: TListItem;
begin
  listview.Clear;
  idftp1.List(ftplist);
  for i:=0 to ftplist.Count-1 do begin
    n:=copy(ftplist[i],cfname,length(ftplist[i])-cfname+1);
    if (n[1]='.') and (ftplist[i][1]='d') then begin
    end else begin
      ListItem := ListView.Items.Add;
      listItem.Data:=pchar(ftplist[i]);
      listItem.Caption:=n;
      if ftplist[i][1]='d' then listitem.ImageIndex:=0
        else listitem.ImageIndex:=1;
      ListItem.SubItems.Add('d');
    end;
  end;
end;

procedure TFTPForm.splitFTPMessage(st:string;var t:TFTPInfo);

  function getMonat(s1:string):integer;
  var s:string;
  begin
    s:=Copy(s1,1,3);
    result:=1;
    if s='Jan' then result:=1;
    if s='Feb' then result:=2;
    if s='Mar' then result:=3;
    if s='Apr' then result:=4;
    if s='May' then result:=5;
    if s='Jun' then result:=6;
    if s='Jul' then result:=7;
    if s='Aug' then result:=8;
    if s='Sep' then result:=9;
    if s='Oct' then result:=10;
    if s='Nov' then result:=11;
    if s='Dez' then result:=12;
  end;

  function getTag(s1:string):integer;
  var s:string;
  begin
    s:=copy(s1,5,2);
    result:=strtoint(s);
  end;

  function getYear(s1:string):integer;
  var s:string;
  begin
    s:=copy(s1,8,5);
    if pos(':',s)>0 then result:=yearof(date) else result:=strtoint(s);
  end;

  function getHour(s1:string):integer;
  var s:string;
  begin
    s:=copy(s1,8,5);
    result:=0;
    if pos(':',s)>0 then begin
      s:=copy(s,1,2);
      result:=strtoint(s);
    end;
  end;

  function getMinute(s1:string):integer;
  var s:string;
  begin
    s:=copy(s1,8,5);
    result:=0;
    if pos(':',s)>0 then begin
      s:=copy(s,4,2);
      result:=strtoint(s);
    end;
  end;

var s1:string;

begin
  if st='' then raise EStringInvalid.create('String fault');
  t.isdir:=st[1]='d';
  t.permission:=copy(st,1,10);
  t.unknown:=copy(st,12,2);
  t.owner:=copy(st,16,8);
  t.group:=copy(st,25,8);
  t.size:=strtoint(copy(st,33,8));
  s1:=copy(st,42,12);
  t.date:=EncodeDateTime(getYear(s1),getMonat(s1),getTag(s1),getHour(s1),getMinute(s1),0,0);
  t.name:=copy(st,cfname,length(st)-cfname+1);
end;

procedure TFTPForm.ListViewDblClick(Sender: TObject);
var s:Pchar;
    s1:string;
begin
  if listview.SelCount=0 then exit;
  s:=listview.Selected.Data;
  if s[0]='d' then begin
    s1:=ShellComboBox1.Path+'\'+listview.Selected.Caption;
    if checkbox1.Checked then begin
      ForceDirectories(s1);
      setPath(s1);
    end;
    idftp1.ChangeDir(listview.Selected.Caption);
    showftp;
  end;
end;

procedure TFTPForm.ListViewCompare(Sender: TObject; Item1,
  Item2: TListItem; Data: Integer; var Compare: Integer);
var s,s2:pchar;
    t1,t2:TFtpInfo;
begin
  s:=item1.data; s2:=item2.data;
  compare:=0;
  compare:=AnsiCompareStr(s2[0],s[0]);
  if compare=0 then begin
    splitFTPMessage(s,t1);
    splitFTPMessage(s2,t2);
    compare:=AnsiCompareStr(t1.name,t2.name);
  end;
end;

procedure TFTPForm.getWalk(tp:tftpinfo);
begin
  memo1.Lines.Add(lang(2024)+tp.name);
  try
    idftp1.Get(tp.name,currPath+'\'+tp.name,true);
  except
  end;
end;

procedure TFTPForm.getDir(folder:string);
begin
  if folder[1]='/' then delete(folder,1,1);
  currPath:=currPath+'\'+folder;
  ForceDirectories(currPath);
  memo1.Lines.Add(lang(2019)+idftp1.RetrieveCurrentDir+lang(2023)+currPath);
end;

procedure TFTPForm.getDirUp(folder:string);
begin
  while currPath[length(currPath)]<>'\' do delete(currPath,length(currPath),1);
  if length(currPath)>3 then delete(currPath,length(currPath),1);
  memo1.Lines.Add(lang(2019)+idftp1.RetrieveCurrentDir+lang(2023)+currPath);
end;

procedure TFTPForm.Button4Click(Sender: TObject);
var t:TListItem;
    ti:TFtpInfo;
    oldname,ftppath:string;
    sp:Pchar;
begin
  memo1.Clear;
  if listview.SelCount>0 then
  begin
    shelllistview1.Items.BeginUpdate;
    currpath:=shellcombobox1.Path;
    oldname:=shellcombobox1.path;
    ftppath:=idftp1.RetrieveCurrentDir;
    t:=listview.Selected;
    while t<>nil do begin
      sp:=t.data;
      splitFTPMessage(sp,ti);
      if ti.isdir then begin
        try
          memo1.Lines.Add(lang(2015)+ftppath);
          memo1.Lines.Add(lang(2022)+ti.name);
          idftp1.ChangeDir(ti.name);
          getDir(ti.name);
          walktree(getWalk,getDir,getDirUp);
          idftp1.ChangeDir('..');
          getDirUp(ti.name);
          memo1.Lines.Add(lang(2021));
        except
          memo1.Lines.Add(lang(2008));
        end;
      end else begin
        memo1.Lines.Add(lang(2024)+ti.name);
        try
          idftp1.Get(ti.name,shellcombobox1.Path+'\'+ti.name,true);
        except
          memo1.Lines.Add(lang(2008));
        end;
      end;
      // next item
      t:=listview.GetNextItem(t,sdAll, [isSelected]);
    end;
    setpath(oldname);
    idftp1.Disconnect;idftp1.Connect(true);
    idftp1.ChangeDir(ftppath);
    shelllistview1.Refresh;
    shelllistview1.Invalidate;
    shelllistview1.Items.EndUpdate;
  end;
end;

procedure TFTPForm.setLang;
begin
  button2.Caption:=lang(2000);
  button4.Caption:=lang(2001);
  checkbox1.Caption:=lang(2002);
  delete1.Caption:=lang(2003);
  newFolder1.Caption:=lang(2004);
end;

procedure TFTPForm.ChangeFTPPath();
var command,s:string;
    lauf:integer;
begin
  command:=settings.FTPServerPathText;
  lauf:=4;
  s:=command;
  while lauf>1 do begin
    if s[1]='/' then dec(lauf);
    delete(s,1,1);
  end;
  command:=s;
  idftp1.ChangeDir(command);
end;

procedure TFTPForm.FormShow(Sender: TObject);
begin
  setlang;
  setPath(settings.localpathText);
  ftplist:=TStringList.Create;
  idftp1.Port:=strtoint(settings.FTPPortText);
  idftp1.Host:=settings.FTPHostText;
  idftp1.User:=settings.FTPUserText;
  idftp1.Password:=settings.FTPPasswordText;
  idFTP1.Connect(true);
  ChangeFTPPath();
  showFTP;
end;

procedure TFTPForm.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  idftp1.Disconnect;
  ftplist.Free;
  action:=cafree;
end;

procedure TFTPForm.setPath(s:string);
var new:integer;
begin
  shellcombobox1.Items.BeginUpdate;
  shelllistview1.Items.BeginUpdate;
  ShellComboBox1.Path:=s;
  new:=shellcombobox1.ItemIndex;
  shellcombobox1.ItemIndex:=0;
  shellcombobox1.ItemIndex:=new;
  shelllistview1.Items.EndUpdate;
  shellcombobox1.Items.EndUpdate;
end;

procedure TFTPForm.walkTree(OnWalk:TWalkProc;
    OnDirChange:TWalkFolderProc;OnDirUp:TWalkFolderProc);
var i:integer;
    tp:TFTPInfo;
    ls:TStringList;
begin
  ls:=TstringList.Create;
  idftp1.List(ls);
  ls.Sort;
  for i:=ls.Count-1 downto 0 do begin
    splitFTPMessage(ls[i],tp);
    if tp.isdir then begin
      if tp.name[1]<>'.' then begin
        idftp1.ChangeDir(tp.name);
        if assigned(OnDirChange) then OnDirChange(tp.name);
        walktree(OnWalk,OnDirChange,OnDirUp);
        idftp1.ChangeDir('..');
        if assigned(OnDirUp) then OndirUp(tp.name);
      end;
    end else begin
      if assigned(OnWalk) then OnWalk(tp);
    end;
  end;
  ls.Free;
end;

procedure TFTPForm.FileLook(Filespec:string);
//filespec must contain the full path ie. c:\folder\*.* or c:\folder\this.txt
var validres:integer;
    res:boolean;
    SearchRec : TSearchRec;
    DirPath, FullName, Flname : string;
begin
  DirPath:=ExtractFilePath(FileSpec);
  res:= DirectoryExists(DirPath);
  If not res then exit;
  Flname:=ExtractFileName(FileSpec);
  validres := FindFirst(FileSpec, faAnyFile, SearchRec);
  while validres=0 do begin
    If (SearchRec.Name[1] <> '.') then begin
      FullName:=DirPath + LowerCase(SearchRec.Name);
      If (SearchRec.Attr and faDirectory > 0) then begin
        memo1.Lines.Add(lang(2019)+FullName);
        idftp1.MakeDir(SearchRec.Name);
        idftp1.ChangeDir(searchRec.Name);
        FileLook(FullName+'\'+ Flname);
        idftp1.ChangeDir('..');
        memo1.Lines.Add(lang(2018));
      end else begin
        memo1.Lines.Add(lang(2020)+fullname);
        idftp1.Put(Fullname,searchRec.Name);
      end;
    end;
    validres:=FindNext(SearchRec);
  end;
end;

procedure TFTPForm.Button2Click(Sender: TObject);
var i:integer;
begin
  memo1.Clear;
  for I :=0 to ShellListView1.Items.Count -1 do
  if ShellListView1.Items.Item[I].Selected then begin
    if shelllistview1.Folders[i].IsFolder then begin
      memo1.Lines.Add(lang(2019)+shelllistview1.Folders[i].PathName);
      idftp1.MakeDir(shelllistview1.Folders[i].DisplayName);
      idftp1.ChangeDir(shelllistview1.Folders[i].DisplayName);
      FileLook(shelllistview1.Folders[i].PathName+'\*.*');
      idftp1.ChangeDir('..');
      memo1.Lines.Add(lang(2018));
    end else begin
      memo1.Lines.Add(lang(2017)+shelllistview1.Folders[i].PathName);
      idftp1.Put(shelllistview1.Folders[i].PathName,ShellListView1.Folders[I].DisplayName);
    end;
  end;
  showftp;
end;

procedure TFTPForm.delWalk(tp:tftpinfo);
begin
  memo1.Lines.Add(lang(2005)+tp.name);
  try
    idftp1.delete(tp.name);
  except
  end;
end;

procedure TFTPForm.delDir(folder:string);
begin
end;

procedure TFTPForm.delDirUp(folder:string);
begin
    memo1.Lines.Add(lang(2016)+folder );
    try
      idftp1.RemoveDir(folder);
    except
    end;
end;

procedure TFTPForm.delete1Click(Sender: TObject);
var t:TListItem;
    ti:TFtpInfo;
    oldname,ftppath:string;
    sp:Pchar;
begin
  memo1.Clear;
  if MessageDlg(lang(2009), mtConfirmation, [mbOK,mbCancel], 0) = mrCancel then exit;
  if listview.SelCount>0 then
  begin
    oldname:=shellcombobox1.path;
    ftppath:=idftp1.RetrieveCurrentDir;
    t:=listview.Selected;
    while t<>nil do begin
      sp:=t.data;
      splitFTPMessage(sp,ti);
      t:=listview.GetNextItem(t,sdAll, [isSelected]);
      if ti.isdir then begin
        try
          memo1.Lines.Add(lang(2015)+ftppath);
          idftp1.ChangeDir(ti.name);
          delDir(ti.name);
          try
            walktree(delWalk,delDir,delDirUp);
          except
          end;
          idftp1.ChangeDir('..');
          delDirUp(ti.name);
          memo1.Lines.Add(lang(2014)+ti.name);
          try
            idftp1.RemoveDir(ti.name);
          except
          end;
          memo1.Lines.Add(lang(2006));
        except
          memo1.Lines.Add(lang(2007));
        end;
      end else begin
        memo1.Lines.Add(lang(2013)+ti.name);
        try
          idftp1.Delete(ti.name);
        except
          memo1.Lines.Add(lang(2008));
        end;
      end;
    end;
    idftp1.Disconnect;idftp1.Connect(true);
    idftp1.ChangeDir(ftppath);
    showftp;
  end;
end;

procedure TFTPForm.newFolder1Click(Sender: TObject);
var val:string;
begin
  val:=lang(2012);
  if InputQuery(lang(2010),lang(2011),val)then begin
    idftp1.MakeDir(val);
    showftp;
  end;
end;

procedure TFTPForm.SpeedButton1Click(Sender: TObject);
var s:string;
    slv,lv:boolean;
begin
  slv:=false;lv:=false;
  if not checkbox1.Checked then begin
    if shelllistview1.Focused then begin
      slv:=true;
    end;
    if listview.Focused then begin
      lv:=true;
    end;
  end else begin slv:=true; lv:=true;
  end;
  s:=shellcombobox1.Path;
  while s[length(s)]<>'\' do delete(s,length(s),1);
  if length(s)>3 then delete(s,length(s),1);
  if slv then setPath(s);
  if lv then begin
    idftp1.ChangeDir('..');
    showftp;
  end;
end;

procedure DeleteFiles (const Path, Mask : string; recursive : boolean);
var
  Result    : integer;
  SearchRec : TSearchRec;
begin
  Result := FindFirst(Path + Mask, faAnyFile - faDirectory, SearchRec);
  while Result = 0 do
  begin
    if not DeleteFile (Path + SearchRec.name) then
    begin
      FileSetAttr (Path + SearchRec.name, 0);
      DeleteFile (Path + SearchRec.name);
    end;
    Result := FindNext(SearchRec);
  end;
  FindClose(SearchRec);

  if not recursive then
    exit;

  Result := FindFirst(Path + '*.*', faDirectory, SearchRec);
  while Result = 0 do
  begin
    if (SearchRec.name <> '.') and (SearchRec.name <> '..') then
    begin
      FileSetAttr (Path + SearchRec.name, faDirectory);
      DeleteFiles (Path + SearchRec.name + '\', Mask, TRUE);
      RmDir (Path + SearchRec.name);
    end;
    Result := FindNext(SearchRec);
  end;
  FindClose(SearchRec);
end;

procedure TFTPForm.ShellListView1KeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
var l:integer;
    ref:boolean;
    s:string;
begin
  ref:=true;
  if key=VK_BACK then key:=0;
  if key=VK_DELETE then begin
    memo1.Clear;
    if MessageDlg(lang(2009), mtConfirmation, [mbOK,mbCancel], 0) = mrCancel then exit;
    for l:=0 to shelllistview1.Items.Count-1 do begin
      if shelllistview1.items[l].Selected then begin
        if shelllistview1.Folders[l].IsFolder then begin
          s:=shellcombobox1.Path+'\'+shelllistview1.Folders[l].DisplayName;
          deleteFiles(s+'\','*.*',true);
          removeDir(s);
        end else begin
          DeleteFile(shellcombobox1.Path+'\'+
              shelllistview1.folders[l].DisplayName);
        end;
        shelllistview1.items[l].Selected:=false;
      end;
    end;
    if ref then begin
      shelllistview1.Refresh;
    end;
  end;
end;

procedure TFTPForm.ShellListView1DblClick(Sender: TObject);
var l:integer;
    s:string;
begin
  s:='';
  for l:=0 to shelllistview1.Items.Count-1 do begin
    if shelllistview1.items[l].Selected then s:=shelllistview1.folders[l].DisplayName;
  end;
  if s<>'' then begin
    if checkbox1.Checked then begin
      idftp1.ChangeDir(s);
      showftp;
    end;
    setpath(shellcombobox1.Path+'\'+s);
  end;
end;

procedure TFTPForm.ListViewKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if Key=VK_DELETE then begin
    delete1click(sender);
  end;
end;

end.
