//
// +----------------------------------------------------------------------+
// | Dev-PHP - Integrated Development Environment                         |
// +----------------------------------------------------------------------+
// | Copyright (C) 2002-2003, http://devphp.sourceforge.net               |
// +----------------------------------------------------------------------+
// | This program is free software; you can redistribute it and/or modify |
// | it under the terms of the GNU General Public License as published by |
// | the Free Software Foundation; either version 2 of the License, or    |
// | (at your option) any later version.                                  |
// | This program is distributed in the hope that it will be useful       |
// | but WITHOUT ANY WARRANTY; without even the implied warranty of       |
// | MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the         |
// | GNU General Public License for more details.                         |
// +----------------------------------------------------------------------+
// | Author: Leonardo Garca <simbiotik@users.sourceforge.net>            |
// | Author: Urs Mder       <ursmaeder@users.sourceforge.net>            |
// +----------------------------------------------------------------------+
//
unit frmFunction;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls, Buttons, uIniFile
//  ,  XPMenu
  ;

type
  TFunctionForm = class(TForm)
    Panel1: TPanel;
    Panel2: TPanel;
    Edit1: TEdit;
    Panel3: TPanel;
    Edit2: TEdit;
    Panel4: TPanel;
    ok: TSpeedButton;
    cancel: TSpeedButton;
    Panel5: TPanel;
    Label1: TLabel;
    Panel6: TPanel;
    Edit3: TEdit;
    procedure okClick(Sender: TObject);
    procedure cancelClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure FormKeyUp(Sender: TObject; var Key: Word;
      Shift: TShiftState);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  FunctionForm: TFunctionForm;

implementation

uses frmMain;

{$R *.dfm}

procedure TFunctionForm.okClick(Sender: TObject);
begin
  MainFrm.GetEditor.SynEdit.SelText := 'function ' + Self.Edit1.Text + ' (' + Self.Edit2.Text + ')' + #13#10 + '{' + #13#10 + '} // ' + Self.Edit3.Text + #13#10;
  Close;
end;

procedure TFunctionForm.cancelClick(Sender: TObject);
begin
  Close;
end;

procedure TFunctionForm.FormShow(Sender: TObject);
begin
  Self.Font.Name := settings.DialogFontText;
end;

procedure TFunctionForm.FormKeyUp(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if Key=VK_ESCAPE then begin
    Close; Key:=0;
  end;
end;

end.
