//
// +----------------------------------------------------------------------+
// | Dev-PHP - Integrated Development Environment                         |
// +----------------------------------------------------------------------+
// | Copyright (C) 2002-2003, http://devphp.sourceforge.net               |
// +----------------------------------------------------------------------+
// | This program is free software; you can redistribute it and/or modify |
// | it under the terms of the GNU General Public License as published by |
// | the Free Software Foundation; either version 2 of the License, or    |
// | (at your option) any later version.                                  |
// | This program is distributed in the hope that it will be useful       |
// | but WITHOUT ANY WARRANTY; without even the implied warranty of       |
// | MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the         |
// | GNU General Public License for more details.                         |
// +----------------------------------------------------------------------+
// | Author: Leonardo Garca <simbiotik@users.sourceforge.net>            |
// | Author: Urs Mder <ursmaeder@users.sourceforge.net>                  |
// +----------------------------------------------------------------------+
//

unit frmMain;

interface

uses Forms, Windows, Dialogs,  ExtCtrls, RegExpr,
  SynHighlighterXML, SynCompletionProposal, SynHighlighterMulti,
  SynExportRTF, SynEditExport, SynExportHTML, SynHighlighterSQL,SynEditTypes,
  SynHighlighterPHP, SynHighlighterJScript, SynHighlighterHtml,SynEditSearch,
  SynEdit,uEditor,uIniFile, IniFiles, D6OnHelpFix,hh, hh_funcs,SysUtils,uLang,
  SynEditHighlighter, SynHighlighterCss, SynEditPrint, Menus, ImgList,Graphics,
  Registry, uHighlighterProcs, Clipbrd,StrUtils,shellAPI,IdException,
  Controls, Classes, ActnList, OnceOnly, StdCtrls, ComCtrls, OleCtrls, DateUtils,
  SHDocVw, ShellCtrls, ToolWin, SynMemo,Messages,version, FMTBcd, Provider,
  SqlExpr, DBXpress, DBClient, DB, DBLocal, DBLocalS, DBCtrls, Grids,WebServ,
  DBGrids, cltreeview,uParser, SynEditMiscClasses, ActnMan, ActnCtrls,
  CustomizeDlg, BandActn, SynEditRegexSearch, TB2Item, TB2Dock, TB2Toolbar,
  TB2MDI, TB2ExtItems, TB2ToolWindow,Tb2kedit,Consts, IdFTP,FileCtrl,
  IdTCPConnection, IdTCPClient, IdAntiFreezeBase, IdAntiFreeze,
  IdBaseComponent, IdComponent, DHTMLEDLib_TLB, StdActns, Buttons,
  OleServer, phpdbg_TLB, IdTCPServer, IdTelnet, IdSimpleServer,
  IdEchoServer, IdTelnetServer;
  
type
  TftpInfo=record
    name:string;
    isdir:boolean;
    date:TDateTime;
    owner:string;
    group:string;
    size:integer;
    permission:string;
    unknown:string;
  end;
  TPosInfo=record
    line:integer;
    char:integer;
    isfilename:boolean;
    filename:string;
    pos:integer;
    length:integer;
  end;

  PTPosInfo = ^TPosInfo;

  EStringInvalid = class(Exception);

  TWalkProc=Procedure (tp:TftpInfo) of object;
  TWalkFolderProc=Procedure (folder:string) of object;

  TStrProc = Function(const S: string;searchstr:string):boolean;
  TMainFrm = class(TForm)
    OpenDialog: TOpenDialog;
    SaveDialog: TSaveDialog;
    PrinterSetupDialog1: TPrinterSetupDialog;
    Defecto: TImageList;
    ExportDialog: TSaveDialog;
    PrintDialog1: TPrintDialog;
    SynEditPrint1: TSynEditPrint;
    ColorDialog1: TColorDialog;
    SynCssSyn1: TSynCssSyn;
    SynHTMLSyn1: TSynHTMLSyn;
    SynJScriptSyn1: TSynJScriptSyn;
    SynPHPSyn: TSynPHPSyn;
    SynSQLSyn1: TSynSQLSyn;
    SynExporterHTML1: TSynExporterHTML;
    SynExporterRTF1: TSynExporterRTF;
    SynMultiSyn1: TSynMultiSyn;
    StatusBar1: TStatusBar;
    AutoComplete: TSynCompletionProposal;
    SynXMLSyn1: TSynXMLSyn;
    ReplaceDialog1: TReplaceDialog;
    FindDialog1: TFindDialog;
    scpParams: TSynCompletionProposal;
    IdFTP1: TIdFTP;
    WebServ1: TWebServ;
    Panel5: TPanel;
    PageControl1: TPageControl;
    TabSheet1: TTabSheet;
    TabSheet2: TTabSheet;
    TabSheet3: TTabSheet;
    TabSheet4: TTabSheet;
    TabSheet5: TTabSheet;
    PageControl: TPageControl;
    WebBrowser: TWebBrowser;
    CompilerOutput: TListView;
    Splitter1: TSplitter;
    WebBrowser1: TWebBrowser;
    WebBrowser2: TWebBrowser;
    ListView: TListView;
    PopupMenu2: TPopupMenu;
    PopupMenu3: TPopupMenu;
    Memo1: TMemo;
    Timer1: TTimer;
    Panel1: TPanel;
    Label1: TLabel;
    TabSheet6: TTabSheet;
    Panel3: TPanel;
    WebBrowser3: TWebBrowser;
    BrowserPath: TEdit;
    IdAntiFreeze1: TIdAntiFreeze;
    PopupMenu5: TPopupMenu;
    Button1: TButton;
    Panel4: TPanel;
    DataSource1: TDataSource;
    ClientDataSet1: TClientDataSet;
    DataSetProvider1: TDataSetProvider;
    SynEditSearch1: TSynEditSearch;
    SynMultiSyn2: TSynMultiSyn;
    StandardM: TActionManager;
    ANew: TAction;
    AOpen: TAction;
    ASave: TAction;
    APrint: TAction;
    AExit: TAction;
    AUndo: TAction;
    ARedo: TAction;
    ASaveAs: TAction;
    ASaveAll: TAction;
    ASearch: TAction;
    AReplace: TAction;
    ANextSearch: TAction;
    AClose: TAction;
    AOpenProject: TAction;
    ASaveProject: TAction;
    ASelectAll: TAction;
    AGotoLine: TAction;
    ASaveAndSend: TAction;
    AExecute: TAction;
    ARunGTK: TAction;
    ACheck: TAction;
    ASaveAndSendFtp: TAction;
    ASend: TAction;
    ANextWindow: TAction;
    APreviousWindow: TAction;
    ASearchDocs: TAction;
    FtpItems: TImageList;
    AInsText: TAction;
    AInsButton: TAction;
    AInsCheck: TAction;
    AInsRadio: TAction;
    AInsList: TAction;
    AInsFile: TAction;
    AInsImage: TAction;
    AInsHidden: TAction;
    AInsImagen: TAction;
    AInsTable: TAction;
    AInsLayer: TAction;
    AInsForm: TAction;
    AInsInc: TAction;
    AInsMail: TAction;
    AInsHR: TAction;
    AInsBR: TAction;
    AInsDate: TAction;
    Trenner: TAction;
    SynEditRegexSearch1: TSynEditRegexSearch;
    FindDialog2: TFindDialog;
    ASearchRegEx: TAction;
    ASearchRegDir: TAction;
    FindDialog3: TFindDialog;
    Splitter3: TSplitter;
    Panel7: TPanel;
    Panel9: TPanel;
    Button3: TButton;
    SynEdit1: TSynEdit;
    TreeView1: TTreeView;
    AEditTool: TAction;
    ACloseAll: TAction;
    TBDock1: TTBDock;
    TBToolbar1: TTBToolbar;
    FileMenu: TTBSubmenuItem;
    Nuevo1: TTBSubmenuItem;
    NuevoTexto: TTBItem;
    N17: TTBSeparatorItem;
    NuevoHTML: TTBItem;
    NuevoPHP: TTBItem;
    N1: TTBSeparatorItem;
    Abrir1: TTBItem;
    OpenProject1: TTBItem;
    Reabrir: TTBSubmenuItem;
    N16: TTBSeparatorItem;
    ReloadCurrentFile1: TTBItem;
    N15: TTBSeparatorItem;
    GuardarComo2: TTBItem;
    FileFormat1: TTBSubmenuItem;
    Savewithcrlf1: TTBItem;
    SaveUnix1: TTBItem;
    Savewithcr1: TTBItem;
    SaveProject1: TTBItem;
    GuardarComo1: TTBItem;
    GuardarTodo1: TTBItem;
    N10: TTBSeparatorItem;
    Cerrar1: TTBItem;
    N4: TTBSeparatorItem;
    Exportar: TTBSubmenuItem;
    HTML2: TTBItem;
    RTF1: TTBItem;
    Imprimir2: TTBItem;
    ConfigurarImpresin1: TTBItem;
    N5: TTBSeparatorItem;
    Salir1: TTBItem;
    EditMenu: TTBSubmenuItem;
    Deshacer1: TTBItem;
    Rehacer1: TTBItem;
    N2: TTBSeparatorItem;
    N3: TTBSeparatorItem;
    Indent1: TTBItem;
    DeIndent1: TTBItem;
    N23: TTBSeparatorItem;
    DeleteLine1: TTBItem;
    DeletetoEndLine1: TTBItem;
    DeleteWord1: TTBItem;
    DeletePreviousWord1: TTBItem;
    SeleccionarTodo1: TTBItem;
    UCaseLCase1: TTBSubmenuItem;
    UpperCase1: TTBItem;
    LowerCase1: TTBItem;
    C3: TTBItem;
    OptimizarComprimircdigo1: TTBItem;
    SearchMenu: TTBSubmenuItem;
    Buscar2: TTBItem;
    Reemplazar1: TTBItem;
    NextSearch1: TTBItem;
    Re1: TTBItem;
    SearchRegExDir: TTBItem;
    N11: TTBSeparatorItem;
    Iralnea1: TTBItem;
    ViewMenu: TTBSubmenuItem;
    N19: TTBSeparatorItem;
    LineNumbers: TTBItem;
    S1: TTBItem;
    Anpassen1: TTBItem;
    RunMenu: TTBSubmenuItem;
    EjecutarPHP1: TTBItem;
    N13: TTBSeparatorItem;
    Gtk2: TTBItem;
    N14: TTBSeparatorItem;
    Comprobarsintaxis1: TTBItem;
    OptionsMenu: TTBSubmenuItem;
    Formato1: TTBSubmenuItem;
    CSS1: TTBItem;
    HTML3: TTBItem;
    HTML1: TTBItem;
    JavaScript1: TTBItem;
    MySQL1: TTBItem;
    PHP1: TTBItem;
    HtmlPHP1: TTBItem;
    XML1: TTBItem;
    Texto1: TTBItem;
    N9: TTBSeparatorItem;
    OpcionesGenerales1: TTBItem;
    CheckforUpdate1: TTBItem;
    test1: TTBItem;
    ToolsMenu: TTBSubmenuItem;
    extSnippets1: TTBItem;
    EMailWizard1: TTBItem;
    InsertFunction: TTBItem;
    InsertTable1: TTBItem;
    N20: TTBSeparatorItem;
    PRINTselected1: TTBItem;
    ECHOselectedtext1: TTBItem;
    Commentselectedtext1: TTBItem;
    N21: TTBSeparatorItem;
    Replacewith1: TTBItem;
    N22: TTBSeparatorItem;
    InsertColor1: TTBItem;
    DateTime1: TTBSubmenuItem;
    InsertDate1: TTBItem;
    InsertTime1: TTBItem;
    InsertDateTime1: TTBItem;
    DocumentSpecials1: TTBSubmenuItem;
    InsertDocPath1: TTBItem;
    InsertDocFilename1: TTBItem;
    Insert1: TTBItem;
    WindowMenu: TTBSubmenuItem;
    CerrarTodo: TTBItem;
    N7: TTBSeparatorItem;
    Siguiente2: TTBItem;
    Anterior1: TTBItem;
    N12: TTBSeparatorItem;
    HelpMenu: TTBSubmenuItem;
    SearchDocumentation: TTBItem;
    Website: TTBItem;
    N6: TTBSeparatorItem;
    News: TTBItem;
    ReadGPL: TTBItem;
    N8: TTBSeparatorItem;
    Acercade1: TTBItem;
    test2: TTBItem;
    TBToolbar2: TTBToolbar;
    TBVisibilityToggleItem1: TTBVisibilityToggleItem;
    TBSubmenuItem1: TTBSubmenuItem;
    TBItem4: TTBItem;
    TBItem1: TTBItem;
    TBItem5: TTBItem;
    TBItem2: TTBItem;
    TBItem3: TTBItem;
    TBItem6: TTBItem;
    TBItem7: TTBItem;
    TBItem8: TTBItem;
    TBItem9: TTBItem;
    TBItem10: TTBItem;
    TBToolbar3: TTBToolbar;
    TBItem11: TTBItem;
    TBItem12: TTBItem;
    TBItem13: TTBItem;
    TBItem14: TTBItem;
    TBItem15: TTBItem;
    TBItem16: TTBItem;
    TBItem17: TTBItem;
    TBItem18: TTBItem;
    TBToolbar4: TTBToolbar;
    TBItem19: TTBItem;
    TBItem20: TTBItem;
    TBItem21: TTBItem;
    TBItem22: TTBItem;
    TBItem23: TTBItem;
    TBItem24: TTBItem;
    TBItem25: TTBItem;
    TBItem26: TTBItem;
    TBItem27: TTBItem;
    TBItem28: TTBItem;
    TBItem29: TTBItem;
    TBItem30: TTBItem;
    TBItem31: TTBItem;
    TBItem32: TTBItem;
    TBItem33: TTBItem;
    TBItem34: TTBItem;
    TBItem35: TTBItem;
    TBDock2: TTBDock;
    TBToolWindow1: TTBToolWindow;
    Panel2: TPanel;
    PageControl2: TPageControl;
    TabSheet7: TTabSheet;
    ShellListView1: TShellListView;
    ShellTreeView1: TShellTreeView;
    TabSheet8: TTabSheet;
    DBGrid1: TDBGrid;
    TabSheet10: TTabSheet;
    Panel6: TPanel;
    Button2: TButton;
    TreeView11: TTreeView1;
    Panel8: TPanel;
    FunctionBrowser: TComboBox;
    TBItem36: TTBItem;
    TBItem37: TTBItem;
    TBSeparatorItem1: TTBSeparatorItem;
    TBSeparatorItem2: TTBSeparatorItem;
    TBSeparatorItem3: TTBSeparatorItem;
    TBSeparatorItem4: TTBSeparatorItem;
    TBSeparatorItem6: TTBSeparatorItem;
    Splitter2: TSplitter;
    TBSubmenuItem2: TTBSubmenuItem;
    TBItem38: TTBItem;
    AEditEdit: TAction;
    AEditIns: TAction;
    TBItem39: TTBItem;
    BarradeHerramientas1: TTBVisibilityToggleItem;
    MHTMLBar: TTBVisibilityToggleItem;
    BarradeEstado1: TTBVisibilityToggleItem;
    SideBar1: TTBVisibilityToggleItem;
    NewHTMLFile: TAction;
    AInsShellFilename: TAction;
    TBItem40: TTBItem;
    AInsShellPath: TAction;
    TBItem41: TTBItem;
    Send: TTBItem;
    SearchRegExOFiles: TTBItem;
    ASearchOFiles: TAction;
    SendFile: TTBItem;
    TBVisibilityToggleItem2: TTBVisibilityToggleItem;
    EditCut1: TEditCut;
    EditCopy1: TEditCopy;
    EditPaste1: TEditPaste;
    TBItem42: TTBItem;
    TBItem43: TTBItem;
    TBItem44: TTBItem;
    ClearHistory: TTBItem;
    SpeedButton1: TSpeedButton;
    TBDock3: TTBDock;
    Splitter4: TSplitter;
    procedure Acercade1Click(Sender: TObject);
    procedure HTML1Click(Sender: TObject);
    procedure PHP1Click(Sender: TObject);
    procedure Texto1Click(Sender: TObject);
    procedure SeleccionarTodo1Click(Sender: TObject);
    procedure BarradeEstado1Click(Sender: TObject);
    procedure NuevoExecute(Sender: TObject);
    procedure AOpenExecute(Sender: TObject);
    procedure GuardarExecute(Sender: TObject);
    procedure SalirExecute(Sender: TObject);
    procedure DeshacerExecute(Sender: TObject);
    procedure RehacerExecute(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure CSS1Click(Sender: TObject);
    procedure JavaScript1Click(Sender: TObject);
    procedure LineNumbersClick(Sender: TObject);
    procedure EjecutarExecute(Sender: TObject);
    procedure ConfigurarImpresin1Click(Sender: TObject);
    procedure HTML3Click(Sender: TObject);
    procedure MySQL1Click(Sender: TObject);
    procedure ImprimirExecute(Sender: TObject);
    procedure GuardarComoExecute(Sender: TObject);
    procedure HTML2Click(Sender: TObject);
    procedure RTF1Click(Sender: TObject);
    procedure BarradeHerramientas1Click(Sender: TObject);
    procedure BuscarExecute(Sender: TObject);
    procedure SiguienteExecute(Sender: TObject);
    procedure ReemplazarExecute(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure EditMenuClick(Sender: TObject);
    procedure OpcionesGenerales1Click(Sender: TObject);
    procedure ReadGPLClick(Sender: TObject);
    procedure ClearHistoryClick(Sender: TObject);
    procedure AbrirHistorial;
    procedure GuardarHistorial(const Filename:string);
    procedure AgregarHistorial(Filename : string);
    procedure OpenHistoryFile(Sender: TObject);
    procedure NuevoHTMLClick(Sender: TObject);
    procedure Siguiente2Click(Sender: TObject);
    procedure CerrarTodoClick(Sender: TObject);
    procedure NuevoPHPClick(Sender: TObject);
    procedure GuardarTodoExecute(Sender: TObject);
    procedure CerrarExecute(Sender: TObject);
    procedure NewsClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure ActivarBotones(Activar: boolean);
    procedure CheckExecute(Sender: TObject);
    procedure Iralnea1Click(Sender: TObject);
    procedure OptimizarComprimircdigo1Click(Sender: TObject);
    procedure insTablaExecute(Sender: TObject);
    procedure Gtk2Click(Sender: TObject);
    procedure ReadLangFile;
    procedure Anterior1Click(Sender: TObject);
    procedure GuardarSesion;
    procedure OnceOnlyParameter(Sender: TObject; const Value: String);
    procedure MHTMLBarClick(Sender: TObject);
    procedure PRINTselected1Click(Sender: TObject);
    procedure Replacewith1Click(Sender: TObject);
    procedure ECHOselectedtext1Click(Sender: TObject);
    procedure EMailWizard1Click(Sender: TObject);
    procedure InsertFunctionClick(Sender: TObject);
    procedure ReloadCurrentFile1Click(Sender: TObject);
    procedure EnableSaveAll;
    procedure CallPrint(doPrint : boolean);
    procedure InsertColor1Click(Sender: TObject);
    procedure CheckforUpdate1Click(Sender: TObject);
    procedure LoadAutoComplete;
    procedure GetFunctions;
    procedure FunctionBrowserChange(Sender: TObject);
    procedure SearchDocumentationClick(Sender: TObject);
    procedure FunctionBrowserDropDown(Sender: TObject);
    procedure XML1Click(Sender: TObject);
    procedure Commentselectedtext1Click(Sender: TObject);
    procedure scpParamsExecute(Kind: SynCompletionType; Sender: TObject;
      var AString: String; var x, y: Integer; var CanExecute: Boolean);
    procedure FormDestroy(Sender: TObject);
    procedure FindDialog1Find(Sender: TObject);
    procedure ReplaceDialog1Find(Sender: TObject);
    procedure ReplaceDialog1Replace(Sender: TObject);
    function CloseAll : boolean;
    procedure WebsiteClick(Sender: TObject);
    procedure FormPaint(Sender: TObject);
    function GetSearchString : string;
    function GetFindOptions(dial:TFindDialog): TSynSearchOptions;
    function GetSearchAndReplaceOptions: TSynSearchOptions;
    function GetEditor(const index: integer = -1): TEditor;
    procedure SynEditDropFiles(Sender: TObject; X, Y: Integer;
      AFiles: TStrings);
    procedure PageControlChange(Sender: TObject);
    function AskBeforeClose(e: TEditor): integer;
    function CloseEditor(id: integer): integer;
    procedure Insert(Text: string);
    procedure LoadEditorSettings;
    function RunAndGetOutput(Cmd, WorkDir: string): string;
    procedure AnalizeOutput(List: TStringList);
    procedure ProcessLine(s, l: string);
    procedure CompilerOutputDblClick(Sender: TObject);
    procedure FastFTPExecute(Sender: TObject);
    procedure ToolButton49Click(Sender: TObject);
    procedure insImagenExecute(Sender: TObject);
    procedure insCapaExecute(Sender: TObject);
    procedure insFormExecute(Sender: TObject);
    procedure insTextExecute(Sender: TObject);
    procedure insButtonExecute(Sender: TObject);
    procedure insCheckExecute(Sender: TObject);
    procedure insRadioExecute(Sender: TObject);
    procedure insListExecute(Sender: TObject);
    procedure InsImageExecute(Sender: TObject);
    procedure insImgExecute(Sender: TObject);
    procedure insHiddenExecute(Sender: TObject);
    procedure insIncExecute(Sender: TObject);
    procedure insMailExecute(Sender: TObject);
    procedure insHRExecute(Sender: TObject);
    procedure insBRExecute(Sender: TObject);
    procedure insDateExecute(Sender: TObject);
    procedure Indent1Click(Sender: TObject);
    procedure DeIndent1Click(Sender: TObject);
    procedure ShellListView1DblClick(Sender: TObject);
    procedure ShellListView1KeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure FormKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure PageControl1Change(Sender: TObject);
    procedure MenuItem2Click(Sender: TObject);
    procedure Send1Click(Sender: TObject);
    procedure delete1Click(Sender: TObject);
    procedure MenuItem1Click(Sender: TObject);
    procedure MenuItem3Click(Sender: TObject);
    procedure ListViewDblClick(Sender: TObject);
    procedure ShellTreeView1Changing(Sender: TObject; Node: TTreeNode;
      var AllowChange: Boolean);
    procedure delete2Click(Sender: TObject);
    procedure ShellTreeView1Change(Sender: TObject; Node: TTreeNode);
    procedure Explorer1Click(Sender: TObject);
    procedure Refresch1Click(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure Send2Click(Sender: TObject);
    procedure WebBrowser1NavigateComplete2(Sender: TObject;
      const pDisp: IDispatch; var URL: OleVariant);
    procedure ToolButton50Click(Sender: TObject);
    procedure ToolButton51Click(Sender: TObject);
    procedure Close1Click(Sender: TObject);
    procedure BrowserPathKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure Button1Click(Sender: TObject);
    procedure IdFTP1Connected(Sender: TObject);
    procedure IdFTP1Disconnected(Sender: TObject);
    procedure WebBrowser2DocumentComplete(Sender: TObject;
      const pDisp: IDispatch; var URL: OleVariant);
    procedure FormDragDrop(Sender, Source: TObject; X, Y: Integer);
    procedure S1Click(Sender: TObject);
    procedure edit1Click(Sender: TObject);
    procedure DBGrid1DblClick(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure TreeView11Change(Sender: TObject; Node: TTreeNode);
    procedure UpperCase1Click(Sender: TObject);
    procedure LowerCase1Click(Sender: TObject);
    procedure C3Click(Sender: TObject);
    procedure InsertDocPath1Click(Sender: TObject);
    procedure InsertDocFilename1Click(Sender: TObject);
    procedure Insert1Click(Sender: TObject);
    procedure InsertDate1Click(Sender: TObject);
    procedure InsertTime1Click(Sender: TObject);
    procedure InsertDateTime1Click(Sender: TObject);
    procedure InsertFilename1Click(Sender: TObject);
    procedure DeleteLine1Click(Sender: TObject);
    procedure DeleteWord1Click(Sender: TObject);
    procedure DeletetoEndLine1Click(Sender: TObject);
    procedure DeletePreviousWord1Click(Sender: TObject);
    procedure InsertFilePath1Click(Sender: TObject);
    procedure SaveUnix1Click(Sender: TObject);
    procedure Savewithcrlf1Click(Sender: TObject);
    procedure Savewithcr1Click(Sender: TObject);
    procedure SideBar1Click(Sender: TObject);
    procedure Re1Click(Sender: TObject);
    procedure HtmlPHP1Click(Sender: TObject);
    procedure ListViewChange(Sender: TObject; Item: TListItem;
      Change: TItemChange);
    procedure ControlBar1DockOver(Sender: TObject; Source: TDragDockObject;
      X, Y: Integer; State: TDragState; var Accept: Boolean);
    procedure Panel8Resize(Sender: TObject);
    procedure FindDialog2Find(Sender: TObject);
    procedure TreeView1Deletion(Sender: TObject; Node: TTreeNode);
    procedure TreeView1Click(Sender: TObject);
    procedure TreeView1CustomDrawItem(Sender: TCustomTreeView;
      Node: TTreeNode; State: TCustomDrawState; var DefaultDraw: Boolean);
    procedure Button3Click(Sender: TObject);
    procedure ASearchRegDirExecute(Sender: TObject);
    procedure FindDialog3Find(Sender: TObject);
    procedure AEditToolExecute(Sender: TObject);
    procedure AutoCompleteExecute(Kind: SynCompletionType; Sender: TObject;
      var CurrentInput: String; var x, y: Integer;
      var CanExecute: Boolean);
    procedure Splitter2CanResize(Sender: TObject; var NewSize: Integer;
      var Accept: Boolean);
    procedure TBToolWindow1DockChanging(Sender: TObject; Floating: Boolean;
      DockingTo: TTBDock);
    procedure AEditEditExecute(Sender: TObject);
    procedure AEditInsExecute(Sender: TObject);
    procedure TBVisibilityToggleItem1Click(Sender: TObject);
    procedure ASearchOFilesExecute(Sender: TObject);
    procedure TBVisibilityToggleItem2Click(Sender: TObject);
    procedure DHTMLEdit1ShowContextMenu(Sender: TObject; xPos,
      yPos: Integer);
    procedure FindDialog1Show(Sender: TObject);
    procedure FindDialog1Close(Sender: TObject);
    procedure test2Click(Sender: TObject);
    procedure SpeedButton1Click(Sender: TObject);
   private
    ftpList:TStringList;
    LangFileName : string;
    LookupList : TStringList;
    ParamList : TStringList;
    FunctionNames : TStringList;
    FunctionNumbers : TStringList;
    SearchString : string;
    currPath:string;
    currFtpPath:string;
    FolderIcon:integer;
    findactive:boolean;
    procedure Insertar(Texto: string);
    procedure showFTP;
    procedure splitFTPMessage(st: string; var t: TFTPInfo);
    procedure delDir(folder: string);
    procedure walkTree(OnWalk: TWalkProc; OnDirChange,
      OnDirUp: TWalkFolderProc);
    procedure delWalk(tp: tftpinfo);
    procedure delDirUp(folder: string);
    procedure FileLook(Filespec: string);
    procedure getDir(folder: string);
    procedure getWalk(tp: tftpinfo);
    procedure getDirUp(folder: string);
    procedure FTPConnect;
    procedure FTPDisConnect;
    function ChangeFTPPath: boolean;
    procedure syncEditorWithPath;
    procedure LoadProject(filename: String);
    procedure WMDropFiles(var Msg: TMessage); message WM_DROPFILES;
    function GotoClass(item: TTreeNode; Sender: TObject):string;
    procedure visibleBar(barCaption: string; value: boolean);
    procedure searchReg(filename: string;searchstr:string);
    procedure OnMessage(var Msg: TMsg; var Handled: Boolean);
    procedure OpenFile(Sender: TObject; filename: string);
    procedure searchRe(e:TEditor;searchstr:string);
    procedure DoTreeRefresh(Sender: TObject; onlyTree: boolean);
  public
    fHighlighters : TStringList;
    toOpen:TStringList;
    openingallowed:boolean;
    Parser : string;
    LangFile : TIniFile;
    NewCount : integer;
    InternalPreview : boolean;
    BrowserActiveFlag:boolean;
    oldx,oldy:integer;
    firstSearch:boolean;
  end;

const
  pEdit = 0;
  pIPreview = 1;
  pEPreview = 2;
  pFtp = 3;
  pDoc = 4;
  pBrowser = 5;
  pHtmlEdit = 6;

var
  MainFrm: TMainFrm;
  mHHelp: THookHelpSystem;

implementation

uses
  frmOptions, frmAbout, frmCheck,
  frmGoTo, frmOptimize, frmGTK, frmMail, frmFunction, frmUpdate, frmTable,
  frmAutoText, FrmSearch, frmhtmledit;


{$R *.dfm}

var doc_complete:boolean;

Procedure searchdir2(path:string;searchstr:string;proc:TStrProc);
var sr:tsearchrec;
   n:word;
begin
 if path[length(path)]<>'\' then path:=path+'\';
 n:=findfirst(path+'*.*',faAnyFile,sr);
 while n=0 do begin
   if sr.name[1]<>'.' then begin
     if sr.attr and fadirectory = fadirectory then begin
       searchdir2(path+sr.name+'\',searchstr,proc);
     end else begin
       proc(path+sr.name,searchstr);
     end;
   end;
   n:=findnext(sr);
 end;
 if path[length(path)]='\' then delete(path,length(path),1);
end;


Procedure searchdir(path:string;searchstr:string;proc:TStrProc);
var sr:tsearchrec;
   n:word;
begin
 if path[length(path)]<>'\' then path:=path+'\';
 n:=findfirst(path+'*.*',faAnyFile,sr);
 while n=0 do begin
   if sr.name[1]<>'.' then begin
     if sr.attr and fadirectory = fadirectory then begin
       searchdir(path+sr.name+'\',searchstr,proc);
     end else begin
       proc(path+sr.name,searchstr);
     end;
   end;
   n:=findnext(sr);
 end;
 if path[length(path)]='\' then delete(path,length(path),1);
 if not SysUtils.RemoveDir(path) then showmessage('error: '+path+' not deleted');
end;


procedure TMainFrm.FTPConnect;
begin
  if idftp1.Connected then exit;
  idftp1.Passive:=false;
  idftp1.Host:=settings.FTPHostText;
  idftp1.Port:=strtoint(settings.FTPPortText);
  idftp1.Username:=settings.FTPUserText;
//  idftp1.Password:=settings.FTPPasswordText;
  idftp1.Password:=settings.FTPPasswordSave;
  idftp1.connect(true);
end;

procedure TMainFrm.FTPDisConnect;
begin
  if not idftp1.connected then exit;
  try
    idftp1.abort;
    idftp1.Quit;
    idftp1.disconnect;
  except
  end;
  listview.Items.Clear;
end;

function TMainFrm.GetFindOptions(dial:TFindDialog): TSynSearchOptions;
begin
  Result := [];
  if frWholeWord in dial.Options then Result := Result + [ssoWholeWord];
  if frMatchCase in dial.Options then Result := Result + [ssoMatchCase];
  if not (frDown in dial.Options) then Result := Result + [ssoBackwards];
end;

function TMainFrm.GetSearchAndReplaceOptions: TSynSearchOptions;
begin
  Result := [];
  if frWholeWord in ReplaceDialog1.Options then Result := Result + [ssoWholeWord];
  if frMatchCase in ReplaceDialog1.Options then Result := Result + [ssoMatchCase];
  if not (frDown in ReplaceDialog1.Options) then Result := Result + [ssoBackwards];
  if frReplace in ReplaceDialog1.Options then Result := Result + [ssoReplace];
  if frReplaceAll in ReplaceDialog1.Options then Result := Result + [ssoReplaceAll];
end;

procedure TMainFrm.GetFunctions;
var
  j, i, c, c1, c2, p, q, v, q2, s1, s2 : integer;
  s, t : string;
  isComment, isScript, isString : boolean;
  e : TEditor;
begin
  IsScript:=false;
  FunctionNumbers.Clear;
  e := GetEditor;
  for i := 0 to e.SynEdit.Lines.Count-1 do begin
    s := Trim(e.SynEdit.Lines[i]);
    isString := FALSE;
    isComment := FALSE;
    for j := 0 to Length(s) - 1 do begin
      if (isString = True) then begin
        if ((s[j] = '\' ) and (s[j + 1] = '"')) or (s[j] <> '"') then begin
          s[j] := ' ';
        end;
      end;
      if (s[j] = '"') then begin
        isString := not isString;
      end;
    end;
    c := Pos('//',s);
    if (c > 0) then begin
      Delete(s, c, Length(s) - c);
    end;
    c1 := Pos('/*',s);
    if (c1 > 0) then begin
      c2 := Pos('*/',s);
      Delete(s, c1, Length(s) - c1 - c2);
      if (c2 > c1) then begin
        isComment := FALSE;
      end else begin
        isComment := TRUE;
      end;
    end;
    c2 := Pos('*/', s);
    if (c1 > 0) then begin
      Delete(s, c1, c2 + 2);
      isComment := FALSE;
    end;
    if (isString = False) and (isComment = False) then begin
      s1 := Pos('<?', s);
      if (s1 > 0) then begin
        s2 := Pos('?>', s);
        if (s2 > s1) then begin
          isScript := FALSE;
        end else begin
          isScript := TRUE;
        end;
      end;
      s2 := Pos('?>', s);
      if (s2 > 0) then begin
        isScript := FALSE;
      end;
      if (isScript = True) then begin
        t := LowerCase(s);
        if (isComment = True) then begin
          p := 0;
          q := 0;
          q2 := 0;
          v := 0;
        end else begin
          p := Pos('function ', t);
          q := Pos('(', s);
          if (q > p) then begin
            q2 := q + 2; (* JFH *)
            v  := q + 1; (* JFH *)
          end else begin
            q2 := 0;
            v := 0;
          end;
        end;
        if (p <> 0) and (q <> 0) and (q > p) and (q < q2) and (((v > q) and (v < q2)) or (v = 0)) then begin
          Delete(s, 1, p);
          Delete(s, 1, StrLen('function'));
          q := Pos('(', s);
          Delete(s, q, Length(s) - q + 1);
          s := Trim(s);
          p := Pos(' ', s);
          if p = 0 then begin
            if s <> '' then begin
              FunctionNames.Add(s + '()>>>' + IntToStr(i + 1));
            end;
          end;
        end;
      end;
    end;
  end;
  FunctionBrowser.Items.Clear;
  FunctionNames.Sort;
  if FunctionNames.Count > 0 then begin
    for i := 0 to FunctionNames.Count - 1 do begin
      s := FunctionNames.Strings[i];
      Delete(s, 1, Pos('>>>', s) + 2);
      FunctionNumbers.Add(s);
      s := FunctionNames.Strings[i];
      Delete(s, Pos('>>>', s), Length(s) - Pos('>>>', s) + 1);
      FunctionBrowser.Items.Add(s);
    end;
  end;
  FunctionNames.Clear;
end;

procedure TMainFrm.Acercade1Click(Sender: TObject);
begin
  AboutForm := TAboutForm.Create(Self);
  with AboutForm do
  try
     ShowModal;
  finally
    Free;
  end;
end;

procedure TMainFrm.HTML1Click(Sender: TObject);
begin
  GetEditor.SynEdit.Highlighter := SynMultiSyn1;
  StatusBar1.Panels[3].Text := (Sender as TTBItem).Caption;
end;

procedure TMainFrm.PHP1Click(Sender: TObject);
begin
  GetEditor.Synedit.Highlighter := SynPHPSyn;
  StatusBar1.Panels[3].Text := (Sender as TTBItem).Caption;
end;

procedure TMainFrm.EnableSaveAll;
var
  i : integer;
  e : TEditor;
begin
  ASaveAll.Enabled := FALSE;
  if PageControl.PageCount > 0 then begin
    for i := 0 to (PageControl.PageCount - 1) do begin
      e := GetEditor(i);
      if e.modified = False then begin
        ASaveAll.Enabled := TRUE;
        Exit;
      end;
    end;
  end;
end;

procedure TMainFrm.Texto1Click(Sender: TObject);
begin
  if GetEditor.SynEdit.Highlighter <> nil then
    GetEditor.SynEdit.Highlighter := nil;
  StatusBar1.Panels[3].Text := (Sender as TTBItem).Caption;
end;

procedure TMainFrm.SeleccionarTodo1Click(Sender: TObject);
begin
  if PageControl.PageCount > 0 then begin
    GetEditor.SynEdit.SelectAll;
  end;
end;

procedure TMainFrm.BarradeEstado1Click(Sender: TObject);
begin
  gsettings.StatusBar1visible:=StatusBar1.Visible;
end;

procedure TMainFrm.NuevoExecute(Sender: TObject);
var
  e : TEditor;
begin
  Inc(NewCount);
  e := TEditor.Create;
  e.Init('Untitled' + IntToStr(NewCount) + '.php', FALSE);
  ActivarBotones(TRUE);
end;

procedure TMainFrm.SynEditDropFiles(Sender: TObject; X, Y: Integer;
  AFiles: TStrings);
var
  i, j : integer;
  Exists : boolean;
  e : TEditor;
begin
  for i := 0 to AFiles.Count-1 do begin
    Exists := FALSE;
    for j := 0 to PageControl.PageCount - 1 do begin
      if AFiles[i] = GetEditor(j).fFileName then begin
        Exists := TRUE;
        Break;
      end;
    end;
    if Exists = False then begin
      e := TEditor.Create;
      e.Init(AFiles[i], TRUE);
      AgregarHistorial(AFiles[i]);
      GuardarHistorial(AFiles[i]);
    end else begin
      Application.ProcessMessages;
      MessageDlg('File "' + AFiles[i] + '" is already open. Use "Reload Current File" to reload it.', mtError, [mbOk], 0);
    end;
  end;
end;

procedure TMainFrm.OpenFile(Sender:TObject;filename:string);
var x:integer;
  Exists : boolean;
  e : TEditor;
begin
  if FileExists(filename) then begin
    Exists := FALSE;
    for x := 0 to PageControl.PageCount - 1 do begin
      if filename = GetEditor(x).fFileName then begin
        Exists := TRUE;
        pagecontrol.ActivePageIndex:=x;
        if GetEditor(x).modified then
          MessageDlg('File "' + filename + '" is already open. Use "Reload Current File" to reload it.', mtError, [mbOk], 0);
        Break;
      end;
    end;
    if Exists = False then begin
      e := TEditor.Create;
      e.Init(filename, TRUE);
      AgregarHistorial(filename);
      GuardarHistorial(filename);
    end else begin
    end;
  end else begin
    MessageDlg(Lang(952) + ' "' + filename + '" ' + Lang(955), mtError, [mbOk], 0);
  end;
  ActivarBotones(TRUE);
end;

procedure TMainFrm.AOpenExecute(Sender: TObject);
var
  i  : integer;
begin
  if OpenDialog.Execute then begin
//    Loaded := 0;
    for i := 0 to OpenDialog.Files.Count - 1 do begin
      OpenFile(Sender,OpenDialog.Files[i]);
    end;
  end;
end;

procedure TMainFrm.AgregarHistorial(Filename : string);
var
   NewMenuItem : TTBCustomItem;
   i : integer;
begin
  for i := 2 to ReAbrir.Count-1 do begin
    if lowercase(ReAbrir.Items[i].Caption) = lowercase(Filename) then exit;
  end;
  if Length(Filename) > 0 then begin
    NewMenuItem := TTBCustomItem.Create(Self);
    NewMenuItem.Caption := Filename;
    NewMenuItem.OnClick := OpenHistoryFile;
    ReAbrir.Insert(2, NewMenuItem);
  end;
end;

procedure TMainFrm.OpenHistoryFile(Sender: TObject);
var
  FileName : string;
  x : integer;
  Exists : boolean;
  e : TEditor;
begin
  FileName := (Sender as TTBCustomItem).Caption;
  if FileExists(FileName) then begin
    Exists := FALSE;
    for x := 0 to PageControl.PageCount - 1 do begin
      if FileName = GetEditor(x).fFileName then begin
        Exists := TRUE;
        Break;
      end;
    end;
    if Exists = False then begin
      e := TEditor.Create;
      e.Init(FileName, TRUE);
    end else begin
      Application.ProcessMessages;
      MessageDlg('File "' + FileName + '" is already open. Use "Reload Current File" to reload it.', mtError, [mbOk], 0);
    end;
  end else begin
    MessageDlg(Lang(952) + ' "' + FileName + '" ' + Lang(955),mtError,[mbOk],0)
  end;
  ActivarBotones(TRUE);
end;

procedure TMainFrm.GuardarHistorial(const Filename:string);
var
   i : integer;
   List : TStringList;
begin
  List:=TStringList.Create;
  List.Text:=settings.History.Text;
  for I:=0 to List.Count - 1 do
    if List.Values[IntToStr(I)]= Filename then begin
      List.Free;
      Exit;
    end;
  settings.History.Add(Filename);
  settings.writeHistory;
end;

procedure TMainFrm.AbrirHistorial;
var
   i       : integer;
   fName : string;
begin
  i := ReAbrir.Count-1;

  if ReAbrir.Count <> 2 then
    repeat
      ReAbrir.Remove(ReAbrir.Items[i]);
      dec(i);
    until ReAbrir.Count = 2;

  for i := 0 to settings.History.Count-1 do begin
    fName := settings.History[I];
    if (fName <> '') and (FileExists(fName)) then begin
      AgregarHistorial(fName);
    end;
  end;
end;

procedure TMainFrm.GuardarExecute(Sender: TObject);
var
  e : TEditor;
begin
  e := GetEditor;
  if Assigned(e) then begin
    e.SaveFile(false);
    shelllistview1.Refresh;
    statusbar1.Panels[1].Text:='';
  end;
end;

procedure TMainFrm.SalirExecute(Sender: TObject);
begin
  GuardarSesion;
  uIniFile.Settings.writeHistory();
  close;
end;

procedure TMainFrm.DeshacerExecute(Sender: TObject);
var
  e : TEditor;
begin
  e := GetEditor;
  if Assigned(e) then begin
    e.SynEdit.Undo;
    e.SynEdit.SetFocus;
  end;
end;

procedure TMainFrm.RehacerExecute(Sender: TObject);
var
  e : TEditor;
begin
  e := GetEditor;
  if Assigned(e) then begin
    e.SynEdit.Redo;
    e.SynEdit.SetFocus;
  end;
end;

procedure TMainFrm.LoadAutoComplete;
var
  acItems, acInsert : TStringList;
  i : integer;
  DataFile1, DataFile2, s : string;
begin
  DataFile1 := ExtractFilePath(Application.Exename)+ 'data\functions_lite.dat';
  DataFile2 := ExtractFilePath(Application.Exename)+ 'data\functions_full.dat';
  if (FileExists(DataFile1)) and (FileExists(DataFile2)) then begin
    AutoComplete.InsertList.LoadFromFile(DataFile1);
    AutoComplete.ItemList.LoadFromFile(DataFile2);
  end;
  for i := 0 to AutoComplete.InsertList.Count-1 do begin
//    AutoComplete.ItemList[i] := StringReplace(AutoComplete.ItemList[i], #9, #9' ', []);
//    AutoComplete.ItemList[i] := 'function'#9 + AutoComplete.ItemList[i];
    AutoComplete.ItemList[i] := StringReplace(AutoComplete.ItemList[i], #9, ' ', []);
//    AutoComplete.InsertList[i] := AutoComplete.ItemList[i];
    AutoComplete.ItemList[i] := 'function   ' + AutoComplete.ItemList[i];
    AutoComplete.InsertList[i] := AutoComplete.InsertList[i] + '()';
  end;
  DataFile1 := ExtractFilePath(Application.Exename)+ 'data/variables.dat';
  if FileExists(DataFile1) then begin
    acItems := TStringList.Create;
    acInsert := TStringList.Create;
    acInsert.LoadFromFile(DataFile1);
    for i := 0 to acInsert.Count -1 do begin
//      acItems.Add('variable'#9 + acInsert.Strings[i]);
      acItems.Add('variable   ' + acInsert.Strings[i]);
    end;
    AutoComplete.ItemList.AddStrings(acItems);
    AutoComplete.InsertList.AddStrings(acInsert);
    acItems.Free;
    acInsert.Free;
  end;

  LookupList := TStringList.Create;
  DataFile1 := ExtractFilePath(Application.Exename)+ 'data/functions_lite.dat';
  if FileExists(DataFile1) then begin
    LookupList.LoadFromFile(DataFile1);
  end;
  ParamList := TStringList.Create;
  DataFile1 := ExtractFilePath(Application.Exename)+ 'data/functions_full.dat';
  if FileExists(DataFile1) then begin
    ParamList.LoadFromFile(DataFile1)
  end;
  for i := 0 to ParamList.Count - 1 do begin
    s := Trim(ParamList.Strings[i]);
    Delete(s, 1, Pos('(', s) - 1);
    s := StringReplace(s, '(', '"', []);
    s := StringReplace(s, ', ', '", "', [rfReplaceAll]);
    s[Length(s)] := '"';
    ParamList.Strings[i] := s;
  end;
  scpParams.EndOfTokenChr := '';

  if AutoComplete.ItemList.Count > 0 then begin
    { Nothing }
  end else begin
    AutoComplete.Editor := nil;
  end;
end;

procedure TMainFrm.OnMessage(var Msg: TMsg; var Handled: Boolean);
begin
  OnceOnly.IWndProc2(Msg,Handled);
end;

Procedure OnParam(const value:String);
begin
  if mainfrm.openingallowed then begin
    mainfrm.OpenFile(nil,value);
  end else begin
    mainfrm.toOpen.Add(value);
  end;
end;

procedure TMainFrm.FormCreate(Sender: TObject);
var
  RegFile : TRegistry;
  chmFile: string;
  autoFile:string;
  iFilename:string;
  info:TShFileInfo;
begin
  openingallowed:=false;
  toOpen:=TStringList.Create;
  application.OnMessage:=OnMessage;
  OnceOnly.OnParameter:=OnParam;
  OnceOnly.create;
  firstSearch:=true;
  if not (csDesigning in ComponentState) then
    DragAcceptFiles(Handle, TRUE);
//  StandardM.FileName:=ExtractFilePath(application.ExeName)+'toolbar.cfg';
  iFilename:=ExtractFilePath(Application.Exename) +
      ChangeFileExt(lowercase(ExtractFileName(Application.Exename)), '.ini');
  if not FileExists(iFilename) then begin
    uIniFile.OldIniFileName:=iFilename;
    MessageDlg('This is the first time you run Dev-PHP.'#13#10
             + 'Now it''s going to create the configuration file.'#13#10
             + 'If everything goes well, you won''t see this message again.',mtInformation,[mbOk],0);
    CreateNewIniFile(True);
  end;
  loadGIniFile();
  uinifile.IniFileName:=gsettings.LastProject;
  loadIniFile();


//  idftp1.Password:=settings.FTPPasswordText;
  idftp1.Password:=settings.FTPPasswordSave;
  idftp1.Username:=settings.FTPUserText;
  idftp1.Host:=settings.FTPHostText;
  idftp1.port:=strtoint(settings.FTPPortText);
  if settings.FTPHostText='' then begin
    tabsheet4.Visible:=false;
    tabsheet4.TabVisible:=false;
  end;

  LineNumbers.Checked := gsettings.LineNumbers;

  Parser := gsettings.Edit1Text;

  news.visible:=FileExists(ExtractFilePath(Application.Exename)+ 'news.txt');
  ReadGPL.Visible:=FileExists(ExtractFilePath(Application.Exename)+ 'docs\copying.txt');

  RegFile := TRegistry.Create;
  with RegFile do
  try
    RootKey := HKEY_CLASSES_ROOT;

    if settings.regCssChecked then begin
      OpenKey('.css', True);
      WriteString('', 'phpfile');
      CloseKey;
    end;
    if settings.regHtmlChecked then begin
      OpenKey('.html', True);
      WriteString('', 'phpfile');
      CloseKey;
      OpenKey('.htm', True);
      WriteString('', 'phpfile');
      CloseKey;
    end;
    if settings.regJsChecked then begin
      OpenKey('.js', True);
      WriteString('', 'phpfile');
      CloseKey;
    end;
    if settings.regSqlChecked then begin
      OpenKey('.sql', True);
      WriteString('', 'phpfile');
      CloseKey;
    end;
    if settings.regPhpChecked then begin
      OpenKey('.php', True);
      WriteString('', 'phpfile');
      CloseKey;
      OpenKey('.php3', True);
      WriteString('', 'phpfile');
      CloseKey;
      OpenKey('.php4', True);
      WriteString('', 'phpfile');
      CloseKey;
      OpenKey('.phtml', True);
      WriteString('', 'phpfile');
      CloseKey;
    end;
  except
    MessageDlg('Dev-PHP was not able to write to the registry. This possible cause is that you are running NT not in administrator mode. To remove this message, go to General options, Extra sheet and uncheck the "File Asociations" options.', mtError, [mbOK], 0);
    Free;
  end;
  AbrirHistorial;
  fHighlighters := TStringList.Create;
  fHighlighters.Sorted := TRUE;
  GetHighlighters(Self, fHighlighters, FALSE);
  OpenDialog.Filter :=  'All Files Windows(crlf)|*.*|All Files Unix(lf)|*.*|All Files Mac(cr)|*.*|Text Files|*.txt|' + GetHighlightersFilter(fHighlighters);
  SaveDialog.Filter := OpenDialog.Filter;
  FunctionNames := TStringList.Create;
  FunctionNumbers := TStringList.Create;
  LoadAutoComplete;
  chmFile := gsettings.DocsPathText;
  mHHelp := nil;
  {HH 1.2 oder hher Versionskontrolle}
  if (hh.HHCtrlHandle = 0)
    or (hh_funcs._hhMajVer < 4)
    or ((hh_funcs._hhMajVer = 4) and (hh_funcs._hhMinVer < 73)) then
      ShowMessage('Diese Anwendung erfordert die Installation der '+
      'MS HTML Help 1.2 oder hher');
  {Hook - verwendet HH_FUNCS.pas}
  mHHelp := hh_funcs.THookHelpSystem.Create(chmFile, '', htHHAPI);
//  controll:=TController.create();
  autofile:=extractFilePath(application.exename)+ '\'+frmAutoText.autofilename;
  if not FileExists(autofile) then begin
    ClientDataSet1.filename:=autofile;
    ClientDataSet1.CreateDataSet;
    ClientDataSet1.saveToFile(ClientDataSet1.filename,dfXML);
  end else begin
    ClientDataSet1.filename:=autofile;
  end;
  clientDataSet1.active:=true;
  ftpitems.handle:=SHGetFileInfo('',
        0,
        info,
        Sizeof(SHFileinfo),
        SHGFI_SYSICONINDEX OR SHGFI_SMALLICON);
  MainFrm.Left := gsettings.MainFormLeft;
  MainFrm.Top := gsettings.MainFormTop;
  MainFrm.width := gsettings.MainFormwidth;
  MainFrm.Height := gsettings.MainFormHeight;
  MainFrm.WindowState := TWindowState(gsettings.MainFormWindowState);
  panel7.Visible:=false;
  splitter3.Visible:=false;
  panel2.Width:=gsettings.SideBarWidth;
  if gsettings.DockSideBar='TBDock2' then TBToolWindow1.CurrentDock:=TBDock2;
  if gsettings.DockSideBar='TBDock3' then TBToolWindow1.CurrentDock:=TBDock3;
end;

procedure TMainFrm.CSS1Click(Sender: TObject);
begin
  GetEditor.SynEdit.Highlighter := SynCSSSyn1;
  StatusBar1.Panels[3].Text := (Sender as TTBItem).Caption;
end;

procedure TMainFrm.JavaScript1Click(Sender: TObject);
begin
  GetEditor.SynEdit.Highlighter := SynJScriptSyn1;
  StatusBar1.Panels[3].Text := (Sender as TTBItem).Caption;
end;

procedure TMainFrm.LineNumbersClick(Sender: TObject);
var
  e : TEditor;
begin
  e := GetEditor;
  if Assigned(e) then begin
    e.SynEdit.Gutter.Visible := not e.SynEdit.Gutter.Visible;
    gsettings.LineNumbers:=e.SynEdit.Gutter.Visible;
    LineNumbers.checked:=e.SynEdit.Gutter.Visible;
  end;
end;

procedure TMainFrm.EjecutarExecute(Sender: TObject);
//var
//  e: TEditor;
//  IFile, OutputFile, CommandLine, OutputString, IniPath: string;
//  Output: TStringList;
begin
{  compileroutput.Clear;
  e := GetEditor;
  if (Assigned(e)) and (FileExists(Parser)) then begin
    if FileExists(e.fFileName) then begin
      IFile := ExtractFilePath(e.fFileName) + '~out.php';
      OutputFile := ExtractFilePath(e.fFileName) + '~out.html';
    end else begin
      IFile := ExtractFilePath(Application.ExeName) + '~out.php';
      OutputFile := ExtractFilePath(Application.ExeName) + '~out.html';
    end;
    e.SynEdit.Lines.SaveToFile(IFile);
    IniPath := ExtractFilePath(Parser);
    Delete(IniPath, Length(IniPath), 1);
    CommandLine := '"' + Parser + '" -c "' + IniPath + '" -f "' + IFile + '"';
    Application.ProcessMessages;
    OutputString := RunAndGetOutput(CommandLine, ExtractFilePath(e.fFileName));
    if FileExists(IFile) then SysUtils.DeleteFile(IFile);
    Application.ProcessMessages;
    if Length(OutputString) > 0 then begin
      Output := TStringList.Create;
      Output.Add(OutputString);
      Output.SaveToFile(OutputFile);
      Output.LoadFromFile(OutputFile);
      AnalizeOutput(Output);
      Output.Free;
      Application.ProcessMessages;
    end;
    if FileExists(OutputFile) then begin
      WebBrowser.Navigate(OutputFile);
      PageControl1.ActivePageIndex := plPreview;
    end;
  end else begin
    showmessage('Parser not found');
  end;      }

  case pagecontrol1.ActivePageIndex of
  pEdit:  begin
        pagecontrol1.ActivePageIndex:=pIPreview;
        PageControl1Change(sender);
      end;
  pIPreview:  begin
        pagecontrol1.ActivePageIndex:=pEdit;
        PageControl1Change(sender);
      end;
  end;
end;

procedure TMainFrm.ConfigurarImpresin1Click(Sender: TObject);
begin
  PrinterSetupDialog1.Execute;
end;

procedure TMainFrm.HTML3Click(Sender: TObject);
begin
  GetEditor.SynEdit.Highlighter := SynHTMLSyn1;
  StatusBar1.Panels[3].Text := (Sender as TTBItem).Caption;
end;

procedure TMainFrm.MySQL1Click(Sender: TObject);
begin
  GetEditor.SynEdit.Highlighter := SynSQLSyn1;
  StatusBar1.Panels[3].Text := (Sender as TTBItem).Caption;
end;

procedure TMainFrm.ImprimirExecute(Sender: TObject);
begin
  if PageControl.PageCount > 0 then begin
    if PrintDialog1.Execute then begin
      CallPrint(True);
    end;
  end;
end;

procedure TMainFrm.GuardarComoExecute(Sender: TObject);
var
  e : TEditor;
begin
  e := GetEditor;
  if Assigned(e) then begin
    e.SaveAs;
  end;
end;

procedure TMainFrm.HTML2Click(Sender: TObject);
var
  e : TEditor;
begin
  e := GetEditor;
  if Assigned(e) then begin
    ExportDialog.Filter := SynExporterHTML1.DefaultFilter;
    ExportDialog.DefaultExt := '.html';
    if ExportDialog.Execute then begin
      SynExporterHTML1.Highlighter := e.SynEdit.Highlighter;
      SynExporterHTML1.ExportAll(e.SynEdit.Lines);
      if fileExists(ExportDialog.FileName) then begin
        case MessageDlg(Lang(950) + #13#10 + Lang(951), mtConfirmation, [mbYes, mbNo], 0) of
          mrYes : begin
                    SynExporterHTML1.SaveToFile(ExportDialog.FileName);
                  end;
          mrNo : Exit;
        end;
      end else begin
        SynExporterHTML1.SaveToFile(ExportDialog.FileName);
      end;
    end;
  end;
end;

procedure TMainFrm.RTF1Click(Sender: TObject);
var
  e : TEditor;
begin
  e := GetEditor;
  if Assigned(e) then begin
    ExportDialog.Filter := SynExporterRTF1.DefaultFilter;
    ExportDialog.DefaultExt := '.rtf';
    if ExportDialog.Execute then begin
      SynExporterRTF1.Highlighter := e.SynEdit.Highlighter;
      SynExporterRTF1.ExportAll(e.SynEdit.Lines);
      if fileExists(ExportDialog.FileName) then begin
        case MessageDlg(Lang(950) + #13#10 + Lang(951), mtConfirmation, [mbYes, mbNo], 0) of
          mrYes : begin
                    SynExporterRTF1.SaveToFile(ExportDialog.FileName);
                  end;
          mrNo : Exit;
        end;
      end else begin
        SynExporterRTF1.SaveToFile(ExportDialog.FileName);
      end;
    end;
  end;
end;

Procedure TMainFrm.visibleBar(barCaption:string;value:boolean);
var i:integer;
begin
  for i:=0 to StandardM.ActionBars.Count-1 do begin
    if StandardM.ActionBars[i].ActionBar.Caption=barCaption then begin
      StandardM.ActionBars[i].Visible:=value;
    end;
  end;
end;

procedure TMainFrm.BarradeHerramientas1Click(Sender: TObject);
begin
  gsettings.toolbar1visible:=not BarradeHerramientas1.checked;
end;

procedure TMainFrm.LoadEditorSettings;
var
  e : TEditor;
  i : integer;
begin
  for i := PageControl.PageCount - 1 downto 0 do begin
    e := GetEditor(i);
    if Assigned(e) then begin
      e.SynEdit.Color := gsettings.DemoEditColor;
      e.SynEdit.RightEdge := settings.UpDown1Position;
      e.SynEdit.Font.Size := gsettings.UpDown2Position;
      e.SynEdit.TabWidth := gsettings.UpDown3Position;
      e.SynEdit.Font.Name := gsettings.EditorFontText;
    end;
  end;
end;

procedure TMainFrm.BuscarExecute(Sender: TObject);
begin
  if PageControl.PageCount > 0 then begin
    with GetEditor do begin
      if (SynEdit.SelText <> '') then begin
        FindDialog1.FindText := SynEdit.SelText;
      end else begin
        FindDialog1.FindText := settings.FindDialog1FindText;
      end;
    end;
    FindDialog1.Execute;
  end;
end;

procedure TMainFrm.SiguienteExecute(Sender: TObject);
var searchstr:string;
begin
  if PageControl.PageCount > 0 then begin
    with GetEditor do begin
      if (SynEdit.SelText <> '') then begin
        searchstr:=SynEdit.SelText
      end else begin
        searchstr:= settings.ReplaceDialog1FindText
      end;
      if GetEditor.SynEdit.SearchReplace(searchstr, '', GetFindOptions(FindDialog1)) = 0 then begin
        MessageBeep($7000);
        MessageDlg(Lang(956) + ' "' + searchstr + '" ' + Lang(957), MtInformation, [mbOK],0);
      end;
    end;
  end;
end;

procedure TMainFrm.ReemplazarExecute(Sender: TObject);
begin
  if PageControl.PageCount > 0 then begin
    MainFrm.ReplaceDialog1.FindText := GetEditor.SynEdit.WordAtCursor;
    if MainFrm.ReplaceDialog1.FindText<>'' then
      MainFrm.ReplaceDialog1Find(sender);
    MainFrm.ReplaceDialog1.Execute;
  end;
end;

procedure TMainFrm.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  AExit.Enabled := FALSE;
  if settings.SaveSessionChecked then begin
    GuardarSesion;
  end;
  if WindowState <> wsMaximized then begin
    gsettings.MainFormLeft:=MainFrm.Left;
    gsettings.MainFormTop:=MainFrm.Top;
    gsettings.MainFormwidth:=MainFrm.Width;
    gsettings.MainFormHeight:=MainFrm.Height;
  end;
  gsettings.MainFormWindowState:=ord(MainFrm.WindowState);
  gsettings.SideBarWidth:=panel2.Width;
  if TBToolWindow1.CurrentDock=TBDock2 then gsettings.DockSideBar:='TBDock2';
  if TBToolWindow1.CurrentDock=TBDock3 then gsettings.DockSideBar:='TBDock3';
  TB2KSaveToolbarButtons(TBToolbar2);
  TB2KSaveToolbarButtons(TBToolbar3);
  TB2KSaveToolbarButtons(TBToolbar4);
  if CloseAll then begin
    FtpDisconnect;
    settings.BrowserPath:=BrowserPath.Text;
    ftplist.Free;
    freeIniFile();
    Action := caFree;
  end else begin
    Action := caNone;
  end;
end;

procedure TMainFrm.EditMenuClick(Sender: TObject);
var
  e : TEditor;
begin
  e := GetEditor;
  if Assigned(e) then begin
    AUndo.Enabled := e.SynEdit.CanUndo;
    ARedo.Enabled := e.SynEdit.CanRedo;
    EditCut1.Enabled := TRUE;
    EditCopy1.Enabled := TRUE;
    EditPaste1.Enabled := Clipboard.HasFormat(CF_TEXT);
    SeleccionarTodo1.Enabled := TRUE;
  end
  else begin
     AUndo.Enabled := FALSE;
     ARedo.Enabled := FALSE;
     EditCut1.Enabled := FALSE;
     EditCopy1.Enabled := FALSE;
     EditPaste1.Enabled := FALSE;
     SeleccionarTodo1.Enabled := FALSE;
   end;
end;

procedure TMainFrm.ActivarBotones(Activar: boolean);
var pgtz:boolean;
begin
  ASave.Enabled := (GetEditor<>nil) and (not GetEditor.modified);
  pgtz:= PageControl.PageCount > 0;
  ASaveAs.Enabled := pgtz;
  EnableSaveAll;
  AClose.Enabled := pgtz;
  APrint.Enabled := pgtz;
  EditMenuClick(self);
  ASearch.Enabled := pgtz;
  AReplace.Enabled := pgtz;
  AExecute.Enabled := pgtz;
  Exportar.Enabled := pgtz;
  Formato1.Enabled := pgtz;
  AinsImagen.Enabled := pgtz;
  AinsTable.Enabled := pgtz;
  AinsLayer.Enabled := pgtz;
  AinsForm.Enabled := pgtz;
  AinsText.Enabled := pgtz;
  AinsButton.Enabled := pgtz;
  AinsCheck.Enabled := pgtz;
  AinsRadio.Enabled := pgtz;
  AinsList.Enabled := pgtz;
  AinsFile.Enabled := pgtz;
  AinsImage.Enabled := pgtz;
  AinsHidden.Enabled := pgtz;
  AinsInc.Enabled := pgtz;
  AinsMail.Enabled := pgtz;
  AinsHR.Enabled := pgtz;
  AinsBR.Enabled := pgtz;
  AinsDate.Enabled := pgtz;
  Gtk2.Enabled := pgtz;
  Comprobarsintaxis1.Enabled := pgtz;
  OptimizarComprimircdigo1.Enabled := pgtz;
  IraLnea1.Enabled := pgtz;
  CerrarTodo.Enabled := pgtz;
  EMailWizard1.Enabled := pgtz;
  InsertFunction.Enabled := pgtz;
  PrintSelected1.Enabled := pgtz;
  EchoSelectedtext1.Enabled := pgtz;
  Replacewith1.Enabled := pgtz;
  InsertColor1.Enabled := pgtz;
  ReloadCurrentFile1.Enabled := pgtz;
  Siguiente2.Enabled := pgtz;
  Anterior1.Enabled := pgtz;
  InsertTable1.Enabled := pgtz;
  Commentselectedtext1.Enabled := pgtz;
  StatusBar1.Panels[0].Text := '';
  StatusBar1.Panels[1].Text := '';
  StatusBar1.Panels[2].Text := '';
  StatusBar1.Panels[3].Text := '';
  Commentselectedtext1.Enabled := FALSE;
end;

procedure TMainFrm.OpcionesGenerales1Click(Sender: TObject);
var i:integer;
    doi:boolean;
begin
  i:=pageControl.activePageIndex;
  OptionForm := TOptionForm.Create(Self);
  with OptionForm do
  try
     ShowModal;
  finally
    doi:=OptionForm.ModalResult=mrok;
    Free;
  end;
  pageControl.activePageindex:=i;
  if doi then begin
    if gsettings.HideSideBar then panel2.Visible:=false else panel2.Visible:=true;
    ReadLangFile;
    mainfrm.Refresh;
    application.ProcessMessages;
    IdFTP1.Passive:=settings.ftppassive;
  end;
end;

procedure TMainFrm.ReadGPLClick(Sender: TObject);
begin
  TEditor.Create.Init(ExtractFilePath(Application.ExeName) + 'docs\copying.txt', TRUE);
  ActivarBotones(TRUE);
end;

procedure TMainFrm.ClearHistoryClick(Sender: TObject);
var
  i : integer;
begin
  settings.clearHistory;
  settings.writeHistory;
  i := Reabrir.Count-1;
  if Reabrir.Count <> 2 then
    repeat
       Reabrir.Remove(ReAbrir.Items[i]);
       dec(i);
    until Reabrir.Count = 2;
end;

procedure TMainFrm.NuevoHTMLClick(Sender: TObject);
var
  e : TEditor;
    opt:TSynSearchOptions;
begin
  Inc(NewCount);
  e := TEditor.Create;
  e.Init('Untitled' + IntToStr(NewCount) + '.htm', FALSE);
  clientdataset1.FindFirst;
  while not clientdataset1.Eof do begin
    if clientdataset1.FieldByName('Name').asstring='HTMLTemplate' then begin
      e.SynEdit.selText:=clientdataset1.fieldbyname('text').asstring;
      e.SynEdit.SetFocus;
      opt:=[ssoBackwards,ssoReplace];
      e.SynEdit.SearchReplace(frmAutoText.cursorstr,'',opt);
      break;
    end;
    if not clientdataset1.FindNext then break;
  end;
  ActivarBotones(TRUE);
end;

procedure TMainFrm.Siguiente2Click(Sender: TObject);
begin
  PageControl.SelectNextPage(TRUE);
end;

function TMainFrm.CloseEditor(id: integer): integer;
var
  e : TEditor;
begin
  Result := mrCancel;
  e := GetEditor(id);
  if not Assigned(e) then Exit;
  Result := AskBeforeClose(e);
  if Result=mrCancel then Exit;
  e.Close(pagecontrol.ActivePage);
end;

function TMainFrm.AskBeforeClose(e: TEditor): integer;
var
  nRes : integer;
  fn:string;
begin
  nRes:=0;
  if e.modified = true then begin
    fn:=e.fFileName;
    if fn='' then fn:=GetEditor.fTabSheet.Caption;
    nRes := Application.MessageBox(PChar(Lang(952) + ' ' +fn +
                                   ' ' + Lang(953) + #13#10 + Lang(954)),
                                   'Dev-PHP IDE', MB_YESNOCANCEL);
    if nRes = IDYES then e.SaveFile(true);
  end;
  Result := nres;
end;

function TMainFrm.CloseAll;
var
  i : integer;
  res:integer;
begin
  Result := TRUE;
  if PageControl.PageCount > 0 then begin
    for i := PageControl.PageCount - 1 downto 0 do begin
      pagecontrol.activepageIndex:=pagecontrol.pagecount-1;
      res:=CloseEditor(i);
      if res=mrCancel then begin
        Result := FALSE;
        AExit.Enabled := TRUE;
        Break;
      end;
      if res=mrNo then begin
      end;
    end;
  end;
  if not(PageControl.PageCount > 0) then begin
    PageControl.Visible := FALSE;
  end;
end;

procedure TMainFrm.CerrarTodoClick(Sender: TObject);
begin
  CloseAll;
end;

procedure TMainFrm.NuevoPHPClick(Sender: TObject);
var
  e : TEditor;
    opt:TSynSearchOptions;
begin
  Inc(NewCount);
  e := TEditor.Create;
  e.Init('Untitled' + IntToStr(NewCount) + '.php', FALSE);
  clientdataset1.FindFirst;
  while not clientdataset1.Eof do begin
    if clientdataset1.FieldByName('Name').asstring='PHPTemplate' then begin
      e.SynEdit.selText:=clientdataset1.fieldbyname('text').asstring;
      e.SynEdit.SetFocus;
      opt:=[ssoBackwards,ssoReplace];
      e.SynEdit.SearchReplace(frmAutoText.cursorstr,'',opt);
      break;
    end;
    if not clientdataset1.FindNext then break;
  end;
  ActivarBotones(TRUE);
end;

procedure TMainFrm.GuardarTodoExecute(Sender: TObject);
var
  i : integer;
  e : TEditor;
begin
  if PageControl.PageCount > 0 then begin
    for i := PageControl.PageCount - 1 downto 0 do begin
      PageControl.ActivePage := PageControl.Pages[i];
      e := GetEditor(i);
      e.SaveFile(true);
    end;
  end;
end;

procedure TMainFrm.CerrarExecute(Sender: TObject);
var
  e : TEditor;
  t : TTabSheet;
begin
  e := GetEditor;
  t:=pagecontrol.ActivePage;
  if Assigned(e) then begin
//    pagecontrol.SelectNextPage(false);
    if AskBeforeClose(e)<>mrCancel then e.Close(t);
  end;
  if not(PageControl.PageCount > 0) then begin
    PageControl.Visible := FALSE;
  end;
end;

procedure TMainFrm.CallPrint(doPrint : boolean);
var
  e : TEditor;
begin
  e := GetEditor;
  SynEditPrint1.Lines := e.SynEdit.Lines;
  SynEditPrint1.Font.Name := gsettings.EditorFontText;
  SynEditPrint1.Font.Size := gsettings.UpDown2Position;
  SynEditPrint1.Highlighter := e.SynEdit.Highlighter;
  if doPrint = TRUE then begin
    SynEditPrint1.Title := 'Dev-PHP IDE - ' + e.fFileName;
    SynEditPrint1.Header.Clear;
    SynEditPrint1.Header.Add(ExtractFileName(e.fFileName), nil, taLeftJustify, 1);
    SynEditPrint1.Header.Add('$DATE$ $TIME$', nil, taRightJustify, 1);
    SynEditPrint1.Footer.Clear;
    SynEditPrint1.Footer.Add('Page $PAGENUM$ of $PAGECOUNT$', nil, taRightJustify, 1);
    SynEditPrint1.Copies := Self.PrintDialog1.Copies;
    SynEditPrint1.Print;
  end;
end;

procedure TMainFrm.NewsClick(Sender: TObject);
begin
  TEditor.Create.Init(ExtractFilePath(Application.ExeName) + 'news.txt', TRUE);
  ActivarBotones(TRUE);
end;

procedure TMainFrm.ReadLangFile;
begin
  LangFileName := gsettings.IdiomaText;
  LangFile := TIniFile.Create(LangFileName);
  FileMenu.Caption := Lang(0);
  EditMenu.Caption := Lang(1);
  SearchMenu.Caption := Lang(2);
  ViewMenu.Caption := Lang(3);
  RunMenu.Caption := Lang(4);
  OptionsMenu.Caption := Lang(5);
  WindowMenu.Caption := Lang(6);
  HelpMenu.Caption := Lang(7);
  ANew.Caption := Lang(50);
  ANew.Hint := ANew.Caption;
  Nuevo1.Caption:=ANew.Caption;
  NuevoTexto.Caption := Lang(51);
  NuevoHTML.Caption := Lang(52);
  NuevoPHP.Caption := Lang(53);
  AOpen.Caption := Lang(54);
  AOpen.Hint := AOpen.Caption;
  Reabrir.Caption := Lang(55);
  ClearHistory.Caption := Lang(56);
  ASave.Caption := Lang(57);
  ASave.Hint := ASave.Caption;
  ASaveAs.Caption := Lang(58);
  ASaveAs.Hint := ASaveAs.Caption;
  ASaveAll.Caption := Lang(59);
  ASaveAll.Hint := ASaveAll.Caption;
  AClose.Caption := Lang(60);
  AClose.Hint := Lang(68);
  Exportar.Caption := Lang(61);
  HTML2.Caption := Lang(62);
  RTF1.Caption := Lang(63);
  APrint.Caption := Lang(64);
  APrint.Hint := APrint.Caption;
  ConfigurarImpresin1.Caption := Lang(66);
  AExit.Caption := Lang(67);
  AExit.Hint := AExit.Caption;
  FileFormat1.Caption:=lang(69);
  ReloadCurrentFile1.Caption:=lang(70);
  AUndo.Caption := Lang(100);
  AUndo.Hint := AUndo.Caption;
  ARedo.Caption := Lang(101);
  ARedo.Hint := ARedo.Caption;
  EditCut1.Caption := Lang(102);
  EditCut1.Hint := EditCut1.Caption;
  EditCopy1.Caption := Lang(103);
  EditCopy1.Hint := EditCopy1.Caption;
  EditPaste1.Caption := Lang(104);
  EditPaste1.Hint := EditPaste1.Caption;
  SeleccionarTodo1.Caption := Lang(105);
  OptimizarComprimircdigo1.Caption := Lang(106);
  DeleteLine1.Caption:=lang(107);
  DeleteToEndLine1.Caption:=lang(108);
  DeleteWord1.Caption:=lang(109);
  DeletePreviousWord1.Caption:=lang(110);
  UCaseLCase1.Caption:=lang(111);
  UpperCase1.Caption:=lang(112);
  LowerCase1.Caption:=lang(113);
  C3.Caption:=lang(114);

  ASearch.Caption := Lang(150);
  ASearch.Hint := ASearch.Caption;
  AReplace.Caption := Lang(151);
  AReplace.Hint := AReplace.Caption;
  ANextSearch.Caption := Lang(152);
  ANextSearch.Hint := ANextSearch.Caption;
  Iralnea1.Caption := Lang(153);
  BarradeHerramientas1.Caption := Lang(200);
  BarradeEstado1.Caption := Lang(202);
  LineNumbers.Caption := Lang(203);
  TBSubmenuItem2.Caption:=Lang(205);
  TBSubmenuItem2.Hint:=TBSubmenuItem2.Caption;
  AExecute.Caption := Lang(250);
  AExecute.Hint := AExecute.Caption;
  ComprobarSintaxis1.Caption := Lang(251);
  Gtk2.Caption := Lang(254);
  Formato1.Caption := Lang(300);
  Texto1.Caption := Lang(301);
  OpcionesGenerales1.Caption := Lang(303);
  S1.Caption:=Lang(304);
  ACloseAll.Caption := Lang(350);
  ACloseAll.Hint:=ACloseAll.Caption;
  ANextWindow.Caption:=lang(351);
  ANextWindow.Hint:=ANextWindow.Caption;
  APreviousWindow.Caption := Lang(352);
  APreviousWindow.Hint:=APreviousWindow.Caption;
  extSnippets1.Caption:=lang(353);
  EMailWizard1.Caption:=lang(354);
  InsertFunction.Caption:=lang(355);
  InsertTable1.Caption:=lang(356);
  PRINTselected1.Caption:=lang(357);
  ECHOselectedtext1.Caption:=lang(358);
  Replacewith1.Caption:=lang(359);
  InsertColor1.Caption:=lang(360);
  DateTime1.Caption:=lang(361);
  InsertDate1.Caption:=lang(362);
  InsertTime1.Caption:=lang(363);
  InsertDateTime1.Caption:=lang(364);
  Indent1.caption:=Lang(365);
  deindent1.Caption:=lang(366);
  DocumentSpecials1.Caption:=lang(367);
  InsertDocPath1.Caption:=lang(368);
  InsertDocFilename1.Caption:=lang(369);
  Insert1.Caption:=lang(370);
  
  Acercade1.Caption := Lang(400);
  ASearchDocs.Caption:=Lang(401);
  ASearchDocs.Hint:=ASearchDocs.Caption;
  AinsImagen.Caption := Lang(1050);
  AinsImagen.Hint := AinsImagen.Caption;
  AinsTable.Caption := Lang(1051);
  AinsTable.Hint := AinsTable.Caption;
  AinsLayer.Caption := Lang(1052);
  AinsLayer.Hint := AinsLayer.Caption;
  AinsForm.Caption := Lang(1053);
  AinsForm.Hint := AinsForm.Caption;
  AinsMail.Caption := Lang(1058);
  AinsMail.Hint := AinsMail.Caption;
  AinsInc.Caption := Lang(1055);
  AinsInc.Hint := AinsInc.Caption;
  AinsHR.Caption := Lang(1061);
  AinsHR.Hint := AinsHR.Caption;
  AinsBR.Caption := Lang(1062);
  AinsBR.Hint := AinsBR.Caption;
  AinsDate.Caption := Lang(1071);
  AinsDate.Hint := AinsDate.Caption;
  AinsText.Caption := Lang(1100);
  AinsText.Hint := AinsText.Caption;
  AinsButton.Caption := Lang(1101);
  AinsButton.Hint := AinsButton.Caption;
  AinsCheck.Caption := Lang(1102);
  AinsCheck.Hint := AinsCheck.Caption;
  AinsRadio.Caption := Lang(1103);
  AinsRadio.Hint := AinsRadio.Caption;
  AinsList.Caption := Lang(1104);
  AinsList.Hint := AinsList.Caption;
  AinsFile.Caption := Lang(1105);
  AinsFile.Hint := AinsFile.Caption;
  AinsImage.Caption := Lang(1106);
  AinsImage.Hint := AinsImage.Caption;
  AinsHidden.Caption := Lang(1107);
  AinsHidden.Hint := AinsHidden.Caption;
  AOpenProject.Caption:=Lang(2025);
  AOpenProject.Hint:=AOpenproject.Caption;
  ASaveProject.Caption:=Lang(2026);
  ASaveProject.Hint:=ASaveProject.Caption;
  Re1.Caption:=Lang(154);
  Re1.Hint:=Re1.Caption;
  SearchRegExOFiles.Caption:=Lang(155);
  SearchRegExOFiles.Hint:=SearchRegExOFiles.Caption;
  SearchRegExDir.Caption:=Lang(156);
  SearchRegExDir.Hint:=SearchRegExDir.Caption;
  SendFile.Caption:=Lang(255);
  SendFile.Hint:=SendFile.Caption;
  send.Caption:=lang(256);
  send.Hint:=send.Caption;
end;

function GetLongPathName(APath:String):String;
var
  i : Integer;
  h : THandle;
  Data : TWin32FindData;
  IsBackSlash : Boolean;
begin
  APath:=ExpandFileName(APath);
  i:=Pos('\',APath);
  Result:=Copy(APath,1,i);
  Delete(APath,1,i);
  repeat
    i:=Pos('\',APath);
    IsBackSlash:=i>0;
    if Not IsBackSlash then
      i:=Length(APath)+1;
    h:=FindFirstFile(PChar(Result+Copy(APath,1,i-1)),Data);
    if h<>INVALID_HANDLE_VALUE then begin
      try
        Result:=Result+Data.cFileName;
        if IsBackSlash then
          Result:=Result+'\';
      finally
        Windows.FindClose(h);
      end;
    end
    else begin
      Result:=Result+APath;
      Exit;
    end;
    Delete(APath,1,i);
  until Length(APath)=0;
end;

procedure TMainFrm.FormShow(Sender: TObject);
var
  FileName : string;
  e : TEditor;
  i:integer;
begin
  ftplist:=TStringList.Create;
  pagecontrol1.ActivePageIndex:=pEdit;
  pagecontrol2.activePageIndex:=0;
  Self.Caption := 'Dev-PHP ' + DevPHPVer;
  if ParamCount > 0 then begin
    FileName := getLongPathName(ParamStr(1));
    if FileExists(FileName) then begin
      e := TEditor.Create;
      e.Init(FileName, True);
    end;
  end else begin
//    if settings.SaveSessionChecked then begin
//      List := TStringList.Create;
//      List.Text:=settings.session.Text;
//      for i := 0 to List.Count-1 do begin
//        FileName := List[i];
//        if FileExists(FileName) then begin
//          e := TEditor.Create;
//          e.Init(FileName, True);
//          AgregarHistorial(OpenDialog.FileName);
//          GuardarHistorial(OpenDialog.FileName);
//        end;
//      end;
//      List.Free;
//      TempIndex := settings.SessionActive;
//      if (TempIndex < PageControl.PageCount) and (TempIndex > -1) then begin
//        PageControl.ActivePageIndex := TempIndex;
//      end;
//    end;
  end;
  ReadLangFile;
  Application.ProcessMessages;
  ActivarBotones(TRUE);
  CreateHighlighters(SynPHPSyn,SynCSSSyn1,SynJScriptSyn1,SynSQLSyn1);
  webserv1.Active:=false;
  webserv1.Port:=strtoint(settings.localPortText);
  webserv1.RootPath:=settings.localpathText;
  webserv1.PHPExe:=gsettings.Edit1Text;
  webserv1.Active:=true;
  WebBrowser.Navigate('about:blank');
  ShellTreeView1.Root:=settings.localpathText;
  ShellTreeView1.TopItem.Text:=ShellTreeView1.Root;
  shellListview1.Columns[0].Width:=shelllistview1.Width-3;
  BrowserPath.Text:=settings.BrowserPath;
  LoadProject(gsettings.LastProject);
  case gsettings.SaveType of
  0: savewithcrlf1.Checked:=true;
  1: saveunix1.Checked:=true;
  2: savewithcr1.Checked:=true;
  else savewithcrlf1.Checked:=true;
  end;
  TB2kInitializeToolbar(TBToolbar2, EmptyStr, ExtractFilePath(Application.EXEName) + '\DEVPHP.INI', 0);
  TB2kInitializeToolbar(TBToolbar3, EmptyStr, ExtractFilePath(Application.EXEName) + '\DEVPHP.INI', 0);
  TB2kInitializeToolbar(TBToolbar4, EmptyStr, ExtractFilePath(Application.EXEName) + '\DEVPHP.INI', 0);
  TBToolWindow1.Visible:=not gsettings.HideSideBar;
  TBToolbar2.Visible := gsettings.toolbar1visible;
  TBToolbar4.Visible := gsettings.htmlbar1visible;
  TBToolbar3.Visible := gsettings.editbar1visible;
  StatusBar1.Visible := gsettings.StatusBar1visible;
  for i:=0 to toOpen.Count-1 do begin
    OpenFile(self,toOpen.Strings[i]);
  end;
  toOpen.Clear;
  openingallowed:=true;
end;

procedure TMainFrm.GuardarSesion;
var
  i : integer;
  CurrentFile : string;
  e:TEditor;
begin
  settings.Session.Clear;
  if PageControl.PageCount > 0 then begin
    for i := 0 to PageControl.PageCount - 1 do begin
      e:=GetEditor(i);
      CurrentFile:=e.fFilename;
      if (e<>nil) and (Length(e.fFileName) > 0) then begin
        settings.Session.Add(GetEditor(i).fFileName);
      end;
    end;
    settings.SessionActive:=PageControl.ActivePageIndex;
  end;
  settings.writeSession;
end;

procedure TMainFrm.Iralnea1Click(Sender: TObject);
begin
  if PageControl.PageCount > 0 then begin
    GoToLine := TGoToLine.Create(Self);
    with GoToLine do
    try
      ShowModal;
    finally
      Free;
    end;
  end;
end;

procedure TMainFrm.OptimizarComprimircdigo1Click(Sender: TObject);
begin
  if PageControl.PageCount > 0 then begin
    OptimizeForm := TOptimizeForm.Create(Self);
    with OptimizeForm do
    try
      ShowModal;
    finally
      Free;
    end;
  end;
end;

function TMainFrm.GetEditor(const index: integer): TEditor;
var
 i: integer;
begin
  if index = -1 then
    i:= PageControl.ActivePageIndex
  else
    i:= index;

  if PageControl.PageCount <= 0 then begin
    result := nil;
  end else begin
    result := TEditor(PageControl.Pages[i].Tag);
  end;
end;

procedure TMainFrm.Insert(Text: string);
var
  e : TEditor;
begin
  e := GetEditor;
  if Assigned(e) then begin
    e.SynEdit.SelText := Text;
    e.SynEdit.SetFocus;
    e.SynEdit.EnsureCursorPosVisible;
    MainFrm.ASave.Enabled := TRUE;
  end;
end;

procedure TMainFrm.insTablaExecute(Sender: TObject);
begin
  if PageControl.PageCount > 0 then begin
    TableForm := TTableForm.Create(Self);
    try
      tableform.Visible:=false;
      TableForm.ShowModal;
    finally
      Tableform.Free;
    end;
  end;
end;

procedure TMainFrm.Anterior1Click(Sender: TObject);
begin
  PageControl.SelectNextPage(FALSE);
end;

procedure TMainFrm.Gtk2Click(Sender: TObject);
begin
  if PageControl.PageCount > 0 then begin
    GtkRun := TGtkRun.Create(Self);
    with GtkRun do
    try
      ShowModal;
    finally
      Free;
    end;
  end;
end;

procedure TMainFrm.CheckExecute(Sender: TObject);
begin
  if PageControl.PageCount > 0 then begin
    SyntaxCheck := TSyntaxCheck.Create(Self);
    with SyntaxCheck do
    try
      ShowModal;
    finally
      Free;
    end;
  end;
end;

procedure TMainFrm.OnceOnlyParameter(Sender: TObject; const Value: String);
var
  x : integer;
  Exists : boolean;
begin
  application.ProcessMessages;
  if FileExists(Value) then begin
    Exists := FALSE;
    for x := 0 to PageControl.PageCount - 1 do begin
      if Value = GetEditor(x).fFileName then begin
        Exists := TRUE;
        Break;
      end;
    end;
    if Exists = False then begin
      application.ProcessMessages;
      TEditor.Create.Init(Value, TRUE);
      AgregarHistorial(Value);
      GuardarHistorial(Value);
    end else begin
      MessageDlg('File "' + Value + '" is already open. Use "Reload Current File" to reload it.', mtError, [mbOk], 0);
    end;
  end;
  ActivarBotones(TRUE);
end;

procedure TMainFrm.MHTMLBarClick(Sender: TObject);
begin
  gsettings.htmlbar1visible:=not MhtmlBar.Checked;
end;

procedure TMainFrm.PRINTselected1Click(Sender: TObject);
begin
  if PageControl.PageCount > 0 then begin
    with GetEditor do begin
      SynEdit.SelText := 'PRINT ''' + StringReplace(SynEdit.SelText, '''', '\''', [rfReplaceAll]) + ''';';
    end;
  end;
end;

procedure TMainFrm.Replacewith1Click(Sender: TObject);
begin
  if PageControl.PageCount > 0 then begin
    with GetEditor do begin
      SynEdit.SelText := StringReplace(SynEdit.SelText, '\', '/', [rfReplaceAll]);
    end;
  end;
end;

procedure TMainFrm.ECHOselectedtext1Click(Sender: TObject);
begin
  if PageControl.PageCount > 0 then begin
    with GetEditor do begin
      SynEdit.SelText := 'ECHO "' + StringReplace(SynEdit.SelText, '"', '\"', [rfReplaceAll]) + '";';
    end;
  end;
end;

procedure TMainFrm.EMailWizard1Click(Sender: TObject);
begin
  if PageControl.PageCount > 0 then begin
    MailForm := TMailForm.Create(Self);
    with MailForm do
    try
       ShowModal;
    finally
      Free;
    end;
  end;
end;

procedure TMainFrm.InsertFunctionClick(Sender: TObject);
begin
  if PageControl.PageCount > 0 then begin
    FunctionForm := TFunctionForm.Create(Self);
    with FunctionForm do
    try
       ShowModal;
    finally
      Free;
    end;
  end;
end;

procedure TMainFrm.ReloadCurrentFile1Click(Sender: TObject);
var
  e : TEditor;
begin
  if PageControl.PageCount > 0 then begin
    e := GetEditor;
    case MessageDlg('Do you want to reload "' + e.fFileName + '"?', mtConfirmation, [mbYes, mbNo], 0) of
      mrYes : begin
        if FileExists(e.fFileName) then begin
          e.SynEdit.Lines.LoadFromFile(e.fFileName);
          e.modified := TRUE;
          ASave.Enabled := FALSE;
          e.SynEdit.Modified:=false;
          pagecontrol.ActivePage.Caption:=ExtractFileName(e.fFileName);
//          MessageDlg('File "' + e.fFileName + '" has been reloaded.', mtInformation, [mbOk], 0);
        end else begin
          MessageDlg('File "' + e.fFileName + '" doesn''t exist or has been renamed.', mtError, [mbOk], 0);
        end;
      end;
    end;
  end;
end;

procedure TMainFrm.InsertColor1Click(Sender: TObject);
var
  InsertStr : string;
begin
  if PageControl.PageCount > 0 then begin
    if ColorDialog1.Execute then begin
      InsertStr := IntToHex(ColorDialog1.Color, 6);
      GetEditor.SynEdit.SelText := '#'
        +InsertStr[5]+InsertStr[6]
        +InsertStr[3]+InsertStr[4]
        +InsertStr[1]+InsertStr[2];
    end;
  end;
end;

procedure TMainFrm.CheckforUpdate1Click(Sender: TObject);
begin
  UpdateForm := TUpdateForm.Create(Self);
  with UpdateForm do
  try
     ShowModal;
  finally
    Free;
  end;
end;

procedure TMainFrm.FunctionBrowserChange(Sender: TObject);
var
  CurrentLine : integer;
  e : TEditor;
begin
  if PageControl.PageCount > 0 then begin
    e := GetEditor;
    CurrentLine := StrToInt(FunctionNumbers.Strings[FunctionBrowser.ItemIndex]);
    e.SynEdit.CaretY := CurrentLine;
    e.SynEdit.TopLine := CurrentLine;
    e.SynEdit.EnsureCursorPosVisible;
    e.SynEdit.SetFocus;
  end;
end;

procedure TMainFrm.SearchDocumentationClick(Sender: TObject);
var
  Doc_Filename, Doc_Lang,  Section,s : string;
  Command         :OleVariant;
  e:TEditor;
begin
  PageControl1.ActivePageIndex:=pDoc;
  if not firstSearch then pagecontrol1.OnChange(sender) else firstSearch:=false;
  e:=GetEditor;
  if assigned(e) then begin
    s:=e.SynEdit.GetWordAtRowCol(e.synedit.CaretXY);
  end else s:='';
  command:='about:blank';
  webbrowser2.Navigate2(command);
  application.ProcessMessages;
  Doc_Filename := gsettings.DocsPathText;
  if FileExists(Doc_Filename) then begin
    Doc_Lang := settings.DocLang;
    Section := 'function';
    SearchString := StringReplace(s, '_', '-', [rfReplaceAll]);
    SearchString := LowerCase(SearchString);
    Command := 'mk:@MSITStore:' + Doc_Filename + '::/' + Doc_Lang + '/' + Section + '.' + SearchString + '.html';
    CompilerOutput.Visible := FALSE;
    Splitter1.Visible := FALSE;
    PageControl1.ActivePageIndex := pDoc;
    doc_complete:=false;
    WebBrowser2.Navigate2(Command);
    while doc_complete=false do application.processmessages;
    if pos('res://',Webbrowser2.OleObject.Document.Url)=1 then begin
      Command := 'mk:@MSITStore:' + Doc_Filename + '::/' + Doc_Lang + '/index.html';
      WebBrowser2.Navigate2(Command);
    end;
  end else begin
    MessageDlg('Please set the "PHP Documentation" settings in "Options -> Extra".', mtError, [mbOk], 0);
  end;
  MainFrm.StatusBar1.SetFocus;
end;


function TMainFrm.GetSearchString : string;
var locline, lookup: String;
    TmpX, savepos, StartX,
    ParenCounter   : Integer;
    FoundMatch     : Boolean;
    CanExecute     : Boolean;
    e              : TEditor;
begin
  if PageControl.PageCount > 0 then begin
  e := GetEditor;
  if not(Assigned(e)) then begin
    Exit;
  end;
  with e.SynEdit do
  begin
    locLine := LineText;

    //go back from the cursor and find the first open paren
    TmpX := CaretX;
    if TmpX > length(locLine) then
      TmpX := length(locLine)
    else dec(TmpX);
    FoundMatch := FALSE;
    while (TmpX > 0) and not(FoundMatch) do
    begin
      if LocLine[TmpX] = ',' then
      begin
        dec(TmpX);
      end else if LocLine[TmpX] = ')' then
      begin
        //We found a close, go till it's opening paren
        ParenCounter := 1;
        dec(TmpX);
        while (TmpX > 0) and (ParenCounter > 0) do
        begin
          if LocLine[TmpX] = ')' then inc(ParenCounter)
          else if LocLine[TmpX] = '(' then dec(ParenCounter);
          dec(TmpX);
        end;
        if TmpX > 0 then dec(TmpX);  //eat the open paren
      end else if locLine[TmpX] = '(' then
      begin
        //we have a valid open paren, lets see what the word before it is
        StartX := TmpX;
        while (TmpX > 0) and not(locLine[TmpX] in TSynValidStringChars) do
          Dec(TmpX);
        if TmpX > 0 then
        begin
          SavePos := TmpX;
          While (TmpX > 0) and (locLine[TmpX] in TSynValidStringChars) do
            dec(TmpX);
          inc(TmpX);
          lookup := lowercase(Copy(LocLine, TmpX, SavePos - TmpX + 1));
          FoundMatch := LookupList.IndexOf(Lookup) > -1;
          if not(FoundMatch) then
          begin
            TmpX := StartX;
            dec(TmpX);
          end;
        end;
      end else dec(TmpX)
    end;
  end;

  CanExecute := FoundMatch;
  if CanExecute then begin
    Result := Lookup;
  end;
  end;
end;

procedure TMainFrm.FunctionBrowserDropDown(Sender: TObject);
var
  ItemIndex : integer;
begin
  if PageControl.PageCount > 0 then begin
    ItemIndex := FunctionBrowser.ItemIndex;
    GetFunctions;
    if ItemIndex < FunctionBrowser.Items.Count then begin
      FunctionBrowser.ItemIndex := ItemIndex;
    end;
  end;
end;

procedure TMainFrm.XML1Click(Sender: TObject);
begin
  GetEditor.Synedit.Highlighter := SynXMLSyn1;
  StatusBar1.Panels[3].Text := (Sender as TTBItem).Caption;
end;

procedure TMainFrm.Commentselectedtext1Click(Sender: TObject);
var
  e : TEditor;
begin
  e := GetEditor;
  if Assigned(e) then begin
    e.SynEdit.SelText := '/* ' + e.SynEdit.SelText + ' */';
  end;
end;

procedure TMainFrm.scpParamsExecute(Kind: SynCompletionType;
  Sender: TObject; var AString: String; var x, y: Integer;
  var CanExecute: Boolean);
var locline, lookup: String;
    TmpX, savepos, StartX,
    ParenCounter,
    TmpLocation    : Integer;
    FoundMatch     : Boolean;
    i : integer;
begin
  with TSynCompletionProposal(Sender).Editor do
  begin
    locLine := LineText;

    //go back from the cursor and find the first open paren
    TmpX := CaretX;
    if TmpX > length(locLine) then
      TmpX := length(locLine)
    else dec(TmpX);
    FoundMatch := FALSE;
    TmpLocation := 0;
    while (TmpX > 0) and not(FoundMatch) do
    begin
      if LocLine[TmpX] = ',' then
      begin
        inc(TmpLocation);
        dec(TmpX);
      end else if LocLine[TmpX] = ')' then
      begin
        //We found a close, go till it's opening paren
        ParenCounter := 1;
        dec(TmpX);
        while (TmpX > 0) and (ParenCounter > 0) do
        begin
          if LocLine[TmpX] = ')' then inc(ParenCounter)
          else if LocLine[TmpX] = '(' then dec(ParenCounter);
          dec(TmpX);
        end;
        if TmpX > 0 then dec(TmpX);  //eat the open paren
      end else if locLine[TmpX] = '(' then
      begin
        //we have a valid open paren, lets see what the word before it is
        StartX := TmpX;
        while (TmpX > 0) and not(locLine[TmpX] in TSynValidStringChars) do
          Dec(TmpX);
        if TmpX > 0 then
        begin
          SavePos := TmpX;
          While (TmpX > 0) and (locLine[TmpX] in TSynValidStringChars) do
            dec(TmpX);
          inc(TmpX);
          lookup := Uppercase(Copy(LocLine, TmpX, SavePos - TmpX + 1));
          FoundMatch := LookupList.IndexOf(Lookup) > -1;
          if not(FoundMatch) then
          begin
            TmpX := StartX;
            dec(TmpX);
          end;
        end;
      end else dec(TmpX)
    end;
  end;

  CanExecute := FoundMatch;

  if CanExecute then
  begin
    TSynCompletionProposal(Sender).Form.CurrentIndex := TmpLocation;
    if Lookup <> TSynCompletionProposal(Sender).PreviousToken then
    begin
      TSynCompletionProposal(Sender).ItemList.Clear;

      for i := 0 to LookupList.Count - 1 do begin
        if Lookup = UpperCase(LookupList.Strings[i]) then begin
          TSynCompletionProposal(Sender).ItemList.Add(ParamList.Strings[i]);
          Break;
        end;
      end;
    end;
  end else TSynCompletionProposal(Sender).ItemList.Clear;
end;

procedure TMainFrm.FormDestroy(Sender: TObject);
begin
  OnceOnly.destroy;
  TB2KShutdownToolbar;
  if not (csDesigning in ComponentState) then
    DragAcceptFiles(Handle, FALSE);
  HHCloseAll; // Schliet alle Hilfe-Fenster
  if Assigned(mHHelp) then
    mHHelp.Free;

  if LookupList <> nil then LookupList.Free;
  if ParamList <> nil then ParamList.Free;
  if FunctionNames <> nil then FunctionNames.Free;
  if FunctionNumbers <> nil then FunctionNumbers.Free;
  ftpitems.Handle:=0;
  toOpen.Free;
end;

procedure TMainFrm.FindDialog1Find(Sender: TObject);
var
  FindStr : string;
begin
  FindDialog1.CloseDialog;
  FindStr := FindDialog1.FindText;
  settings.FindDialog1FindText:=FindDialog1.FindText;
  if GetEditor.SynEdit.SearchReplace(FindStr, '', GetFindOptions(FindDialog1)) = 0 then begin
    MessageBeep($7000);
    MessageDlg(Lang(956) + ' "' + FindStr + '" ' + Lang(957), MtInformation, [mbOK],0);
    ANextSearch.Enabled := FALSE;
  end else
    ANextSearch.Enabled := TRUE;
end;

procedure TMainFrm.ReplaceDialog1Find(Sender: TObject);
var
  FindStr : string;
begin
  FindStr := ReplaceDialog1.FindText;
  settings.ReplaceDialog1FindText:=ReplaceDialog1.FindText;
  if GetEditor.SynEdit.SearchReplace(FindStr, '', []) = 0 then begin
    MessageBeep($7000);
    MessageDlg(Lang(956) + ' "' + FindStr + '" ' + Lang(957), MtInformation, [mbOK],0);
  end;
end;

procedure TMainFrm.ReplaceDialog1Replace(Sender: TObject);
var
  FindStr : string;
  ReplaceStr : string;
  e : TEditor;
begin
  e := GetEditor;
  if Assigned(e) then begin
    FindStr := ReplaceDialog1.FindText;
    ReplaceStr := ReplaceDialog1.ReplaceText;
    if frReplaceAll in ReplaceDialog1.Options then begin
      while e.SynEdit.SearchReplace(FindStr, '', []) <> 0 do
        e.SynEdit.SelText := ReplaceStr;
    end else begin
      e.SynEdit.SelText := ReplaceStr;
    end;
  end;
end;

procedure TMainFrm.WebsiteClick(Sender: TObject);
begin
  WebBrowser.Navigate('http://devphp.sourceforge.net');
  PageControl1.ActivePageIndex := piPreview;
end;

procedure TMainFrm.FormPaint(Sender: TObject);
begin
  Self.Font.Name := settings.DialogFontText;
end;

procedure TMainFrm.syncEditorWithPath;

var s:string;
    ni:TTreeNode;
    e:TEditor;

  function friss(var s:string):string;
  var s1:string;
  begin
    while (length(s)>0) and (s[1]='\') do begin
      delete(s,1,1);
    end;
    s1:='';
    while (length(s)>0) and (s[1]<>'\')  do begin
      s1:=s1+s[1];
      delete(s,1,1);
    end;
//    if s1='\' then s1:='';
    result:=s1;
  end;

{$O-}
  procedure findNode(const node:TTreeNode;caption:string);
  var s,s1:string;
  begin
    s:=caption;
    ni:=node.getFirstChild;
    s1:=friss(s);
    while (ni<>nil) and (ni.Text<>s1) do begin
      ni:=node.GetNextChild(ni);
    end;
    if (ni<>nil) then begin
      shelltreeview1.Select(ni);
      shelltreeview1.Selected.Expand(false);
//      res:=ni;
      findNode(ni,s);
    end;
  end;
{$O+}

begin
  e:=GetEditor();
  if not assigned(e) then exit;
  s:=ExtractFilePath(e.fFileName);
  statusbar1.SimpleText:=e.fFileName;
  delete(s,1,length(shelltreeview1.Root));
//  shelltreeview1.Selected.Expand(true);
  if s='\' then begin
    shelltreeview1.Select(shelltreeview1.Items[0]);
  end else begin
    findNode(shelltreeview1.Items[0],s);
//    shelltreeview1.Select(res);
  end;
//  shelltreeview1.Refresh(shelltreeview1.Selected);
end;

procedure TMainFrm.PageControlChange(Sender: TObject);
var
  e : TEditor;

begin
//  showmessage(inttostr(pagecontrol.ActivePageIndex));
  e := GetEditor(PageControl.ActivePageIndex);
  if Assigned(e) then begin
    ASave.Enabled := not(e.modified);
    scpParams.Editor := e.SynEdit;
    EditMenuClick(Self);
    e.NameHighlighters;
    e.LoadEditorSettings;
    StatusBar1.Panels[2].Text := e.szInsert;
    StatusBar1.Panels[0].Text := Format('%12d:%4d',
      [e.SynEdit.CaretY, e.SynEdit.CaretX]);
    Self.Caption := 'Dev-PHP ' + DevPHPVer + ' - [ ' + ExtractFileName(e.fTabSheet.Caption) + ' ]';
    SyncEditorWithPath;
    with e.SynEdit do begin
      if S1.checked then
        Options:=Options + [eoShowSpecialChars] else Options:=Options - [eoShowSpecialChars]
    end;
  end;
end;

function TMainFrm.RunAndGetOutput(Cmd, WorkDir: string): string;
var
  tsi: TStartupInfo;
  tpi: TProcessInformation;
  nRead: DWORD;
  aBuf: Array[0..101] of char;
  sa: TSecurityAttributes;
  hOutputReadTmp, hOutputRead, hOutputWrite, hInputWriteTmp, hInputRead,
  hInputWrite, hErrorWrite: THandle;
  FOutput: String;
begin
  FOutput := '';

  sa.nLength              := SizeOf(TSecurityAttributes);
  sa.lpSecurityDescriptor := nil;
  sa.bInheritHandle       := True;

  CreatePipe(hOutputReadTmp, hOutputWrite, @sa, 0);
  DuplicateHandle(GetCurrentProcess(), hOutputWrite, GetCurrentProcess(),
    @hErrorWrite, 0, true, DUPLICATE_SAME_ACCESS);
  CreatePipe(hInputRead, hInputWriteTmp, @sa, 0);

  DuplicateHandle(GetCurrentProcess(), hOutputReadTmp,  GetCurrentProcess(),
    @hOutputRead,  0, false, DUPLICATE_SAME_ACCESS);
  DuplicateHandle(GetCurrentProcess(), hInputWriteTmp, GetCurrentProcess(),
    @hInputWrite, 0, false, DUPLICATE_SAME_ACCESS);
  CloseHandle(hOutputReadTmp);
  CloseHandle(hInputWriteTmp);

  FillChar(tsi, SizeOf(TStartupInfo), 0);
  tsi.cb         := SizeOf(TStartupInfo);
  tsi.dwFlags    := STARTF_USESTDHANDLES or STARTF_USESHOWWINDOW;
  tsi.hStdInput  := hInputRead;
  tsi.hStdOutput := hOutputWrite;
  tsi.hStdError  := hErrorWrite;

  CreateProcess(nil, PChar(Cmd), @sa, @sa, true, 0, nil, PChar(WorkDir),
    tsi, tpi);
  CloseHandle(hOutputWrite);
  CloseHandle(hInputRead );
  CloseHandle(hErrorWrite);
  Application.ProcessMessages;

  repeat
     if (not ReadFile(hOutputRead, aBuf, 16, nRead, nil)) or (nRead = 0) then
     begin
        if GetLastError = ERROR_BROKEN_PIPE then Break
        else MessageDlg('Pipe read error, could not execute file', mtError, [mbOK], 0);
     end;
     aBuf[nRead] := #0;
     FOutput := FOutput + PChar(@aBuf[0]);
     Application.ProcessMessages;
  until False;

  Result := FOutput;
end;

procedure TMainFrm.AnalizeOutput(List: TStringList);
var
  i, p, w, e, f : integer;
  s, t : string;
begin
  w := 0;
  e := 0;
  f := 0;
  for i := 0 to List.Count - 1 do begin
    s := List.Strings[i];
    s := Trim(s);
    p := Pos('on line <b>', s);
    t := '';
    if p <> 0 then begin
      t := s;
      Delete(t, 1, p + Length('on line <b>') - 1);
      Delete(t, pos('</b>', t), Length(t));
    end;
    p := Pos('<b>Warning</b>:  ',s);
    if p <> 0 then begin
      Inc(w);
      ProcessLine(s, t);
    end;
    p := Pos('<b>Parse error</b>:  ',s);
    if p <> 0 then begin
      Inc(e);
      ProcessLine(s, t);
    end;
    p := Pos('<b>Fatal error</b>:  ',s);
    if p <> 0 then begin
      Inc(f);
      ProcessLine(s, t);
    end;
  end;
  if (e > 0) or (f > 0) or (w > 0) then begin
    Splitter1.Visible := TRUE;
    CompilerOutput.Visible := TRUE;
  end else begin
    Splitter1.Visible := FALSE;
    CompilerOutput.Visible := FALSE;
  end;
end;

procedure TMainFrm.ProcessLine(s, l: string);
var
  ListItem: TListItem;
  p : integer;
begin
  p := pos('<b>',s);
  while p <> 0 do begin
    Delete(s,p,3);
    p := pos('<b>',s);
  end;
  p := pos('</b>',s);
  while p <> 0 do begin
    Delete(s,p,4);
    p := pos('</b>',s);
  end;
  Delete(s,pos('<br />',s),6);
  ListItem := CompilerOutput.Items.Add;
  ListItem.Caption := l;
  ListItem.SubItems.Add(s);
end;

procedure TMainFrm.CompilerOutputDblClick(Sender: TObject);
var
  e : TEditor;
begin
  if CompilerOutput.Selected <> nil then begin
    e := GetEditor;
    if Assigned(e) then begin
      e.SynEdit.CaretX := 0;
      e.SynEdit.CaretY := StrToInt(CompilerOutput.Selected.Caption);
      PageControl1.ActivePageIndex := pEdit;
      e.SynEdit.SetFocus;
    end;
  end;
end;

procedure TMainFrm.FastFTPExecute(Sender: TObject);
var path,CurrFile:string;
begin
  if pagecontrol1.ActivePageIndex=pePreview then begin
    pagecontrol1.ActivePageIndex:=pEdit;
    pagecontrol1.OnChange(sender);
  end else begin
    StatusBar1.Panels[3].Text:='save File.. ';
    GuardarExecute(sender);
    StatusBar1.Panels[3].Text:='sending.. ';
    Path:=settings.localpathText;
    idftp1.Port:=strtoint(settings.FTPPortText);
    idftp1.Host:=settings.FTPHostText;
    idftp1.Username:=settings.FTPUserText;
  //  idftp1.Password:=settings.FTPPasswordText;
    idftp1.Password:=settings.FTPPasswordSave;
    try
      try
        FtpConnect();
      except
        exit;
      end;
      changeFTPPath();
      CurrFile := GetEditor.fFileName;
      StatusBar1.Panels[3].Text:='sending '+currfile;
//      showmessage(CurrFile+' '+ExtractFilename(CurrFile));
      idftp1.Put(CurrFile,ExtractFilename(CurrFile),false);
    except
      StatusBar1.Panels[3].Text:='error sending '+currfile;
      exit;
    end;
    StatusBar1.Panels[3].Text:='end sending '+currfile;
    pagecontrol1.ActivePageIndex:=pePreview;
    pagecontrol1.OnChange(sender);
  end;
end;

procedure TMainFrm.ToolButton49Click(Sender: TObject);
begin
   PageControl1.ActivePageIndex := pDoc;
   pagecontrol1.OnChange(sender);
end;

{
procedure TEditForm.ComentarioHTML1Click(Sender: TObject);
begin
  Insertar('<!--  -->');
end;

procedure TEditForm.ComentarioPHP1Click(Sender: TObject);
begin
  Insertar('/*  */');
end;

procedure TEditForm.agPHP1Click(Sender: TObject);
begin
  Insertar('<?  ?>');
end;

procedure TEditForm.agPHPphp1Click(Sender: TObject);
begin
  Insertar('<?php  ?>');
end;

procedure TEditForm.ScriptPHP1Click(Sender: TObject);
begin
  Insertar('<SCRIPT Language="PHP">'#13
         + #13
         + '</SCRIPT>');
end;

procedure TEditForm.ComentarioPHPEstiloC1Click(Sender: TObject);
begin
  Insertar('// ');
end;

procedure TEditForm.Marcador1Click(Sender: TObject);
begin
  Insertar('<a name="Bookmark"></a>');
end;

procedure TEditForm.VnculoaMarcador1Click(Sender: TObject);
begin
  Insertar('<a href="#Marcador">Goto Bookmark</a>');
end;

}

procedure TMainFrm.Insertar(Texto: string);
begin
  getEditor.SynEdit.SelText := Texto;
  getEditor.SynEdit.SetFocus;
  getEditor.SynEdit.EnsureCursorPosVisible;
  getEditor.Modified := true;
  ASave.Enabled := true;
end;

procedure TMainFrm.insImagenExecute(Sender: TObject);
begin
  Insertar('<img src="image_url">');
end;

procedure TMainFrm.insCapaExecute(Sender: TObject);
begin
  Insertar('<div id="Layer1" style="position:absolute; width:200px; height:115px; z-index:1"></div>');
end;

procedure TMainFrm.insFormExecute(Sender: TObject);
begin
  Insertar('<form name="form1" method="post" action="">'#13#10 + ''#13#10 + '</form>');
end;

procedure TMainFrm.insTextExecute(Sender: TObject);
begin
  Insertar('<input type="text" name="text_field">');
end;

procedure TMainFrm.insButtonExecute(Sender: TObject);
begin
  Insertar('<input type="submit" name="Submit" value="Send Form">');
end;

procedure TMainFrm.insCheckExecute(Sender: TObject);
begin
  Insertar('<input type="checkbox" name="checkbox" value="checkbox">');
end;

procedure TMainFrm.insRadioExecute(Sender: TObject);
begin
  if pagecontrol1.ActivePageIndex=pHTMLEdit then begin
    form1.InsertRadioActionExecute(sender);
  end else begin
    Insertar('<input type="radio" name="radiobutton" value="radiobutton">');
  end;
end;

procedure TMainFrm.insListExecute(Sender: TObject);
begin
  Insertar('<select name="select">'#13#10 + ''#13#10 + '</select>');
end;

procedure TMainFrm.InsImageExecute(Sender: TObject);
begin
  Insertar('<input type="file" name="file">');
end;

procedure TMainFrm.insImgExecute(Sender: TObject);
begin
  Insertar('<input type="image" border="0" name="image_field" src="image_url">');
end;

procedure TMainFrm.insHiddenExecute(Sender: TObject);
begin
  Insertar('<input type="hidden" name="hidden_field">');
end;

procedure TMainFrm.insIncExecute(Sender: TObject);
begin
  Insertar('<!--#include virtual="file_url" -->');
end;

procedure TMainFrm.insMailExecute(Sender: TObject);
begin
  Insertar('<a href="mailto:mail@domain.com">Write Email</a>');
end;

procedure TMainFrm.insHRExecute(Sender: TObject);
begin
  Insertar('<hr>');
end;

procedure TMainFrm.insBRExecute(Sender: TObject);
begin
  Insertar('<br>');
end;

procedure TMainFrm.insDateExecute(Sender: TObject);
var s:string;
begin
  DateTimeToString(s,'DD.MM.YYYY t',now());
  Insertar(s);
end;

procedure TMainFrm.Indent1Click(Sender: TObject);
var e:TSynEdit;
    linestart,lineend,lauf,lauf2,i:integer;
    bb,be:TBufferCoord;
begin
  e:=getEditor.SynEdit;
  bb:=e.BlockBegin; be:=e.BlockEnd;
  linestart:=e.BlockBegin.Line-1;
  if e.BlockEnd.Char=1 then i:=2 else i:=1;
  lineend:=e.BlockEnd.Line-i;
  if lineend<linestart then lineend:=linestart;
  for lauf:=linestart to lineend do begin
    for lauf2:=1 to e.TabWidth do begin
      e.Lines[lauf]:=' '+e.Lines[lauf];
    end;
  end;
  e.Modified:=true;
  getEditor.modified:=false;
  e.BlockBegin:=bb; e.BlockEnd:=be;
end;

procedure TMainFrm.DeIndent1Click(Sender: TObject);
var e:TSynEdit;
    linestart,lineend,lauf,lauf2,i:integer;
    s:string;
    bb,be:TBufferCoord;
begin
  e:=getEditor.SynEdit;
  bb:=e.BlockBegin; be:=e.BlockEnd;
  linestart:=e.BlockBegin.Line-1;
  if e.BlockEnd.Char=1 then i:=2 else i:=1;
  lineend:=e.BlockEnd.line-i;
  if lineend<linestart then lineend:=linestart;
  for lauf:=linestart to lineend do begin
    s:=e.Lines[lauf];
    for lauf2:=1 to e.TabWidth do begin
      if (ord(s[1])=ord(' ')) then begin
        delete(s,1,1);
      end;
    end;
    e.Lines[Lauf]:=s;
  end;
  e.Modified:=true;
  e.BlockBegin:=bb; e.BlockEnd:=be;
end;

procedure TMainFrm.ShellListView1DblClick(Sender: TObject);
var s:string;
    cr:boolean;
    i:integer;
begin
  if (lowercase(ExtractFileExt(shelllistview1.SelectedFolder.PathName))='.jpg')
    or (lowercase(ExtractFileExt(shelllistview1.SelectedFolder.PathName))='.png')
    or (lowercase(ExtractFileExt(shelllistview1.SelectedFolder.PathName))='.gif')
    then begin
    shellexecute(0,'open',PChar(shelllistview1.selectedFolder.pathname),'','',SW_SHOW);
    exit;
  end;
  if not ShellListView1.SelectedFolder.IsFolder then begin
    s:=ShellListView1.selectedFolder.PathName;
    if pagecontrol1.ActivePageIndex=pHtmlEdit then begin
      form1.loadfile(s);
    end else begin
      PageControl1.ActivePageIndex:=pEdit;
      cr:=true;
      for i := PageControl.PageCount - 1 downto 0 do begin
        if GetEditor(i).fFileName=s then begin
          pageControl.ActivePageIndex:=i; cr:=false;
        end;
      end;
      if cr then begin
        OpenFile(sender,s);
      end;
    end;
  end;
end;

procedure TMainFrm.ShellListView1KeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
var lauf:integer;
begin
  if Key=VK_DELETE then begin
     for lauf:=0 to shelllistview1.SelCount-1 do begin
        SysUtils.DeleteFile(shelllistview1.selectedFolder.PathName);
//        shelllistview1.Selected.Selected:=false;
     end;
     shelllistview1.Refresh;
  end;
  if key=VK_F5 then shelllistview1.Refresh;
//  end;
end;

procedure TMainFrm.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if Key=VK_ESCAPE then begin
    PageControl1.ActivePageIndex:=pEdit;
  end;
end;

function TMainFrm.ChangeFTPPath():boolean;
var command,s,sftp:string;
    lauf:integer;
begin
  result:=true;
  if not idftp1.connected then idftp1.connect;
  sftp:=idftp1.RetrieveCurrentDir;
  if sftp<>'/' then sftp:=sftp+'/';
  command:=settings.FTPServerPathText;
  lauf:=4;
  s:=command;
  while lauf>1 do begin
    if s[1]='/' then dec(lauf);
    delete(s,1,1);
  end;
  command:=s;
  s:=shelltreeview1.SelectedFolder.PathName;
  delete(s,1,length(shelltreeview1.Root));
  s:=stringreplace(s,'\','/',[rfReplaceAll]);
  if (length(s)>0) then begin
    if (s[1]='/') then delete(s,1,1);
    if (s[length(s)]<>'/') then s:=s+'/';
  end;
  currFTPPath:='/'+Command+s;
//  showmessage(currFTPPath);
  try
    idftp1.ChangeDir(currFTPPath);
  except
    on e:EIdProtocolReplyError do begin
      if e.ReplyErrorCode=550 then begin
        delete(currFTPPath,length(currFTPPath),1);
        while currFTPPath[length(currFTPPath)]<>'/' do begin
          delete(currFTPPath,length(currFTPPath),1);
        end;
        idftp1.ChangeDir(currFTPPath);
        if (shelltreeview1.selectedFolder.DisplayName<>'') then begin
          if MessageDlg(s+' not exists. Can I create?',
            mtConfirmation, [mbOK,mbCancel], 0) = mrOk then begin
            idftp1.MakeDir(shelltreeview1.selectedFolder.DisplayName);
            idftp1.ChangeDir(shelltreeview1.selectedFolder.DisplayName);
          end else begin
            result:=false;
          end;
        end;
      end;
    end;
  end;
  sftp:=idftp1.RetrieveCurrentDir;
end;

procedure TMainFrm.PageControl1Change(Sender: TObject);
var
  Temp,s,s1                       : string;
  lauf, NewTab                    :integer;
  e                               :TEditor;
  Command, so         :OleVariant;
  refreshBrowser                  :boolean;

  begin
  NewTab:=pagecontrol1.activePageIndex;
  case NewTab of
  pHtmlEdit:  begin
        exit;
{        if not assigned(Form1) then begin
          application.CreateForm(TForm1,Form1);
          form1.Parent:=Tabsheet9;
          form1.Align:=alClient;
          form1.show;
        end; }
      end;
  pBrowser:  begin
        if webbrowser3.LocationURL<>browserpath.Text then begin
          command:=browserpath.Text;
          webbrowser3.Navigate2(command);
        end;
      end;
  pDoc:  begin // view documentation
        if firstSearch then SearchDocumentationClick(sender);
      end;   
  pFtp:  begin
        listview.Clear;
        application.ProcessMessages;
        if not idftp1.Connected then ftpconnect();
        if idftp1.Connected then begin
          changeFTPPath();
          showFTP;
        end;
        MainFrm.StatusBar1.SetFocus;
        panel4.caption:='0';
      end;
  pEPreview:  begin
        e:=getEditor();
        if not assigned(e) then exit;
        s:=getEditor.fFileName;
        command:=shelltreeview1.Root;
        delete(s,1,length(command));
        if s[1]='\' then delete(s,1,1);
        InternalPreview := TRUE;
        Command := settings.ExternPath;
        Command:=Command+s;
        refreshBrowser:=webbrowser1.LocationURL=command;
        BrowserActiveFlag:=true;
        if refreshBrowser then begin
          statusbar1.Panels[3].Text:='retrieve: '+command;
          webbrowser1.Refresh
        end else WebBrowser1.Navigate2(Command);
        StatusBar1.SetFocus;
      end;
  pIPreview:  begin
        if not FileExists(gsettings.Edit1Text) then begin
          showmessage('Parser not found'); exit;
        end;
        e:=getEditor();
        if not assigned(e) then exit;
        getEditor.SaveFile(false);
        CompilerOutput.Visible := false;
        s:=getEditor.fFileName;
        delete(s,1,length(shelltreeview1.Root));
        stringreplace(s,'\','/',[rfReplaceAll]);
        InternalPreview := TRUE;
        s1:='http://localhost:'+inttostr(webserv1.Port)+'/'+s;
        for lauf:=1 to length(s1) do if s1[lauf]='\' then s1[lauf]:='/';
        so:=s1;
        webserv1.PHPExe:=gsettings.Edit1Text;
        webserv1.Filename:=s;
         if webbrowser.LocationURL<>so then webbrowser.Navigate2(so) else webbrowser.Refresh;
//        MainFrm.StatusBar1.SetFocus;
      end;
  pEdit:  begin
        e:=getEditor();
        if not assigned(e) then exit;
        InternalPreview := FALSE;
        if WebBrowser.LocationName = '~out.html' then begin
          Temp := WebBrowser.LocationURL;
          Delete(Temp, 1, 8);
          if FileExists(Temp) then begin
            Sysutils.DeleteFile(Temp);
          end;
        end;
        if PageControl.PageCount > 0 then begin
          GetEditor.SynEdit.SetFocus;
        end;
      end;
  else
  end;
end;

//const cfname=55;

function CustomSortProc(Item1, Item2: TListItem; ParamSort: integer): integer; stdcall;
var r:integer;
begin
  r:=0;
//  showmessage(Item1.SubItems.Text);
  if (item1.ImageIndex=mainfrm.FolderIcon) and not(item2.ImageIndex=mainfrm.FolderIcon)then r:=-1;
  if (item2.ImageIndex=mainfrm.FolderIcon) and not(item1.ImageIndex=mainfrm.FolderIcon)then r:=1;
  if (item1.ImageIndex=mainfrm.FolderIcon) and (item2.ImageIndex=mainfrm.FolderIcon) then begin
    r := CompareText(Item1.Caption,Item2.Caption);
  end;
  if not(item1.ImageIndex=mainfrm.FolderIcon) and not(item2.ImageIndex=mainfrm.FolderIcon) then begin
    r := CompareText(Item1.Caption,Item2.Caption);
  end;
//  showmessage(inttostr(item1.imageindex)+' '+item1.Caption+'  '+inttostr(r)+'  '+item2.Caption+' '+inttostr(item2.imageindex));
  result:=r;
end;

procedure TMainFrm.showFTP;
var n,s,sftp:string;
    i:integer;
    ListItem: TListItem;
    info:TShFileInfo;
begin
  listview.Clear;
  idftp1.List(ftplist);
  for i:=0 to ftplist.Count-1 do begin
    n:=copy(ftplist[i],strtoint(settings.ftpcfname)+1,
        length(ftplist[i])-strtoint(settings.ftpcfname)+1);
    if (n[1]='.') then begin
    end else begin
      ListItem := ListView.Items.Add;
      listItem.Data:=pchar(ftplist[i]);
      listItem.Caption:=n;
      if ftplist[i][1]='d' then begin
        ShGetFileInfo(PAnsiChar(listitem.caption),FILE_ATTRIBUTE_DIRECTORY,
          info,SizeOf(info),
          SHGFI_SYSICONINDEX +
          SHGFI_USEFILEATTRIBUTES +
          SHGFI_ATTRIBUTES +
          0
          );
          FolderIcon:=info.iicon;
      end else begin
        ShGetFileInfo(PAnsiChar(listitem.caption),FILE_ATTRIBUTE_NORMAL,
          info,SizeOf(info),
          SHGFI_SYSICONINDEX +
          SHGFI_USEFILEATTRIBUTES +
          SHGFI_EXETYPE +
          SHGFI_ATTRIBUTES +
          SHGFI_TYPENAME +
//          SHGFI_ICON +
          0
          );
      end;
      listitem.imageIndex:=info.iIcon;
    end;
  end;
  Listview.CustomSort(@CustomSortProc,0);
  listview.Update;
  s:=settings.FTPServerPathText;
  sftp:=idftp1.RetrieveCurrentDir;
  delete(s,length(s),1);
  label1.Caption:='ftp://'+settings.FTPHostText+sftp;
end;

procedure TMainFrm.splitFTPMessage(st:string;var t:TFTPInfo);

  function getMonat(s1:string):integer;
  var s:string;
  begin
    s:=Copy(s1,1,3);
    result:=1;
    if s='Jan' then result:=1;
    if s='Feb' then result:=2;
    if s='Mar' then result:=3;
    if s='Apr' then result:=4;
    if s='May' then result:=5;
    if s='Jun' then result:=6;
    if s='Jul' then result:=7;
    if s='Aug' then result:=8;
    if s='Sep' then result:=9;
    if s='Oct' then result:=10;
    if s='Nov' then result:=11;
    if s='Dez' then result:=12;
  end;

  function getTag(s1:string):integer;
  var s:string;
  begin
    s:=copy(s1,5,2);
    result:=strtoint(s);
  end;

  function getYear(s1:string):integer;
  var s:string;
  begin
    s:=copy(s1,8,5);
    if pos(':',s)>0 then result:=yearof(date) else result:=strtoint(s);
  end;

  function getHour(s1:string):integer;
  var s:string;
  begin
    s:=copy(s1,8,5);
    result:=0;
    if pos(':',s)>0 then begin
      s:=copy(s,1,2);
      result:=strtoint(s);
    end;
  end;

  function getMinute(s1:string):integer;
  var s:string;
  begin
    s:=copy(s1,8,5);
    result:=0;
    if pos(':',s)>0 then begin
      s:=copy(s,4,2);
      result:=strtoint(s);
    end;
  end;


begin
  if st='' then raise EStringInvalid.create('String fault');
  t.isdir:=st[1]='d';
  t.name:=trim(copy(st,strtoint(settings.ftpcfname)+1,length(st)-strtoint(settings.ftpcfname)+1));
end;

procedure TMainFrm.delDir(folder:string);
begin
end;

procedure TMainFrm.walkTree(OnWalk:TWalkProc;
    OnDirChange:TWalkFolderProc;OnDirUp:TWalkFolderProc);
var i:integer;
    tp:TFTPInfo;
    ls:TStringList;
begin
  ls:=TstringList.Create;
  idftp1.List(ls);
  ls.Sort;
  for i:=ls.Count-1 downto 0 do begin
    splitFTPMessage(ls[i],tp);
    if tp.isdir then begin
      if tp.name[1]<>'.' then begin
        idftp1.ChangeDir(tp.name);
        if assigned(OnDirChange) then OnDirChange(tp.name);
        walktree(OnWalk,OnDirChange,OnDirUp);
        idftp1.ChangeDir('..');
        if assigned(OnDirUp) then OndirUp(tp.name);
      end;
    end else begin
      if assigned(OnWalk) then OnWalk(tp);
    end;
  end;
  ls.Free;
end;

procedure TMainFrm.delWalk(tp:tftpinfo);
begin
  memo1.Lines.Add(lang(2005)+tp.name);
  try
    idftp1.delete(tp.name);
  except
  end;
end;

procedure TMainFrm.delDirUp(folder:string);
begin
    memo1.Lines.Add(lang(2016)+folder );
    try
      idftp1.RemoveDir(folder);
    except
    end;
end;

procedure TMainFrm.MenuItem2Click(Sender: TObject);
var t:TListItem;
    ti:TFtpInfo;
    oldname,ftppath:string;
    sp:Pchar;
begin
  memo1.Clear;
  if not idftp1.Connected then exit;
  if MessageDlg(lang(2009), mtConfirmation, [mbOK,mbCancel], 0) = mrCancel then exit;
  if listview.SelCount>0 then
  begin
    oldname:=shellTreeView1.path;
    ftppath:=idftp1.RetrieveCurrentDir;
    t:=listview.Selected;
    while t<>nil do begin
      sp:=t.data;
      splitFTPMessage(sp,ti);
      t:=listview.GetNextItem(t,sdAll, [isSelected]);
      if ti.isdir then begin
        try
          memo1.Lines.Add(lang(2015)+ftppath);
          idftp1.ChangeDir(ti.name);
          delDir(ti.name);
          try
            walktree(delWalk,delDir,delDirUp);
          except
          end;
          idftp1.ChangeDir('..');
          delDirUp(ti.name);
          memo1.Lines.Add(lang(2014)+ti.name);
          try
            idftp1.RemoveDir(ti.name);
          except
          end;
          memo1.Lines.Add(lang(2006));
        except
          memo1.Lines.Add(lang(2007));
        end;
      end else begin
        memo1.Lines.Add(lang(2013)+ti.name);
        try
          idftp1.Delete(ti.name);
        except
          memo1.Lines.Add(lang(2008));
        end;
      end;
    end;
    idftp1.ChangeDir(ftppath);
    showftp;
  end;
end;

procedure TMainFrm.FileLook(Filespec:string);
//filespec must contain the full path ie. c:\folder\*.* or c:\folder\this.txt
var validres:integer;
    res:boolean;
    SearchRec : TSearchRec;
    DirPath, FullName, Flname : string;
begin
  DirPath:=ExtractFilePath(FileSpec);
  res:= DirectoryExists(DirPath);
  If not res then exit;
  Flname:=ExtractFileName(FileSpec);
  validres := FindFirst(FileSpec, faAnyFile, SearchRec);
  while validres=0 do begin
    If (SearchRec.Name[1] <> '.') then begin
      FullName:=DirPath + LowerCase(SearchRec.Name);
      If (SearchRec.Attr and faDirectory > 0) then begin
        memo1.Lines.Add(lang(2019)+FullName);
        idftp1.MakeDir(SearchRec.Name);
        idftp1.ChangeDir(searchRec.Name);
        FileLook(FullName+'\'+ Flname);
        idftp1.ChangeDir('..');
        memo1.Lines.Add(lang(2018));
      end else begin
        memo1.Lines.Add(lang(2020)+fullname);
        showmessage(Fullname+' '+searchRec.Name);
        idftp1.Put(Fullname,searchRec.Name);
      end;
    end;
    validres:=FindNext(SearchRec);
  end;
end;

procedure TMainFrm.Send1Click(Sender: TObject);
var i:integer;
begin
  pagecontrol1.ActivePageIndex:=pftp;
  if not idftp1.Connected then idftp1.Connect;
  changeFTPPath();
  memo1.Clear;
  for I :=0 to ShellListView1.Items.Count -1 do
  if ShellListView1.Items.Item[I].Selected then begin
    if shelllistview1.Folders[i].IsFolder then begin
      memo1.Lines.Add(lang(2019)+shelllistview1.Folders[i].PathName);
      idftp1.MakeDir(shelllistview1.Folders[i].DisplayName);
      idftp1.ChangeDir(shelllistview1.Folders[i].DisplayName);
      FileLook(shelllistview1.Folders[i].PathName+'\*.*');
      idftp1.ChangeDir('..');
      memo1.Lines.Add(lang(2018));
    end else begin
      memo1.Lines.Add(lang(2017)+shelllistview1.Folders[i].PathName+' '+ShellListView1.Folders[I].DisplayName);
      panel4.caption:='0';
      idftp1.Put(shelllistview1.Folders[i].PathName,ShellListView1.Folders[I].DisplayName);
    end;
  end;
  showftp;
  panel4.caption:='0';
end;


procedure TMainFrm.Send2Click(Sender: TObject);
var i:integer;
begin
  FtpConnect();
  changeFTPPath();
  memo1.Clear;
  for I :=0 to ShellTreeview1.Items.Count -1 do
  if ShellTreeview1.Items.Item[I].Selected then begin
    if ShellTreeview1.Folders[i].IsFolder then begin
      memo1.Lines.Add(lang(2019)+ShellTreeview1.Folders[i].PathName);
      idftp1.MakeDir(ShellTreeview1.Folders[i].DisplayName);
      idftp1.ChangeDir(ShellTreeview1.Folders[i].DisplayName);
      FileLook(ShellTreeview1.Folders[i].PathName+'\*.*');
      idftp1.ChangeDir('..');
      memo1.Lines.Add(lang(2018));
    end;
  end;
  showftp;
  panel4.caption:='0';
end;

procedure TMainFrm.delete1Click(Sender: TObject);
var I:integer;
begin
  if MessageDlg(lang(2009), mtConfirmation, [mbOK,mbCancel], 0) = mrCancel then exit;
  for I :=0 to ShellListView1.Items.Count -1 do
  if ShellListView1.Items.Item[I].Selected then begin
    if shelllistview1.Folders[i].IsFolder then begin
      showmessage(shelllistview1.Folders[i].PathName);
    end else begin
      SysUtils.DeleteFile(shelllistview1.Folders[i].PathName);
//      memo1.Lines.Add(lang(2017)+shelllistview1.Folders[i].PathName+' '+ShellListView1.Folders[I].DisplayName);
//      idftp1.Put(shelllistview1.Folders[i].PathName,ShellListView1.Folders[I].DisplayName);
    end;
  end;
  shelllistview1.Refresh;
  application.ProcessMessages;
  shelltreeview1.Items[0].Text:=shelltreeview1.Root;
end;

procedure TMainFrm.getDir(folder:string);
begin
  if folder[1]='/' then delete(folder,1,1);
  currPath:=currPath+'\'+folder;
  ForceDirectories(currPath);
  memo1.Lines.Add(lang(2019)+idftp1.RetrieveCurrentDir+lang(2023)+currPath);
end;

procedure TMainFrm.getWalk(tp:tftpinfo);
begin
  memo1.Lines.Add(lang(2024)+tp.name);
  try
    panel4.Caption:='0';
    idftp1.Get(tp.name,currPath+'\'+tp.name,true);
  except
  end;
end;

procedure TMainFrm.getDirUp(folder:string);
begin
  while currPath[length(currPath)]<>'\' do delete(currPath,length(currPath),1);
  if length(currPath)>3 then delete(currPath,length(currPath),1);
  memo1.Lines.Add(lang(2019)+idftp1.RetrieveCurrentDir+lang(2023)+currPath);
end;


procedure TMainFrm.MenuItem1Click(Sender: TObject);
var t:TListItem;
    ti:TFtpInfo;
    oldname,ftppath:string;
    sp:Pchar;
begin
  if not idftp1.Connected then exit;
  memo1.Clear;
  if listview.SelCount>0 then
  begin
    currpath:=shelltreeview1.selectedFolder.PathName;
    oldname:=shelltreeview1.path;
    ftppath:=idftp1.RetrieveCurrentDir;
    t:=listview.Selected;
    while t<>nil do begin
      sp:=t.data;
      splitFTPMessage(sp,ti);
      if ti.isdir then begin
        try
          memo1.Lines.Add(lang(2015)+ftppath);
          memo1.Lines.Add(lang(2022)+ti.name);
//          showmessage(currpath+'  - '+ftppath+' - '+ti.name);
          try
            idftp1.ChangeDir(ftppath+'/'+ti.name);
          except
          end;
          getDir(ti.name);
          walktree(getWalk,getDir,getDirUp);
          idftp1.ChangeDir(ftppath);
          getDirUp(ti.name);
          memo1.Lines.Add(lang(2021));
        except
          memo1.Lines.Add(lang(2008));
        end;
        DoTreeRefresh(sender,true);
      end else begin
        memo1.Lines.Add(lang(2024)+ti.name);
        try
          panel4.caption:='0';
          idftp1.Get(ti.name,shelltreeview1.selectedFolder.PathName+'\'+ti.name,true);
        except
          memo1.Lines.Add(lang(2008));
        end;
      end;
      // next item
      t:=listview.GetNextItem(t,sdAll, [isSelected]);
    end;
    shelltreeview1.Path:=oldname;
//    shelllistview1.Refresh;
//    shelltreeview1.Refresh(shelltreeview1.Selected.Parent);
  end;
end;

procedure TMainFrm.MenuItem3Click(Sender: TObject);
var val:string;
begin
  if not idftp1.Connected then exit;
  val:=lang(2012);
  if InputQuery(lang(2010),lang(2011),val)then begin
    idftp1.MakeDir(val);
    showftp;
  end;
end;

procedure TMainFrm.ListViewDblClick(Sender: TObject);
var s:Pchar;
    lauf:integer;
    t:TTreeNode;
begin
  t:=nil;
  if listview.SelCount=0 then exit;
  s:=listview.Selected.Data;
  if s[0]='d' then begin
    for lauf:=0 to shelltreeview1.Items.Count-1 do begin
      if LowerCase(shelltreeview1.Folders[lauf].PathName)=
         LowerCase(shelltreeview1.Path+'\'+listview.Selected.Caption) then begin
           shelltreeview1.Items[lauf].Expand(false);
           t:=shelltreeview1.Items[lauf];
         end;
    end;
    if assigned(t) then begin
      t.Parent.Expand(false);
      shellTreeview1.Select(t);
      t.Expand(false);
    end;
  end;
end;

procedure TMainFrm.ShellTreeView1Changing(Sender: TObject;
  Node: TTreeNode; var AllowChange: Boolean);
begin
//  showmessage('ShellTreeView1Change');
//  shelltreeview1.Items[0].Text:=shelltreeview1.Root;
end;

function delFile(const filename:string;searchstr:string):Boolean;
begin
  result:=SysUtils.DeleteFile(filename);
end;

procedure TMainFrm.delete2Click(Sender: TObject);
var s:string;
begin
  if shelltreeview1.Items[0]=shelltreeview1.Selected then exit;
  s:=shelltreeview1.selectedFolder.PathName;
  shelltreeview1.Select(shelltreeview1.Selected.Parent);
//  shelltreeview1 as TTreeView1.collapse(shelltreeview1.selected.parent);
  searchdir(s,'',delFile);
  shelltreeview1.Refresh(shelltreeview1.TopItem);
end;

procedure TMainFrm.ShellTreeView1Change(Sender: TObject; Node: TTreeNode);
//var n:TTreeNode;
begin
  if (pagecontrol1.ActivePageIndex=3) and (assigned(settings)) then begin
//    showmessage('change');
//    shelltreeview1.Items[0].Text:=shelltreeview1.Root;
//    if shelltreeview1.selectedFolder.DisplayName<>'' then begin
//      currLocalPath:=shelltreeview1.selectedfolder.PathName;
//      delete(currLocalPath,1,length(shelltreeview1.Root));
//    end else currLocalPath:='';
//    shelltreeview1.Selected.Expand(false);
//    application.ProcessMessages;
    try
//      n:=shelltreeview1.Selected.Parent;
      if pagecontrol1.ActivePage=TabSheet4 then begin
        if idftp1.Connected then begin
          if not changeFTPPath()then begin
//            shelltreeview1.Select(n);
//            application.ProcessMessages;
//            shelltreeview1.Refresh(shelltreeview1.TopItem);
          end;
          showftp;
        end;
      end;
    except
    end;
  end;
end;

procedure TMainFrm.Explorer1Click(Sender: TObject);
var s:PChar;
begin
  s:=Pchar(shelltreeview1.SelectedFolder.PathName);
  shellexecute(0,PChar('open'),s,Pchar(''),s,SW_SHOW);
end;

procedure TMainFrm.Refresch1Click(Sender: TObject);
begin
  shelltreeview1.refresh(shelltreeview1.TopItem);
end;

procedure TMainFrm.Timer1Timer(Sender: TObject);
var i:integer;
begin
  if panel4.Caption='120' then begin
    panel4.Caption:='0';
    if idftp1.connected then showftp;
  end else begin
    i:=strtoint(panel4.caption);
    panel4.caption:=inttostr(i+1);
  end;
end;

procedure TMainFrm.WebBrowser1NavigateComplete2(Sender: TObject;
  const pDisp: IDispatch; var URL: OleVariant);
begin
  BrowserActiveFlag:=false;
end;

procedure TMainFrm.ToolButton50Click(Sender: TObject);
begin
  SaveDialog.FileName := 'project.prd';
  if SaveDialog.Execute then begin
    uinifile.SaveIniFile(SaveDialog.FileName);
    gsettings.LastProject:=SaveDialog.FileName;
  end;
end;

procedure TMainFrm.LoadProject(filename:String);
var list:TStringList;
    i:integer;
    TempIndex:integer;
begin
  if Filename='' then exit;
  if pagecontrol.PageCount>0 then closeall;
  gsettings.LastProject:=Filename;
  uIniFile.IniFileName:=FileName;
  uIniFile.LoadIniFile;
  if settings.SaveSessionChecked then begin
    List := TStringList.Create;
    List.Text:=settings.session.Text;
    for i := 0 to List.Count-1 do begin
      OpenFile(self,List[i]);
    end;
    List.Free;
    TempIndex := settings.SessionActive;
    if (TempIndex < PageControl.PageCount) and (TempIndex > -1) then begin
      PageControl.ActivePageIndex := TempIndex;
    end;
  end;
  ReadLangFile;
  Application.ProcessMessages;
  ActivarBotones(TRUE);
  CreateHighlighters(SynPHPSyn,SynCSSSyn1,SynJScriptSyn1,SynSQLSyn1);
  webserv1.Active:=false;
  webserv1.Port:=strtoint(settings.localPortText);
  webserv1.RootPath:=settings.localpathText;
  webserv1.PHPExe:=gsettings.Edit1Text;
  webserv1.Active:=true;
  WebBrowser.Navigate('about:blank');
  ShellTreeView1.Root:=settings.localpathText;
  ShellTreeView1.TopItem.Text:=ShellTreeView1.Root;
  shellListview1.Columns[0].Width:=shelllistview1.Width-3;
  BarradeEstado1.Checked := gsettings.StatusBar1visible;
  StatusBar1.Visible:=gsettings.StatusBar1visible;
  BarradeHerramientas1.Checked := gsettings.toolbar1visible;
  visibleBar('ToolBar',gsettings.toolbar1visible);
  MHTMLBar.Checked := gsettings.htmlbar1visible;
  visibleBar('HTMLBar',gsettings.toolbar1visible);
  SyncEditorWithPath;
end;

procedure TMainFrm.ToolButton51Click(Sender: TObject);
begin
  if OpenDialog.Execute then begin
    LoadProject(opendialog.FileName);
  end;
end;

procedure TMainFrm.Close1Click(Sender: TObject);
begin
  CerrarExecute(Sender);
end;

procedure TMainFrm.BrowserPathKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if key=VK_RETURN then begin
      webbrowser3.Navigate(browserpath.text);
  end;
end;

procedure TMainFrm.Button1Click(Sender: TObject);
begin
  panel4.Caption:='0';
  if button1.Caption='connect' then begin
    if idftp1.Connected then begin
      FtpDisconnect;
    end;
    try
      FTPConnect();
      changeFTPPath();
      showftp;
    except
    end;
  end else begin
    try
      ftpDisconnect;
    except
    end;
  end;
end;

procedure TMainFrm.IdFTP1Connected(Sender: TObject);
begin
  panel4.Color:=clRed;
  button1.Caption:='disconnect';
  label1.Caption:='connecting..';
  timer1.enabled:=true;
end;

procedure TMainFrm.IdFTP1Disconnected(Sender: TObject);
begin
  panel4.Color:=clBtnFace;
  button1.Caption:='connect';
  label1.Caption:='not connected ..';
  timer1.enabled:=false;
end;

procedure TMainFrm.WebBrowser2DocumentComplete(Sender: TObject;
  const pDisp: IDispatch; var URL: OleVariant);
begin
  doc_complete:=true;
end;

procedure TMainFrm.FormDragDrop(Sender, Source: TObject; X, Y: Integer);
begin
  showmessage('drop');
end;

procedure TMainFrm.WMDropFiles(var Msg: TMessage);
var
  i, iNumberDropped: integer;
  szPathName: array[0..260] of char;
  Point: TPoint;
  FilesList: TStringList;
  x:integer;
  exists:boolean;
  e:TEditor;
begin
  try
//    if Assigned(fOnDropFiles) then begin
      FilesList := TStringList.Create;
      try
        iNumberDropped := DragQueryFile(THandle(Msg.wParam), Cardinal(-1),
          nil, 0);
        DragQueryPoint(THandle(Msg.wParam), Point);

        for i := 0 to iNumberDropped - 1 do begin
          DragQueryFile(THandle(Msg.wParam), i, szPathName,
            SizeOf(szPathName));
          FilesList.Add(szPathName);
          Exists:=FALSE;
          for x := 0 to PageControl.PageCount - 1 do begin
            if szPathName = GetEditor(x).fFileName then begin
              Exists := TRUE;
              Break;
            end;
          end;
          if Exists = False then begin
            e := TEditor.Create;
            e.Init(szPathName, TRUE);
            AgregarHistorial(szPathName);
            GuardarHistorial(szPathName);
          end else begin
            MessageDlg('File "' + szPathName + '" is already open. Use "Reload Current File" to reload it.', mtError, [mbOk], 0);
          end;

        end;
//        fOnDropFiles(Self, Point.X, Point.Y, FilesList);
      finally
        FilesList.Free;
      end;
 //   end;
  finally
    Msg.Result := 0;
    DragFinish(THandle(Msg.wParam));
  end;
end;
procedure TMainFrm.S1Click(Sender: TObject);
var e:TEditor;
begin
  if PageControl.Pagecount>0 then begin
    e:=getEditor(pagecontrol.ActivePageIndex);
    with e.SynEdit do begin
      if S1.checked then
        Options:=Options + [eoShowSpecialChars] else Options:=Options - [eoShowSpecialChars]
    end;
  end;
end;

procedure TMainFrm.edit1Click(Sender: TObject);
begin
  AutoTextFrm := TAutoTextFrm.Create(Self);
  with AutoTextFrm do
  try
     ShowModal;
  finally
    Free;
  end;
  DBGrid1.datasource.Dataset.close;
  DBgrid1.datasource.dataset.open;
end;

procedure TMainFrm.DBGrid1DblClick(Sender: TObject);
var e:TEditor;
    opt:TSynSearchOptions;
begin
  e:=GetEditor();
  e.SynEdit.selText:=clientdataset1.fieldbyname('text').asstring;
  e.SynEdit.SetFocus;
  opt:=[ssoBackwards,ssoReplace];
  e.SynEdit.SearchReplace(frmAutoText.cursorstr,'',opt)
end;

function TMainFrm.GotoClass(item:TTreeNode;Sender:TObject):string;
var p:TTreeNode;
begin
  p:=item;
  while assigned(p.parent) do begin
    if p.parent.text<>'class' then begin
      p:=p.parent;
    end else begin  break;
    end;
  end;
  if p.Parent=nil then exit;
  if p.parent.text='class' then result:=('class '+p.text) else result:='';
end;

procedure TMainFrm.Button2Click(Sender: TObject);
var pars:TParse;
    classes,rvars,rfunc,vars,functions,classname:TTreeNode;
    s:string;
    bracketcount:integer;

  procedure addNode(lastChar:string;node:TTreeNode);
  begin
      s:=pars.getNextWord(false);
      while pos(lastchar,s)=0 do begin
        s:=s+pars.getNextWord(true);
      end;
      treeview11.items.addChild(node,s);
  end;

begin
  pars:=TParse.create();
  treeview11.items.clear;
  classes:=treeview11.items.addNode(nil,nil,'class',nil,naadd);
  rfunc:=treeview11.items.addNode(nil,nil,'function',nil,naadd);
  rvars:=treeview11.items.addNode(nil,nil,'var',nil,naadd);
  pars.parsedStr:=GetEditor.Synedit.lines.text;
  treeview11.filename:=GetEditor.ffilename;
  s:=pars.getNextWord(false);
  while not pars.fertig do begin
    if (s='<?php') or (s='<?') then begin
    end;
    if (s='class') and (pars.getPreviewChar(1,false)<>'=') then begin
      s:=pars.getNextWord(false);
      classname:=treeview11.items.addChild(classes,s);
      vars:=treeview11.items.addChild(classname,'var');
      functions:=treeview11.items.addChild(classname,'function');
      bracketcount:=-1;
      while not pars.fertig and (bracketcount<>0) do begin
        if s='function' then addNode(')',functions);
        if s='var' then addNode(';',vars);
        if s='{' then if bracketcount=-1 then bracketcount:=1 else inc(bracketcount);
        if s='}' then dec (bracketcount);
        s:=pars.getnextword(false);
      end;
    end;
    if s='function' then addNode(')',rfunc);
    if s='var' then addNode(';',rvars);
    s:=pars.getnextword(false);
  end;
  pars.free;
  treeview11.fullexpand;
end;

procedure TMainFrm.TreeView11Change(Sender: TObject; Node: TTreeNode);
var s:string;
    e:TEditor;
    i:integer;
    classsearch:boolean;
begin
  s:='';
  for i := PageControl.PageCount - 1 downto 0 do begin
    if GetEditor(i).fFileName=TreeView11.filename then begin
      pageControl.ActivePageIndex:=i;
    end;
  end;
  e:=GetEditor;
  classsearch:=false;
  if assigned(treeview11.selected.parent) then begin
    if treeview11.selected.parent.text='class' then begin
      s:='class '; classsearch:=true;
    end;
    if treeview11.selected.parent.text='function' then begin
      s:='function ';
    end;
    if treeview11.selected.parent.text='var' then begin
      s:='var ';
    end;
    if s='' then exit;
    s:=s+Treeview11.selected.text;
    e.synedit.selstart:=0;
    e.synedit.selend:=0;
    if classsearch then begin
      e.Synedit.SearchReplace(gotoclass(treeview11.Selected,sender),'',[]);
      e.Synedit.SearchReplace(s,'',[]);
    end else e.Synedit.SearchReplace(s,'',[]);
  end;
end;

procedure TMainFrm.UpperCase1Click(Sender: TObject);
begin
  if PageControl.PageCount > 0 then begin
    with GetEditor do begin
      SynEdit.SelText := UpperCase(SynEdit.SelText);
      //StringReplace(SynEdit.SelText, '\', '/', [rfReplaceAll]);
    end;
  end;
end;

procedure TMainFrm.LowerCase1Click(Sender: TObject);
begin
  if PageControl.PageCount > 0 then begin
    with GetEditor do begin
      SynEdit.SelText := LowerCase(SynEdit.SelText);
      //StringReplace(SynEdit.SelText, '\', '/', [rfReplaceAll]);
    end;
  end;
end;

procedure TMainFrm.C3Click(Sender: TObject);
var pars:TParse;
    e:TEditor;
begin
  e:=getEditor();
  if not assigned(e) then exit;
  if e.synedit.selText='' then exit;
  pars:=TParse.create();
  pars.parsedStr:=e.synedit.selText;
  e.synedit.selText:=pars.Capitalize;
  pars.free;
end;

procedure TMainFrm.InsertDocPath1Click(Sender: TObject);
begin
  Insertar(ExtractFilePath(getEditor.fFilename));
end;

procedure TMainFrm.InsertDocFilename1Click(Sender: TObject);
begin
  Insertar(ExtractFileName(getEditor.fFilename));
end;

procedure TMainFrm.Insert1Click(Sender: TObject);
begin
  Insertar(getEditor.fFilename);
end;

procedure TMainFrm.InsertDate1Click(Sender: TObject);
var s:string;
begin
  DateTimeToString(s,gsettings.dateFmt,now());
  Insertar(s);
end;

procedure TMainFrm.InsertTime1Click(Sender: TObject);
var s:string;
begin
  DateTimeToString(s,gsettings.TimeFmt,now());
  Insertar(s);
end;

procedure TMainFrm.InsertDateTime1Click(Sender: TObject);
var s:string;
begin
  DateTimeToString(s,gsettings.DateTimeFmt,now());
  Insertar(s);
end;

procedure TMainFrm.InsertFilename1Click(Sender: TObject);
begin
  Insertar(shelllistview1.selectedFolder.pathname);
end;

procedure TMainFrm.DeleteLine1Click(Sender: TObject);
var e:TEditor;
    bb,be:TBufferCoord;
begin
  e:=getEditor();
  bb.char:=0;
  bb.Line:=e.synedit.CaretY;
  e.SynEdit.BlockBegin:=bb;
  if e.SynEdit.lines.Count=e.SynEdit.carety then begin
    be.Char:=high(integer);be.Line:=e.synedit.CaretY;
  end else begin
    be.Char:=0;be.Line:=e.synedit.CaretY+1;
  end;
  e.synedit.blockend:=be;
  e.synedit.selText:='';
  e.modified:=true;
end;

procedure TMainFrm.DeleteWord1Click(Sender: TObject);
var e:TEditor;
begin
  e:=getEditor();
  e.synedit.SetSelWord;
  e.SynEdit.SelText:='';
//  e.synedit.lines.delete(e.synedit.carety-1);
  e.modified:=true;
end;

procedure TMainFrm.DeletetoEndLine1Click(Sender: TObject);
var e:TEditor;
    be,bb:TBufferCoord;
begin
  e:=getEditor();
  bb.Char:=e.synedit.caretx;bb.Line:=e.synedit.carety;
  e.synedit.blockbegin:=bb;
  be.Char:=high(integer);be.Line:=e.synedit.carety;
  e.synedit.blockend:=be;
  e.synedit.selText:='';
  e.modified:=true;
end;

procedure TMainFrm.DeletePreviousWord1Click(Sender: TObject);
var e:TEditor;
begin
  e:=getEditor();
  e.synedit.caretxy:=e.synedit.prevWordPos;
  e.synedit.SetSelWord;
  e.SynEdit.SelText:='';
  e.modified:=true;
end;

procedure TMainFrm.InsertFilePath1Click(Sender: TObject);
begin
  if shelllistview1.SelCount>0 then
  Insertar(ExtractFilePath(shelllistview1.selectedFolder.pathname));
end;

procedure TMainFrm.SaveUnix1Click(Sender: TObject);
var
  e : TEditor;
begin
  e := GetEditor;
  if Assigned(e) then begin
    e.LB:=#10;
  end;
  saveunix1.Checked:=true;
  gsettings.SaveType:=1;
end;

procedure TMainFrm.Savewithcrlf1Click(Sender: TObject);
begin
  savewithcrlf1.Checked:=true;
  gsettings.SaveType:=0;
end;

procedure TMainFrm.Savewithcr1Click(Sender: TObject);
begin
  savewithcr1.Checked:=true;
  gsettings.SaveType:=2;
end;

procedure TMainFrm.SideBar1Click(Sender: TObject);
begin
  gsettings.HideSideBar:=sideBar1.Checked;
end;


procedure TMainFrm.HtmlPHP1Click(Sender: TObject);
begin
  GetEditor.SynEdit.Highlighter := SynMultiSyn2;
  StatusBar1.Panels[3].Text := (Sender as TTBItem).Caption;
end;

procedure TMainFrm.ListViewChange(Sender: TObject; Item: TListItem;
  Change: TItemChange);
begin
  if listview.SelCount>0 then
  Listview.Hint:=listview.Selected.Caption;
end;

procedure TMainFrm.ControlBar1DockOver(Sender: TObject;
  Source: TDragDockObject; X, Y: Integer; State: TDragState;
  var Accept: Boolean);
begin
  accept:= Source.Control is TActionToolBar;
end;

procedure TMainFrm.Panel8Resize(Sender: TObject);
begin
  FunctionBrowser.Width:=Panel8.Width-speedbutton1.Width-2;
end;

procedure TMainFrm.Re1Click(Sender: TObject);
var s:string;
    i:integer;
begin
  treeview1.Items.Clear;
  if PageControl.PageCount > 0 then begin
    with GetEditor do begin
      Application.CreateForm(TSearchForm, SearchForm);
      if (SynEdit.SelText <> '') then begin
          SearchForm.SynEdit1.Lines.Text:=SynEdit.selText;
      end else begin
      end;
      Searchform.ShowModal;
      s:='';
      for i:=0 to searchform.synedit1.lines.count-1 do begin
        if s<>'' then s:=s+#13#10;
        s:=s+searchForm.SynEdit1.Lines[i];
      end;
      SearchForm.Free;
      if searchForm.ModalResult=mrok then begin
        panel7.Visible:=true;
        splitter3.Visible:=true;
        splitter3.Top:=panel7.Top-splitter3.Height;
        searchre(getEditor,s);
        treeview1.FullExpand;
      end;
    end;
  end;
end;

procedure TMainFrm.FindDialog2Find(Sender: TObject);
var s:string;
    i:integer;
    bc:TBufferCoord;
    info:PTPosInfo;
    ro:TTreeNode;
begin
  s:=FindDialog2.FindText;
  SynEditRegExSearch1.Options:=[ssoMatchCase];
  SynEditRegExSearch1.Pattern:=s;
  SynEditRegExSearch1.FindAll(GetEditor.SynEdit.Text);
  ro:=treeview1.Items.Add(nil,getEditor.fFileName);
  new(info);
  info^.filename:=getEditor.fFileName;
  info^.isfilename:=true;
  ro.Data:=TObject(info);
  For i:=0 to SynEditRegExSearch1.ResultCount-1 do begin
    new(info);
    bc:=GetEditor.SynEdit.CharIndexToRowCol(SynEditRegExSearch1.Results[i]);
    info^.line:=bc.Line;
    info^.char:=bc.Char;
    info^.pos:=SynEditRegExSearch1.Results[i];
    info^.length:=SynEditRegExSearch1.Lengths[i];
    info^.filename:=GetEditor.fFileName;
    info^.isfilename:=false;
    treeview1.Items.AddChildObject(ro,inttostr(bc.Line)
      +' : '+trim(GetEditor.SynEdit.Lines[bc.line-1]),TObject(info));
  end;
  FindDialog2.CloseDialog;
  treeview1.FullExpand;
  panel7.Visible:=true;
  splitter3.Visible:=true;
end;

procedure TMainFrm.TreeView1Deletion(Sender: TObject; Node: TTreeNode);
begin
  if assigned(node.data) then dispose(node.Data);
end;

procedure TMainFrm.TreeView1Click(Sender: TObject);
var bc:TBufferCoord;
    info:PTPosInfo;
    cr:boolean;
    s:string;
    i:integer;
    e:TEditor;
begin
  if not assigned(treeview1.selected) then exit;
  info:=PTPosInfo(treeview1.Selected.Data);
  if not assigned(info) then exit;
  if info^.isfilename then exit;
  PageControl1.ActivePageIndex:=pEdit;
  cr:=true;
  s:=info^.filename;
  for i := PageControl.PageCount - 1 downto 0 do begin
    if GetEditor(i).fFileName=s then begin
      pageControl.ActivePageIndex:=i; cr:=false;
    end;
  end;
  if cr then begin
    e := TEditor.Create;
    e.Init(s, TRUE);
    AgregarHistorial(s);
    GuardarHistorial(s);
    ActivarBotones(TRUE);
  end;
  bc.Line:= info^.line;
  bc.Char:= info^.char;
  GetEditor.SynEdit.GotoLineAndCenter(bc.line);
  GetEditor.SynEdit.SelStart:=info^.pos-1;
  getEditor.SynEdit.SelEnd:=info^.pos+info^.length-1;
  SyncEditorwithPath;
end;

procedure TMainFrm.TreeView1CustomDrawItem(Sender: TCustomTreeView;
  Node: TTreeNode; State: TCustomDrawState; var DefaultDraw: Boolean);
var info:PTPosInfo;
begin
  info:=PTPosInfo(node.data);
  if info.isfilename then begin
    Treeview1.Canvas.Brush.Color:=TColor($00BBBB);;
    Treeview1.Canvas.FillRect(node.DisplayRect(false));
    Treeview1.Canvas.TextOut(node.DisplayRect(true).Left,node.displayRect(true).Top,info^.filename);
    DefaultDraw:=false;
  end;
end;

procedure TMainFrm.Button3Click(Sender: TObject);
begin
  splitter3.Visible:=false;
  panel7.Visible:=false;
end;

procedure TMainFrm.searchRe(e:TEditor;searchstr:string);
var s:string;
    i:integer;
    bc:TBufferCoord;
    info:PTPosInfo;
    ro:TTreeNode;
begin
  s:=searchstr;
//  SynEditRegExSearch1.Options:=[ssoMatchCase];
  SynEditRegExSearch1.Options:=GetFindOptions(findDialog3);
  SynEditRegExSearch1.Pattern:=s;
  SynEditRegExSearch1.FindAll(e.SynEdit.Text);
  if SynEditRegExSearch1.ResultCount>0 then begin
    ro:=treeview1.Items.Add(nil,e.fFileName);
    new(info);
    info^.filename:=e.fFileName;
    info^.isfilename:=true;
    ro.Data:=TObject(info);
    For i:=0 to SynEditRegExSearch1.ResultCount-1 do begin
      new(info);
      bc:=e.SynEdit.CharIndexToRowCol(SynEditRegExSearch1.Results[i]);
      info^.line:=bc.Line;
      info^.char:=bc.Char;
      info^.pos:=SynEditRegExSearch1.Results[i];
      info^.length:=SynEditRegExSearch1.Lengths[i];
      info^.filename:=e.fFileName;
      info^.isfilename:=false;
      treeview1.Items.AddChildObject(ro,inttostr(bc.Line)
        +' : '+trim(e.SynEdit.lines[bc.line-1]),TObject(info));
    end;
  end;
end;

procedure TMainFrm.searchReg(filename:string;searchstr:string);
var s:string;
    i:integer;
    bc:TBufferCoord;
    info:PTPosInfo;
    ro:TTreeNode;
begin
  synedit1.Lines.LoadFromFile(filename);
  s:=searchstr;
//  SynEditRegExSearch1.Options:=[ssoMatchCase];
  SynEditRegExSearch1.Options:=GetFindOptions(findDialog3);
  SynEditRegExSearch1.Pattern:=s;
  SynEditRegExSearch1.FindAll(synedit1.Text);
  if SynEditRegExSearch1.ResultCount>0 then begin
    ro:=treeview1.Items.Add(nil,FileName);
    new(info);
    info^.filename:=FileName;
    info^.isfilename:=true;
    ro.Data:=TObject(info);
    For i:=0 to SynEditRegExSearch1.ResultCount-1 do begin
      new(info);
      bc:=SynEdit1.CharIndexToRowCol(SynEditRegExSearch1.Results[i]);
      info^.line:=bc.Line;
      info^.char:=bc.Char;
      info^.pos:=SynEditRegExSearch1.Results[i];
      info^.length:=SynEditRegExSearch1.Lengths[i];
      info^.filename:=FileName;
      info^.isfilename:=false;
      treeview1.Items.AddChildObject(ro,inttostr(bc.Line)
        +' : '+trim(synedit1.lines[bc.line-1]),TObject(info));
    end;
  end;
  synedit1.lines.clear;
end;

function getfname(const s:string;searchstr:string):boolean;
begin
//  showmessage(s);
  application.ProcessMessages;
  if mainfrm.panel7.visible then mainfrm.searchReg(s,searchstr);
  result:= true;
end;

procedure TMainFrm.ASearchRegDirExecute(Sender: TObject);
var s:string;
    i:integer;
begin
  treeview1.Items.Clear;
  if PageControl.PageCount > 0 then begin
    with GetEditor do begin
      Application.CreateForm(TSearchForm, SearchForm);
      if (SynEdit.SelText <> '') then begin
          SearchForm.SynEdit1.Lines.Text:=SynEdit.selText;
      end else begin
      end;
      Searchform.ShowModal;
      s:='';
      for i:=0 to searchform.synedit1.lines.count-1 do begin
        if s<>'' then s:=s+#13#10;
        s:=s+searchForm.SynEdit1.Lines[i];
      end;
      SearchForm.Free;
      if searchForm.ModalResult=mrok then begin
        panel7.Visible:=true;
        splitter3.Visible:=true;
        splitter3.Top:=panel7.Top-splitter3.Height;
        searchdir2(shelltreeview1.SelectedFolder.PathName,s,getfname);
        treeview1.FullExpand;
      end;
    end;
//    FindDialog3.Execute;
  end;
end;

procedure TMainFrm.FindDialog3Find(Sender: TObject);
begin
  FindDialog3.CloseDialog;
  panel7.Visible:=true;
  splitter3.Visible:=true;
  splitter3.Top:=panel7.Top-splitter3.Height;
  searchdir2(shelltreeview1.SelectedFolder.PathName,finddialog3.FindText,getfname);
  treeview1.FullExpand;
end;

procedure TMainFrm.AutoCompleteExecute(Kind: SynCompletionType;
  Sender: TObject; var CurrentInput: String; var x, y: Integer;
  var CanExecute: Boolean);
begin
  if pagecontrol1.ActivePageIndex=pEdit then begin
    geteditor.SynEdit.SetFocus;
    CurrentInput:=geteditor.SynEdit.WordAtCursor;
    AutoComplete.TriggerChars;
  end;
end;


procedure TMainFrm.Splitter2CanResize(Sender: TObject;
  var NewSize: Integer; var Accept: Boolean);
begin
  TBToolWindow1.Width:=newsize;
end;

procedure TMainFrm.TBToolWindow1DockChanging(Sender: TObject;
  Floating: Boolean; DockingTo: TTBDock);
begin
  splitter1.Left:=200;
end;

procedure TMainFrm.AEditEditExecute(Sender: TObject);
var
  ToolbarEditForm : TToolbarEditForm;
begin
  TB2kInitializeToolbar(TBToolbar3, EmptyStr, ExtractFilePath(Application.EXEName) + 'DEVPHP.INI', 0);
  ToolbarEditForm := TToolbarEditForm.Create(Application);
  With ToolbarEditForm Do
    begin
      ShowModal;
      Release;
    end;
end;

procedure TMainFrm.AEditInsExecute(Sender: TObject);
var
  ToolbarEditForm : TToolbarEditForm;
begin
  TB2kInitializeToolbar(TBToolbar4, EmptyStr, ExtractFilePath(Application.EXEName) + 'DEVPHP.INI', 0);
  ToolbarEditForm := TToolbarEditForm.Create(Application);
  With ToolbarEditForm Do
    begin
      ShowModal;
      Release;
    end;
end;

procedure TMainFrm.AEditToolExecute(Sender: TObject);
var
  ToolbarEditForm : TToolbarEditForm;
begin
  TB2kInitializeToolbar(TBToolbar2, EmptyStr, ExtractFilePath(Application.EXEName) + 'DEVPHP.INI', 0);
  ToolbarEditForm := TToolbarEditForm.Create(Application);
  With ToolbarEditForm Do
    begin
      ShowModal;
      Release;
    end;
end;

procedure TMainFrm.TBVisibilityToggleItem1Click(Sender: TObject);
begin
  gsettings.hidesidebar:=TBVisibilityToggleItem1.Checked;
end;

procedure TMainFrm.ASearchOFilesExecute(Sender: TObject);
var s:string;
    i:integer;
begin
  treeview1.Items.Clear;
  if PageControl.PageCount > 0 then begin
    with GetEditor do begin
      Application.CreateForm(TSearchForm, SearchForm);
      if (SynEdit.SelText <> '') then begin
          SearchForm.SynEdit1.Lines.Text:=SynEdit.selText;
      end;
      Searchform.ShowModal;
      s:='';
      for i:=0 to searchform.synedit1.lines.count-1 do begin
        if s<>'' then s:=s+#13#10;
        s:=s+searchForm.SynEdit1.Lines[i];
      end;
      SearchForm.Free;
      if searchForm.ModalResult=mrok then begin
        panel7.Visible:=true;
        splitter3.Visible:=true;
        splitter3.Top:=panel7.Top-splitter3.Height;
        for i:=0 to pagecontrol.PageCount-1 do begin
          searchre(getEditor(i),s);
        end;
        treeview1.FullExpand;
      end;
    end;
  end;
end;

procedure TMainFrm.DoTreeRefresh(Sender: TObject; onlyTree:boolean);
var ch:TTVChangedEvent;
begin
  if not onlyTree then begin
    shelltreeview1.Refresh(shelltreeview1.TopItem);
  end else begin
    ch:=shelltreeview1.OnChange;
    shelltreeview1.OnChange:=nil;
    shelltreeview1.Refresh(shelltreeview1.Selected);
    shelltreeview1.OnChange:=ch;
  end;
  ShellTreeView1.TopItem.Text:=ShellTreeView1.Root;
end;

procedure TMainFrm.TBVisibilityToggleItem2Click(Sender: TObject);
begin
  gsettings.editbar1visible:=not TBVisibilityToggleItem2.Checked;
end;

procedure TMainFrm.DHTMLEdit1ShowContextMenu(Sender: TObject; xPos,
  yPos: Integer);
//var p,p2:TPoint;
begin
//  p.x:=xPOS;p.Y:=yPos;
//  p2:=dhtmledit1.ClientToScreen(p);
//  popupmenu1.Popup(p2.X,p2.Y);
end;

procedure TMainFrm.FindDialog1Show(Sender: TObject);
begin
  findactive:=true;
end;

procedure TMainFrm.FindDialog1Close(Sender: TObject);
begin
  findactive:=false;
end;

procedure TMainFrm.test2Click(Sender: TObject);
begin
//  showmessage(inttostr(SynPHPSyn.keyHash('as')));
end;

procedure TMainFrm.SpeedButton1Click(Sender: TObject);
var s1:string;
  o:TSelectDirOpts;
begin
  s1:=settings.localpathText;
  if FileCtrl.SelectDirectory(s1,o,0) then
  settings.localpathText:=s1;
  if MainFrm.ShellTreeView1.Root<>s1 then begin
    MainFrm.ShellTreeView1.root:=s1;
    shelltreeview1.TopItem.Text:=s1;
  end;
  webserv1.RootPath:=settings.localpathText;
//  shelltreeview1.Refresh(shelltreeview1.TopItem);
//  shelllistview1.Refresh;
end;

end.
