//
// +----------------------------------------------------------------------+
// | Dev-PHP - Integrated Development Environment                         |
// +----------------------------------------------------------------------+
// | Copyright (C) 2002-2003, http://devphp.sourceforge.net               |
// +----------------------------------------------------------------------+
// | This program is free software; you can redistribute it and/or modify |
// | it under the terms of the GNU General Public License as published by |
// | the Free Software Foundation; either version 2 of the License, or    |
// | (at your option) any later version.                                  |
// | This program is distributed in the hope that it will be useful       |
// | but WITHOUT ANY WARRANTY; without even the implied warranty of       |
// | MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the         |
// | GNU General Public License for more details.                         |
// +----------------------------------------------------------------------+
// | Author: Leonardo Garca <simbiotik@users.sourceforge.net>            |
// +----------------------------------------------------------------------+
//
unit frmOptimize;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Buttons, ExtCtrls, SynEdit, uLang,uIniFile,
//  XPMenu,
  uEditor;

type
  TOptimizeForm = class(TForm)
    Panel1: TPanel;
    showedit: TSynEdit;
    GroupBox1: TGroupBox;
    doit: TBitBtn;
    release: TBitBtn;
    GroupBox2: TGroupBox;
    GroupBox3: TGroupBox;
    rb3: TRadioButton;
    rb1: TRadioButton;
    rb2: TRadioButton;
    take: TBitBtn;
    undo: TBitBtn;
    cbTabs: TCheckBox;
    cbBR: TCheckBox;
    procedure doitClick(Sender: TObject);
    procedure takeClick(Sender: TObject);
    procedure releaseClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure undoClick(Sender: TObject);
    procedure FormKeyUp(Sender: TObject; var Key: Word;
      Shift: TShiftState);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  OptimizeForm: TOptimizeForm;

implementation

uses frmMain;

{$R *.dfm}

procedure TOptimizeForm.doitClick(Sender: TObject);
var
  i : integer;
  s,z : string;
begin
  z := '';
  for i := 0 to showedit.Lines.Count-1 do begin
    s := showedit.Lines[i];
    if cbTabs.Checked = true then begin
      while Pos('  ',s) <> 0 do begin
        Delete(s,Pos('  ',s),2);
      end;
    end;
    if rb1.Checked = true then begin
      s := LowerCase(s);
    end;
    if rb2.Checked = true then begin
      s := UpperCase(s);
    end;
    showedit.Lines[i] := s;
    if cbBR.Checked = true then begin
      while Pos(#13,s) <> 0 do
        Delete(s,Pos(#13,s),1);
      while Pos(#10,s) <> 0 do
        Delete(s,Pos(#10,s),1);
      z := z + s + ' ';
    end;
  end;
  if cbBR.Checked = true then begin
    showedit.Lines.Clear;
    showedit.Lines.Add(z);
  end;
end;

procedure TOptimizeForm.takeClick(Sender: TObject);
begin
  with MainFrm do begin
    GetEditor.SynEdit.Lines := showedit.Lines;
    GetEditor.modified := FALSE;
    ASave.Enabled := TRUE;
  end;
  Close;
end;

procedure TOptimizeForm.releaseClick(Sender: TObject);
begin
  Close;
end;

procedure TOptimizeForm.FormShow(Sender: TObject);
var
  e : TEditor;
begin
  e := MainFrm.GetEditor;
  Font.Name := settings.DialogFontText;
  showedit.Lines := e.SynEdit.Lines;
  showedit.Highlighter := e.SynEdit.Highlighter;
  showedit.Font.Name := e.SynEdit.Font.Name;
  showedit.Font.Size := e.SynEdit.Font.Size;
  showedit.Color := e.SynEdit.Color;
  Caption := Lang(500);
  GroupBox1.Caption := Lang(501);
  cbTabs.Caption := Lang(502);
  cbBR.Caption := Lang(503);
  rb1.Caption := Lang(504);
  rb2.Caption := Lang(505);
  rb3.Caption := Lang(506);
  doit.Caption := Lang(507);
  take.Caption := Lang(508);
  undo.Caption := Lang(509);
  release.Caption := Lang(510);
end;

procedure TOptimizeForm.undoClick(Sender: TObject);
begin
  FormShow(self);
end;

procedure TOptimizeForm.FormKeyUp(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if Key=VK_ESCAPE then begin
    Close; Key:=0;
  end;
end;

end.
