//
// +----------------------------------------------------------------------+
// | Dev-PHP - Integrated Development Environment                         |
// +----------------------------------------------------------------------+
// | Copyright (C) 2002-2003, http://devphp.sourceforge.net               |
// +----------------------------------------------------------------------+
// | This program is free software; you can redistribute it and/or modify |
// | it under the terms of the GNU General Public License as published by |
// | the Free Software Foundation; either version 2 of the License, or    |
// | (at your option) any later version.                                  |
// | This program is distributed in the hope that it will be useful       |
// | but WITHOUT ANY WARRANTY; without even the implied warranty of       |
// | MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the         |
// | GNU General Public License for more details.                         |
// +----------------------------------------------------------------------+
// | Author: Leonardo Garca <simbiotik@users.sourceforge.net>            |
// +----------------------------------------------------------------------+
//
unit frmOptions;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ExtCtrls, StdCtrls, ColorGrd, SynEditHighlighter,
  SynHighlighterPHP, SynEdit, jpeg, Buttons, ComCtrls, Spin, uLang, shellAPI,
  ColorPickerButton, devTabs, uEditor,fileCtrl,uIniFile, IdAntiFreezeBase,
  IdAntiFreeze, IdBaseComponent, IdComponent, IdTCPConnection, IdTCPClient,
  IdFTP,IdFTPList,IdException;

type
  TOptionForm = class(TForm)
    OpenDialog1: TOpenDialog;
    DemoSyn: TSynPHPSyn;
    accept: TSpeedButton;
    cancel: TSpeedButton;
    Servers: TdevPages;
    General: TdevPage;
    Sintaxis: TdevPage;
    Parser: TdevPage;
    Extra: TdevPage;
    Panel9: TPanel;
    Panel10: TPanel;
    Panel11: TPanel;
    DialogFont: TComboBox;
    SaveSession: TCheckBox;
    Panel12: TPanel;
    Bevel3: TBevel;
    ColorPickerButton3: TColorPickerButton;
    SpinEdit3: TEdit;
    UpDown3: TUpDown;
    UpDown2: TUpDown;
    SpinEdit2: TEdit;
    SpinEdit1: TEdit;
    UpDown1: TUpDown;
    EditFont: TPanel;
    EditorFont: TComboBox;
    Opciones: TPanel;
    Borde: TPanel;
    Tamano: TPanel;
    Ancho: TPanel;
    Color: TPanel;
    Braces: TCheckBox;
    Panel17: TPanel;
    Foreground: TLabel;
    ColorPickerButton2: TColorPickerButton;
    Background: TLabel;
    ColorPickerButton1: TColorPickerButton;
    Propiedades: TPanel;
    ElementList: TListBox;
    Bold: TCheckBox;
    Italic: TCheckBox;
    DemoEdit: TSynEdit;
    Panel13: TPanel;
    Examinar: TSpeedButton;
    Edit1: TEdit;
    Panel3: TPanel;
    Panel2: TPanel;
    Image1: TImage;
    Panel1: TPanel;
    Image2: TImage;
    Interprete: TPanel;
    Panel7: TPanel;
    cbQ: TCheckBox;
    cbS: TCheckBox;
    cbW: TCheckBox;
    cbV: TCheckBox;
    cbI: TCheckBox;
    cbH: TCheckBox;
    Ejecucion: TPanel;
    Panel8: TPanel;
    Actuales: TPanel;
    Parametros: TEdit;
    Panel16: TPanel;
    SelectLanguage: TSpeedButton;
    Archivo: TPanel;
    Idioma: TEdit;
    Actual: TPanel;
    Edit3: TEdit;
    Panel14: TPanel;
    SearchDocs: TSpeedButton;
    Panel15: TPanel;
    DocsPath: TEdit;
    DocsLang: TComboBox;
    Panel4: TPanel;
    Panel5: TPanel;
    regPhp: TCheckBox;
    regCss: TCheckBox;
    regJs: TCheckBox;
    regHtml: TCheckBox;
    regSql: TCheckBox;
    Panel6: TPanel;
    Edit2: TEdit;
    UpDown4: TUpDown;
    Panel18: TPanel;
    devPage1: TdevPage;
    GroupBox1: TGroupBox;
    Label2: TLabel;
    Label1: TLabel;
    LocalPort: TEdit;
    LocalPath: TEdit;
    SpeedButton1: TSpeedButton;
    GroupBox3: TGroupBox;
    Label9: TLabel;
    WebServerPath: TEdit;
    ftp: TdevPage;
    GroupBox2: TGroupBox;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Label8: TLabel;
    Label10: TLabel;
    Label11: TLabel;
    FTPHost: TEdit;
    FTPPort: TEdit;
    FTPUser: TEdit;
    FTPPassword: TEdit;
    FTPServerPath: TEdit;
    ftppassive: TCheckBox;
    GroupBox4: TGroupBox;
    UpDown5: TUpDown;
    Edit4: TEdit;
    Label7: TLabel;
    ListBox1: TListBox;
    Button1: TButton;
    IdFTP1: TIdFTP;
    IdAntiFreeze1: TIdAntiFreeze;
    Label12: TLabel;
    Edit5: TEdit;
    Label13: TLabel;
    Edit6: TEdit;
    Label14: TLabel;
    Edit7: TEdit;
    CheckBox1: TCheckBox;
    CheckBox2: TCheckBox;
    procedure FormCreate(Sender: TObject);
    procedure ElementListClick(Sender: TObject);
    procedure EditorFontChange(Sender: TObject);
    procedure ExaminarClick(Sender: TObject);
    procedure cancelClick(Sender: TObject);
    procedure acceptClick(Sender: TObject);
    procedure Image1Click(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure SelectLanguageClick(Sender: TObject);
    procedure SpinEdit2Change(Sender: TObject);
    procedure BoldClick(Sender: TObject);
    procedure StyleBold(Attri: TSynHighlighterAttributes);
    procedure StyleItalic(Attri: TSynHighlighterAttributes);
    procedure ItalicClick(Sender: TObject);
    procedure ColorPickerButton1Change(Sender: TObject);
    procedure ColorPickerButton2Change(Sender: TObject);
    procedure ColorPickerButton3Change(Sender: TObject);
    procedure Image2Click(Sender: TObject);
    procedure SearchDocsClick(Sender: TObject);
    procedure DialogFontChange(Sender: TObject);
    procedure SpeedButton1Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure FormKeyUp(Sender: TObject; var Key: Word;
      Shift: TShiftState);
  private
    procedure RegisterExt(prefix, exepfad: string);
  end;

var
  OptionForm: TOptionForm;

implementation

uses frmMain,shlobj,registry;

{$R *.dfm}

procedure TOptionForm.RegisterExt(prefix:string;exepfad:string);
var
  reg: TRegistry;
begin
  reg := TRegistry.Create;
  try
    reg.RootKey := HKEY_CLASSES_ROOT;
    //create a new key  --> .pci
    reg.OpenKey('.' + prefix, True);
    try
      //create a new value for this key --> pcifile
      reg.Writestring('', prefix + 'file');
    finally
      reg.CloseKey;
    end;
    //create a new key --> pcifile
    reg.CreateKey(prefix + 'file');
    //create a new key pcifile\DefaultIcon
    reg.OpenKey(prefix + 'file\DefaultIcon', True);
    //and create a value where the icon is stored --> c:\project1.exe,0
    try
      reg.Writestring('', exepfad + ',0');
    finally
      reg.CloseKey;
    end;
    reg.OpenKey(prefix + 'file\shell\open\command', True);
    //create value where exefile is stored --> c:\project1.exe "%1"
    try
      reg.Writestring('', exepfad + ' "%1"');
    finally
      reg.CloseKey;
    end;
  finally
    reg.Free;
  end;
  SHChangeNotify(SHCNE_ASSOCCHANGED, SHCNF_IDLIST, nil, nil);
end;

procedure TOptionForm.FormCreate(Sender: TObject);
var
  Params : string;
  dl : string;
  ii : integer;
begin
  DemoEdit.Color                    := gsettings.DemoEditColor;
  ColorPickerButton3.SelectionColor := gsettings.DemoEditColor;
  UpDown1.Position                  := settings.UpDown1Position;
  UpDown2.Position                  := gsettings.UpDown2Position;
  UpDown3.Position                  := gsettings.UpDown3Position;
  UpDown4.Position                  := mainfrm.Panel2.Width;
  Edit1.Text                        := gsettings.Edit1Text;
  EditorFont.Text                   := gsettings.EditorFontText;
  DemoEdit.Font.Name                := settings.DemoEditFontName;
  Idioma.Text                       := gsettings.IdiomaText;
  Braces.Checked                    := settings.BracesChecked;
  SaveSession.Checked               := settings.SaveSessionChecked;
  DialogFont.Text                   := settings.DialogFontText;
  localpath.Text                    := settings.localpathText;
  localPort.Text                    := settings.localPortText;
  updown5.Position                  :=strtoint(settings.FTPcfname);
//  edit4.Text                        := settings.FTPcfname;
  Ftppassive.Checked                := settings.FTPPassive;
  FTPHost.Text                      := settings.FTPHostText;
  FTPPort.Text                      := settings.FTPPortText;
  FTPUser.Text                      := settings.FTPUserText;
//  FTPPassword.Text                  := settings.FTPPasswordText;
  FTPPassword.Text                  := settings.FTPPasswordSave;
  FTPServerPath.Text                := settings.FTPServerPathText;
  WebServerPath.Text                := settings.WebServerPathText;
  regCss.Checked                    := settings.regCssChecked;
  regHtml.Checked                   := settings.regHtmlChecked;
  regJs.Checked                     := settings.regJsChecked;
  regSql.Checked                    := settings.regSqlChecked;
  regPhp.Checked                    := settings.regPhpChecked;

  EditFont.Font.Name := EditorFont.Text;
  EditFont.Font.Size := StrToInt(SpinEdit2.Text);

  LoadSynEditFromFile(DemoSyn);

  Params        := settings.Params;
  if Pos('-q',Params) <> 0 then cbQ.Checked := true;
  if Pos('-s',Params) <> 0 then cbS.Checked := true;
  if Pos('-w',Params) <> 0 then cbW.Checked := true;
  if Pos('-v',Params) <> 0 then cbV.Checked := true;
  if Pos('-i',Params) <> 0 then cbI.Checked := true;
  if Pos('-h',Params) <> 0 then cbH.Checked := true;

  DocsPath.Text := gsettings.DocsPathText;
  dl            := gsettings.dl;
  ii := 0;
  if dl = 'pt_BR' then ii := 1;
  if dl = 'zh' then ii := 2;
  if dl = 'cs' then ii := 3;
  if dl = 'nl' then ii := 4;
  if dl = 'fi' then ii := 5;
  if dl = 'fr' then ii := 6;
  if dl = 'de' then ii := 7;
  if dl = 'hu' then ii := 8;
  if dl = 'it' then ii := 9;
  if dl = 'ja' then ii := 10;
  if dl = 'kr' then ii := 11;
  if dl = 'pl' then ii := 12;
  if dl = 'ro' then ii := 13;
  if dl = 'sk' then ii := 14;
  if dl = 'sl' then ii := 15;
  if dl = 'es' then ii := 16;
  if dl = 'sv' then ii := 17;
  if dl = 'tr' then ii := 18;
  DocsLang.ItemIndex := ii;

  Parametros.Text := Params;
  EditorFont.Items.AddStrings(Screen.Fonts);
  DialogFont.Items.AddStrings(Screen.Fonts);
  edit5.Text:=gsettings.DateFmt;
  edit6.Text:=gsettings.TimeFmt;
  edit7.Text:=gsettings.DateTimeFmt;
  checkbox1.Checked:=gsettings.AutoIndent;
  checkbox2.Checked:=gsettings.WordWrap;
end;

procedure TOptionForm.ElementListClick(Sender: TObject);
begin
  case ElementList.ItemIndex of
    0 : begin
      with DemoSyn.CommentAttri do begin
        ColorPickerButton1.SelectionColor := Background;
        ColorPickerButton2.SelectionColor := Foreground;
        Italic.Checked := fsItalic in Style;
        Bold.Checked := fsBold in Style;
      end;
    end;
    1 : begin
      with DemoSyn.IdentifierAttri do begin
        ColorPickerButton1.SelectionColor := Background;
        ColorPickerButton2.SelectionColor := Foreground;
        Italic.Checked := fsItalic in Style;
        Bold.Checked := fsBold in Style;
      end;
    end;
    2 : begin
//ToDo      with DemoSyn.InvalidSymbolAttri do begin
//        ColorPickerButton1.SelectionColor := Background;
//        ColorPickerButton2.SelectionColor := Foreground;
//        Italic.Checked := fsItalic in Style;
//        Bold.Checked := fsBold in Style;
//      end;
    end;
    3 : begin
      with DemoSyn.KeyAttri do begin
        ColorPickerButton1.SelectionColor := Background;
        ColorPickerButton2.SelectionColor := Foreground;
        Italic.Checked := fsItalic in Style;
        Bold.Checked := fsBold in Style;
      end;
    end;
    4 : begin
      with DemoSyn.NumberAttri do begin
        ColorPickerButton1.SelectionColor := Background;
        ColorPickerButton2.SelectionColor := Foreground;
        Italic.Checked := fsItalic in Style;
        Bold.Checked := fsBold in Style;
      end;
    end;
    5 : begin
      with DemoSyn.SpaceAttri do begin
        ColorPickerButton1.SelectionColor := Background;
        ColorPickerButton2.SelectionColor := Foreground;
        Italic.Checked := fsItalic in Style;
        Bold.Checked := fsBold in Style;
      end;
    end;
    6 : begin
      with DemoSyn.StringAttri do begin
        ColorPickerButton1.SelectionColor := Background;
        ColorPickerButton2.SelectionColor := Foreground;
        Italic.Checked := fsItalic in Style;
        Bold.Checked := fsBold in Style;
      end;
    end;
    7 : begin
      with DemoSyn.SymbolAttri do begin
        ColorPickerButton1.SelectionColor := Background;
        ColorPickerButton2.SelectionColor := Foreground;
        Italic.Checked := fsItalic in Style;
        Bold.Checked := fsBold in Style;
      end;
    end;
    8 : begin
      with DemoSyn.VariableAttri do begin
        ColorPickerButton1.SelectionColor := Background;
        ColorPickerButton2.SelectionColor := Foreground;
        Italic.Checked := fsItalic in Style;
        Bold.Checked := fsBold in Style;
      end;
    end;
  end;
end;

procedure TOptionForm.EditorFontChange(Sender: TObject);
begin
  if EditorFont.ItemIndex = 4 then
    EditorFont.ItemIndex := 3;
  EditFont.Font.Name := EditorFont.Text;
end;

procedure TOptionForm.ExaminarClick(Sender: TObject);
begin
  OpenDialog1.Filter := 'Applications|*.exe';
  OpenDialog1.FileName:=Edit1.Text;
  if OpenDialog1.Execute then begin
    Edit1.Text := OpenDialog1.FileName;
  end;
end;

procedure TOptionForm.cancelClick(Sender: TObject);
begin
  Close;
end;

procedure TOptionForm.acceptClick(Sender: TObject);
var
  Params : string;
  dl : string;
  e : TEditor;
begin
  MainFrm.Parser := Edit1.Text;
  SaveSynEditFromFile(DemoSyn);
  gsettings.Edit1Text:=Edit1.Text;
  gsettings.EditorFontText:=EditorFont.Text;
  gsettings.UpDown4Position:=UpDown4.Position;
  MainFrm.panel2.Width := UpDown4.Position;
  gsettings.DemoEditColor:=DemoEdit.Color;
  settings.UpDown1Position:=UpDown1.Position;
  gsettings.UpDown2Position:=UpDown2.Position;
  gsettings.UpDown3Position:=UpDown3.Position;
  gsettings.DateFmt:=Edit5.Text;
  gsettings.TimeFmt:=Edit6.Text;
  gsettings.DateTimeFmt:=Edit7.Text;
  gsettings.AutoIndent:=checkbox1.Checked;
  gsettings.WordWrap:=checkbox2.Checked;
  settings.SaveSessionChecked:=SaveSession.Checked;
  settings.DialogFontText:=DialogFont.Text;
  if DialogFont.Text <> MainFrm.Font.Name then begin
    MainFrm.Repaint;
  end;
  settings.BracesChecked:=Braces.Checked;
  settings.localpathText:=LocalPath.Text;
  settings.localPortText:=LocalPort.Text;
  settings.FTPcfname:=edit4.Text;
  settings.FTPPassive:=ftppassive.Checked;
  settings.FTPHostText:=FTPHost.Text;
  settings.FTPPortText:=FTPPort.Text;
  settings.FTPUserText:=FTPUser.Text;
//  settings.FTPPasswordText:=FTPPassword.Text;
  settings.FTPPasswordSave:=FTPPassword.Text;
  settings.FTPServerPathText:=FTPServerPath.Text;
  settings.WebServerPathText:=WebServerPath.Text;

  e := MainFrm.GetEditor;
  if Assigned(e) then begin
    e.LoadEditorSettings;
    CreateHighlighters(MainFrm.SynPHPSyn,MainFrm.SynCSSSyn1,
                      MainFrm.SynJScriptSyn1,MainFrm.SynSQLSyn1);
    MainFrm.ReadLangFile;
  end;

  Params := '';
  if cbQ.Checked = true then
    Params := Params + ' -q';
  if cbS.Checked = true then
    Params := Params + ' -s';
  if cbW.Checked = true then
    Params := Params + ' -w';
  if cbV.Checked = true then
    Params := Params + ' -v';
  if cbI.Checked = true then
    Params := Params + ' -i';
  if cbH.Checked = true then
    Params := Params + ' -h';

  settings.Params:=Params;
  gsettings.IdiomaText:=Idioma.text;
  settings.regCssChecked:=regCss.Checked;
  settings.regHtmlChecked:=regHtml.Checked;
  settings.regJsChecked:=regJs.Checked;
  settings.regSqlChecked:=regSql.Checked;
  settings.regPhpChecked:=regPhp.Checked;
  if regphp.Checked then RegisterExt('php',application.ExeName);
  gsettings.DocsPathText:=DocsPath.Text;
  dl := 'en';
  Case DocsLang.ItemIndex of
    0 : dl := 'en';
    1 : dl := 'pt_BR';
    2 : dl := 'zh';
    3 : dl := 'cs';
    4 : dl := 'nl';
    5 : dl := 'fi';
    6 : dl := 'fr';
    7 : dl := 'de';
    8 : dl := 'hu';
    9 : dl := 'it';
    10 : dl := 'ja';
    11 : dl := 'kr';
    12 : dl := 'pl';
    13 : dl := 'ro';
    14 : dl := 'sk';
    15 : dl := 'sl';
    16 : dl := 'es';
    17 : dl := 'sv';
    18 : dl := 'tr';
  end;
  gsettings.dl:=dl;
  settings.DocLang:=dl;
  Close;
  if MainFrm.ShellTreeView1.Root<>LocalPath.Text then begin
    MainFrm.ShellTreeView1.root:=LocalPath.text;
  end;
  if settings.FTPHostText='' then begin
//    MainFrm.tabsheet4.Visible:=false;
    MainFrm.tabsheet4.TabVisible:=false;
  end else begin
//    MainFrm.tabsheet4.Visible:=true;
    MainFrm.tabsheet4.TabVisible:=true;
  end;
  self.ModalResult:=mrok;
end;

procedure TOptionForm.Image1Click(Sender: TObject);
begin
  ShellExecute(0, 'open', 'http://www.php.net', nil, nil, 0);
end;

procedure TOptionForm.FormShow(Sender: TObject);
begin
  Self.Font.Name := settings.DialogFontText;
  Edit3.Text := MainFrm.LangFile.ReadString('Lang','Lang','<ERR: 666>');
  Caption := Lang(700);
  General.Caption := Lang(701);
  Interprete.Caption := Lang(702);
  Opciones.Caption := Lang(704);
  Borde.Caption := Lang(705);
  Ancho.Caption := Lang(706);
  Tamano.Caption := Lang(707);
  Color.Caption := Lang(708);
  EditFont.Caption := Lang(710);
  Sintaxis.Caption := Lang(711);
  Propiedades.Caption := Lang(712);
  Foreground.Caption := Lang(713);
  Background.Caption := Lang(714);
  Parser.Caption := Lang(716);
  Ejecucion.Caption := Lang(717);
  cbQ.Caption := Lang(718);
  cbS.Caption := Lang(719);
  cbW.Caption := Lang(720);
  cbV.Caption := Lang(721);
  cbI.Caption := Lang(722);
  cbH.Caption := Lang(724);
  Actuales.Caption := Lang(726);
  Archivo.Caption := Lang(727);
  Actual.Caption := Lang(728);
  Extra.Caption := Lang(729);
  accept.Caption := Lang(900);
  cancel.Caption := Lang(901);
  checkbox1.Caption:=Lang(730);
  panel10.Caption:=Lang(731);
  panel18.Caption:=Lang(732);
  checkbox2.Caption:=lang(733);
  braces.Caption:=lang(734);
  panel4.Caption:=lang(735);
  panel15.Caption:=lang(736);
  panel6.Caption:=lang(737);
  label12.Caption:=lang(738);
  label13.Caption:=lang(739);
  label14.Caption:=lang(740);
  groupbox1.Caption:=lang(1700);
  label1.Caption:=lang(1701);
  label2.Caption:=lang(1702);
  groupbox3.Caption:=lang(1703);
  label9.Caption:=lang(1704);
  groupbox2.Caption:=lang(1705);
  label11.Caption:=lang(1706);
  label3.Caption:=lang(1707);
  label5.Caption:=lang(1708);
  ftppassive.Caption:=lang(1709);
  label4.Caption:=lang(1710);
  label6.Caption:=lang(1711);
  label10.Caption:=lang(1712);
  label8.Caption:=lang(1713);
  groupbox4.Caption:=lang(1714);
  label7.Caption:=lang(1715);
  button1.Caption:=lang(1716);
  Servers.ActivePageIndex:=0;
end;

procedure TOptionForm.SelectLanguageClick(Sender: TObject);
begin
  OpenDialog1.Filter := 'Language File|*.lng';
  OpenDialog1.FileName:=Idioma.text;
  if OpenDialog1.Execute then begin
    Idioma.Text := OpenDialog1.FileName;
    uinifile.clearToolbars;
  end;
end;

procedure TOptionForm.SpinEdit2Change(Sender: TObject);
begin
  EditFont.Font.Size := UpDown2.Position;
end;

procedure TOptionForm.BoldClick(Sender: TObject);
begin
  with DemoSyn do begin
    Case ElementList.ItemIndex of
      0 : StyleBold(CommentAttri);
      1 : StyleBold(IdentifierAttri);
//ToDo      2 : StyleBold(InvalidSymbolAttri);
      3 : StyleBold(KeyAttri);
      4 : StyleBold(NumberAttri);
      5 : StyleBold(SpaceAttri);
      6 : StyleBold(StringAttri);
      7 : StyleBold(SymbolAttri);
      8 : StyleBold(VariableAttri);
    end;
  end;
end;

procedure TOptionForm.StyleBold(Attri: TSynHighlighterAttributes);
begin
  if Bold.Checked = True then begin
    Attri.Style := Attri.Style + [fsBold];
  end else begin
    Attri.Style := Attri.Style - [fsBold];
  end;
end;

procedure TOptionForm.StyleItalic(Attri: TSynHighlighterAttributes);
begin
  if Italic.Checked = True then begin
    Attri.Style := Attri.Style + [fsItalic];
  end else begin
    Attri.Style := Attri.Style - [fsItalic];
  end;
end;

procedure TOptionForm.ItalicClick(Sender: TObject);
begin
  with DemoSyn do begin
    Case ElementList.ItemIndex of
      0 : StyleItalic(CommentAttri);
      1 : StyleItalic(IdentifierAttri);
//ToDo      2 : StyleItalic(InvalidSymbolAttri);
      3 : StyleItalic(KeyAttri);
      4 : StyleItalic(NumberAttri);
      5 : StyleItalic(SpaceAttri);
      6 : StyleItalic(StringAttri);
      7 : StyleItalic(SymbolAttri);
      8 : StyleItalic(VariableAttri);
    end;
  end;
end;

procedure TOptionForm.ColorPickerButton1Change(Sender: TObject);
begin
  with DemoSyn do begin
    Case ElementList.ItemIndex of
      0 : CommentAttri.Background := ColorPickerButton1.SelectionColor;
      1 : IdentifierAttri.Background := ColorPickerButton1.SelectionColor;
//ToDo      2 : InvalidSymbolAttri.Background := ColorPickerButton1.SelectionColor;
      3 : KeyAttri.Background := ColorPickerButton1.SelectionColor;
      4 : NumberAttri.Background := ColorPickerButton1.SelectionColor;
      5 : SpaceAttri.Background := ColorPickerButton1.SelectionColor;
      6 : StringAttri.Background := ColorPickerButton1.SelectionColor;
      7 : SymbolAttri.Background := ColorPickerButton1.SelectionColor;
      8 : VariableAttri.Background := ColorPickerButton1.SelectionColor;
    end;
  end;
end;

procedure TOptionForm.ColorPickerButton2Change(Sender: TObject);
begin
  with DemoSyn do begin
    Case ElementList.ItemIndex of
      0 : CommentAttri.Foreground := ColorPickerButton2.SelectionColor;
      1 : IdentifierAttri.Foreground := ColorPickerButton2.SelectionColor;
//ToDo      2 : InvalidSymbolAttri.Foreground := ColorPickerButton2.SelectionColor;
      3 : KeyAttri.Foreground := ColorPickerButton2.SelectionColor;
      4 : NumberAttri.Foreground := ColorPickerButton2.SelectionColor;
      5 : SpaceAttri.Foreground := ColorPickerButton2.SelectionColor;
      6 : StringAttri.Foreground := ColorPickerButton2.SelectionColor;
      7 : SymbolAttri.Foreground := ColorPickerButton2.SelectionColor;
      8 : VariableAttri.Foreground := ColorPickerButton2.SelectionColor;
    end;
  end;
end;

procedure TOptionForm.ColorPickerButton3Change(Sender: TObject);
begin
  DemoEdit.Color := ColorPickerButton3.SelectionColor;
end;

procedure TOptionForm.Image2Click(Sender: TObject);
begin
  ShellExecute(0, 'open', 'http://gtk.php.net', nil, nil, 0);
end;

procedure TOptionForm.SearchDocsClick(Sender: TObject);
begin
  OpenDialog1.Filter := 'Help Files (*.chm)|*.chm';
  OpenDialog1.FileName:=DocsPath.Text;
  if OpenDialog1.Execute then begin
    DocsPath.Text := OpenDialog1.FileName;
  end;
end;

procedure TOptionForm.DialogFontChange(Sender: TObject);
begin
  Panel11.Font.Name := DialogFont.Text;
end;

procedure TOptionForm.SpeedButton1Click(Sender: TObject);
var s1:string;
begin
  s1:=localpath.Text;
  if SelectDirectory('Bitte whlen','',s1) then
  localPath.text:=s1;
end;

procedure TOptionForm.Button1Click(Sender: TObject);
var i,c:integer;
    s:string;
begin
  idftp1.Host:=FtpHost.Text;
  idftp1.Passive:=ftppassive.Checked;
  idftp1.Username:=FtpUser.Text;
  idftp1.Password:=ftpPassword.Text;
  idftp1.port:=strtoint(ftpport.Text);
  try
    idftp1.Connect();
  except
  end;
  if idftp1.Connected then begin
    try
      idftp1.List(listbox1.Items);
    except
      on EIdConnClosedGracefully do ;
    end;
    c:=strtoint(edit4.Text);
    for i:=0 to listbox1.items.Count-1 do begin
      s:=listbox1.Items[i];
      delete(s,1,c);
      listbox1.Items[i]:=s;
    end;
    try
      idftp1.Disconnect;
    except
    end;
  end else begin
    showmessage('no connect to ftp - server');
  end;
  settings.FTPcfname:=edit4.Text;
end;

procedure TOptionForm.FormKeyUp(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if Key=VK_ESCAPE then begin
    Close; Key:=0;
  end;
//  showmessage(inttostr(key));
end;

end.
