//
// +----------------------------------------------------------------------+
// | Dev-PHP - Integrated Development Environment                         |
// +----------------------------------------------------------------------+
// | Copyright (C) 2002-2003, http://devphp.sourceforge.net               |
// +----------------------------------------------------------------------+
// | This program is free software; you can redistribute it and/or modify |
// | it under the terms of the GNU General Public License as published by |
// | the Free Software Foundation; either version 2 of the License, or    |
// | (at your option) any later version.                                  |
// | This program is distributed in the hope that it will be useful       |
// | but WITHOUT ANY WARRANTY; without even the implied warranty of       |
// | MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the         |
// | GNU General Public License for more details.                         |
// +----------------------------------------------------------------------+
// | Author: Leonardo Garca <simbiotik@users.sourceforge.net>            |
// | Author: Urs Mder       <ursmaeder@users.sourceforge.net>            |
// +----------------------------------------------------------------------+
//
unit frmUpdate;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, Buttons, StdCtrls, ExtCtrls, wininet, shellapi,uIniFile,
  IdBaseComponent, IdComponent, IdTCPConnection, IdTCPClient, IdHTTP,
  IdAntiFreezeBase, IdAntiFreeze,version;

type
  TUpdateForm = class(TForm)
    Panel1: TPanel;
    Panel2: TPanel;
    L: TEdit;
    Panel3: TPanel;
    Panel4: TPanel;
    Local: TEdit;
    Panel5: TPanel;
    Panel6: TPanel;
    Label1: TLabel;
    accept: TSpeedButton;
    DownloadUpdate: TSpeedButton;
    Remote: TEdit;
    DSite: TEdit;
    Panel7: TPanel;
    Description: TMemo;
    Panel8: TPanel;
    IdHTTP1: TIdHTTP;
    IdAntiFreeze1: TIdAntiFreeze;
    procedure FormActivate(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure DownloadUpdateClick(Sender: TObject);
    procedure acceptClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure FormKeyUp(Sender: TObject; var Key: Word;
      Shift: TShiftState);
  private
    FirstStart : boolean;
  public

  end;

var
  UpdateForm: TUpdateForm;

const URL = 'http://devphp/sourceforge.net/update.txt';
//const URL = 'http://localhost/update.txt'; // Used for testing.
const LocalFileName = './update.txt';

type
  TCheckForUpdate = class(TObject)
  private
    NetHandle: HINTERNET;
    UrlHandle: HINTERNET;
    Buffer: array[0..1024] of char;
    BytesRead: cardinal;
  public
    UpdateFile, VersionName, Needed_package, Description : string;
    constructor Create;
    function  Connect: boolean;
    procedure Disconnect;
    procedure Download;
    procedure doCheck;
  end;

implementation

uses frmMain;

{$R *.dfm}

function TCheckForUpdate.Connect;
begin
  if Assigned(NetHandle) then
     Disconnect;

  UpdateFile := '';

  NetHandle := InternetOpen('Dev-PHP Check for Update', INTERNET_OPEN_TYPE_PRECONFIG,
                            nil, nil, 0);

  if Assigned(NetHandle) then begin
     UrlHandle := InternetOpenUrl(NetHandle, PChar(Url), nil, 0,
                                  INTERNET_FLAG_RELOAD, 0);
     Result := True;
  end
  else begin
     raise Exception.Create('Dev-PHP was not able to download update file. Please see http://devphp.sourceforge.net');
     Result := False;
  end;
end;

constructor TCheckForUpdate.Create;
begin
  inherited Create;
  Application.ProcessMessages;
end;

procedure TCheckForUpdate.Disconnect;
begin
  InternetCloseHandle(UrlHandle);
  UrlHandle := nil;
end;

procedure TCheckForUpdate.Download;
var F : TextFile;
begin
  if Assigned(UrlHandle) then
     { UrlHandle valid? Proceed with download }
  begin
     FillChar(Buffer, SizeOf(Buffer), 0);
     repeat
        UpdateFile := UpdateFile + Buffer;
        FillChar(Buffer, SizeOf(Buffer), 0);
        InternetReadFile(UrlHandle, @Buffer, SizeOf(Buffer), BytesRead);
     until BytesRead = 0;
     Disconnect;

     AssignFile(F,LocalFileName);
     Rewrite(F);
     Write(F, UpdateFile);
     CloseFile(F);
  end
  else begin
     { UrlHandle is not valid. Raise an exception. }
     raise Exception.CreateFmt('Cannot get update file. Please visit http://devphp.sourceforge.net to check for updates.', []);
     Disconnect;
  end;
end;

procedure TUpdateForm.FormActivate(Sender: TObject);
var
  iCheck: TCheckForUpdate;
  stream:TMemoryStream;
begin
  stream:=TMemoryStream.Create;
  if not FirstStart then Exit;
  FirstStart := False;
  Local.Text := DevPHPVer;
//  Check := TCheckForUpdate.Create;
  Application.ProcessMessages;
  iCheck:=TCheckForUpdate.Create;
  with iCheck do begin
     L.Text := ' Connecting...';
     Application.ProcessMessages;
     idhttp1.Connect;
     L.Text := ' Downloading update file...';
     Application.ProcessMessages;
     idhttp1.Get(URL,stream);
     stream.SaveToFile(LocalFilename);
     Application.ProcessMessages;
     L.Text := ' Disconnecting...';
     Application.ProcessMessages;
     idhttp1.Disconnect;
     L.Text := ' Checking update file...';
     Application.ProcessMessages;
     doCheck();
     L.Text := ' Done';
     Application.ProcessMessages;
  end;
  stream.Free;
end;

procedure TUpdateForm.FormCreate(Sender: TObject);
begin
  FirstStart := True;
end;

procedure TCheckForUpdate.doCheck;
var
  VersionName, Description : string;
begin
  if not FileExists(LocalFileName) then begin
     MessageDlg('Dev-PHP was not able to download the update file. Please see http://devphp.sourceforge.net', mtError, [mbOK],0);
     Exit;
  end;
  VersionName := settings.Version;
  UpdateForm.Remote.Text := VersionName;
  if VersionName = DevPHPVer then
     MessageDlg('You are currently using the newest release, there is no need to download it.',MtInformation,[mbOK],0)
  else begin
     UpdateForm.DSite.Text := settings.DSiteText;
     Description := settings.Description;
     Description := StringReplace(Description, '[NL]', #13#10, [rfReplaceAll]);
     UpdateForm.Description.Lines.Clear;
     UpdateForm.Description.Lines.Add(Trim(Description));
     MessageDlg('There is a new Dev-PHP version available: ' + VersionName,MtInformation,[mbok],0);
     UpdateForm.DownloadUpdate.Enabled := True;
     UpdateForm.Description.Repaint;
  end;
end;

procedure TUpdateForm.DownloadUpdateClick(Sender: TObject);
begin
  ShellExecute(GetDesktopWindow, 'open', pChar(DSite.Text), nil, nil, SW_SHOWNORMAL);
end;

procedure TUpdateForm.acceptClick(Sender: TObject);
begin
  Close;
end;

procedure TUpdateForm.FormShow(Sender: TObject);
begin
  Self.Font.Name := settings.DialogFontText;
end;

procedure TUpdateForm.FormKeyUp(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if Key=VK_ESCAPE then begin
    Close; Key:=0;
  end;
end;

end.
