(* $Id: mUtilityunit.pas,v 1.3 2004/02/24 15:31:40 urmade Exp $ *)
unit mUtilityunit;
interface
//{$I BORCVS.inc}
uses
  windows,
  typinfo;
//---------------------------------------------------------------------------
function GetQuotedString(str: string): string;
function GetOptQuotedString(str: string): string;

function GetCorrectFilename(name: string; workdir: string): string;
function GetTempDir: string;

{$IFNDEF D6UP}

{
2002-12-19 Per-Eric Larsson
These are some functions that have been added
in later versions of delphi - it's easier to have all
compability problems in one file :-)
}
procedure RaiseLastOSError;
function IncludeTrailingPathDelimiter(const S: string): string;

function Supports(const Instance: IUnknown; const IID: TGUID): Boolean;
overload;
function Supports(const Instance: TObject; const IID: TGUID): Boolean; overload;
function Supports(const AClass: TClass; const IID: TGUID): Boolean; overload;

{$ENDIF}

// SystemTime functions
function CVSTimeToSystemTime(CVSTimestring: string): SystemTime;
function IsSameSystemTime(Ft1, Ft2: SystemTime): boolean;
Function IsDLL:Boolean;
Function Package_Dll_name:string;
// debugging functions
function SystemTimeString(const st: SystemTime): string;
function BoolString(const b: Boolean): string;

//---------------------------------------------------------------------------
implementation
uses
  mPELDebugit,
  SysUtils;
//---------------------------------------------------------------------------

{$TYPEINFO ON}
{Needed for the  GetEnumValue() function used in datetime conversion}

type
  Tmonths = (Oops, Jan, Feb, Mar, Apr, May, Jun, Jul, Aug, Sep, Oct, Nov, Dec);
{ There is no month equal to zero so I added a dummy month "oops" !}

{$IFNDEF D6UP}

{ RaiseLastOSError is the new name for RaiseLastWin32Error }

procedure RaiseLastOSError;
begin
  RaiseLastWin32Error;
end;

{ IncludeTrailingPathDelimiter is the new name for IncludeTrailingBackslash  }

function IncludeTrailingPathDelimiter(const S: string): string;
begin
  result := IncludeTrailingBackslash(s);
end;

{ Interface support routines }

function Supports(const Instance: IUnknown; const IID: TGUID): Boolean;
var
  Temp: IUnknown;
begin
  Result := Supports(Instance, IID, Temp);
end;

function Supports(const Instance: TObject; const IID: TGUID): Boolean;
var
  Temp: IUnknown;
begin
  Result := Supports(Instance, IID, Temp);
end;

function Supports(const AClass: TClass; const IID: TGUID): Boolean;
begin
  Result := AClass.GetInterfaceEntry(IID) <> nil;
end;

{$ENDIF}

function GetTempDir: string;
var
  l: cardinal;
  u: UINT;
begin
  l := 255;
  setlength(result, l);
  u := GetTempPath(255, pchar(result));
  if (u > 0) then
  begin
    setlength(result, u);
  end
  else
  begin
    result := '';
  end;
end;

function GetQuotedString(str: string): string;
begin
  result := '"' + trim(Str) + '"';
end;
//---------------------------------------------------------------------------

function GetOptQuotedString(str: string): string;
begin
  result := str;
  if (Pos(' ', str) > 0) then
    result := GetQuotedString(str);
end;
//---------------------------------------------------------------------------

function GetCorrectFilename(name: string; workdir: string): string;
var
  i: integer;
begin
  if (Pos('\', name) > 0) or (Pos('/', name) > 0) then
  begin
    result := name;
    for i := 1 to Length(result) do
    begin
      if (result[i] = '/') then
        result[i] := '\';
    end;
  end
  else
  begin
    result := workdir + name;
  end;
end;

function BoolString(const b: Boolean): string;
const
  CBoolStr: array[false..true] of string = ('false', 'true');
begin
  result := CBoolStr[b];
end;

function SystemTimeString(const st: SystemTime): string;
begin
  if st.wYear = 0 then
  begin
    result := 'Not available';
  end
  else
  begin
    result :=
      format('%.4d-%.2d-%.2d %.2d:%.2d:%.2d',
      [st.wYear, st.wMonth, st.wDay,
      st.wHour, st.wMinute, st.wSecond]);
  end;
end;

function CVSTimeToSystemTime(CVSTimestring: string): SystemTime;
var
  Code: integer;
begin
  val(Copy(CVSTimestring, 21, 4), result.wYear, Code);
  val(Copy(CVSTimestring, 9, 2), result.wDay, Code);
  result.wMonth := GetEnumValue(TypeInfo(Tmonths), Copy(CVSTimestring, 5, 3));
  val(Copy(CVSTimestring, 12, 2), result.wHour, Code);
  val(Copy(CVSTimestring, 15, 2), result.wMinute, Code);
  val(Copy(CVSTimestring, 18, 2), result.wSecond, Code);
end;
//------------------------------------------------------------
// windows builtin CompareFileTime() is too accurate - dont care about msecs !

function IsSameSystemTime(Ft1, Ft2: SystemTime): boolean;
// temporaryfix for DST BUG !
begin
  result := false;
  if ft1.wYear <> ft2.wYear then
    exit;
  if ft1.wMonth <> ft2.wMonth then
    exit;
  if ft1.wDay <> ft2.wDay then
    exit;
//  if ft1.wHour <> ft2.wHour then
//  begin
//    exit;
  if ft1.wMinute <> ft2.wMinute then
    exit;
  if ft1.wSecond <> ft2.wSecond then
    exit;
  if ft1.wHour <> ft2.wHour then
  begin
// fix, If exactly one hour difference then assume equal !
    if abs(ft1.wHour - ft2.wHour) <> 1 then
      exit;
  end;
  result := true;
end;

Function IsDLL:Boolean;
begin
  result:=UpperCase(ExtractFileExt(Package_Dll_name))='.DLL';
end;

Function Package_Dll_name:string;
var
  Buf: array[0..MAX_PATH + 1] of Char;
begin
  GetModuleFileName(HINSTANCE, Buf, SizeOf(Buf) - 1);
  Result := StrPas(Buf);
end;

end.
