//
// +----------------------------------------------------------------------+
// | Dev-PHP - Integrated Development Environment                         |
// +----------------------------------------------------------------------+
// | Copyright (C) 2002-2003, http://devphp.sourceforge.net               |
// +----------------------------------------------------------------------+
// | This program is free software; you can redistribute it and/or modify |
// | it under the terms of the GNU General Public License as published by |
// | the Free Software Foundation; either version 2 of the License, or    |
// | (at your option) any later version.                                  |
// | This program is distributed in the hope that it will be useful       |
// | but WITHOUT ANY WARRANTY; without even the implied warranty of       |
// | MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the         |
// | GNU General Public License for more details.                         |
// +----------------------------------------------------------------------+
// | Author: Leonardo Garca <simbiotik@users.sourceforge.net>            |
// | Author: Urs Mder       <ursmaeder@users.sourceforge.net>            |
// +----------------------------------------------------------------------+
//
unit uEditor;

interface

uses Windows, SysUtils, Classes, Graphics, Controls, Forms, Dialogs, consts,
  Menus, ImgList, ComCtrls, StdCtrls, ExtCtrls, SynEdit, SynEditKeyCmds, Grids,
  SynCompletionProposal, StrUtils, SynEditTypes, SynEditHighlighter, devTabs,
  uHighlighterProcs, uLang, uIniFile,version,SynEditSearch,ShellCtrls;

type
  TEditor = class
    procedure Init(FileName : string; LoadFile : boolean);
    procedure SaveFile(focus: boolean);
    procedure SaveAs;
    procedure NameHighlighters;
    procedure LoadEditorSettings;
    procedure Close(t: TTabSheet);
    constructor create;
    destructor destroy; override;
  protected
    procedure SynEditStatusChange(Sender: TObject;
      Changes: TSynStatusChanges);
    procedure SynEditPaintTransient(Sender: TObject; Canvas: TCanvas;
      TransientType: TTransientType);
    procedure SynEditKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure FindMetas;
  private
    Fmodifed: boolean;
    { Nothing }
    procedure Setmodifed(const Value: boolean);
    procedure SynEditChange(Sender: TObject);
  public
    fTabSheet : TTabSheet;
    fFileName : string;
    SynEdit : TSynEdit;
    MSynEditSearch:TSynEditSearch;
    szInsert : string;
    LB:string;
  published
    property modified:boolean read Fmodifed write Setmodifed;
  end;

implementation

uses frmMain;

procedure TEditor.NameHighlighters;
begin
  with MainFrm do begin
  if PageControl.PageCount > 0 then begin
    if Assigned(SynEdit.Highlighter) then begin
      if SynEdit.Highlighter = SynMultiSyn1 then begin
        StatusBar1.Panels[3].Text := 'HTML - JScript - CSS';
      end else
      if SynEdit.Highlighter = SynSQLSyn1 then begin
        StatusBar1.Panels[3].Text := 'mySQL';
      end else
      if SynEdit.Highlighter = SynHTMLSyn1 then begin
        StatusBar1.Panels[3].Text := 'HTML';
      end else
      if SynEdit.Highlighter = SynXMLSyn1 then begin
        StatusBar1.Panels[3].Text := 'XML';
      end else begin
        StatusBar1.Panels[3].Text := SynEdit.Highlighter.LanguageName;
      end;
    end else begin
      StatusBar1.Panels[3].Text := Texto1.Caption;
    end;
  end;
  end;
end;

procedure TEditor.SynEditKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
try
  case Key of
  vk_Insert : if (not (ssCtrl in Shift)) and (not (ssShift in Shift)) then  begin
                if szInsert = Lang(1252) then
                   szInsert := Lang(1251)
                else
                   szInsert := Lang(1252);
                MainFrm.StatusBar1.Panels[2].Text := szInsert;
                Exit;
              end;
  vk_Left, vk_Up, vk_Right, vk_Down : SynEdit.InvalidateLine(SynEdit.CaretY);
  vk_Space: if ssCtrl in Shift then begin
    mainFrm.AutoComplete.CurrentString:=synedit.WordAtCursor;
    mainFrm.AutoComplete.Editor:=mainFrm.GetEditor.SynEdit;
    mainFrm.AutoComplete.ActivateCompletion;
  end;
  vk_Control: begin
    MainFrm.EditMenuClick(self);
  end;
  vk_Tab: begin
    if synedit.SelLength=0 then exit;
    modified:=true;
    if ssShift in Shift then MainFrm.DeIndent1Click(sender) else MainFrm.Indent1Click(sender);
    Key:=0;
  end;
//  vk_End, vk_Home,
  vk_Shift, vk_NumLock, vk_Escape, vk_Menu,
  vk_Capital, vk_Prior, vk_Next, vk_Pause, vk_Scroll : exit;
  end;
except
end;
end;

procedure TEditor.SynEditStatusChange(Sender: TObject;
  Changes: TSynStatusChanges);
begin
  if Changes * [scAll, scCaretX, scCaretY] <> [] then begin
    MainFrm.StatusBar1.Panels[0].Text := Format('%12d:%4d',
      [SynEdit.CaretY, SynEdit.CaretX]);
  end;
end;

procedure TEditor.SaveAs;
var oldlb:string;
begin
  oldlb:=LB;
  MainFrm.SaveDialog.InitialDir:=MainFrm.ShellTreeView1.selectedFolder.PathName;
  MainFrm.SaveDialog.FilterIndex:=gsettings.SaveType+1;
  MainFrm.SaveDialog.FileName := fTabSheet.Caption;
  if fFilename<>'' then MainFrm.SaveDialog.FileName:=fFilename;
  if MainFrm.SaveDialog.Execute then begin
    case MainFrm.SaveDialog.FilterIndex of
    1: LB:=#13#10;
    2: LB:=#10;
    3: LB:=#13;
    end;
    if FileExists(MainFrm.SaveDialog.FileName) then begin
      case MessageDlg(Lang(950) + #13#10 + Lang(951), mtConfirmation, [mbYes, mbNo], 0) of
        mrYes : begin
                  fFileName := MainFrm.SaveDialog.FileName;
                  SaveFile(false);
                end;
        mrNo : Exit;
      end;
    end else begin
      fFileName := MainFrm.SaveDialog.FileName;
      SaveFile(false);
    end;
    modified := TRUE;
    MainFrm.ASave.Enabled := FALSE;
    fTabSheet.Caption := ExtractFileName(fFileName);
    Application.ProcessMessages;
  end;
  SynEdit.SetFocus;
  LB:=oldLB;
end;

procedure TEditor.Close(t:TTabSheet);
begin
  MainFrm.EnableSaveAll;
  t.destroy;
  MainFrm.ActivarBotones(FALSE);
end;

procedure TEditor.SynEditChange(Sender: TObject);
begin
  modified := true;
end;

procedure TEditor.SaveFile(focus:boolean);
var
  WasSaved : boolean;
  s:string;

  function GetTextStr(str:TStrings;LB:string): string;
  var
    I, L, Size, Count: Integer;
    P: PChar;
    S: string;
  begin
    Count := str.Count;
    Size := 0;
    for I := 0 to Count - 1 do Inc(Size, Length(str[I]) + Length(LB));
    SetString(Result, nil, Size);
    P := Pointer(Result);
    for I := 0 to Count - 1 do
    begin
      S := str[I];
      L := Length(S);
      if L <> 0 then
      begin
        System.Move(Pointer(S)^, P^, L);
        Inc(P, L);
      end;
      L := Length(LB);
      if L <> 0 then
      begin
        System.Move(Pointer(LB)^, P^, L);
        Inc(P, L);
      end;
    end;
  end;

  procedure SaveToStream(str:TStrings;Stream: TStream;LB:String);
  var
    S: string;
  begin
    S := GetTextStr(str,LB);
    Stream.WriteBuffer(Pointer(S)^, Length(S));
  end;

  procedure SaveToFile(str:TStrings;const FileName: string;LineBreak:String);
  var
    Stream: TStream;
  begin
    Stream := TFileStream.Create(FileName, fmCreate);
    try
      SaveToStream(str,Stream,LineBreak);
    finally
      Stream.Free;
    end;
  end;

begin
  WasSaved := FALSE;
  case gsettings.SaveType of
    0: LB:=#13#10;
    1: LB:=#10;
    2: LB:=#13;
  end;
  if fFileName <> '' then begin
    SaveToFile(SynEdit.Lines,fFilename,LB);
    WasSaved := TRUE;
  end else begin
    s:=fTabSheet.Caption;
    if s[length(s)]='*' then delete(s,length(s),1);
    MainFrm.SaveDialog.FileName := s;
    if MainFrm.SaveDialog.Execute then begin
      fFileName := MainFrm.SaveDialog.FileName;
      SaveToFile(SynEdit.Lines,fFilename,LB);
      WasSaved := TRUE;
    end;
  end;
  if WasSaved = TRUE then begin
    modified := false;
    MainFrm.ASave.Enabled := FALSE;
    fTabSheet.Caption := ExtractFileName(fFileName);
  end;
  MainFrm.EnableSaveAll;
  Application.ProcessMessages;
  if focus then SynEdit.SetFocus;
end;

procedure TEditor.Init(FileName : string; LoadFile : boolean);
begin
  if LoadFile = TRUE then begin
    fFileName := FileName;
  end else begin
    fFileName := '';
  end;

  fTabSheet := TTabSheet.Create(MainFrm.PageControl);
  fTabSheet.Caption := ExtractFileName(FileName);
  fTabSheet.PageControl := MainFrm.PageControl;
  fTabSheet.TabVisible:= FALSE;
  fTabSheet.Tag := integer(self);
  MainFrm.PageControl.PopupMenu:=MainFrm.PopupMenu5;

  SynEdit := TSynEdit.Create(MainFrm.PageControl);
  SynEdit.Align := alClient;
  SynEdit.Parent := fTabSheet;
  SynEdit.Visible := TRUE;
  SynEdit.Gutter.UseFontStyle := FALSE;
  SynEdit.Gutter.ShowLineNumbers := TRUE;
  SynEdit.Options := [
                        // eoAutoIndent,
                        // eoScrollPastEol,
                        // eoSmartTabDelete,
                        // eoTabIndent,
                        // eoTabsToSpaces,
                        // eoTrimTrailingSpaces
                        eoDragDropEditing,
                        eoDropFiles,
                        eoGroupUndo,
                        eoKeepCaretX,
                        eoScrollByOneLess,
                        eoShowScrollHint,
                        eoEnhanceHomeKey
                       ];
  LoadEditorSettings;

  if (fFileName <> '') and (FileExists(fFileName)) then
    SynEdit.Lines.LoadFromFile(FileName);

  SynEdit.OnChange := SynEditChange;
  SynEdit.OnDropFiles := MainFrm.SynEditDropFiles;
  SynEdit.OnKeyDown := SynEditKeyDown;
  SynEdit.OnStatusChange := SynEditStatusChange;

  SynEdit.Repaint;
  SynEdit.ClearUndo;
  Synedit.Hint:='';

  SynEdit.Highlighter := GetHighlighterFromFileExt(MainFrm.fHighlighters, ExtractFileExt(fFileName));
  if SynEdit.Highlighter = MainFrm.SynHTMLSyn1 then SynEdit.Highlighter := MainFrm.SynMultiSyn2;
  if SynEdit.Highlighter = MainFrm.SynPHPSyn then SynEdit.Highlighter := MainFrm.SynMultiSyn2;
  SynEdit.SearchEngine:=MainFrm.SynEditSearch1;
  NameHighlighters;
  MainFrm.ASave.Enabled := FALSE;
  FindMetas;

  MainFrm.scpParams.Editor := SynEdit;
  MainFrm.AutoComplete.Editor := SynEdit;
  MainFrm.Caption := 'Dev-PHP ' + DevPHPVer + ' - [ ' + ExtractFileName(fTabSheet.Caption) + ' ]';
  MainFrm.StatusBar1.Panels[0].Text := Format('%12d:%4d', [SynEdit.CaretY, SynEdit.CaretX]);
  with SynEdit do
    if MainFrm.S1.checked then
      Options:=Options + [eoShowSpecialChars] else Options:=Options - [eoShowSpecialChars];

  fTabSheet.PageControl.ActivePage := fTabSheet;
  fTabSheet.TabVisible := TRUE;
  fTabSheet.PageControl.Visible := TRUE;
  modified := FALSE;
end;

procedure TEditor.LoadEditorSettings;
begin
  if settings.BracesChecked = TRUE then begin
    if not Assigned(SynEdit.OnPaintTransient) then begin
      SynEdit.OnPaintTransient := SynEditPaintTransient;
    end;
  end else begin
    SynEdit.OnPaintTransient := nil;
  end;
  SynEdit.Gutter.Visible := gsettings.LineNumbers;
  SynEdit.Color := gsettings.DemoEditColor;
  SynEdit.RightEdge := settings.UpDown1Position;
  SynEdit.Font.Size := gsettings.UpDown2Position;
  SynEdit.TabWidth := gsettings.UpDown3Position;
  SynEdit.Font.Name := gsettings.EditorFontText;
  SynEdit.SetOptionFlag(eoAutoIndent,gsettings.AutoIndent);
  SynEdit.WantTabs := TRUE;
  SynEdit.WordWrap:=gsettings.WordWrap;
  SynEdit.SearchEngine:=MainFrm.SynEditRegexSearch1;
end;

procedure TEditor.SynEditPaintTransient(Sender: TObject; Canvas: TCanvas;
  TransientType: TTransientType);
const
  BracketSet = ['{','[','(','}',']',')'];
  OpenChars:array[0..2] of Char=('{','[','(');
  CloseChars:array[0..2] of Char=('}',']',')');

  function CharToPixels(P: TBufferCoord): TPoint;
  begin
//    Result:=P;
    Result:=SynEdit.RowColumnToPixels(Synedit.BufferToDisplayPos(P));
    //Result.Y:=Result.Y-1;
  end;

var P:  TbufferCoord;
    Pix: TPoint;
    S: String;
    I: Integer;
    Attri: TSynHighlighterAttributes;
begin
  if not Assigned(SynEdit.Highlighter) then
    Exit;

  P := SynEdit.CaretXY;
  SynEdit.GetHighlighterAttriAtRowCol(P, S, Attri);
  if (SynEdit.CaretX<=length(SynEdit.LineText) + 1) and
     (SynEdit.Highlighter.SymbolAttribute = Attri) then begin
    for i := 0 to 2 do begin
      if (S = OpenChars[i]) or (S = CloseChars[i]) then begin
        Pix := CharToPixels(P);
        SynEdit.Canvas.Brush.Style := bsSolid;
        SynEdit.Canvas.Font.Assign(SynEdit.Font);
        SynEdit.Canvas.Font.Style := Attri.Style;

        if (TransientType = ttAfter) then begin
          if SynEdit.Highlighter.SymbolAttribute.Background <> clNone then
            SynEdit.Canvas.Font.Color := SynEdit.Highlighter.SymbolAttribute.Background
          else
            SynEdit.Canvas.Font.Color := SynEdit.Brush.Color;
          SynEdit.Canvas.Brush.Color := SynEdit.Highlighter.SymbolAttribute.Foreground;
        end
        else begin
          if SynEdit.Highlighter.SymbolAttribute.Foreground <> clNone then
            SynEdit.Canvas.Font.Color:= SynEdit.Highlighter.SymbolAttribute.Foreground
          else
            SynEdit.Canvas.Font.Color:= SynEdit.Font.Color;
          if SynEdit.Highlighter.SymbolAttribute.Background <> clNone then
            SynEdit.Canvas.Brush.Color:= SynEdit.Highlighter.SymbolAttribute.Background
          else
            SynEdit.Canvas.Brush.Color:= SynEdit.Brush.Color;
        end;

        SynEdit.Canvas.TextOut(Pix.X, Pix.Y, S);
        P := SynEdit.GetMatchingBracketEx(P);

        if (P.Char > 0) and (P.Line > 0) then begin
          Pix := CharToPixels(P);
          if S = OpenChars[i] then
            SynEdit.Canvas.TextOut(Pix.X, Pix.Y, CloseChars[i])
          else
            SynEdit.Canvas.TextOut(Pix.X, Pix.Y, OpenChars[i]);
        end;
      end;
    end;
    SynEdit.Canvas.Brush.Style := bsSolid;
  end;
end;

procedure TEditor.FindMetas;
var
  p1,p2,i,c : integer;
  s : string;
begin
{
  This procedure looks for FrontPage's "Generator" and "ProgId" METAs and
  replaces them with the Dev-PHP ones (if the META is "Generator"), or deletes
  them (if the META is "ProgId").
  Hey, don't bother me.. FrontPage does the same (test by yourself if you don't
  belive me!).
}
  for i := 0 to SynEdit.Lines.Count-1 do begin
    s := LowerCase(SynEdit.Lines[i]);
    if (pos('<meta',s) <> 0) and (pos('content="',s) <> 0) then begin
      if (pos('name="generator"',s) <> 0) or (pos('name=''generator''',s) <> 0) or (pos('name=generator',s) <> 0) then begin
        p1 := pos('content="',s);
        p2 := pos('"',s);
        while p1 > p2 do begin
          Delete(s,p2,1);
          p2 := pos('"',s);
        end;
        Delete(s,p2,1);
        p2 := pos('"',s) + 1;
        s := SynEdit.Lines[i];
        if pos('name=',s) > pos('content=',s) then begin
          c := 1;
        end else begin
          c := 3;
        end;
        Delete(s,p1,(p2-p1)+c);
        Insert('content="Dev-PHP ' + DevPHPVer + '"',s,p1);
        SynEdit.Lines[i] := s;
      end;
      s := LowerCase(SynEdit.Lines[i]);
      if (pos('name="progid"',s) <> 0) or (pos('name=progid',s) <> 0) then begin
        p1 := pos('<meta',s);
        p2 := pos('>',s);
        while p1 > p2 do begin
          Delete(s,p2,1);
          p2 := pos('>',s);
        end;
        s := SynEdit.Lines[i];
        Delete(s,p1,(p2-p1+1));
        if trim(s) = '' then begin
          SynEdit.Lines.Delete(i);
        end else begin
          SynEdit.Lines[i] := s;
        end;
      end;
    end;
  end;
end;

constructor TEditor.create;
begin
  inherited create;
  LB:=#13#10;
end;

destructor TEditor.destroy;
begin
  inherited destroy;
end;

procedure TEditor.Setmodifed(const Value: boolean);
begin
  Fmodifed := Value;
  if Value then begin
    SynEdit.Modified:=Value;
    MainFrm.ASave.Enabled := TRUE;
    MainFrm.ASaveAll.Enabled := TRUE;
    MainFrm.StatusBar1.Panels[1].Text := Lang(1250);
    MainFrm.EditMenuClick(self);
    if MainFrm.pagecontrol.ActivePage=nil then exit;
    with MainFrm.pagecontrol.ActivePage do begin
      if caption[length(caption)]<>'*' then begin
        Caption:=Caption+'*';
      end;
    end;
  end;
end;

end.
