//
// +----------------------------------------------------------------------+
// | Dev-PHP - Integrated Development Environment                         |
// +----------------------------------------------------------------------+
// | Copyright (C) 2002-2003, http://devphp.sourceforge.net               |
// +----------------------------------------------------------------------+
// | This program is free software; you can redistribute it and/or modify |
// | it under the terms of the GNU General Public License as published by |
// | the Free Software Foundation; either version 2 of the License, or    |
// | (at your option) any later version.                                  |
// | This program is distributed in the hope that it will be useful       |
// | but WITHOUT ANY WARRANTY; without even the implied warranty of       |
// | MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the         |
// | GNU General Public License for more details.                         |
// +----------------------------------------------------------------------+
// | Author: Leonardo Garca <simbiotik@users.sourceforge.net>            |
// | Author: Urs Mder <ursmaeder@users.sourceforge.net>                  |
// +----------------------------------------------------------------------+
//

unit uIniFile;

interface

uses Classes, Dialogs, IniFiles, Forms, graphics, SysUtils,
     SynEditHighlighter,SynHighlighterSQL, SynHighlighterJScript,
     SynHighlighterHtml, SynHighlighterCss, SynHighlighterPHP, SynEdit, 
     version,DCPrc4,DCPsha1;

type

TGlobSettings=class (TPersistent)
    constructor Create();
    destructor Destroy;override;
  private
    fIdiomaText:string;
    fEdit1Text: string;
    fEditorFontText:string;
    fDemoEditColor:integer;
    fUpDown4Position:integer;
    fUpDown2Position:integer;
    fUpDown3Position:integer;
    fStatusBar1visible:boolean;
    fDocsPathText: string;
    fdl: string;
    fLastProject:string;
    fToolBar1visible:boolean;
    fhtmlbar1visible:boolean;
    feditbar1visible:boolean;
    fLineNumbers:boolean;
    fMainFormWindowState: integer;
    fMainFormLeft : integer;
    fMainFormTop : integer;
    fMainFormwidth : integer;
    fMainFormHeight : integer;
    fDateFmt:string;
    fTimeFmt:string;
    fDateTimeFmt:string;
    fSaveType:integer;
    fHideSideBar:boolean;
    fAutoIndent:boolean;
    fWordWrap:boolean;
    fSideBarWidth:integer;
    fDockSideBar:string;
    procedure wEdit1Text(const Value: string);
    procedure wDemoEditColor(const Value: integer);
    procedure wUpDown4Position(const Value: integer);
    procedure wUpDown2Position(const Value: integer);
    procedure wUpDown3Position(const Value: integer);
    procedure wEditorFontText(const Value: string);
    procedure wStatusBar1visible(const Value: boolean);
    procedure wDocsPathText(const Value: string);
    procedure wdl(const Value: string);
    procedure wIdiomaText(const Value:string);
    procedure wLastProject(const Value:string);
    procedure wToolBar1visible(const Value: boolean);
    procedure whtmlbar1visible(const Value: boolean);
    procedure weditbar1visible(const Value: boolean);
    procedure wLineNumbers(const Value: boolean);
    procedure wMainFormWindowState(const Value: integer);
    procedure wMainFormLeft (const Value: integer);
    procedure wMainFormTop (const Value: integer);
    procedure wMainFormwidth (const Value: integer);
    procedure wMainFormHeight (const Value: integer);
    procedure wDateFmt(const Value:string);
    procedure wTimeFmt(const Value:string);
    procedure wDateTimeFmt(const Value:string);
    procedure wSaveType(const Value:integer);
    procedure wHideSideBar(const Value:boolean);
    procedure wSideBarWidth(const Value:integer);
    procedure wAutoIndent(const Value:boolean);
    procedure wWordWrap(const Value:boolean);
    procedure wDockSideBar(const Value:string);
  protected
  public
  published
    property Edit1Text:string read fEdit1Text write wEdit1Text;
    property UpDown4Position:integer read fUpDown4Position write wUpDown4Position;
    property UpDown2Position:integer read fUpDown2Position write wUpDown2Position;
    property UpDown3Position:integer read fUpDown3Position write wUpDown3Position;
    property DemoEditColor:integer read fDemoEditColor write wDemoEditColor;
    property EditorFontText:string read fEditorFontText write wEditorFontText;
    property StatusBar1visible:boolean read fStatusBar1visible write wStatusBar1visible;
    property DocsPathText :string read fDocsPathText write wDocsPathText;
    property dl :string read fdl write wdl;
    property IdiomaText:string read fIdiomaText write wIdiomaText;
    property LastProject:string read fLastProject write wLastProject;
    property toolbar1visible:boolean read fToolbar1visible write wToolbar1visible;
    property htmlbar1visible:boolean read fhtmlbar1visible write whtmlbar1visible;
    property editbar1visible:boolean read feditbar1visible write weditbar1visible;
    property LineNumbers:boolean read fLineNumbers write wLineNumbers;
    property MainFormWindowState:Integer read fMainFormWindowState write wMainFormWindowState;
    property MainFormLeft :Integer read fMainFormLeft write wMainFormLeft;
    property MainFormTop :Integer read fMainFormTop write wMainFormTop;
    property MainFormwidth :Integer read fMainFormwidth write wMainFormwidth;
    property MainFormHeight :Integer read fMainFormHeight write wMainFormHeight;
    property DateFmt:string read fDateFmt write wDateFmt;
    property TimeFmt:String read fTimeFmt write wTimeFmt;
    property DateTimeFmt:String read fDateTimeFmt write wDateTimeFmt;
    property SaveType:integer read fSaveType write wSaveType;
    // 0 = DOS - 1 = UNIX - 2 = MAC
    property HideSideBar:boolean read fHideSideBar write wHideSideBar;
    property AutoIndent:boolean read fAutoIndent write wAutoIndent;
    property WordWrap:boolean read fWordWrap write wWordWrap;
    property SideBarWidth:integer read fSideBarWidth write wSideBarWidth;
    property DockSideBar:String read fDockSideBar write wDockSideBar;
end;

TSettings = class (TPersistent)
    constructor Create();
    destructor Destroy;override;
  private
    fUpDown1Position:integer;
    fDemoEditFontName: string;
    fBracesChecked: boolean;
    fSaveSessionChecked: boolean;
    fDialogFontText: string;
    fFTPcfname:string;
    fFTPPassive:boolean;
    fFTPPortText: string;
    flocalpathText: string;
 //   fFTPPasswordText: string;
    fFTPPasswordSave: string;
    fFTPServerPathText: string;
    fFTPHostText: string;
    fWebServerPathText: string;
    fFTPUserText: string;
    flocalPortText: string;
    fregJsChecked: boolean;
    fregCssChecked: boolean;
    fregHtmlChecked: boolean;
    fregSqlChecked: boolean;
    fregPhpChecked: boolean;
    fParams: string;
    fHistory:TStringList;
    fSession:TStringList;
    fFindDialog1FindText:string;
    fReplaceDialog1FindText:string;
    fSessionActive: integer;
    fDocFilename:string;
    fDocLang:string;
    fExternPath:string;
    fVersion:string;
    fDSiteText:string;
    fDescription:string;
    fBrowserPath:string;
    procedure wDemoEditFontName(const Value: string);
    procedure wBracesChecked(const Value: boolean);
    procedure wDialogFontText(const Value: string);
    procedure wSaveSessionChecked(const Value: boolean);
    procedure wFTPcfname(const value:string);
    procedure wFTPPassive(const Value:boolean);
    procedure wFTPHostText(const Value: string);
//    procedure wFTPPasswordText(const Value: string);
    procedure wFTPPasswordSave(const Value: string);
    procedure wFTPPortText(const Value: string);
    procedure wFTPServerPathText(const Value: string);
    procedure wFTPUserText(const Value: string);
    procedure wlocalpathText(const Value: string);
    procedure wlocalPortText(const Value: string);
    procedure wWebServerPathText(const Value: string);
    procedure wUpDown1Position(const Value: integer);
    procedure wregCssChecked(const Value: boolean);
    procedure wregHtmlChecked(const Value: boolean);
    procedure wregJsChecked(const Value: boolean);
    procedure wregPhpChecked(const Value: boolean);
    procedure wregSqlChecked(const Value: boolean);
    procedure wParams(const Value: string);
    procedure wFindDialog1FindText (const Value:string);
    procedure wReplaceDialog1FindText (const Value:string);
    procedure wSessionActive (const Value: integer);
    procedure wDocFilename(const Value:string);
    procedure wDocLang(const Value:string);
    procedure wExternPath(const Value:string);
    procedure wVersion(const Value:string);
    procedure wDSiteText(const value:string);
    procedure wDescription(const value:string);
    procedure wBrowserPath(const value:string);
    function ReadPw():string;
  protected
  public
    procedure writeHistory();
    procedure writeSession();
    procedure clearHistory;
  published
    property UpDown1Position:integer read fUpDown1Position write wUpDown1Position;
    property DemoEditFontName:string read fDemoEditFontName write wDemoEditFontName;
    property BracesChecked :boolean read fBracesChecked write wBracesChecked;
    property SaveSessionChecked:boolean read fSaveSessionChecked write wSaveSessionChecked;
    property DialogFontText:string read fDialogFontText write wDialogFontText;
    property localpathText:string read flocalpathText write wlocalpathText;
    property localPortText:string read flocalPortText write wlocalPortText;
    property FTPcfname:string read fFTPcfname write wFTPcfname;
    property FTPPassive:boolean read fFTPPassive write wFTPPassive;
    property FTPHostText:string read fFTPHostText write wFTPHostText;
    property FTPPortText:string read fFTPPortText write wFTPPortText;
    property FTPUserText:string read fFTPUserText write wFTPUserText;
//    property FTPPasswordText:string read fFTPPasswordText write wFTPPasswordText;
    property FTPPasswordSave:string read fFTPPasswordSave write wFTPPasswordSave;
    property FTPServerPathText:string read fFTPServerPathText write wFTPServerPathText;
    property WebServerPathText:string read fWebServerPathText write wWebServerPathText;
    property regCssChecked :boolean read fregCssChecked write wregCssChecked;
    property regHtmlChecked :boolean read fregHtmlChecked write wregHtmlChecked;
    property regJsChecked :boolean read fregJsChecked write wregJsChecked;
    property regSqlChecked :boolean read fregSqlChecked write wregSqlChecked;
    property regPhpChecked :boolean read fregPhpChecked write wregPhpChecked;
    property Params :string read fParams write wParams;
    property FindDialog1FindText:string read fFindDialog1FindText write wFindDialog1FindText;
    property ReplaceDialog1FindText:string read fReplaceDialog1FindText write wReplaceDialog1FindText;
    property SessionActive:integer read fSessionActive write wSessionActive;
    property UDocFilename:string read fDocFilename write wDocFilename;
    property DocLang:string read fDocLang write wDocLang;
    property ExternPath:string read fExternPath write wExternPath;
    property Version:string read fVersion write wVersion;
    property DSiteText:string read fDSiteText write wDSiteText;
    property Description:string read fDescription write wDescription;
    property BrowserPath:string read fBrowserPath write wBrowserPath;
    property History:TStringList read fHistory write fHistory;
    property Session:TStringList read fSession write fSession;
end;

procedure CreateNewIniFile(CreateIni : boolean);
procedure CreateHighlighters( SynPHPSyn:TSynPHPSyn;SynCSSSyn1:TSynCssSyn;
                              SynJScriptSyn1:TSynJScriptSyn; SynSQLSyn1:TSynSQLSyn);
procedure LoadIniFile();
procedure LoadGIniFile();
procedure SaveIniFile(filename:string);
procedure LoadSynEditFromFile(DemoSyn:TSynPHPSyn);
procedure SaveSynEditFromFile(DemoSyn:TSynPHPSyn);
procedure freeIniFile;
procedure clearToolbars;

const keyStr='DEV-PHP is good';

var
    Settings:TSettings;
    GSettings:TGlobSettings;
    IniFile:TIniFile;
    OldIniFile:TIniFile;
    IniFileName:string;
    OldIniFilename:string;

implementation

procedure CreateNewIniFile(CreateIni : boolean);
begin
if FileExists(OldIniFileName) then
  SysUtils.DeleteFile(OldIniFileName);
  OldIniFile:=TIniFile.Create(OldIniFileName);
  if CreateIni = True then begin
    gsettings:=TGlobSettings.Create;
    gsettings.Edit1Text:=ExtractFilePath(Application.ExeName) + 'php.exe';
    gsettings.UpDown2Position:=10;
    gsettings.UpDown3Position:=2;
    gsettings.UpDown4Position:=80;
    gsettings.DemoEditColor:=16777215;
    gsettings.EditorFontText:='Courier New';
    gsettings.StatusBar1visible:=true;
    gsettings.toolbar1visible:=true;
    gsettings.htmlbar1visible:=true;
    gsettings.editbar1visible:=true;
    gsettings.LineNumbers:=true;
    gsettings.MainFormWindowState:=integer(wsnormal);
    gsettings.MainFormLeft:=10;
    gsettings.MainFormTop:=10;
    gsettings.MainFormwidth:=600;
    gsettings.MainFormHeight:=400;
    gsettings.DateFmt:='MM.DD.YYYY';
    gsettings.TimeFmt:='t';
    gsettings.DateTimeFmt:='MM.DD.YYYY t';
    gsettings.SaveType:=0;
    gsettings.HideSideBar:=false;
    gsettings.AutoIndent:=true;
    gsettings.WordWrap:=false;
    gsettings.sideBarWidth:=200;
    gsettings.DockSideBar:='TBDock2';
  end;
end;

procedure LoadGIniFile();
begin
  if not assigned(OldIniFile) then OldIniFile:=TIniFile.Create(OldIniFileName);
  if not assigned(gsettings) then gsettings:=TGlobSettings.Create;
  gsettings.DemoEditColor:= OldIniFile.ReadInteger('Edit','Color',ord(clwhite));
  gsettings.UpDown2Position := OldIniFile.ReadInteger('Edit','Size',8);
  gsettings.UpDown3Position := OldIniFile.ReadInteger('Edit','Tab',4);
  gsettings.UpDown4Position := OldIniFile.ReadInteger('Options', 'FunctionBrowser', 185);
  gsettings.Edit1Text:= OldIniFile.ReadString('Options','Parser','');
  gsettings.EditorFontText := OldIniFile.ReadString('Options','Font', 'Courier New');
  gsettings.StatusBar1visible:=OldIniFile.ReadBool('ToolBars','StatusBar',true);
  gsettings.DocsPathText := OldIniFile.ReadString('Documentation', 'Filename', '');
  gsettings.dl := OldIniFile.ReadString('Documentation', 'Lang', 'en');
  gsettings.IdiomaText := OldIniFile.ReadString('Options','LangFile',
    ExtractFilePath(Application.ExeName) + 'lang\english.lng');
  gsettings.LastProject:=OldIniFile.ReadString('Projects','Last',
    ExtractFilePath(Application.Exename)+
    ChangeFileExt(ExtractFileName(Application.Exename), '.prd'));
  gsettings.toolbar1visible:=OldIniFile.ReadBool('ToolBars','ToolBar',true);
  gsettings.htmlbar1visible:=OldIniFile.ReadBool('ToolBars','HtmlBar',true);
  gsettings.editbar1visible:=OldIniFile.ReadBool('ToolBars','EditBar',true);
  gsettings.LineNumbers:=OldIniFile.ReadBool('Edit','LineNums',True);
  gsettings.MainFormWindowState:=OldIniFile.ReadInteger('Options','WindowState',0);
  gsettings.MainFormLeft:=  OldIniFile.ReadInteger('Options','windowX',10);
  gsettings.MainFormTop:=  OldIniFile.ReadInteger('Options','windowY',10);
  gsettings.MainFormwidth:=   OldIniFile.ReadInteger('Options','windowW',400);
  gsettings.MainFormHeight:=OldIniFile.ReadInteger('Options','windowH',200);
  gsettings.DateFmt:=OldIniFile.ReadString('Options','DateFmt','MM.DD.YYYY');
  gsettings.TimeFmt:=OldIniFile.ReadString('Options','TimeFmt','t');
  gsettings.DateTimeFmt:=OldIniFile.ReadString('Options','DateTimeFmt','MM.DD.YYYY t');
  gsettings.SaveType:=OldIniFile.ReadInteger('Options','SaveType',0);
  gsettings.HideSideBar:=OldIniFile.ReadBool('Options','HideSideBar',false);
  gsettings.AutoIndent:=OldIniFile.ReadBool('Edit','AutoIndent',True);
  gsettings.WordWrap:=OldIniFile.ReadBool('Edit','WordWrap',False);
  gsettings.SideBarWidth:=OldIniFile.ReadInteger('Options','SideBarWidth',200);
  gsettings.DockSideBar:=OldIniFile.ReadString('Options','DockSideBar','TBDock2');
//  showmessage(inttostr(gsettings.TBFormBarx)+' '+
//    inttostr(gsettings.TBFormBary)+' '+
//    inttostr(gsettings.TBFormBarh)+' '+
//    inttostr(gsettings.TBFormBarw));
end;

procedure LoadIniFile();
var last,lauf:integer;
    s:string;
begin
  if assigned(IniFile) then IniFile.Free;
  if assigned(Settings) then Settings.free;
  IniFile:=TIniFile.Create(IniFileName);
  settings:=TSettings.Create();
  settings.UpDown1Position := IniFile.ReadInteger('Edit','Edge',80);
  settings.DemoEditFontName := IniFile.ReadString('Options','Font','Courier New');
  settings.BracesChecked := IniFile.ReadBool('Options', 'Highlight', True);
  settings.SaveSessionChecked := IniFile.ReadBool('Options', 'SaveSession', True);
  settings.DialogFontText := IniFile.ReadString('Options', 'DialogFont', 'Tahoma');
  settings.externPath := IniFile.ReadString('Options', 'ExternPath', 'http://sourceforge.org/dev-php/');
  settings.localpathText:=iniFile.ReadString('Options','LocalPath','');
  settings.localPortText:=iniFile.ReadString('Options','LocalPort','8080');
  settings.FTPcfname:=iniFile.readString('Options','FTPcfname','0');
  settings.FTPPassive:=iniFile.ReadBool('Options','FTPPassive',false);
  settings.FTPHostText:=iniFile.ReadString('Options','FTPHost','');
  settings.FTPPortText:=iniFile.ReadString('Options','FTPPort','21');
  settings.FTPUserText:=iniFile.ReadString('Options','FTPUser','anonymous');
//  settings.FTPPasswordText:=iniFile.ReadString('Options','FTPPassword','');
  settings.FTPPasswordSave:=settings.ReadPw();
  settings.FTPServerPathText:=iniFile.ReadString('Options','FTPServerPath','');
  settings.WebServerPathText:=iniFile.ReadString('Options','ExternPath','');
  settings.regCssChecked := IniFile.ReadBool('Registry', 'css', false);
  settings.regHtmlChecked := IniFile.ReadBool('Registry', 'html', false);
  settings.regJsChecked := IniFile.ReadBool('Registry', 'js', false);
  settings.regSqlChecked := IniFile.ReadBool('Registry', 'sql', false);
  settings.regPhpChecked := IniFile.ReadBool('Registry', 'php', true);
  settings.Params := IniFile.ReadString('Options','Parameters',' -q');
  settings.History.Clear;
  last:=inifile.ReadInteger('History','Last',0);
  if last>0 then begin
    for lauf:=1 to last do begin
      settings.History.Add(inifile.ReadString('History',inttostr(lauf),''));
    end;
  end;
  settings.Session.Clear;
  last:=inifile.ReadInteger('Session','Last',0);
  if last>0 then begin
    for lauf:=1 to last do begin
      s:=inifile.ReadString('Session',inttostr(lauf),'');
      settings.Session.Add(s);
    end;
  end;
  settings.FindDialog1FindText:=  iniFile.ReadString('Options', 'FindText', '');
  settings.ReplaceDialog1FindText:=  iniFile.ReadString('Options', 'ReplaceText', '');
  settings.SessionActive := IniFile.ReadInteger('Session', 'Active', 1);
  settings.DocLang := IniFile.ReadString('Documentation', 'Lang', 'en');
  settings.version := IniFile.ReadString('UPDATE', 'Version',DevPHPVer);
  settings.DSiteText := IniFile.ReadString('UPDATE', 'Download', '');
  settings.Description := IniFile.ReadString('UPDATE', 'Description', '');
  settings.BrowserPath:= IniFile.ReadString('Options','BrowserPath','http://devphp.sourceforge.net/');
end;

procedure SaveGIniFile;
begin
  OldIniFile:=TIniFile.Create(OldIniFileName);
  OldIniFile.WriteInteger('Edit','Color',gsettings.DemoEditColor);
  OldIniFile.WriteInteger('Edit','Size',gsettings.UpDown2Position);
  OldIniFile.WriteInteger('Edit','Tab',gsettings.UpDown3Position);
  OldIniFile.WriteInteger('Options', 'FunctionBrowser', gsettings.UpDown4Position);
  OldIniFile.WriteString('Options','Parser',gsettings.Edit1Text);
  OldIniFile.WriteString('Options','Font', gsettings.EditorFontText);
  OldIniFile.WriteBool('ToolBars','StatusBar',gsettings.StatusBar1visible);
  OldIniFile.WriteString('Documentation', 'Filename', gsettings.DocsPathText);
  OldIniFile.WriteString('Documentation', 'Lang', gsettings.dl);
  OldIniFile.WriteString('Options','LangFile',gsettings.IdiomaText);
  OldiniFile.Writestring('Projects','Last',gsettings.LastProject);
  OldIniFile.WriteBool('ToolBars','ToolBar',gsettings.toolbar1visible);
  OldIniFile.WriteBool('ToolBars','HtmlBar',gsettings.htmlbar1visible);
  OldIniFile.WriteBool('ToolBars','EditBar',gsettings.editbar1visible);
  OldIniFile.WriteBool('Edit','LineNums',gsettings.LineNumbers);
  OldIniFile.WriteInteger('Options','WindowState',gsettings.MainFormWindowState);
  OldIniFile.WriteInteger('Options','windowX',gsettings.MainFormLeft);
  OldIniFile.WriteInteger('Options','windowY',gsettings.MainFormTop);
  OldIniFile.WriteInteger('Options','windowW',gsettings.MainFormwidth);
  OldIniFile.WriteInteger('Options','windowH',gsettings.MainFormHeight);
  OldIniFile.WriteString('Options','DateFmt',gsettings.dateFmt);
  OldIniFile.WriteString('Options','TimeFmt',gsettings.timeFmt);
  OldIniFile.WriteString('Options','DateTimeFmt',gsettings.datetimeFmt);
  OldIniFile.WriteInteger('Options','SaveType',gsettings.SaveType);
  OldIniFile.WriteBool('Options','HideSideBar',gsettings.HideSideBar);
  OldIniFile.WriteBool('Edit','AutoIndent',gsettings.AutoIndent);
  OldIniFile.WriteBool('Edit','WordWrap',gsettings.WordWrap);
  OldIniFile.WriteInteger('Options','SideBarWidth',240);
end;

procedure SaveIniFile(filename:string);
begin
  iniFilename:=filename;
  IniFile:=TIniFile.Create(IniFileName);
  IniFile.WriteInteger('Edit','Edge',settings.UpDown1Position);
  IniFile.WriteString('Options','Font',settings.DemoEditFontName);
  IniFile.WriteBool('Options', 'Highlight', settings.BracesChecked);
  IniFile.WriteBool('Options', 'SaveSession', settings.SaveSessionChecked);
  IniFile.WriteString('Options', 'DialogFont', settings.DialogFontText);
  IniFile.WriteString('Options', 'ExternPath', settings.externPath);
  iniFile.WriteString('Options','LocalPath',settings.localpathText);
  iniFile.WriteString('Options','LocalPort',settings.localPortText);
  iniFile.WriteString('Options','FTPcfname',settings.FTPcfname);
  iniFile.WriteBool('Options','FTPPassive',settings.FTPPassive);
  iniFile.WriteString('Options','FTPHost',settings.FTPHostText);
  iniFile.WriteString('Options','FTPPort',settings.FTPPortText);
  iniFile.WriteString('Options','FTPUser',settings.FTPUserText);
  iniFile.WriteString('Options','FTPServerPath',settings.FTPServerPathText);
  iniFile.WriteString('Options','ExternPath',settings.WebServerPathText);
  IniFile.WriteBool('Registry', 'css', settings.regCssChecked);
  IniFile.WriteBool('Registry', 'html', settings.regHtmlChecked);
  IniFile.WriteBool('Registry', 'js', settings.regJsChecked);
  IniFile.WriteBool('Registry', 'sql', settings.regSqlChecked);
  IniFile.WriteBool('Registry', 'php', settings.regPhpChecked);
  IniFile.WriteString('Options','Parameters',settings.Params);
  settings.writeHistory();
  settings.writeSession();
  iniFile.WriteString('Options', 'FindText', settings.FindDialog1FindText);
  iniFile.WriteString('Options', 'ReplaceText', settings.ReplaceDialog1FindText);
  IniFile.WriteInteger('Session', 'Active', settings.SessionActive);
  IniFile.WriteString('Documentation', 'Filename', settings.UDocFilename);
  IniFile.WriteString('Documentation', 'Lang', settings.DocLang );
  IniFile.WriteString('UPDATE', 'Version',settings.version);
  IniFile.WriteString('UPDATE', 'Download', settings.DSiteText );
  IniFile.WriteString('UPDATE', 'Description', settings.Description);
  IniFile.WriteString('Options', 'BrowserPath',settings.BrowserPath);
end;

procedure clearToolbars;
begin
  oldinifile.EraseSection('TBToolbar2Options');
  oldinifile.EraseSection('TBToolbar2DefaultOptions');
  oldinifile.EraseSection('TBToolbar2DefaultButtons');
  oldinifile.EraseSection('TBToolbar2Buttons');
  oldinifile.EraseSection('TBToolbar3Options');
  oldinifile.EraseSection('TBToolbar3DefaultOptions');
  oldinifile.EraseSection('TBToolbar3DefaultButtons');
  oldinifile.EraseSection('TBToolbar3Buttons');
  oldinifile.EraseSection('TBToolbar4Options');
  oldinifile.EraseSection('TBToolbar4DefaultOptions');
  oldinifile.EraseSection('TBToolbar4DefaultButtons');
  oldinifile.EraseSection('TBToolbar4Buttons');
end;

procedure CreateHighlighters( SynPHPSyn:TSynPHPSyn;
                              SynCSSSyn1:TSynCssSyn;
                              SynJScriptSyn1:TSynJScriptSyn;
                              SynSQLSyn1:TSynSQLSyn);
begin
  SynPHPSyn.CommentAttri.LoadFromFile(IniFile);
  SynPHPSyn.IdentifierAttri.LoadFromFile(IniFile);
//ToDo  SynPHPSyn.InvalidSymbolAttri.LoadFromFile(IniFile);
  SynPHPSyn.KeyAttri.LoadFromFile(IniFile);
  SynPHPSyn.NumberAttri.LoadFromFile(IniFile);
  SynPHPSyn.SpaceAttri.LoadFromFile(IniFile);
  SynPHPSyn.StringAttri.LoadFromFile(IniFile);
  SynPHPSyn.SymbolAttri.LoadFromFile(IniFile);
  SynPHPSyn.VariableAttri.LoadFromFile(IniFile);

  SynCSSSyn1.CommentAttri.LoadFromFile(IniFile);
//ToDo  SynCSSSyn1.IdentifierAttri.LoadFromFile(IniFile);
  SynCSSSyn1.KeyAttri.LoadFromFile(IniFile);
  SynCSSSyn1.NumberAttri.LoadFromFile(IniFile);
  SynCSSSyn1.SpaceAttri.LoadFromFile(IniFile);
  SynCSSSyn1.StringAttri.LoadFromFile(IniFile);
  SynCSSSyn1.SymbolAttri.LoadFromFile(IniFile);

  SynJScriptSyn1.CommentAttri.LoadFromFile(IniFile);
  SynJScriptSyn1.IdentifierAttri.LoadFromFile(IniFile);
  SynJScriptSyn1.KeyAttri.LoadFromFile(IniFile);
  SynJScriptSyn1.NumberAttri.LoadFromFile(IniFile);
  SynJScriptSyn1.SpaceAttri.LoadFromFile(IniFile);
  SynJScriptSyn1.StringAttri.LoadFromFile(IniFile);
  SynJScriptSyn1.SymbolAttri.LoadFromFile(IniFile);

  SynSQLSyn1.CommentAttri.LoadFromFile(IniFile);
  SynSQLSyn1.IdentifierAttri.LoadFromFile(IniFile);
  SynSQLSyn1.KeyAttri.LoadFromFile(IniFile);
  SynSQLSyn1.NumberAttri.LoadFromFile(IniFile);
  SynSQLSyn1.SpaceAttri.LoadFromFile(IniFile);
  SynSQLSyn1.StringAttri.LoadFromFile(IniFile);
  SynSQLSyn1.SymbolAttri.LoadFromFile(IniFile);
  SynSQLSyn1.VariableAttri.LoadFromFile(IniFile);
end;

procedure SaveSynEditFromFile(DemoSyn:TSynPHPSyn);
begin
  DemoSyn.CommentAttri.SaveToFile(IniFile);
  DemoSyn.IdentifierAttri.SaveToFile(IniFile);
//ToDo  DemoSyn.InvalidSymbolAttri.SaveToFile(IniFile);
  DemoSyn.KeyAttri.SaveToFile(IniFile);
  DemoSyn.NumberAttri.SaveToFile(IniFile);
  DemoSyn.SpaceAttri.SaveToFile(IniFile);
  DemoSyn.StringAttri.SaveToFile(IniFile);
  DemoSyn.SymbolAttri.SaveToFile(IniFile);
  DemoSyn.VariableAttri.SaveToFile(IniFile);
end;

procedure LoadSynEditFromFile(DemoSyn:TSynPHPSyn);
begin
  DemoSyn.CommentAttri.LoadFromFile(IniFile);
  DemoSyn.IdentifierAttri.LoadFromFile(IniFile);
//ToDo  DemoSyn.InvalidSymbolAttri.LoadFromFile(IniFile);
  DemoSyn.KeyAttri.LoadFromFile(IniFile);
  DemoSyn.NumberAttri.LoadFromFile(IniFile);
  DemoSyn.SpaceAttri.LoadFromFile(IniFile);
  DemoSyn.StringAttri.LoadFromFile(IniFile);
  DemoSyn.SymbolAttri.LoadFromFile(IniFile);
  DemoSyn.VariableAttri.LoadFromFile(IniFile);
end;

procedure freeIniFile;
begin
  if assigned(IniFile) then IniFile.Free;
  if assigned(Settings) then Settings.free;
  if assigned(OldIniFile) then OldInifile.Free;
  if assigned(GSettings) then GSettings.Free;
end;

{ TSettings }

procedure TSettings.wBracesChecked(const Value: boolean);
begin
  fBracesChecked:=Value;
  IniFile.WriteBool('Options', 'Highlight', Value);
end;

procedure TGlobSettings.wDemoEditColor(const Value: integer);
begin
  fDemoEditColor:=Value;
  OldIniFile.WriteInteger('Edit','Color',Value);
end;

procedure TSettings.wDemoEditFontName(const Value: string);
begin
  fDemoEditFontName:=value;
  IniFile.WriteString('Options','Font',value);
end;

procedure TSettings.wDialogFontText(const Value: string);
begin
  fDialogFontText:=value;
  IniFile.WriteString('Options','DialogFont',value);
end;

procedure TGlobSettings.wdl(const Value: string);
begin
  fdl := Value;
  OldIniFile.WriteString('Documentation','Lang',value);
end;

procedure TGlobSettings.wDocsPathText(const Value: string);
begin
  fDocsPathText := Value;
  OldIniFile.WriteString('Documentation','Filename',value);
end;

procedure TGlobSettings.wEdit1Text(const Value: string);
begin
  fEdit1Text:=value;
  OldInifile.WriteString('Options','Parser',value);
end;

procedure TGlobSettings.wEditorFontText(const Value: string);
begin
  fEditorFontText:=value;
  OldInifile.WriteString('Options','Font',value);
end;

procedure TSettings.wFTPcfname(const Value: string);
begin
  fFTPcfname:=value;
  inifile.WriteString('Options','FTPcfname',value);
end;

procedure TSettings.wFTPpassive(const Value: boolean);
begin
  fFTPpassive:=value;
  inifile.WriteBool('Options','FTPPassive',value);
end;

procedure TSettings.wFTPHostText(const Value: string);
begin
  fFTPHosttext:=value;
  inifile.WriteString('Options','FTPHost',value);
end;

{procedure TSettings.wFTPPasswordText(const Value: string);
begin
  fFTPPasswordText:=value;
  iniFile.WriteString('Options','FTPPassword','');
end;}

procedure TSettings.wFTPPortText(const Value: string);
begin
  fFtpPortText:=value;
  inifile.WriteString('Options','FTPPort',value);
end;

procedure TSettings.wFTPServerPathText(const Value: string);
begin
  fFTPServerPathText:=value;
  iniFile.WriteString('Options','FTPServerPath',value);
end;

procedure TSettings.wFTPUserText(const Value: string);
begin
  fFTPUserText:=value;
  iniFile.WriteString('Options','FTPUser',value);
end;

procedure TGlobSettings.wIdiomaText(const Value: string);
begin
  fIdiomaText:=value;
  OldiniFile.WriteString('Options','LangFile',value);
end;

procedure TSettings.wlocalpathText(const Value: string);
begin
  flocalpathText:=value;
  iniFile.WriteString('Options','LocalPath',value);
end;

procedure TSettings.wlocalPortText(const Value: string);
begin
  flocalPortText:=value;
  iniFile.WriteString('Options','LocalPort',value);
end;

procedure TSettings.wParams(const Value: string);
begin
  fParams := Value;
  iniFile.WriteString('Options','Parameters',value);
end;

procedure TSettings.wFindDialog1FindText(const Value: string);
begin
  fFindDialog1FindText := Value;
  iniFile.WriteString('Options', 'FindText', value);
end;

procedure TSettings.wReplaceDialog1FindText(const Value: string);
begin
  fReplaceDialog1FindText := Value;
  iniFile.WriteString('Options', 'ReplaceText', value);
end;

procedure TSettings.wregCssChecked(const Value: boolean);
begin
  fregCssChecked := Value;
  iniFile.WriteBool('Registry','css',value);
end;

procedure TSettings.wregHtmlChecked(const Value: boolean);
begin
  fregHtmlChecked := Value;
  iniFile.WriteBool('Registry','html',value);
end;

procedure TSettings.wregJsChecked(const Value: boolean);
begin
  fregJsChecked := Value;
  iniFile.WriteBool('Registry','js',value);
end;

procedure TSettings.wregPhpChecked(const Value: boolean);
begin
  fregPhpChecked := Value;
  iniFile.WriteBool('Registry','php',value);
end;

procedure TSettings.wregSqlChecked(const Value: boolean);
begin
  fregSqlChecked := Value;
  iniFile.WriteBool('Registry','sql',value);
end;

procedure TSettings.wSaveSessionChecked(const Value: boolean);
begin
  fSaveSessionChecked:=value;
  iniFile.WriteBool('Options','SaveSession',value);
end;

procedure TSettings.wUpDown1Position(const Value: integer);
begin
  fUpDown1Position:=value;
  inifile.WriteInteger('Edit','Edge',value);
end;

procedure TGlobSettings.wUpDown2Position(const Value: integer);
begin
  fUpDown2Position:=value;
  oldIniFile.WriteInteger('Edit','Size',value);
end;

procedure TGlobSettings.wUpDown3Position(const Value: integer);
begin
  fUpDown3Position:=value;
  OldIniFile.WriteInteger('Edit','Tab',Value);
end;

procedure TGlobSettings.wUpDown4Position(const Value: integer);
begin
  fUpDown4Position := Value;
  OldIniFile.WriteInteger('Options','FunctionBrowser',Value);
end;

procedure TGlobSettings.wMainFormWindowState(const Value: integer);
begin
  fMainFormWindowState := Value;
  OldIniFile.WriteInteger('Options','WindowState',value);
end;

procedure TGlobSettings.wMainFormLeft (const Value: integer);
begin
  fMainFormLeft := Value;
  OldIniFile.WriteInteger('Options','windowX',value);
end;

procedure TGlobSettings.wMainFormTop (const Value: integer);
begin
  fMainFormTop := Value;
  OldIniFile.WriteInteger('Options','windowY',value);
end;

procedure TGlobSettings.wMainFormwidth (const Value: integer);
begin
  fMainFormwidth := Value;
  OldIniFile.WriteInteger('Options','windowW',value);
end;

procedure TGlobSettings.wMainFormHeight (const Value: integer);
begin
  fMainFormHeight := Value;
  OldIniFile.WriteInteger('Options','windowH',value);
end;

procedure TSettings.wWebServerPathText(const Value: string);
begin
  fWebServerPathText:=value;
  iniFile.WriteString('Options','ExternPath',value);
end;

procedure TSettings.wDocFilename(const Value: string);
begin
  fDocFilename:=value;
  iniFile.WriteString('Documentation','Filename',value);
end;

procedure TSettings.wVersion(const Value: string);
begin
  fVersion:=value;
  iniFile.WriteString('UPDATE','Version',value);
end;

procedure TSettings.wExternPath(const Value: string);
begin
  fExternPath:=value;
  iniFile.WriteString('Options','ExternPath',value);
end;

procedure TSettings.wDSiteText(const Value: string);
begin
  fDSiteText:=value;
  iniFile.WriteString('UPDATE','Download',value);
end;

procedure TSettings.wDescription(const Value: string);
begin
  fDescription:=value;
  iniFile.WriteString('UPDATE','Description',value);
end;

procedure TSettings.wDocLang(const Value: string);
begin
  fDocLang:=value;
  iniFile.WriteString('Documentation','Lang',value);
end;

procedure TGlobSettings.wStatusBar1visible(const Value: boolean);
begin
  fStatusBar1visible:=value;
  OldiniFile.WriteBool('Toolbars','StatusBar',value);
end;

procedure TGlobSettings.wToolBar1visible(const Value: boolean);
begin
  fToolBar1visible:=value;
  OldiniFile.WriteBool('Toolbars','ToolBar',value);
end;

procedure TGlobSettings.whtmlbar1visible(const Value: boolean);
begin
  fhtmlbar1visible:=value;
  OldiniFile.WriteBool('Toolbars','HtmlBar',value);
end;

procedure TGlobSettings.weditbar1visible(const Value: boolean);
begin
  feditbar1visible:=value;
  OldiniFile.WriteBool('Toolbars','EditBar',value);
end;

procedure TGlobSettings.wLineNumbers(const Value: boolean);
begin
  fLineNumbers:=value;
  OldiniFile.WriteBool('Edit','LineNums',value);
end;

procedure TSettings.wSessionActive(const Value: integer);
begin
  fSessionActive:=value;
  iniFile.WriteInteger('Session','Active',value);
end;

procedure TSettings.clearHistory;
begin
  fhistory.clear;
end;

procedure TSettings.writeHistory;
var i2,i:integer;
begin
  i:=fhistory.count-1;
  while i>0 do begin
    i2:=fhistory.count-1;
    while i2>0  do begin
      if (i2<>i) and (fhistory[i]=fhistory[i2]) then fhistory.Delete(i); dec(i2);dec(i);
    end;
    dec(i);
    if i>fhistory.count-1 then i:=fhistory.count-1;
  end;
  inifile.EraseSection('History');
  inifile.WriteInteger('History','Last',fhistory.count);
  if fhistory.count=0 then exit;
  for i2:=0 to fhistory.count-1 do begin
    inifile.WriteString('History',inttostr(i2+1),fhistory[i2]);
  end;
end;

procedure TSettings.writeSession;
var lauf:integer;
begin
  inifile.EraseSection('Session');
  inifile.WriteInteger('Session','Last',fSession.count);
  if fSession.count=0 then exit;
  for lauf:=1 to fSession.count do begin
    inifile.WriteString('Session',inttostr(lauf),fSession[lauf-1]);
  end;
end;

constructor TSettings.Create();
begin
  inherited create();
  fHistory:=TStringList.Create;
  fSession:=TStringList.Create;
end;

destructor TSettings.Destroy;
begin
  fHistory.Destroy;
  fSession.Destroy;
  inherited Destroy;
end;

procedure TSettings.wBrowserPath(const value: string);
begin
  fBrowserPath:=value;
  IniFile.WriteString('Options','BrowserPath',value);
end;

procedure TSettings.wFTPPasswordSave(const Value: string);
var Cipher: TDCP_rc4;
    s:string;
begin
  fFTPPasswordSave:=value;
  if Value<>'' then begin
    Cipher:= TDCP_rc4.Create(nil);
    Cipher.InitStr(KeyStr,TDCP_sha1);         // initialize the cipher with a hash of the passphrase
    s:= Cipher.EncryptString(value);
    Cipher.Burn;
    Cipher.Free;
    iniFile.WriteString('Options','FTPPasswordSave',s);
  end;
end;

function TSettings.ReadPw():string;
var
  Cipher: TDCP_rc4;
  s,s1:string;
begin
  s:='';
  s1:=IniFile.ReadString('Options','FTPPasswordSave','');
  if s1<>'' then begin
    Cipher:= TDCP_rc4.Create(nil);
    Cipher.InitStr(KeyStr,TDCP_sha1);         // initialize the cipher with a hash of the passphrase
    s:= Cipher.DecryptString(s1);
    Cipher.Burn;
    Cipher.Free;
  end;
  result:=s;
end;

{ TGlobSettings }

constructor TGlobSettings.Create;
begin
  inherited;
end;

destructor TGlobSettings.Destroy;
begin
  inherited;
end;

procedure TGlobSettings.wLastProject(const Value: string);
begin
  fLastProject:=value;
  OldiniFile.WriteString('Projects','Last',value);
end;

procedure TGlobSettings.wDateFmt(const Value: string);
begin
  fDateFmt:=value;
  OldiniFile.WriteString('Options','DateFmt',value);
end;

procedure TGlobSettings.wTimeFmt(const Value: string);
begin
  fTimeFmt:=value;
  OldiniFile.WriteString('Options','TimeFmt',value);
end;

procedure TGlobSettings.wDateTimeFmt(const Value: string);
begin
  fDateTimeFmt:=value;
  OldiniFile.WriteString('Options','DateTimeFmt',value);
end;

procedure TGlobSettings.wSaveType(const Value: integer);
begin
  fSaveType:=value;
  OldiniFile.WriteInteger('Options','SaveType',value);
end;

procedure TGlobSettings.wHideSideBar(const Value: boolean);
begin
  fHideSideBar:=value;
  OldiniFile.WriteBool('Options','HideSideBar',value);
end;

procedure TGlobSettings.wAutoIndent(const Value: boolean);
begin
  fAutoIndent:=value;
  OldiniFile.WriteBool('Edit','AutoIndent',value);
end;

procedure TGlobSettings.wWordWrap(const Value: boolean);
begin
  fWordWrap:=value;
  OldiniFile.WriteBool('Edit','WordWrap',value);
end;

procedure TGlobSettings.wSideBarWidth(const Value: integer);
begin
  fSideBarWidth:=value;
  OldiniFile.WriteInteger('Options','SideBarWidth',value);
end;

procedure TGlobSettings.wDockSideBar(const Value: string);
begin
  fDockSideBar:=value;
  OldiniFile.WriteString('Options','DockSideBar',value);
end;

begin
  IniFileName := ExtractFilePath(Application.Exename)+ ChangeFileExt(ExtractFileName(Application.Exename), '.prd');
  OldIniFileName := ExtractFilePath(Application.Exename)+ ChangeFileExt(ExtractFileName(Application.Exename), '.ini');
end.
