//
// +----------------------------------------------------------------------+
// | Dev-PHP - Integrated Development Environment                         |
// +----------------------------------------------------------------------+
// | Copyright (C) 2002-2003, http://devphp.sourceforge.net               |
// +----------------------------------------------------------------------+
// | This program is free software; you can redistribute it and/or modify |
// | it under the terms of the GNU General Public License as published by |
// | the Free Software Foundation; either version 2 of the License, or    |
// | (at your option) any later version.                                  |
// | This program is distributed in the hope that it will be useful       |
// | but WITHOUT ANY WARRANTY; without even the implied warranty of       |
// | MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the         |
// | GNU General Public License for more details.                         |
// +----------------------------------------------------------------------+
// | Author: Leonardo Garca <simbiotik@users.sourceforge.net>            |
// | Author: Urs Mder <ursmaeder@users.sourceforge.net>                  |
// +----------------------------------------------------------------------+
//

unit uParser;

interface

uses
	SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
	Forms, Dialogs;

type

TParse = class(TObject)
    charpos:integer;
    Ffilename:string;
    ffertig:boolean;
    procedure writeFString(s:string);
    constructor create;
  private
    FString:String;
    blanks:Set of char;
    lineends:Set of char;
    ends:Set of char;
    function getNextChar(): char;
  protected
  public
    function Capitalize: string;
    function getNextWord(withblanks:boolean):string;
    function getPreviewChar(add: integer;withblanks:boolean): char;
  published
    property parsedStr:string read FString write writeFString;
    property Filename:string read FFilename write FFilename;
    property fertig:boolean read ffertig write ffertig;
end;

implementation

uses frmMain;
{ TParse }

constructor TParse.create();
begin
  inherited create;
  ffertig:=false;
  blanks:=[' ',chr(10)];
  lineends:=[chr(10),chr(13)];
  ends:=[';',',','(',')','=','''','{','}','"'];
end;

function TParse.getNextChar():char;
begin
  if charpos>length(FString) then begin
    result:=chr(0);charpos:=high(integer);ffertig:=true;exit;
  end;
  result:=FString[charpos];
  inc(charpos);
end;

function TParse.getPreviewChar(add:integer;withblanks:boolean):char;
begin
  if charpos>length(FString) then begin
    result:=chr(0);exit;
  end;
  if not withblanks then while FString[charpos] in blanks do inc(charpos);
  result:=FString[charpos];
end;

function TParse.getNextWord(withblanks:boolean): string;
var c:char;
    s:string;
begin
  s:='';
  repeat
    c:=getNextChar();
    if ffertig then begin break; end;
    if (c in ends) then begin s:=c; break; end;
    case c of
    ' ': begin
      if withblanks then begin
        s:=s+c;break;
      end else begin
        while (getPreviewChar(1,true) in blanks) do getNextChar();
        s:='';
      end;
    end;
    chr(13),chr(10):
        begin
          s:=s+c;
          break;
        end;
    '/': begin
      if getPreviewChar(1,true)='*' then begin
        repeat c:=getNextChar(); until ((c='*') and (getPreviewChar(1,false)='/'));
        getNextChar();
        s:='';
      end;
      if getPreviewChar(1,true)='/' then begin
        repeat c:=getNextChar; until(c in lineends);
        s:='';
      end;
    end;
    else
      s:=s+c;
    end;
    if getPreviewChar(1,true) in ends then  break;
    if getPreviewChar(1,true) in lineends then  break;
    if getPreviewChar(1,true) in blanks then break;
  until false;
//  showmessage(s);
  result:=s;
end;

procedure TParse.writeFString(s: string);
begin
  FString:=s;
  filename:=mainfrm.geteditor().fFilename;
  charpos:=1;
  ffertig:=false;
end;

function TParse.Capitalize():string;
var st:string;
    res:string;
    s:PChar;
begin
  while not fertig do begin
    st:=getNextWord(true);
    if length(st)>0 then begin
      s:=Pointer(st);
      if (s^ >= 'a') and (s^ <= 'z') then begin
        Dec(s^, 32);
      end;
    end;
    if fertig and (st=#10) then break;
    res:=res+st;
  end;
  result:= res;
end;

end.