unit OnceOnly;

interface

uses
  Windows, Messages, SysUtils, Classes, Controls, Forms,dialogs;

const
  wm_SecondStart=wm_User+$1;
  wm_SecondParameter=wm_User+$2;
  wm_HandleParameters=wm_User+$3;

type   
  TStringEvent=procedure (Sender:TObject;const Value:String) of object;
  TOnceOnly=class (TComponent)
  private
     Mapping,WindowHandle:THandle;
     fOnParameter:TStringEvent;
     procedure CheckMapping;
     procedure IWndProc (var Ms:TMsg; var Handled:boolean);
  protected
     procedure Loaded;override;
  public
     constructor Create (aOwner:TComponent);override;
     destructor Destroy;override;
  published
     property OnParameter:TStringEvent read fOnParameter write fOnParameter default nil;
  end;

procedure Register;

implementation

type
  PInstInfo=^TInstInfo;
  TInstInfo=record
     AppHandle:THandle;
     Parameter:ShortString;
  end;

{*******************************************************}
{* TOnceOnly                                           *}
{*******************************************************}

function GetLongPathName(APath:String):String;
var
  i : Integer;
  h : THandle;
  Data : TWin32FindData;
  IsBackSlash : Boolean;
begin
  APath:=ExpandFileName(APath);
  i:=Pos('\',APath);
  Result:=Copy(APath,1,i);
  Delete(APath,1,i);
  repeat
    i:=Pos('\',APath);
    IsBackSlash:=i>0;
    if Not IsBackSlash then
      i:=Length(APath)+1;
    h:=FindFirstFile(PChar(Result+Copy(APath,1,i-1)),Data);
    if h<>INVALID_HANDLE_VALUE then begin
      try
        Result:=Result+Data.cFileName;
        if IsBackSlash then
          Result:=Result+'\';
      finally
        Windows.FindClose(h);
      end;
    end
    else begin
      Result:=Result+APath;
      Exit;
    end;
    Delete(APath,1,i);
  until Length(APath)=0;
end;

function ForceForegroundWindow(hWnd: THandle): BOOL;
var 
  hCurWnd: THandle; 
begin
//  showmessage('ForceForegroundWindow');
  hCurWnd := GetForegroundWindow;
  AttachThreadInput(
    GetWindowThreadProcessId(hCurWnd, nil),
    GetCurrentThreadId, True);
  Result := SetForegroundWindow(hWnd);
  AttachThreadInput(
    GetWindowThreadProcessId(hCurWnd, nil),
    GetCurrentThreadId, False);
end;

constructor TOnceOnly.Create (aOwner:TComponent);
begin
//   showmessage('Create');
   inherited Create (aOwner);
   application.OnMessage:=IWndProc;
end;

procedure TOnceOnly.Loaded;
begin
//   showmessage('Loaded');
   inherited Loaded;
   if not (csDesigning in ComponentState) then
   begin
      CheckMapping;
      PostMessage (WindowHandle,wm_HandleParameters,0,0);
   end;
end;

destructor TOnceOnly.Destroy;
begin
//  showmessage('Destroy');
   if Mapping<>0 then
      CloseHandle (Mapping);
   inherited Destroy;
end;

procedure TOnceOnly.CheckMapping;
var I:Integer;
    MapView:PInstInfo;
begin
   Mapping:=CreateFileMapping ($FFFFFFFF,nil,Page_ReadWrite,0,SizeOf (TInstInfo),PChar (ExtractFileName (ParamStr (0))));
   if GetLastError=Error_Already_Exists then
   begin
      MapView:=MapViewOfFile (Mapping,File_Map_Write,0,0,0);
      PostMessage (MapView^.AppHandle,wm_SecondStart,0,0);
      for I:=1 to ParamCount do
      begin
         MapView^.Parameter:=GetLongPathName(ParamStr (I));
         PostMessage(MapView^.AppHandle,wm_SecondParameter,0,0);
      end;
      UnmapViewOfFile (MapView);
      application.Terminate;
//      halt;
   end
   else
   begin
      MapView:=MapViewOfFile (Mapping,File_Map_Write,0,0,0);
      MapView^.AppHandle:=Application.Handle;
      UnmapViewOfFile (MapView);
   end;
end;

procedure TOnceOnly.IWndProc (var ms:TMsg; var Handled:boolean);

   procedure SecondStart;
   begin
     if IsIconic (application.Handle) then application.Restore
       else  application.BringToFront;
     ForceForegroundWindow(application.Handle);
     handled:=true;
   end;

   procedure SecondParameter;
   var MapView:PInstInfo;
   begin
      if Assigned (fOnParameter) then
      begin
         MapView:=MapViewOfFile (Mapping,File_Map_Read,0,0,0);
         fOnParameter (Self,MapView^.Parameter);
         UnmapViewOfFile (MapView);
      end;
      ForceForegroundWindow(application.Handle);
      handled:=true;
   end;

   procedure HandleParameters;
   var I:Integer;
   begin
      if Assigned (fOnParameter) then
         for I:=1 to ParamCount do
            fOnParameter (Self,GetLongPathName(ParamStr (I)));
      handled:=false;
   end;

begin {TOnceOnly.WndProc}
   with ms do
      case Ms.message of
         wm_SecondStart      : SecondStart;
         wm_SecondParameter  : SecondParameter;
         wm_HandleParameters : HandleParameters;
//         else Result:=DefWindowProc (WindowHandle,Msg,wParam,lParam);
         else handled:=false;
      end;
end;

{*******************************************************}
{* Unit-Registrierung                                  *}
{*******************************************************}

procedure Register;
begin
   RegisterComponents ('Beispiele',[TOnceOnly]);
end;

end.

