unit WebServ;

interface

uses
  Forms, Windows, Messages, SysUtils, Classes, IdBaseComponent, IdComponent,
  IdTCPServer, IdHTTPServer, idGlobal, dialogs, SyncObjs,IdCustomHTTPServer;

type
  TCompileProc=function (debugStr:string):string of object;

  TWebServ = class(TComponent)
  private
    HTTPServer: TIdHTTPServer;
     FrootPath: String;
    FFileToView: string;
    FPort: integer;
    syn:TCriticalSection;
    UILock: TCriticalSection;
    env:TStringList;
    FOnFullText: TCompileProc;
    Fphpexe: string;
    FActive: boolean;
    function Compile(thread: TIdPeerThread; Cmd, Filename,
      WorkDir: String): string;
    function DoCompile(thread: TIdPeerThread; doc,doc2: string): string;
    procedure acActivateExecute(Sender: TObject);
    procedure ManageUserSession(AThread: TIdPeerThread;
      RequestInfo: TIdHTTPRequestInfo; ResponseInfo: TIdHTTPResponseInfo);
    procedure ServeVirtualFolder(AThread: TIdPeerThread;
      RequestInfo: TIdHTTPRequestInfo; ResponseInfo: TIdHTTPResponseInfo);
    procedure DisplayMessage(const Msg: string);
    function GetMIMEType(sFile: TFileName): string;
    procedure HTTPServerCommandGet(AThread: TIdPeerThread;
      RequestInfo: TIdHTTPRequestInfo; ResponseInfo: TIdHTTPResponseInfo);
    procedure SetActive(const Value: boolean);
    { Private-Deklarationen }
  protected
    { Protected-Deklarationen }
    procedure loaded;override;
  public
    MIMEMap: TIdMIMETable;
    constructor Create(AOwner: TComponent); override;
    { Public-Deklarationen }
  published
    { Published-Deklarationen }
    destructor destroy;override;
    property Port:integer read FPort write FPort;
    property RootPath:String read FrootPath write FrootPath;
    property Filename:string read FFileToView write FFileToView;
    property OnDebug:TCompileProc read FOnFullText write FOnFullText;
    property PHPExe:string read Fphpexe write FphpExe;
    property Active:boolean read FActive write SetActive;
//    property SSL:Boolean read fSSL write fSSL;
//    property ManageSessions:Boolean read FManageSessions write FManageSessions;
  end;

procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('Beispiele', [TWebServ]);
end;

function GetShortName(sLongName: string): string; 
var 
  sShortName:    string;
  nShortNameLen: Integer; 
begin 
  SetLength(sShortName, MAX_PATH); 
  nShortNameLen := GetShortPathName(PChar(sLongName), PChar(sShortName), MAX_PATH - 1);
  if (0 = nShortNameLen) then 
  begin 
    // handle errors... 
  end; 
  SetLength(sShortName, nShortNameLen); 
  Result := sShortName; 
end;

function TWebServ.Compile(thread:TIdPeerThread;Cmd, Filename, WorkDir: String): string;

var
  tsi: TStartupInfo;
  tpi: TProcessInformation;
  nRead: DWORD;
  aBuf: Array[0..101] of char;
  sa: TSecurityAttributes;
  hOutputReadTmp, hOutputRead, hOutputWrite, hInputWriteTmp, hInputRead,
  hInputWrite, hErrorWrite: THandle;
  FOutput: String;

begin
  FOutput := '';

  sa.nLength              := SizeOf(TSecurityAttributes);
  sa.lpSecurityDescriptor := nil;
  sa.bInheritHandle       := True;

  CreatePipe(hOutputReadTmp, hOutputWrite, @sa, 0);
  DuplicateHandle(GetCurrentProcess(), hOutputWrite, GetCurrentProcess(),
    @hErrorWrite, 0, true, DUPLICATE_SAME_ACCESS);
  CreatePipe(hInputRead, hInputWriteTmp, @sa, 0);

  DuplicateHandle(GetCurrentProcess(), hOutputReadTmp,  GetCurrentProcess(),
    @hOutputRead,  0, false, DUPLICATE_SAME_ACCESS);
  DuplicateHandle(GetCurrentProcess(), hInputWriteTmp, GetCurrentProcess(),
    @hInputWrite, 0, false, DUPLICATE_SAME_ACCESS);
  CloseHandle(hOutputReadTmp);
  CloseHandle(hInputWriteTmp);

  FillChar(tsi, SizeOf(TStartupInfo), 0);
  tsi.cb         := SizeOf(TStartupInfo);
  tsi.dwFlags    := STARTF_USESTDHANDLES or STARTF_USESHOWWINDOW;
  tsi.hStdInput  := hInputRead;
  tsi.hStdOutput := hOutputWrite;
  tsi.hStdError  := hErrorWrite;
  displayMessage('Command to php: '+cmd);
  CreateProcess(nil, PChar(Cmd), @sa, @sa, true, 0, nil, PChar(WorkDir),
    tsi, tpi);
  CloseHandle(hOutputWrite);
  CloseHandle(hInputRead );
  CloseHandle(hErrorWrite);
  Application.ProcessMessages;

  repeat
     if (not ReadFile(hOutputRead, aBuf, 16, nRead, nil)) or (nRead = 0) then
     begin
        if GetLastError = ERROR_BROKEN_PIPE then Break
        else MessageDlg('Pipe read error, could not execute file', mtError, [mbOK], 0);
     end;
     aBuf[nRead] := #0;
     FOutput := FOutput + PChar(@aBuf[0]);
     Application.ProcessMessages;
  until False;

  Result := FOutput;
  DisplayMessage(#13#10+Result);
end;

{ TWebServ }

procedure TWebServ.acActivateExecute(Sender: TObject);
begin
  if not HTTPServer.Active then
  begin
    HTTPServer.Bindings.Clear;
    HTTPServer.DefaultPort := Fport;
    HTTPServer.Bindings.Add;
  end;

  if not DirectoryExists(FRootPath) then
  begin
    DisplayMessage(Format('Web root folder (%s) not found.', [FRootPath]));
  end
  else
  begin
     try
//      EnableLog := cbEnableLog.Checked;
      HTTPServer.SessionState := true;

      // SSL stuff
//        if fSSL then
//        begin
//          with IdServerInterceptOpenSSL.SSLOptions do
//          begin
//            Method := sslvSSLv23;
//            AppDir := ExtractFilePath(Application.ExeName);
//            RootCertFile := AppDir + 'cert\CAcert.pem';
//            CertFile := AppDir + 'cert\WSScert.pem';
//            KeyFile := AppDir + 'cert\WSSkey.pem';
//          end;
//          IdServerInterceptOpenSSL.OnStatusInfo := MyInfoCallback;
//          IdServerInterceptOpenSSL.OnGetPassword := GetKeyPassword;
//          HTTPServer.Intercept := IdServerInterceptOpenSSL;
//        end;
      // END SSL stuff

      HTTPServer.Active := true;
      DisplayMessage(format('Listening for HTTP connections on %s:%d.',
        [HTTPServer.Bindings[0].IP, HTTPServer.Bindings[0].Port]));
    except
      on e: exception do
      begin
        DisplayMessage(format('Exception %s in Activate. Error is:"%s".',
          [e.ClassName, e.Message]));
      end;
    end;
  end;
end;

procedure TWebServ.ManageUserSession(AThread: TIdPeerThread;
  RequestInfo: TIdHTTPRequestInfo; ResponseInfo: TIdHTTPResponseInfo);
var
  NumberOfView: Integer;
begin
  // Manage session informations
  if assigned(RequestInfo.Session) or
    (HTTPServer.CreateSession(AThread,ResponseInfo,RequestInfo) <> nil) then
  begin
    DisplayMessage(RequestInfo.Session.Content.Text);
    RequestInfo.Session.Lock;
    try
      NumberOfView :=
        StrToIntDef(RequestInfo.Session.Content.Values['NumViews'], 0);
      inc(NumberOfView);
      RequestInfo.Session.Content.Values['NumViews'] := IntToStr(NumberOfView);
      RequestInfo.Session.Content.Values['UserName'] :=
        RequestInfo.AuthUsername;
      RequestInfo.Session.Content.Values['Password'] :=
        RequestInfo.AuthPassword;
    finally
      RequestInfo.Session.Unlock;
    end;
  end;
end;

procedure TWebServ.DisplayMessage(const Msg: string);
begin
  UILock.Acquire;
  try
    if assigned(FOnFulltext) then FOnFulltext(msg);
  finally
    UILock.Release;
  end;
end;

procedure TWebServ.ServeVirtualFolder(AThread: TIdPeerThread;
  RequestInfo: TIdHTTPRequestInfo; ResponseInfo: TIdHTTPResponseInfo);
begin
  ResponseInfo.ContentType := 'text/HTML';
  ResponseInfo.ContentText :=
    '<html><head><title>Virtual folder</title></head><body>';

  if AnsiSameText(RequestInfo.Params.Values['action'], 'close') then
  begin
    // Closing user session
    RequestInfo.Session.Free;
    ResponseInfo.ContentText := ResponseInfo.ContentText +
      '<h1>Session cleared</h1><p><a href="/sessions">Back</a></p>';
  end
  else
  begin
    if assigned(RequestInfo.Session) then
    begin
      if Length(RequestInfo.Params.Values['ParamName']) > 0 then
      begin
        // Add a new parameter to the session
        ResponseInfo.Session.Content.Values[RequestInfo.Params.Values['ParamName']] := RequestInfo.Params.Values['Param'];
      end;
      ResponseInfo.ContentText := ResponseInfo.ContentText +
        '<h1>Session informations</h1>';
      RequestInfo.Session.Lock;
      try
        ResponseInfo.ContentText := ResponseInfo.ContentText +
          '<table border=1>';
        ResponseInfo.ContentText := ResponseInfo.ContentText +
          '<tr><td>SessionID</td><td>' + RequestInfo.Session.SessionID +
          '</td></tr>';
        ResponseInfo.ContentText := ResponseInfo.ContentText +
          '<tr><td>Number of page requested during this session</td><td>' +
          RequestInfo.Session.Content.Values['NumViews'] + '</td></tr>';
        ResponseInfo.ContentText := ResponseInfo.ContentText +
          '<tr><td>Session data (raw)</td><td><pre>' +
          RequestInfo.Session.Content.Text + '</pre></td></tr>';
        ResponseInfo.ContentText := ResponseInfo.ContentText + '</table>';
        ResponseInfo.ContentText := ResponseInfo.ContentText +
          '<h1>Tools:</h1>';
        ResponseInfo.ContentText := ResponseInfo.ContentText +
          '<h2>Add new parameter</h2>';
        ResponseInfo.ContentText := ResponseInfo.ContentText +
          '<form method="POST">';
        ResponseInfo.ContentText := ResponseInfo.ContentText +
          '<p>Name: <input type="text" Name="ParamName"></p>';
        ResponseInfo.ContentText := ResponseInfo.ContentText +
          '<p>value: <input type="text" Name="Param"></p>';
        ResponseInfo.ContentText := ResponseInfo.ContentText +
          '<p><input type="Submit"><input type="reset"></p>';
        ResponseInfo.ContentText := ResponseInfo.ContentText + '</form>';
        ResponseInfo.ContentText := ResponseInfo.ContentText +
          '<h2>Other:</h2>';
        ResponseInfo.ContentText := ResponseInfo.ContentText + '<p><a href="' +
          RequestInfo.Document + '?action=close">Close current session</a></p>';
      finally
        RequestInfo.Session.Unlock;
      end;
    end
    else
    begin
      ResponseInfo.ContentText := ResponseInfo.ContentText +
        '<p color=#FF000>No session</p>';
    end;
  end;
  ResponseInfo.ContentText := ResponseInfo.ContentText + '</body></html>';
end;

procedure TWebServ.HTTPServerCommandGet(AThread: TIdPeerThread;
  RequestInfo: TIdHTTPRequestInfo; ResponseInfo: TIdHTTPResponseInfo);

  procedure AuthFailed;
  begin
    ResponseInfo.ContentText :=
      '<html><head><title>Error</title></head><body><h1>Authentication failed</h1>'#13 +
      'Check the demo source code to discover the password:<br><ul><li>Search for <b>AuthUsername</b> in <b>Main.pas</b>!</ul></body></html>';
//    ResponseInfo.AuthRealm := sauthenticationrealm;
  end;

  procedure AccessDenied;
  begin
    ResponseInfo.ContentText :=
      '<html><head><title>Error</title></head><body><h1>Access denied</h1>'#13 +
      'You do not have sufficient priviligies to access this document.</body></html>';
    ResponseInfo.ResponseNo := 403;
  end;

var
  LocalDoc,idoc: string;
  ByteSent: Cardinal;
  ResultFile: TFileStream;
  ts:Tstringlist;
  lauf:integer;
  
begin
  // Log the request
//  DisplayMessage(Format('Command %s %s received from %s:%d',
//    [RequestInfo.Command, RequestInfo.Document,
//      AThread.Connection.Binding.PeerIP,
//      AThread.Connection.Binding.PeerPort]));
//  if cbAuthentication.Checked and
//    ((RequestInfo.AuthUsername <> 'Indy') or (RequestInfo.AuthPassword <>
//      'rocks')) then
//  begin
//    AuthFailed;
//    exit;
//  end;
//  if FManageSessions then
    ManageUserSession(AThread, RequestInfo, ResponseInfo);
  if (Pos('/session', LowerCase(RequestInfo.Document)) = 1) then
  begin
    ServeVirtualFolder(AThread, RequestInfo, ResponseInfo);
  end
  else
  begin
    // Interprete the command to it's final path (avoid sending files in parent folders)
    LocalDoc := ExpandFilename(FrootPath + RequestInfo.Document);
    // Default document (index.html) for folder
    if not FileExists(LocalDoc) and DirectoryExists(LocalDoc) and
      FileExists(ExpandFileName(LocalDoc + '/index.html')) then
    begin
      LocalDoc := ExpandFileName(LocalDoc + '/index.html');
    end;
    if FileExists(LocalDoc) then // File exists
    begin
      if AnsiSameText(Copy(LocalDoc, 1, Length(FRootPath)), FRootPath) then
        // File down in dir structure
      begin
        if AnsiSameText(RequestInfo.Command, 'HEAD') then
        begin
          // HEAD request, don't send the document but still send back it's size
          ResultFile := TFileStream.create(LocalDoc, fmOpenRead or
            fmShareDenyWrite);
          try
            ResponseInfo.ResponseNo := 200;
            ResponseInfo.ContentType := GetMIMEType(LocalDoc);
            ResponseInfo.ContentLength := ResultFile.Size;
          finally
            ResultFile.Free;
              // We must free this file since it won't be done by the web server component
          end;
        end
        else
        begin
          // Normal document request
          // Send the document back
          if ExtractFileExt(RequestInfo.Document)='.php' then begin
            ts:=TStringList.create;
            idoc:=FrootPath+RequestInfo.Document;
            for lauf:=1 to length(idoc) do if idoc[lauf]='/' then idoc[lauf]:='\';
            ts.LoadFromFile(idoc);
            idoc:=ExtractFilePath(idoc)+'~'+ExtractFilename(idoc);
            for lauf:=0 to requestInfo.Params.Count-1 do begin
              ts.Insert(0,'<? $'+requestInfo.Params.Names[lauf]+'="'+requestInfo.Params.Values[RequestInfo.Params.Names[lauf]]+'";?>');
            end;
            ts.SaveToFile(idoc);
            ts.Text:=DoCompile(AThread,idoc,requestInfo.Document);
            while ts.Strings[0]<>'' do begin
              responseInfo.RawHeaders.Add(ts.Strings[0]);
              ts.Delete(0);
            end;
            responseInfo.ContentText:=responseInfo.contenttext+ts.Text;
            displayMessage(#13#10+ts.Text+#13#10#13#10);
            displayMessage(responseInfo.ContentText+#13#10#13#10);
            DeleteFile(idoc);
            ts.free;
          end else begin
            ByteSent := HTTPServer.ServeFile(AThread, ResponseInfo, LocalDoc);
//            DisplayMessage(Format('Serving file %s (%d bytes / %d bytes sent) to %s:%d',
//              [LocalDoc, ByteSent, FileSizeByName(LocalDoc),
//              AThread.Connection.Binding.PeerIP,
//                AThread.Connection.Binding.PeerPort]));
          end;
        end;
      end
      else
        AccessDenied;
    end
    else
    begin
      ResponseInfo.ResponseNo := 404; // Not found
      ResponseInfo.ContentText :=
        '<html><head><title>Error</title></head><body><h1>' +
        ResponseInfo.ResponseText + '</h1></body></html>';
    end;
  end;
end;

function TWebServ.GetMIMEType(sFile: TFileName): string;
begin
  result := MIMEMap.GetFileMIMEType(sFile);
end;

constructor TWebserv.Create(AOwner: TComponent);
begin
  inherited;
  UILock := TCriticalSection.Create;
  MIMEMap := TIdMIMETable.Create(true);
end;

procedure TWebServ.loaded;
begin
  inherited;
  syn:=TCriticalSection.create;
  if not(csDesigning in componentstate) then begin
    env:=TStringList.Create;
    HTTPserver:=TidHttpServer.Create(nil);
    HTTPServer.Bindings.Clear;
    HTTPserver.DefaultPort:=FPort;
    HTTPserver.ParseParams:=true;
    HTTPserver.AutoStartSession:=true;
    HTTPserver.OnCommandGet:=HTTPServerCommandGet;
    HTTPServer.Bindings.Add;
    HTTPserver.Active:=false;
  end;
end;

destructor TWebServ.destroy;
begin
  if not(csDesigning in componentstate) then begin
    httpserver.Active:=false;
    httpserver.Free;
  end;
  env.Free;
  syn.free;
  MIMEMap.Free;
  UILock.Free;
  inherited;
end;

function TWebServ.DoCompile(thread:TIdPeerThread;doc,doc2:string):string;
var s:string;
    st:TStringList;
begin
  if ExtractFileExt(doc)='.php' then begin
    s:=Fphpexe+' '+getShortName(doc);
    result:=Compile(thread,s,doc2,getShortName(FrootPath));
  end else begin
    st:=TStringList.Create();
    if fileExists(doc) then
     st.LoadFromFile(doc)
    else st.Add('File: '+doc+' not found');
    result:=st.Text;
    st.Free;
  end;
end;

procedure TWebServ.SetActive(const Value: boolean);
begin
  FActive := Value;
  if assigned(httpserver) then
    if value then acActivateExecute(nil) else httpserver.Active:=value;
//  if assigned(httpserver) then httpserver.Active:=Factive;

end;

end.






