package elazyrest.core.aspect;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

import javax.xml.bind.JAXBElement;

import elazyrest.core.util.AppContext;

/**
 * 
 * @author kaz
 *
 */
public class AspectChain {
	private List<AspectBase> adviceList = new ArrayList<AspectBase>(); 
	private List<Annotation> annotationList = new ArrayList<Annotation>(); 
	int nextIndex = 0;

	private Method mainMethod = null; 
	private Object mainInstance = null;
	private Object[] requestParams = null;
	private Object response = null;
	
	public Method getMainMethod() {
		return mainMethod;
	}
	
	public Object getMainInstance() {
		return mainInstance;
	}
	
	public Object getResponse() {
		return response;
	}
	
	protected void doAdvice() throws IOException {
		int currentIndex = nextIndex;
		nextIndex++;
		
		AppContext appContext = AppContext.getContext();
		if (adviceList.size() > currentIndex) {
			AspectBase advice = adviceList.get(currentIndex);
			advice.doAdvice(appContext.getRequest(), appContext.getResponse(), this, annotationList.get(currentIndex));
		}
		else {
			try {
				Object result = mainMethod.invoke(mainInstance, requestParams);
				if (result != null) {
					response = result;
				}
			}
			catch (IllegalArgumentException e) {
				e.printStackTrace();
				throw new RuntimeException(e);
			}
			catch (IllegalAccessException e) {
				e.printStackTrace();
				throw new RuntimeException(e);
			}
			catch (InvocationTargetException e) {
				Throwable t = e.getTargetException();
				if (t instanceof RuntimeException) {
					throw ((RuntimeException) t);
				}
				else {
					throw new RuntimeException(t);
				}
			}
		}
	}

	public Object invoke() throws IOException{
		doAdvice();
		return response;
//		catch (IllegalArgumentException e) {
//			e.printStackTrace();
//			throw new RuntimeException(e);
//		}
//		catch (IllegalAccessException e) {
//			e.printStackTrace();
//			throw new RuntimeException(e);
//		}
//		catch (InvocationTargetException e) {
//			Throwable t = e.getTargetException();
//			if (t instanceof RuntimeException) {
//				throw ((RuntimeException) t);
//			}
//			else {
//				throw new RuntimeException(t);
//			}
//		}
	}

	public void addAdvice(AspectBase advice, Annotation paramAnnotation) {
		if (!adviceList.contains(advice)) {
			adviceList.add(advice);
			annotationList.add(paramAnnotation);
		}
	}

	public void setMainMethod(Method mainMethod, Object mainIntance, Object[] params) {
		this.mainInstance = mainIntance;
		this.mainMethod = mainMethod;
		this.requestParams = params;
	}
}
