package elazyrest.core.provider;

import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * 
 * @author kaz
 *
 */
public class PropertiesLoader {
	private static PropertiesLoader _instance = new PropertiesLoader();
	
	private static Log log = LogFactory.getLog(PropertiesLoader.class);

	protected Map<String, Properties> instances = new HashMap<String, Properties>();
	
	public static Properties get(String key) {
		return _instance.getInstance(key);
	}

	public static boolean contains(String key) {
		return _instance.instances.containsKey(key);
	}

	public static void set(String key, Properties instance) {
		synchronized (_instance.instances) {
			_instance.instances.put(key, instance);
		}
	}
	
	public Properties getInstance(String key) {
		Properties prop = null;
		synchronized (instances) {
			// CX^X݂ΕԂ
			if (instances.containsKey(key)) {
				prop = instances.get(key);
			}
			// ŏ̃ANZXɃCX^X𐶐
			else {
				URL url = PropertiesLoader.class.getClassLoader().getResource(key);
				prop = new Properties();
				try {
					if(key.endsWith(".xml")) {
						prop.loadFromXML(url.openStream());
						instances.put(key, prop);
					} else if(key.endsWith(".properties")) {
						prop.load(url.openStream());
						instances.put(key, prop);
					}
				} catch(IOException e) {
					log.error(e.getMessage(), e);
				}
			}
		}
		return prop;
	}
	
	public static void clear() {
		synchronized (_instance.instances) {
			_instance.instances.clear();
		}
	}
}
